import joblib

from vitors_landcover.preprocessing import FeatsModel


def load_umap_reducer(basename='umap_reducer_v1'):
    try:
        from importlib.resources import as_file, files
        fn = files('vitors_landcover.preprocessing.models').joinpath(
            f'{basename}.jlib')

        with as_file(fn) as f:
            reducer = joblib.load(f)
    except ImportError:  # Python 3.8 and below
        import pkg_resources
        fn = pkg_resources.resource_filename(
            'vitors_landcover.preprocessing.models', f'{basename}.jlib'
        )

        with open(fn, 'rb') as f:
            reducer = joblib.load(f)

    return reducer


class UmapReducerV1(FeatsModel):

    _basename = 'umap_reducer_v1'

    def __init__(self):
        model = load_umap_reducer(self._basename)
        super().__init__(model=model)
        self.bands = model.feature_names_in_

    def predict_df(self, df):
        X = df[self.bands]
        return self.model.predict(X)


class UmapLscReducerV1(UmapReducerV1):

    _basename = 'umap_lsc_reducer_v1'


class UmapReducerV2(UmapReducerV1):

    _basename = 'umap_reducer_v2'
