
# Do not edit this file directly.
# It is automatically generated.
# Used command line arguments:
#    openeo/internal/processes/generator.py specs/openeo-processes specs/openeo-processes/proposals --output openeo/processes.py
# Generated on 2023-09-08

from __future__ import annotations

import builtins

from openeo.internal.processes.builder import ProcessBuilderBase, UNSET
from openeo.internal.documentation import openeo_process
from openeo.rest._datacube import build_child_callback


class ProcessBuilder(ProcessBuilderBase):
    """
    .. include:: api-processbuilder.rst
    """

    _ITERATION_LIMIT = 100

    @openeo_process(process_id="add", mode="operator")
    def __add__(self, other) -> ProcessBuilder:
        return self.add(other)

    @openeo_process(process_id="add", mode="operator")
    def __radd__(self, other) -> ProcessBuilder:
        return add(other, self)

    @openeo_process(process_id="subtract", mode="operator")
    def __sub__(self, other) -> ProcessBuilder:
        return self.subtract(other)

    @openeo_process(process_id="subtract", mode="operator")
    def __rsub__(self, other) -> ProcessBuilder:
        return subtract(other, self)

    @openeo_process(process_id="multiply", mode="operator")
    def __mul__(self, other) -> ProcessBuilder:
        return self.multiply(other)

    @openeo_process(process_id="multiply", mode="operator")
    def __rmul__(self, other) -> ProcessBuilder:
        return multiply(other, self)

    @openeo_process(process_id="divide", mode="operator")
    def __truediv__(self, other) -> ProcessBuilder:
        return self.divide(other)

    @openeo_process(process_id="divide", mode="operator")
    def __rtruediv__(self, other) -> ProcessBuilder:
        return divide(other, self)

    @openeo_process(process_id="multiply", mode="operator")
    def __neg__(self) -> ProcessBuilder:
        return self.multiply(-1)

    @openeo_process(process_id="power", mode="operator")
    def __pow__(self, other) -> ProcessBuilder:
        return self.power(other)

    @openeo_process(process_id="array_element", mode="operator")
    def __getitem__(self, key) -> ProcessBuilder:
        if isinstance(key, builtins.int):
            if key > self._ITERATION_LIMIT:
                raise RuntimeError(
                    "Exceeded ProcessBuilder iteration limit. "
                    "Are you mistakenly using a Python builtin like `sum()` or `all()` in a callback "
                    "instead of the appropriate helpers from the `openeo.processes` module?"
                )
            return self.array_element(index=key)
        else:
            return self.array_element(label=key)

    @openeo_process(process_id="eq", mode="operator")
    def __eq__(self, other) -> ProcessBuilder:
        return eq(self, other)

    @openeo_process(process_id="neq", mode="operator")
    def __ne__(self, other) -> ProcessBuilder:
        return neq(self, other)

    @openeo_process(process_id="lt", mode="operator")
    def __lt__(self, other) -> ProcessBuilder:
        return lt(self, other)

    @openeo_process(process_id="lte", mode="operator")
    def __le__(self, other) -> ProcessBuilder:
        return lte(self, other)

    @openeo_process(process_id="ge", mode="operator")
    def __ge__(self, other) -> ProcessBuilder:
        return gte(self, other)

    @openeo_process(process_id="gt", mode="operator")
    def __gt__(self, other) -> ProcessBuilder:
        return gt(self, other)

    @openeo_process
    def absolute(self) -> ProcessBuilder:
        """
        Absolute value

        :param self: A number.

        :return: The computed absolute value.
        """
        return absolute(x=self)

    @openeo_process
    def add(self, y) -> ProcessBuilder:
        """
        Addition of two numbers

        :param self: The first summand.
        :param y: The second summand.

        :return: The computed sum of the two numbers.
        """
        return add(x=self, y=y)

    @openeo_process
    def add_dimension(self, name, label, type=UNSET) -> ProcessBuilder:
        """
        Add a new dimension

        :param self: A data cube to add the dimension to.
        :param name: Name for the dimension.
        :param label: A dimension label.
        :param type: The type of dimension, defaults to `other`.

        :return: The data cube with a newly added dimension. The new dimension has exactly one dimension label.
            All other dimensions remain unchanged.
        """
        return add_dimension(data=self, name=name, label=label, type=type)

    @openeo_process
    def aggregate_spatial(self, geometries, reducer, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Zonal statistics for geometries

        :param self: A raster data cube.  The data cube must have been reduced to only contain two spatial
            dimensions and a third dimension the values are aggregated for, for example the temporal dimension to
            get a time series. Otherwise, this process fails with the `TooManyDimensions` exception.  The data cube
            implicitly gets restricted to the bounds of the geometries as if ``filter_spatial()`` would have been
            used with the same values for the corresponding parameters immediately before this process.
        :param geometries: Geometries as GeoJSON on which the aggregation will be based. Vector properties are
            preserved for vector data cubes and all GeoJSON Features.  One value will be computed per GeoJSON
            `Feature`, `Geometry` or `GeometryCollection`. For a `FeatureCollection` multiple values will be
            computed, one value per contained `Feature`. For example, a single value will be computed for a
            `MultiPolygon`, but two values will be computed for a `FeatureCollection` containing two polygons.  -
            For **polygons**, the process considers all pixels for which the point at the pixel center intersects
            with the corresponding polygon (as defined in the Simple Features standard by the OGC). - For
            **points**, the process considers the closest pixel center. - For **lines** (line strings), the process
            considers all the pixels whose centers are closest to at least one point on the line.  Thus, pixels may
            be part of multiple geometries and be part of multiple aggregations.  To maximize interoperability, a
            nested `GeometryCollection` should be avoided. Furthermore, a `GeometryCollection` composed of a single
            type of geometries should be avoided in favour of the corresponding multi-part type (e.g.
            `MultiPolygon`).
        :param reducer: A reducer to be applied on all values of each geometry. A reducer is a single process
            such as ``mean()`` or a set of processes, which computes a single value for a list of values, see the
            category 'reducer' for such processes.
        :param target_dimension: The name of a new dimensions that is used to store the results. A new
            dimension will be created with the given name and type `other` (see ``add_dimension()``). Defaults to
            the dimension name `result`. Fails with a `TargetDimensionExists` exception if a dimension with the
            specified name exists.
        :param context: Additional data to be passed to the reducer.

        :return: A vector data cube with the computed results and restricted to the bounds of the geometries.
            The computed value is used for the dimension with the name that was specified in the parameter
            `target_dimension`.  The computation also stores information about the total count of pixels (valid +
            invalid pixels) and the number of valid pixels (see ``is_valid()``) for each geometry. These values are
            added as a new dimension with a dimension name derived from `target_dimension` by adding the suffix
            `_meta`. The new dimension has the dimension labels `total_count` and `valid_count`.
        """
        return aggregate_spatial(
            data=self,
            geometries=geometries,
            reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
            target_dimension=target_dimension,
            context=context
        )

    @openeo_process
    def aggregate_spatial_window(self, reducer, size, boundary=UNSET, align=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Zonal statistics for rectangular windows

        :param self: A raster data cube with exactly two horizontal spatial dimensions and an arbitrary number
            of additional dimensions. The process is applied to all additional dimensions individually.
        :param reducer: A reducer to be applied on the list of values, which contain all pixels covered by the
            window. A reducer is a single process such as ``mean()`` or a set of processes, which computes a single
            value for a list of values, see the category 'reducer' for such processes.
        :param size: Window size in pixels along the horizontal spatial dimensions.  The first value
            corresponds to the `x` axis, the second value corresponds to the `y` axis.
        :param boundary: Behavior to apply if the number of values for the axes `x` and `y` is not a multiple
            of the corresponding value in the `size` parameter. Options are:  - `pad` (default): pad the data cube
            with the no-data value `null` to fit the required window size.  - `trim`: trim the data cube to fit the
            required window size.  Set the parameter `align` to specifies to which corner the data is aligned to.
        :param align: If the data requires padding or trimming (see parameter `boundary`), specifies to which
            corner of the spatial extent the data is aligned to. For example, if the data is aligned to the upper
            left, the process pads/trims at the lower-right.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the newly computed values and the same dimensions.  The resolution will
            change depending on the chosen values for the `size` and `boundary` parameter. It usually decreases for
            the dimensions which have the corresponding parameter `size` set to values greater than 1.  The
            dimension labels will be set to the coordinate at the center of the window. The other dimension
            properties (name, type and reference system) remain unchanged.
        """
        return aggregate_spatial_window(
            data=self,
            reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
            size=size,
            boundary=boundary,
            align=align,
            context=context
        )

    @openeo_process
    def aggregate_temporal(self, intervals, reducer, labels=UNSET, dimension=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Temporal aggregations

        :param self: A data cube.
        :param intervals: Left-closed temporal intervals, which are allowed to overlap. Each temporal interval
            in the array has exactly two elements:  1. The first element is the start of the temporal interval. The
            specified instance in time is **included** in the interval. 2. The second element is the end of the
            temporal interval. The specified instance in time is **excluded** from the interval.  The specified
            temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Although [RFC 3339
            prohibits the hour to be '24'](https://www.rfc-editor.org/rfc/rfc3339.html#section-5.7), **this process
            allows the value '24' for the hour** of an end time in order to make it possible that left-closed time
            intervals can fully cover the day.
        :param reducer: A reducer to be applied for the values contained in each interval. A reducer is a
            single process such as ``mean()`` or a set of processes, which computes a single value for a list of
            values, see the category 'reducer' for such processes. Intervals may not contain any values, which for
            most reducers leads to no-data (`null`) values by default.
        :param labels: Distinct labels for the intervals, which can contain dates and/or times. Is only
            required to be specified if the values for the start of the temporal intervals are not distinct and
            thus the default labels would not be unique. The number of labels and the number of groups need to be
            equal.
        :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
            passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
            expected to only have one temporal dimension. Fails with a `TooManyDimensions` exception if it has more
            dimensions. Fails with a `DimensionNotAvailable` exception if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A new data cube with the same dimensions. The dimension properties (name, type, labels,
            reference system and resolution) remain unchanged, except for the resolution and dimension labels of
            the given temporal dimension.
        """
        return aggregate_temporal(
            data=self,
            intervals=intervals,
            reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
            labels=labels,
            dimension=dimension,
            context=context
        )

    @openeo_process
    def aggregate_temporal_period(self, period, reducer, dimension=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Temporal aggregations based on calendar hierarchies

        :param self: The source data cube.
        :param period: The time intervals to aggregate. The following pre-defined values are available:  *
            `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten day periods,
            counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The third
            dekad of the month can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10 each
            year. * `month`: Month of the year * `season`: Three month periods of the calendar seasons (December -
            February, March - May, June - August, September - November). * `tropical-season`: Six month periods of
            the tropical seasons (November - April, May - October). * `year`: Proleptic years * `decade`: Ten year
            periods ([0-to-9 decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a
            0 to the next year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
            decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the anno Domini (AD)
            calendar era, from a year ending in a 1 to the next year ending in a 0.
        :param reducer: A reducer to be applied for the values contained in each period. A reducer is a single
            process such as ``mean()`` or a set of processes, which computes a single value for a list of values,
            see the category 'reducer' for such processes. Periods may not contain any values, which for most
            reducers leads to no-data (`null`) values by default.
        :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
            passed through the specified reducer. If the dimension is not set or set to `null`, the source data
            cube is expected to only have one temporal dimension. Fails with a `TooManyDimensions` exception if it
            has more dimensions. Fails with a `DimensionNotAvailable` exception if the specified dimension does not
            exist.
        :param context: Additional data to be passed to the reducer.

        :return: A new data cube with the same dimensions. The dimension properties (name, type, labels,
            reference system and resolution) remain unchanged, except for the resolution and dimension labels of
            the given temporal dimension. The specified temporal dimension has the following dimension labels
            (`YYYY` = four-digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`: `YYYY-MM-
            DD-00` - `YYYY-MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` * `dekad`:
            `YYYY-00` - `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December - February),
            `YYYY-mam` (March - May), `YYYY-jja` (June - August), `YYYY-son` (September - November). * `tropical-
            season`: `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` * `decade`:
            `YYY0` * `decade-ad`: `YYY1`  The dimension labels in the new data cube are complete for the whole
            extent of the source data cube. For example, if `period` is set to `day` and the source data cube has
            two dimension labels at the beginning of the year (`2020-01-01`) and the end of a year (`2020-12-31`),
            the process returns a data cube with 365 dimension labels (`2020-001`, `2020-002`, ..., `2020-365`). In
            contrast, if `period` is set to `day` and the source data cube has just one dimension label
            `2020-01-05`, the process returns a data cube with just a single dimension label (`2020-005`).
        """
        return aggregate_temporal_period(
            data=self,
            period=period,
            reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
            dimension=dimension,
            context=context
        )

    @openeo_process
    def all(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Are all of the values true?

        :param self: A set of boolean values.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

        :return: Boolean result of the logical operation.
        """
        return all(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def and_(self, y) -> ProcessBuilder:
        """
        Logical AND

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical AND.
        """
        return and_(x=self, y=y)

    @openeo_process
    def anomaly(self, normals, period) -> ProcessBuilder:
        """
        Compute anomalies

        :param self: A data cube with exactly one temporal dimension and the following dimension labels for the
            given period (`YYYY` = four-digit year, `MM` = two-digit month, `DD` two-digit day of month):  *
            `hour`: `YYYY-MM-DD-00` - `YYYY-MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` -
            `YYYY-52` * `dekad`: `YYYY-00` - `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf`
            (December - February), `YYYY-mam` (March - May), `YYYY-jja` (June - August), `YYYY-son` (September -
            November). * `tropical-season`: `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). *
            `year`: `YYYY` * `decade`: `YYY0` * `decade-ad`: `YYY1` * `single-period` / `climatology-period`: Any
            ``aggregate_temporal_period()`` can compute such a data cube.
        :param normals: A data cube with normals, e.g. daily, monthly or yearly values computed from a process
            such as ``climatological_normal()``. Must contain exactly one temporal dimension with the following
            dimension labels for the given period:  * `hour`: `00` - `23` * `day`: `001` - `365` * `week`: `01` -
            `52` * `dekad`: `00` - `36` * `month`: `01` - `12` * `season`: `djf` (December - February), `mam`
            (March - May), `jja` (June - August), `son` (September - November) * `tropical-season`: `ndjfma`
            (November - April), `mjjaso` (May - October) * `year`: Four-digit year numbers * `decade`: Four-digit
            year numbers, the last digit being a `0` * `decade-ad`: Four-digit year numbers, the last digit being a
            `1` * `single-period` / `climatology-period`: A single dimension label with any name is expected.
        :param period: Specifies the time intervals available in the normals data cube. The following options
            are available:  * `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year *
            `dekad`: Ten day periods, counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 -
            end of month). The third dekad of the month can range from 8 to 11 days. For example, the fourth dekad
            is Feb, 1 - Feb, 10 each year. * `month`: Month of the year * `season`: Three month periods of the
            calendar seasons (December - February, March - May, June - August, September - November). * `tropical-
            season`: Six month periods of the tropical seasons (November - April, May - October). * `year`:
            Proleptic years * `decade`: Ten year periods ([0-to-9
            decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the next
            year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
            decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the anno Domini (AD)
            calendar era, from a year ending in a 1 to the next year ending in a 0. * `single-period` /
            `climatology-period`: A single period of arbitrary length

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged.
        """
        return anomaly(data=self, normals=normals, period=period)

    @openeo_process
    def any(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Is at least one value true?

        :param self: A set of boolean values.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

        :return: Boolean result of the logical operation.
        """
        return any(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def apply(self, process, context=UNSET) -> ProcessBuilder:
        """
        Apply a process to each pixel

        :param self: A data cube.
        :param process: A process that accepts and returns a single value and is applied on each individual
            value in the data cube. The process may consist of multiple sub-processes and could, for example,
            consist of processes such as ``absolute()`` or ``linear_scale_range()``.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply(data=self, process=build_child_callback(process, parent_parameters=['x', 'context']), context=context)

    @openeo_process
    def apply_dimension(self, process, dimension, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Apply a process to pixels along a dimension

        :param self: A data cube.
        :param process: Process to be applied on all pixel values. The specified process needs to accept an
            array and must return an array with at least one element. A process may consist of multiple sub-
            processes.
        :param dimension: The name of the source dimension to apply the process on. Fails with a
            `DimensionNotAvailable` exception if the specified dimension does not exist.
        :param target_dimension: The name of the target dimension or `null` (the default) to use the source
            dimension specified in the parameter `dimension`.  By specifying a target dimension, the source
            dimension is removed. The target dimension with the specified name and the type `other` (see
            ``add_dimension()``) is created, if it doesn't exist yet.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values.  All dimensions stay the same, except for the
            dimensions specified in corresponding parameters. There are three cases how the dimensions can change:
            1. The source dimension is the target dimension:    - The (number of) dimensions remain unchanged as
            the source dimension is the target dimension.    - The source dimension properties name and type remain
            unchanged.    - The dimension labels, the reference system and the resolution are preserved only if the
            number of pixel values in the source dimension is equal to the number of values computed by the
            process. Otherwise, all other dimension properties change as defined in the list below. 2. The source
            dimension is not the target dimension and the latter exists:    - The number of dimensions decreases by
            one as the source dimension is dropped.    - The target dimension properties name and type remain
            unchanged. All other dimension properties change as defined in the list below. 3. The source dimension
            is not the target dimension and the latter does not exist:    - The number of dimensions remain
            unchanged, but the source dimension is replaced with the target dimension.    - The target dimension
            has the specified name and the type other. All other dimension properties are set as defined in the
            list below.  Unless otherwise stated above, for the given (target) dimension the following applies:  -
            the number of dimension labels is equal to the number of values computed by the process, - the
            dimension labels are incrementing integers starting from zero, - the resolution changes, and - the
            reference system is undefined.
        """
        return apply_dimension(
            data=self,
            process=build_child_callback(process, parent_parameters=['data', 'context']),
            dimension=dimension,
            target_dimension=target_dimension,
            context=context
        )

    @openeo_process
    def apply_kernel(self, kernel, factor=UNSET, border=UNSET, replace_invalid=UNSET) -> ProcessBuilder:
        """
        Apply a spatial convolution with a kernel

        :param self: A data cube.
        :param kernel: Kernel as a two-dimensional array of weights. The inner level of the nested array aligns
            with the `x` axis and the outer level aligns with the `y` axis. Each level of the kernel must have an
            uneven number of elements, otherwise the process throws a `KernelDimensionsUneven` exception.
        :param factor: A factor that is multiplied to each value after the kernel has been applied.  This is
            basically a shortcut for explicitly multiplying each value by a factor afterwards, which is often
            required for some kernel-based algorithms such as the Gaussian blur.
        :param border: Determines how the data is extended when the kernel overlaps with the borders. Defaults
            to fill the border with zeroes.  The following options are available:  * *numeric value* - fill with a
            user-defined constant number `n`: `nnnnnn|abcdefgh|nnnnnn` (default, with `n` = 0) * `replicate` -
            repeat the value from the pixel at the border: `aaaaaa|abcdefgh|hhhhhh` * `reflect` - mirror/reflect
            from the border: `fedcba|abcdefgh|hgfedc` * `reflect_pixel` - mirror/reflect from the center of the
            pixel at the border: `gfedcb|abcdefgh|gfedcb` * `wrap` - repeat/wrap the image:
            `cdefgh|abcdefgh|abcdef`
        :param replace_invalid: This parameter specifies the value to replace non-numerical or infinite
            numerical values with. By default, those values are replaced with zeroes.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply_kernel(data=self, kernel=kernel, factor=factor, border=border, replace_invalid=replace_invalid)

    @openeo_process
    def apply_neighborhood(self, process, size, overlap=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Apply a process to pixels in a n-dimensional neighborhood

        :param self: A data cube.
        :param process: Process to be applied on all neighborhoods.
        :param size: Neighborhood sizes along each dimension.  This object maps dimension names to either a
            physical measure (e.g. 100 m, 10 days) or pixels (e.g. 32 pixels). For dimensions not specified, the
            default is to provide all values. Be aware that including all values from overly large dimensions may
            not be processed at once.
        :param overlap: Overlap of neighborhoods along each dimension to avoid border effects. By default no
            overlap is provided.  For instance a temporal dimension can add 1 month before and after a
            neighborhood. In the spatial dimensions, this is often a number of pixels. The overlap specified is
            added before and after, so an overlap of 8 pixels will add 8 pixels on both sides of the window, so 16
            in total.  Be aware that large overlaps increase the need for computational resources and modifying
            overlapping data in subsequent operations have no effect.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply_neighborhood(
            data=self,
            process=build_child_callback(process, parent_parameters=['data', 'context']),
            size=size,
            overlap=overlap,
            context=context
        )

    @openeo_process
    def arccos(self) -> ProcessBuilder:
        """
        Inverse cosine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arccos(x=self)

    @openeo_process
    def arcosh(self) -> ProcessBuilder:
        """
        Inverse hyperbolic cosine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arcosh(x=self)

    @openeo_process
    def arcsin(self) -> ProcessBuilder:
        """
        Inverse sine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arcsin(x=self)

    @openeo_process
    def arctan(self) -> ProcessBuilder:
        """
        Inverse tangent

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arctan(x=self)

    @openeo_process
    def arctan2(self, x) -> ProcessBuilder:
        """
        Inverse tangent of two numbers

        :param self: A number to be used as the dividend.
        :param x: A number to be used as the divisor.

        :return: The computed angle in radians.
        """
        return arctan2(y=self, x=x)

    @openeo_process
    def ard_normalized_radar_backscatter(self, elevation_model=UNSET, contributing_area=UNSET, ellipsoid_incidence_angle=UNSET, noise_removal=UNSET, options=UNSET) -> ProcessBuilder:
        """
        CARD4L compliant SAR NRB generation

        :param self: The source data cube containing SAR input.
        :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the
            back-end to choose, which will improve portability, but reduce reproducibility.
        :param contributing_area: If set to `true`, a DEM-based local contributing area band named
            `contributing_area` is added. The values are given in square meters.
        :param ellipsoid_incidence_angle: If set to `true`, an ellipsoidal incidence angle band named
            `ellipsoid_incidence_angle` is added. The values are given in degrees.
        :param noise_removal: If set to `false`, no noise removal is applied. Defaults to `true`, which removes
            noise.
        :param options: Proprietary options for the backscatter computations. Specifying proprietary options
            will reduce portability.

        :return: Backscatter values expressed as gamma0 in linear scale.  In addition to the bands
            `contributing_area` and `ellipsoid_incidence_angle` that can optionally be added with corresponding
            parameters, the following bands are always added to the data cube:  - `mask`: A data mask that
            indicates which values are valid (1), invalid (0) or contain no-data (null). - `local_incidence_angle`:
            A band with DEM-based local incidence angles in degrees.  The data returned is CARD4L compliant with
            corresponding metadata.
        """
        return ard_normalized_radar_backscatter(
            data=self,
            elevation_model=elevation_model,
            contributing_area=contributing_area,
            ellipsoid_incidence_angle=ellipsoid_incidence_angle,
            noise_removal=noise_removal,
            options=options
        )

    @openeo_process
    def ard_surface_reflectance(self, atmospheric_correction_method, cloud_detection_method, elevation_model=UNSET, atmospheric_correction_options=UNSET, cloud_detection_options=UNSET) -> ProcessBuilder:
        """
        CARD4L compliant Surface Reflectance generation

        :param self: The source data cube containing multi-spectral optical top of the atmosphere (TOA)
            reflectances. There must be a single dimension of type `bands` available.
        :param atmospheric_correction_method: The atmospheric correction method to use.
        :param cloud_detection_method: The cloud detection method to use.  Each method supports detecting
            different atmospheric disturbances such as clouds, cloud shadows, aerosols, haze, ozone and/or water
            vapour in optical imagery.
        :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the
            back-end to choose, which will improve portability, but reduce reproducibility.
        :param atmospheric_correction_options: Proprietary options for the atmospheric correction method.
            Specifying proprietary options will reduce portability.
        :param cloud_detection_options: Proprietary options for the cloud detection method. Specifying
            proprietary options will reduce portability.

        :return: Data cube containing bottom of atmosphere reflectances for each spectral band in the source
            data cube, with atmospheric disturbances like clouds and cloud shadows removed. No-data values (null)
            are directly set in the bands. Depending on the methods used, several additional bands will be added to
            the data cube:  Data cube containing bottom of atmosphere reflectances for each spectral band in the
            source data cube, with atmospheric disturbances like clouds and cloud shadows removed. Depending on the
            methods used, several additional bands will be added to the data cube:  - `date` (optional): Specifies
            per-pixel acquisition timestamps. - `incomplete-testing` (required): Identifies pixels with a value of
            1 for which the per-pixel tests (at least saturation, cloud and cloud shadows, see CARD4L specification
            for details) have not all been successfully completed. Otherwise, the value is 0. - `saturation`
            (required) / `saturation_{band}` (optional): Indicates where pixels in the input spectral bands are
            saturated (1) or not (0). If the saturation is given per band, the band names are `saturation_{band}`
            with `{band}` being the band name from the source data cube. - `cloud`, `shadow` (both
            required),`aerosol`, `haze`, `ozone`, `water_vapor` (all optional): Indicates the probability of pixels
            being an atmospheric disturbance such as clouds. All bands have values between 0 (clear) and 1, which
            describes the probability that it is an atmospheric disturbance. - `snow-ice` (optional): Points to a
            file that indicates whether a pixel is assessed as being snow/ice (1) or not (0). All values describe
            the probability and must be between 0 and 1. - `land-water` (optional): Indicates whether a pixel is
            assessed as being land (1) or water (0). All values describe the probability and must be between 0 and
            1. - `incidence-angle` (optional): Specifies per-pixel incidence angles in degrees. - `azimuth`
            (optional): Specifies per-pixel azimuth angles in degrees. - `sun-azimuth:` (optional): Specifies per-
            pixel sun azimuth angles in degrees. - `sun-elevation` (optional): Specifies per-pixel sun elevation
            angles in degrees. - `terrain-shadow` (optional): Indicates with a value of 1 whether a pixel is not
            directly illuminated due to terrain shadowing. Otherwise, the value is 0. - `terrain-occlusion`
            (optional): Indicates with a value of 1 whether a pixel is not visible to the sensor due to terrain
            occlusion during off-nadir viewing. Otherwise, the value is 0. - `terrain-illumination` (optional):
            Contains coefficients used for terrain illumination correction are provided for each pixel.  The data
            returned is CARD4L compliant with corresponding metadata.
        """
        return ard_surface_reflectance(
            data=self,
            atmospheric_correction_method=atmospheric_correction_method,
            cloud_detection_method=cloud_detection_method,
            elevation_model=elevation_model,
            atmospheric_correction_options=atmospheric_correction_options,
            cloud_detection_options=cloud_detection_options
        )

    @openeo_process
    def array_append(self, value, label=UNSET) -> ProcessBuilder:
        """
        Append a value to an array

        :param self: An array.
        :param value: Value to append to the array.
        :param label: If the given array is a labeled array, a new label for the new value should be given. If
            not given or `null`, the array index as string is used as the label. If in any case the label exists, a
            `LabelExists` exception is thrown.

        :return: The new array with the value being appended.
        """
        return array_append(data=self, value=value, label=label)

    @openeo_process
    def array_apply(self, process, context=UNSET) -> ProcessBuilder:
        """
        Apply a process to each array element

        :param self: An array.
        :param process: A process that accepts and returns a single value and is applied on each individual
            value in the array. The process may consist of multiple sub-processes and could, for example, consist
            of processes such as ``absolute()`` or ``linear_scale_range()``.
        :param context: Additional data to be passed to the process.

        :return: An array with the newly computed values. The number of elements are the same as for the
            original array.
        """
        return array_apply(
            data=self,
            process=build_child_callback(process, parent_parameters=['x', 'index', 'label', 'context']),
            context=context
        )

    @openeo_process
    def array_concat(self, array2) -> ProcessBuilder:
        """
        Merge two arrays

        :param self: The first array.
        :param array2: The second array.

        :return: The merged array.
        """
        return array_concat(array1=self, array2=array2)

    @openeo_process
    def array_contains(self, value) -> ProcessBuilder:
        """
        Check whether the array contains a given value

        :param self: List to find the value in.
        :param value: Value to find in `data`. If the value is `null`, this process returns always `false`.

        :return: `true` if the list contains the value, false` otherwise.
        """
        return array_contains(data=self, value=value)

    @openeo_process
    def array_create(self=UNSET, repeat=UNSET) -> ProcessBuilder:
        """
        Create an array

        :param self: A (native) array to fill the newly created array with. Defaults to an empty array.
        :param repeat: The number of times the (native) array specified in `data` is repeatedly added after
            each other to the new array being created. Defaults to `1`.

        :return: The newly created array.
        """
        return array_create(data=self, repeat=repeat)

    @openeo_process
    def array_create_labeled(self, labels) -> ProcessBuilder:
        """
        Create a labeled array

        :param self: An array of values to be used.
        :param labels: An array of labels to be used.

        :return: The newly created labeled array.
        """
        return array_create_labeled(data=self, labels=labels)

    @openeo_process
    def array_element(self, index=UNSET, label=UNSET, return_nodata=UNSET) -> ProcessBuilder:
        """
        Get an element from an array

        :param self: An array.
        :param index: The zero-based index of the element to retrieve.
        :param label: The label of the element to retrieve. Throws an `ArrayNotLabeled` exception, if the given
            array is not a labeled array and this parameter is set.
        :param return_nodata: By default this process throws an `ArrayElementNotAvailable` exception if the
            index or label is invalid. If you want to return `null` instead, set this flag to `true`.

        :return: The value of the requested element.
        """
        return array_element(data=self, index=index, label=label, return_nodata=return_nodata)

    @openeo_process
    def array_filter(self, condition, context=UNSET) -> ProcessBuilder:
        """
        Filter an array based on a condition

        :param self: An array.
        :param condition: A condition that is evaluated against each value, index and/or label in the array.
            Only the array elements for which the condition returns `true` are preserved.
        :param context: Additional data to be passed to the condition.

        :return: An array filtered by the specified condition. The number of elements are less than or equal
            compared to the original array.
        """
        return array_filter(
            data=self,
            condition=build_child_callback(condition, parent_parameters=['x', 'index', 'label', 'context']),
            context=context
        )

    @openeo_process
    def array_find(self, value, reverse=UNSET) -> ProcessBuilder:
        """
        Get the index for a value in an array

        :param self: List to find the value in.
        :param value: Value to find in `data`. If the value is `null`, this process returns always `null`.
        :param reverse: By default, this process finds the index of the first match. To return the index of the
            last match instead, set this flag to `true`.

        :return: The index of the first element with the specified value. If no element was found, `null` is
            returned.
        """
        return array_find(data=self, value=value, reverse=reverse)

    @openeo_process
    def array_find_label(self, label) -> ProcessBuilder:
        """
        Get the index for a label in a labeled array

        :param self: List to find the label in.
        :param label: Label to find in `data`.

        :return: The index of the element with the specified label assigned. If no such label was found, `null`
            is returned.
        """
        return array_find_label(data=self, label=label)

    @openeo_process
    def array_interpolate_linear(self) -> ProcessBuilder:
        """
        One-dimensional linear interpolation for arrays

        :param self: An array of numbers and no-data values.  If the given array is a labeled array, the labels
            must have a natural/inherent label order and the process expects the labels to be sorted accordingly.
            This is the default behavior in openEO for spatial and temporal dimensions.

        :return: An array with no-data values being replaced with interpolated values. If not at least 2
            numerical values are available in the array, the array stays the same.
        """
        return array_interpolate_linear(data=self)

    @openeo_process
    def array_labels(self) -> ProcessBuilder:
        """
        Get the labels for an array

        :param self: An array.

        :return: The labels or indices as array.
        """
        return array_labels(data=self)

    @openeo_process
    def array_modify(self, values, index, length=UNSET) -> ProcessBuilder:
        """
        Change the content of an array (remove, insert, update)

        :param self: The array to modify.
        :param values: The values to insert into the `data` array.
        :param index: The index in the `data` array of the element to insert the value(s) before. If the index
            is greater than the number of elements in the `data` array, the process throws an
            `ArrayElementNotAvailable` exception.  To insert after the last element, there are two options:  1. Use
            the simpler processes ``array_append()`` to append a single value or ``array_concat()`` to append
            multiple values. 2. Specify the number of elements in the array. You can retrieve the number of
            elements with the process ``count()``, having the parameter `condition` set to `true`.
        :param length: The number of elements in the `data` array to remove (or replace) starting from the
            given index. If the array contains fewer elements, the process simply removes all elements up to the
            end.

        :return: An array with values added, updated or removed.
        """
        return array_modify(data=self, values=values, index=index, length=length)

    @openeo_process
    def arsinh(self) -> ProcessBuilder:
        """
        Inverse hyperbolic sine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arsinh(x=self)

    @openeo_process
    def artanh(self) -> ProcessBuilder:
        """
        Inverse hyperbolic tangent

        :param self: A number.

        :return: The computed angle in radians.
        """
        return artanh(x=self)

    @openeo_process
    def atmospheric_correction(self, method, elevation_model=UNSET, options=UNSET) -> ProcessBuilder:
        """
        Apply atmospheric correction

        :param self: Data cube containing multi-spectral optical top of atmosphere reflectances to be
            corrected.
        :param method: The atmospheric correction method to use. To get reproducible results, you have to set a
            specific method.  Set to `null` to allow the back-end to choose, which will improve portability, but
            reduce reproducibility as you *may* get different results if you run the processes multiple times.
        :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the
            back-end to choose, which will improve portability, but reduce reproducibility.
        :param options: Proprietary options for the atmospheric correction method. Specifying proprietary
            options will reduce portability.

        :return: Data cube containing bottom of atmosphere reflectances.
        """
        return atmospheric_correction(data=self, method=method, elevation_model=elevation_model, options=options)

    @openeo_process
    def between(self, min, max, exclude_max=UNSET) -> ProcessBuilder:
        """
        Between comparison

        :param self: The value to check.
        :param min: Lower boundary (inclusive) to check against.
        :param max: Upper boundary (inclusive) to check against.
        :param exclude_max: Exclude the upper boundary `max` if set to `true`. Defaults to `false`.

        :return: `true` if `x` is between the specified bounds, otherwise `false`.
        """
        return between(x=self, min=min, max=max, exclude_max=exclude_max)

    @openeo_process
    def ceil(self) -> ProcessBuilder:
        """
        Round fractions up

        :param self: A number to round up.

        :return: The number rounded up.
        """
        return ceil(x=self)

    @openeo_process
    def climatological_normal(self, period, climatology_period=UNSET) -> ProcessBuilder:
        """
        Compute climatology normals

        :param self: A data cube with exactly one temporal dimension. The data cube must span at least the
            temporal interval specified in the parameter `climatology-period`.  Seasonal periods may span two
            consecutive years, e.g. temporal winter that includes months December, January and February. If the
            required months before the actual climate period are available, the season is taken into account. If
            not available, the first season is not taken into account and the seasonal mean is based on one year
            less than the other seasonal normals. The incomplete season at the end of the last year is never taken
            into account.
        :param period: The time intervals to aggregate the average value for. The following pre-defined
            frequencies are supported:  * `day`: Day of the year * `month`: Month of the year * `climatology-
            period`: The period specified in the `climatology-period`. * `season`: Three month periods of the
            calendar seasons (December - February, March - May, June - August, September - November). * `tropical-
            season`: Six month periods of the tropical seasons (November - April, May - October).
        :param climatology_period: The climatology period as a closed temporal interval. The first element of
            the array is the first year to be fully included in the temporal interval. The second element is the
            last year to be fully included in the temporal interval. The default period is from 1981 until 2010
            (both inclusive).

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the temporal
            dimension. The temporal dimension has the following dimension labels:  * `day`: `001` - `365` *
            `month`: `01` - `12` * `climatology-period`: `climatology-period` * `season`: `djf` (December -
            February), `mam` (March - May), `jja` (June - August), `son` (September - November) * `tropical-
            season`: `ndjfma` (November - April), `mjjaso` (May - October)
        """
        return climatological_normal(data=self, period=period, climatology_period=climatology_period)

    @openeo_process
    def clip(self, min, max) -> ProcessBuilder:
        """
        Clip a value between a minimum and a maximum

        :param self: A number.
        :param min: Minimum value. If the value is lower than this value, the process will return the value of
            this parameter.
        :param max: Maximum value. If the value is greater than this value, the process will return the value
            of this parameter.

        :return: The value clipped to the specified range.
        """
        return clip(x=self, min=min, max=max)

    @openeo_process
    def cloud_detection(self, method, options=UNSET) -> ProcessBuilder:
        """
        Create cloud masks

        :param self: The source data cube containing multi-spectral optical top of the atmosphere (TOA)
            reflectances on which to perform cloud detection.
        :param method: The cloud detection method to use. To get reproducible results, you have to set a
            specific method.  Set to `null` to allow the back-end to choose, which will improve portability, but
            reduce reproducibility as you *may* get different results if you run the processes multiple times.
        :param options: Proprietary options for the cloud detection method. Specifying proprietary options will
            reduce portability.

        :return: A data cube with bands for the atmospheric disturbances. Each of the masks contains values
            between 0 and 1. The data cube has the same spatial and temporal dimensions as the source data cube and
            a dimension that contains a dimension label for each of the supported/considered atmospheric
            disturbance.
        """
        return cloud_detection(data=self, method=method, options=options)

    @openeo_process
    def constant(self) -> ProcessBuilder:
        """
        Define a constant value

        :param self: The value of the constant.

        :return: The value of the constant.
        """
        return constant(x=self)

    @openeo_process
    def cos(self) -> ProcessBuilder:
        """
        Cosine

        :param self: An angle in radians.

        :return: The computed cosine of `x`.
        """
        return cos(x=self)

    @openeo_process
    def cosh(self) -> ProcessBuilder:
        """
        Hyperbolic cosine

        :param self: An angle in radians.

        :return: The computed hyperbolic cosine of `x`.
        """
        return cosh(x=self)

    @openeo_process
    def count(self, condition=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Count the number of elements

        :param self: An array with elements of any data type.
        :param condition: A condition consists of one or more processes, which in the end return a boolean
            value. It is evaluated against each element in the array. An element is counted only if the condition
            returns `true`. Defaults to count valid elements in a list (see ``is_valid()``). Setting this parameter
            to boolean `true` counts all elements in the list.
        :param context: Additional data to be passed to the condition.

        :return: The counted number of elements.
        """
        return count(data=self, condition=condition, context=context)

    @openeo_process
    def create_raster_cube(self) -> ProcessBuilder:
        """
        Create an empty raster data cube

        :return: An empty raster data cube with zero dimensions.
        """
        return create_raster_cube()

    @openeo_process
    def cummax(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Cumulative maxima

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative maxima.
        """
        return cummax(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def cummin(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Cumulative minima

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative minima.
        """
        return cummin(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def cumproduct(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Cumulative products

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative products.
        """
        return cumproduct(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def cumsum(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Cumulative sums

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative sums.
        """
        return cumsum(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def date_shift(self, value, unit) -> ProcessBuilder:
        """
        Manipulates dates and times by addition or subtraction

        :param self: The date (and optionally time) to manipulate.  If the given date doesn't include the time,
            the process assumes that the time component is `00:00:00Z` (i.e. midnight, in UTC). The millisecond
            part of the time is optional and defaults to `0` if not given.
        :param value: The period of time in the unit given that is added (positive numbers) or subtracted
            (negative numbers). The value `0` doesn't have any effect.
        :param unit: The unit for the value given. The following pre-defined units are available:  -
            millisecond: Milliseconds - second: Seconds - leap seconds are ignored in computations. - minute:
            Minutes - hour: Hours - day: Days - changes only the the day part of a date - week: Weeks (equivalent
            to 7 days) - month: Months - year: Years  Manipulations with the unit `year`, `month`, `week` or `day`
            do never change the time. If any of the manipulations result in an invalid date or time, the
            corresponding part is rounded down to the next valid date or time respectively. For example, adding a
            month to `2020-01-31` would result in `2020-02-29`.

        :return: The manipulated date. If a time component was given in the parameter `date`, the time
            component is returned with the date.
        """
        return date_shift(date=self, value=value, unit=unit)

    @openeo_process
    def dimension_labels(self, dimension) -> ProcessBuilder:
        """
        Get the dimension labels

        :param self: The data cube.
        :param dimension: The name of the dimension to get the labels for.

        :return: The labels as an array.
        """
        return dimension_labels(data=self, dimension=dimension)

    @openeo_process
    def divide(self, y) -> ProcessBuilder:
        """
        Division of two numbers

        :param self: The dividend.
        :param y: The divisor.

        :return: The computed result.
        """
        return divide(x=self, y=y)

    @openeo_process
    def drop_dimension(self, name) -> ProcessBuilder:
        """
        Remove a dimension

        :param self: The data cube to drop a dimension from.
        :param name: Name of the dimension to drop.

        :return: A data cube without the specified dimension. The number of dimensions decreases by one, but
            the dimension properties (name, type, labels, reference system and resolution) for all other dimensions
            remain unchanged.
        """
        return drop_dimension(data=self, name=name)

    @openeo_process
    def e(self) -> ProcessBuilder:
        """
        Euler's number (e)

        :return: The numerical value of Euler's number.
        """
        return e()

    @openeo_process
    def eq(self, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
        """
        Equal to comparison

        :param self: First operand.
        :param y: Second operand.
        :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a
            positive non-zero number the equality of two numbers is checked against a delta value. This is
            especially useful to circumvent problems with floating-point inaccuracy in machine-based computation.
            This option is basically an alias for the following computation: `lte(abs(minus([x, y]), delta)`
        :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be
            disabled by setting this parameter to `false`.

        :return: `true` if `x` is equal to `y`, `null` if any operand is `null`, otherwise `false`.
        """
        return eq(x=self, y=y, delta=delta, case_sensitive=case_sensitive)

    @openeo_process
    def exp(self) -> ProcessBuilder:
        """
        Exponentiation to the base e

        :param self: The numerical exponent.

        :return: The computed value for *e* raised to the power of `p`.
        """
        return exp(p=self)

    @openeo_process
    def extrema(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Minimum and maximum values

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that an array with two `null` values is
            returned if any value is such a value.

        :return: An array containing the minimum and maximum values for the specified numbers. The first
            element is the minimum, the second element is the maximum. If the input array is empty both elements
            are set to `null`.
        """
        return extrema(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def filter_bands(self, bands=UNSET, wavelengths=UNSET) -> ProcessBuilder:
        """
        Filter the bands by names

        :param self: A data cube with bands.
        :param bands: A list of band names. Either the unique band name (metadata field `name` in bands) or one
            of the common band names (metadata field `common_name` in bands). If the unique band name and the
            common name conflict, the unique band name has a higher priority.  The order of the specified array
            defines the order of the bands in the data cube. If multiple bands match a common name, all matched
            bands are included in the original order.
        :param wavelengths: A list of sub-lists with each sub-list consisting of two elements. The first
            element is the minimum wavelength and the second element is the maximum wavelength. Wavelengths are
            specified in micrometers (μm).  The order of the specified array defines the order of the bands in the
            data cube. If multiple bands match the wavelengths, all matched bands are included in the original
            order.

        :return: A data cube limited to a subset of its original bands. The dimensions and dimension properties
            (name, type, labels, reference system and resolution) remain unchanged, except that the dimension of
            type `bands` has less (or the same) dimension labels.
        """
        return filter_bands(data=self, bands=bands, wavelengths=wavelengths)

    @openeo_process
    def filter_bbox(self, extent) -> ProcessBuilder:
        """
        Spatial filter using a bounding box

        :param self: A data cube.
        :param extent: A bounding box, which may include a vertical axis (see `base` and `height`).

        :return: A data cube restricted to the bounding box. The dimensions and dimension properties (name,
            type, labels, reference system and resolution) remain unchanged, except that the spatial dimensions
            have less (or the same) dimension labels.
        """
        return filter_bbox(data=self, extent=extent)

    @openeo_process
    def filter_labels(self, condition, dimension, context=UNSET) -> ProcessBuilder:
        """
        Filter dimension labels based on a condition

        :param self: A data cube.
        :param condition: A condition that is evaluated against each dimension label in the specified
            dimension. A dimension label and the corresponding data is preserved for the given dimension, if the
            condition returns `true`.
        :param dimension: The name of the dimension to filter on. Fails with a `DimensionNotAvailable`
            exception if the specified dimension does not exist.
        :param context: Additional data to be passed to the condition.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except that the given dimension has less (or the same)
            dimension labels.
        """
        return filter_labels(
            data=self,
            condition=build_child_callback(condition, parent_parameters=['value', 'context']),
            dimension=dimension,
            context=context
        )

    @openeo_process
    def filter_spatial(self, geometries) -> ProcessBuilder:
        """
        Spatial filter using geometries

        :param self: A data cube.
        :param geometries: One or more geometries used for filtering, specified as GeoJSON.

        :return: A data cube restricted to the specified geometries. The dimensions and dimension properties
            (name, type, labels, reference system and resolution) remain unchanged, except that the spatial
            dimensions have less (or the same) dimension labels.
        """
        return filter_spatial(data=self, geometries=geometries)

    @openeo_process
    def filter_temporal(self, extent, dimension=UNSET) -> ProcessBuilder:
        """
        Temporal filter based on temporal intervals

        :param self: A data cube.
        :param extent: Left-closed temporal interval, i.e. an array with exactly two elements:  1. The first
            element is the start of the temporal interval. The specified instance in time is **included** in the
            interval. 2. The second element is the end of the temporal interval. The specified instance in time is
            **excluded** from the interval.  The specified temporal strings follow [RFC 3339](https://www.rfc-
            editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`,
            but never both.
        :param dimension: The name of the temporal dimension to filter on. If no specific dimension is
            specified or it is set to `null`, the filter applies to all temporal dimensions. Fails with a
            `DimensionNotAvailable` exception if the specified dimension does not exist.

        :return: A data cube restricted to the specified temporal extent. The dimensions and dimension
            properties (name, type, labels, reference system and resolution) remain unchanged, except that the
            temporal dimensions (determined by `dimensions` parameter) may have less dimension labels.
        """
        return filter_temporal(data=self, extent=extent, dimension=dimension)

    @openeo_process
    def first(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        First element

        :param self: An array with elements of any data type.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if the first value is
            such a value.

        :return: The first element of the input array.
        """
        return first(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def fit_class_random_forest(self, target, max_variables, num_trees=UNSET, seed=UNSET) -> ProcessBuilder:
        """
        Train a random forest classification model

        :param self: The predictors for the classification model as a vector data cube. Aggregated to the
            features (vectors) of the target input variable.
        :param target: The training sites for the classification model as a vector data cube. This is
            associated with the target variable for the Random Forest model. The geometry has to associated with a
            value to predict (e.g. fractional forest canopy cover).
        :param max_variables: Specifies how many split variables will be used at a node.  The following options
            are available:  - *integer*: The given number of variables are considered for each split. - `all`: All
            variables are considered for each split. - `log2`: The logarithm with base 2 of the number of variables
            are considered for each split. - `onethird`: A third of the number of variables are considered for each
            split. - `sqrt`: The square root of the number of variables are considered for each split. This is
            often the default for classification.
        :param num_trees: The number of trees build within the Random Forest classification.
        :param seed: A randomization seed to use for the random sampling in training. If not given or `null`,
            no seed is used and results may differ on subsequent use.

        :return: A model object that can be saved with ``save_ml_model()`` and restored with
            ``load_ml_model()``.
        """
        return fit_class_random_forest(predictors=self, target=target, max_variables=max_variables, num_trees=num_trees, seed=seed)

    @openeo_process
    def fit_curve(self, parameters, function, dimension) -> ProcessBuilder:
        """
        Curve fitting

        :param self: A data cube.
        :param parameters: Defined the number of parameters for the model function and provides an initial
            guess for them. At least one parameter is required.
        :param function: The model function. It must take the parameters to fit as array through the first
            argument and the independent variable `x` as the second argument.  It is recommended to store the model
            function as a user-defined process on the back-end to be able to re-use the model function with the
            computed optimal values for the parameters afterwards.
        :param dimension: The name of the dimension for curve fitting. Must be a dimension with labels that
            have a order (i.e. numerical labels or a temporal dimension). Fails with a `DimensionNotAvailable`
            exception if the specified dimension does not exist.

        :return: A data cube with the optimal values for the parameters.
        """
        return fit_curve(
            data=self,
            parameters=parameters,
            function=build_child_callback(function, parent_parameters=['x', 'parameters']),
            dimension=dimension
        )

    @openeo_process
    def fit_regr_random_forest(self, target, max_variables, num_trees=UNSET, seed=UNSET) -> ProcessBuilder:
        """
        Train a random forest regression model

        :param self: The predictors for the regression model as a vector data cube. Aggregated to the features
            (vectors) of the target input variable.
        :param target: The training sites for the regression model as a vector data cube. This is associated
            with the target variable for the Random Forest model. The geometry has to associated with a value to
            predict (e.g. fractional forest canopy cover).
        :param max_variables: Specifies how many split variables will be used at a node.  The following options
            are available:  - *integer*: The given number of variables are considered for each split. - `all`: All
            variables are considered for each split. - `log2`: The logarithm with base 2 of the number of variables
            are considered for each split. - `onethird`: A third of the number of variables are considered for each
            split. This is often the default for regression. - `sqrt`: The square root of the number of variables
            are considered for each split.
        :param num_trees: The number of trees build within the Random Forest regression.
        :param seed: A randomization seed to use for the random sampling in training. If not given or `null`,
            no seed is used and results may differ on subsequent use.

        :return: A model object that can be saved with ``save_ml_model()`` and restored with
            ``load_ml_model()``.
        """
        return fit_regr_random_forest(predictors=self, target=target, max_variables=max_variables, num_trees=num_trees, seed=seed)

    @openeo_process
    def flatten_dimensions(self, dimensions, target_dimension, label_separator=UNSET) -> ProcessBuilder:
        """
        Combine multiple dimensions into a single dimension

        :param self: A data cube.
        :param dimensions: The names of the dimension to combine. The order of the array defines the order in
            which the dimension labels and values are combined (see the example in the process description). Fails
            with a `DimensionNotAvailable` exception if at least one of the specified dimensions does not exist.
        :param target_dimension: The name of the new target dimension. A new dimensions will be created with
            the given names and type `other` (see ``add_dimension()``). Fails with a `TargetDimensionExists`
            exception if a dimension with the specified name exists.
        :param label_separator: The string that will be used as a separator for the concatenated dimension
            labels.  To unambiguously revert the dimension labels with the process ``unflatten_dimension()``, the
            given string must not be contained in any of the dimension labels.

        :return: A data cube with the new shape. The dimension properties (name, type, labels, reference system
            and resolution) for all other dimensions remain unchanged.
        """
        return flatten_dimensions(data=self, dimensions=dimensions, target_dimension=target_dimension, label_separator=label_separator)

    @openeo_process
    def floor(self) -> ProcessBuilder:
        """
        Round fractions down

        :param self: A number to round down.

        :return: The number rounded down.
        """
        return floor(x=self)

    @openeo_process
    def gt(self, y) -> ProcessBuilder:
        """
        Greater than comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is strictly greater than `y` or `null` if any operand is `null`, otherwise
            `false`.
        """
        return gt(x=self, y=y)

    @openeo_process
    def gte(self, y) -> ProcessBuilder:
        """
        Greater than or equal to comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is greater than or equal to `y`, `null` if any operand is `null`, otherwise
            `false`.
        """
        return gte(x=self, y=y)

    @openeo_process
    def if_(self, accept, reject=UNSET) -> ProcessBuilder:
        """
        If-Then-Else conditional

        :param self: A boolean value.
        :param accept: A value that is returned if the boolean value is `true`.
        :param reject: A value that is returned if the boolean value is **not** `true`. Defaults to `null`.

        :return: Either the `accept` or `reject` argument depending on the given boolean value.
        """
        return if_(value=self, accept=accept, reject=reject)

    @openeo_process
    def inspect(self, code=UNSET, level=UNSET, message=UNSET) -> ProcessBuilder:
        """
        Add information to the logs

        :param self: Data to log.
        :param code: A label to help identify one or more log entries originating from this process in the list
            of all log entries. It can help to group or filter log entries and is usually not unique.
        :param level: The severity level of this message, defaults to `info`.
        :param message: A message to send in addition to the data.

        :return: The data as passed to the `data` parameter without any modification.
        """
        return inspect(data=self, code=code, level=level, message=message)

    @openeo_process
    def int(self) -> ProcessBuilder:
        """
        Integer part of a number

        :param self: A number.

        :return: Integer part of the number.
        """
        return int(x=self)

    @openeo_process
    def is_infinite(self) -> ProcessBuilder:
        """
        Value is an infinite number

        :param self: The data to check.

        :return: `true` if the data is an infinite number, otherwise `false`.
        """
        return is_infinite(x=self)

    @openeo_process
    def is_nan(self) -> ProcessBuilder:
        """
        Value is not a number

        :param self: The data to check.

        :return: `true` if the data is not a number, otherwise `false`.
        """
        return is_nan(x=self)

    @openeo_process
    def is_nodata(self) -> ProcessBuilder:
        """
        Value is a no-data value

        :param self: The data to check.

        :return: `true` if the data is a no-data value, otherwise `false`.
        """
        return is_nodata(x=self)

    @openeo_process
    def is_valid(self) -> ProcessBuilder:
        """
        Value is valid data

        :param self: The data to check.

        :return: `true` if the data is valid, otherwise `false`.
        """
        return is_valid(x=self)

    @openeo_process
    def last(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Last element

        :param self: An array with elements of any data type.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if the last value is
            such a value.

        :return: The last element of the input array.
        """
        return last(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def linear_scale_range(self, inputMin, inputMax, outputMin=UNSET, outputMax=UNSET) -> ProcessBuilder:
        """
        Linear transformation between two ranges

        :param self: A number to transform. The number gets clipped to the bounds specified in `inputMin` and
            `inputMax`.
        :param inputMin: Minimum value the input can obtain.
        :param inputMax: Maximum value the input can obtain.
        :param outputMin: Minimum value of the desired output range.
        :param outputMax: Maximum value of the desired output range.

        :return: The transformed number.
        """
        return linear_scale_range(x=self, inputMin=inputMin, inputMax=inputMax, outputMin=outputMin, outputMax=outputMax)

    @openeo_process
    def ln(self) -> ProcessBuilder:
        """
        Natural logarithm

        :param self: A number to compute the natural logarithm for.

        :return: The computed natural logarithm.
        """
        return ln(x=self)

    @openeo_process
    def load_collection(self, spatial_extent, temporal_extent, bands=UNSET, properties=UNSET) -> ProcessBuilder:
        """
        Load a collection

        :param self: The collection id.
        :param spatial_extent: Limits the data to load from the collection to the specified bounding box or
            polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects with
            the bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).  The
            GeoJSON can be one of the following feature types:  * A `Polygon` or `MultiPolygon` geometry, * a
            `Feature` with a `Polygon` or `MultiPolygon` geometry, * a `FeatureCollection` containing at least one
            `Feature` with `Polygon` or `MultiPolygon` geometries, or * a `GeometryCollection` containing `Polygon`
            or `MultiPolygon` geometries. To maximize interoperability, `GeometryCollection` should be avoided in
            favour of one of the alternatives above.  Set this parameter to `null` to set no limit for the spatial
            extent. Be careful with this when loading large datasets! It is recommended to use this parameter
            instead of using ``filter_bbox()`` or ``filter_spatial()`` directly after loading unbounded data.
        :param temporal_extent: Limits the data to load from the collection to the specified left-closed
            temporal interval. Applies to all temporal dimensions. The interval has to be specified as an array
            with exactly two elements:  1. The first element is the start of the temporal interval. The specified
            instance in time is **included** in the interval. 2. The second element is the end of the temporal
            interval. The specified instance in time is **excluded** from the interval.  The specified temporal
            strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by
            setting one of the boundaries to `null`, but never both.  Set this parameter to `null` to set no limit
            for the temporal extent. Be careful with this when loading large datasets! It is recommended to use
            this parameter instead of using ``filter_temporal()`` directly after loading unbounded data.
        :param bands: Only adds the specified bands into the data cube so that bands that don't match the list
            of band names are not available. Applies to all dimensions of type `bands`.  Either the unique band
            name (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in
            bands) can be specified. If the unique band name and the common name conflict, the unique band name has
            a higher priority.  The order of the specified array defines the order of the bands in the data cube.
            If multiple bands match a common name, all matched bands are included in the original order.  It is
            recommended to use this parameter instead of using ``filter_bands()`` directly after loading unbounded
            data.
        :param properties: Limits the data by metadata properties to include only data in the data cube which
            all given conditions return `true` for (AND operation).  Specify key-value-pairs with the key being the
            name of the metadata property, which can be retrieved with the openEO Data Discovery for Collections.
            The value must be a condition (user-defined process) to be evaluated against the collection metadata,
            see the example.

        :return: A data cube for further processing. The dimensions and dimension properties (name, type,
            labels, reference system and resolution) correspond to the collection's metadata, but the dimension
            labels are restricted as specified in the parameters.
        """
        return load_collection(id=self, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands, properties=properties)

    @openeo_process
    def load_ml_model(self) -> ProcessBuilder:
        """
        Load a ML model

        :param self: The STAC Item to load the machine learning model from. The STAC Item must implement the
            `ml-model` extension.

        :return: A machine learning model to be used with machine learning processes such as
            ``predict_random_forest()``.
        """
        return load_ml_model(id=self)

    @openeo_process
    def load_result(self, spatial_extent=UNSET, temporal_extent=UNSET, bands=UNSET) -> ProcessBuilder:
        """
        Load batch job results

        :param self: The id of a batch job with results.
        :param spatial_extent: Limits the data to load from the batch job result to the specified bounding box
            or polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects
            with the bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).
            The GeoJSON can be one of the following feature types:  * A `Polygon` or `MultiPolygon` geometry, * a
            `Feature` with a `Polygon` or `MultiPolygon` geometry, * a `FeatureCollection` containing at least one
            `Feature` with `Polygon` or `MultiPolygon` geometries, or * a `GeometryCollection` containing `Polygon`
            or `MultiPolygon` geometries. To maximize interoperability, `GeometryCollection` should be avoided in
            favour of one of the alternatives above.  Set this parameter to `null` to set no limit for the spatial
            extent. Be careful with this when loading large datasets! It is recommended to use this parameter
            instead of using ``filter_bbox()`` or ``filter_spatial()`` directly after loading unbounded data.
        :param temporal_extent: Limits the data to load from the batch job result to the specified left-closed
            temporal interval. Applies to all temporal dimensions. The interval has to be specified as an array
            with exactly two elements:  1. The first element is the start of the temporal interval. The specified
            instance in time is **included** in the interval. 2. The second element is the end of the temporal
            interval. The specified instance in time is **excluded** from the interval.  The specified temporal
            strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by
            setting one of the boundaries to `null`, but never both.  Set this parameter to `null` to set no limit
            for the temporal extent. Be careful with this when loading large datasets! It is recommended to use
            this parameter instead of using ``filter_temporal()`` directly after loading unbounded data.
        :param bands: Only adds the specified bands into the data cube so that bands that don't match the list
            of band names are not available. Applies to all dimensions of type `bands`.  Either the unique band
            name (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in
            bands) can be specified. If the unique band name and the common name conflict, the unique band name has
            a higher priority.  The order of the specified array defines the order of the bands in the data cube.
            If multiple bands match a common name, all matched bands are included in the original order.  It is
            recommended to use this parameter instead of using ``filter_bands()`` directly after loading unbounded
            data.

        :return: A data cube for further processing.
        """
        return load_result(id=self, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands)

    @openeo_process
    def load_uploaded_files(self, format, options=UNSET) -> ProcessBuilder:
        """
        Load files from the user workspace

        :param self: The files to read. Folders can't be specified, specify all files instead. An exception is
            thrown if a file can't be read.
        :param format: The file format to read from. It must be one of the values that the server reports as
            supported input file formats, which usually correspond to the short GDAL/OGR codes. If the format is
            not suitable for loading the data, a `FormatUnsuitable` exception will be thrown. This parameter is
            *case insensitive*.
        :param options: The file format parameters to be used to read the files. Must correspond to the
            parameters that the server reports as supported parameters for the chosen `format`. The parameter names
            and valid values usually correspond to the GDAL/OGR format options.

        :return: A data cube for further processing.
        """
        return load_uploaded_files(paths=self, format=format, options=options)

    @openeo_process
    def log(self, base) -> ProcessBuilder:
        """
        Logarithm to a base

        :param self: A number to compute the logarithm for.
        :param base: The numerical base.

        :return: The computed logarithm.
        """
        return log(x=self, base=base)

    @openeo_process
    def lt(self, y) -> ProcessBuilder:
        """
        Less than comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is strictly less than `y`, `null` if any operand is `null`, otherwise `false`.
        """
        return lt(x=self, y=y)

    @openeo_process
    def lte(self, y) -> ProcessBuilder:
        """
        Less than or equal to comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is less than or equal to `y`, `null` if any operand is `null`, otherwise
            `false`.
        """
        return lte(x=self, y=y)

    @openeo_process
    def mask(self, mask, replacement=UNSET) -> ProcessBuilder:
        """
        Apply a raster mask

        :param self: A raster data cube.
        :param mask: A mask as a raster data cube. Every pixel in `data` must have a corresponding element in
            `mask`.
        :param replacement: The value used to replace masked values with.

        :return: A masked raster data cube with the same dimensions. The dimension properties (name, type,
            labels, reference system and resolution) remain unchanged.
        """
        return mask(data=self, mask=mask, replacement=replacement)

    @openeo_process
    def mask_polygon(self, mask, replacement=UNSET, inside=UNSET) -> ProcessBuilder:
        """
        Apply a polygon mask

        :param self: A raster data cube.
        :param mask: A GeoJSON object containing at least one polygon. The provided feature types can be one of
            the following:  * A `Polygon` or `MultiPolygon` geometry, * a `Feature` with a `Polygon` or
            `MultiPolygon` geometry, * a `FeatureCollection` containing at least one `Feature` with `Polygon` or
            `MultiPolygon` geometries, or * a `GeometryCollection` containing `Polygon` or `MultiPolygon`
            geometries. To maximize interoperability, `GeometryCollection` should be avoided in favour of one of
            the alternatives above.
        :param replacement: The value used to replace masked values with.
        :param inside: If set to `true` all pixels for which the point at the pixel center **does** intersect
            with any polygon are replaced.

        :return: A masked raster data cube with the same dimensions. The dimension properties (name, type,
            labels, reference system and resolution) remain unchanged.
        """
        return mask_polygon(data=self, mask=mask, replacement=replacement, inside=inside)

    @openeo_process
    def max(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Maximum value

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The maximum value.
        """
        return max(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def mean(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Arithmetic mean (average)

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed arithmetic mean.
        """
        return mean(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def median(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Statistical median

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed statistical median.
        """
        return median(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def merge_cubes(self, cube2, overlap_resolver=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Merge two data cubes

        :param self: The first data cube.
        :param cube2: The second data cube.
        :param overlap_resolver: A reduction operator that resolves the conflict if the data overlaps. The
            reducer must return a value of the same data type as the input values are. The reduction operator may
            be a single process such as ``multiply()`` or consist of multiple sub-processes. `null` (the default)
            can be specified if no overlap resolver is required.
        :param context: Additional data to be passed to the overlap resolver.

        :return: The merged data cube. See the process description for details regarding the dimensions and
            dimension properties (name, type, labels, reference system and resolution).
        """
        return merge_cubes(
            cube1=self,
            cube2=cube2,
            overlap_resolver=build_child_callback(overlap_resolver, parent_parameters=['x', 'y', 'context']),
            context=context
        )

    @openeo_process
    def min(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Minimum value

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The minimum value.
        """
        return min(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def mod(self, y) -> ProcessBuilder:
        """
        Modulo

        :param self: A number to be used as the dividend.
        :param y: A number to be used as the divisor.

        :return: The remainder after division.
        """
        return mod(x=self, y=y)

    @openeo_process
    def multiply(self, y) -> ProcessBuilder:
        """
        Multiplication of two numbers

        :param self: The multiplier.
        :param y: The multiplicand.

        :return: The computed product of the two numbers.
        """
        return multiply(x=self, y=y)

    @openeo_process
    def nan(self) -> ProcessBuilder:
        """
        Not a Number (NaN)

        :return: Returns `NaN`.
        """
        return nan()

    @openeo_process
    def ndvi(self, nir=UNSET, red=UNSET, target_band=UNSET) -> ProcessBuilder:
        """
        Normalized Difference Vegetation Index

        :param self: A raster data cube with two bands that have the common names `red` and `nir` assigned.
        :param nir: The name of the NIR band. Defaults to the band that has the common name `nir` assigned.
            Either the unique band name (metadata field `name` in bands) or one of the common band names (metadata
            field `common_name` in bands) can be specified. If the unique band name and the common name conflict,
            the unique band name has a higher priority.
        :param red: The name of the red band. Defaults to the band that has the common name `red` assigned.
            Either the unique band name (metadata field `name` in bands) or one of the common band names (metadata
            field `common_name` in bands) can be specified. If the unique band name and the common name conflict,
            the unique band name has a higher priority.
        :param target_band: By default, the dimension of type `bands` is dropped. To keep the dimension specify
            a new band name in this parameter so that a new dimension label with the specified name will be added
            for the computed values.

        :return: A raster data cube containing the computed NDVI values. The structure of the data cube differs
            depending on the value passed to `target_band`:  * `target_band` is `null`: The data cube does not
            contain the dimension of type `bands`, the number of dimensions decreases by one. The dimension
            properties (name, type, labels, reference system and resolution) for all other dimensions remain
            unchanged. * `target_band` is a string: The data cube keeps the same dimensions. The dimension
            properties remain unchanged, but the number of dimension labels for the dimension of type `bands`
            increases by one. The additional label is named as specified in `target_band`.
        """
        return ndvi(data=self, nir=nir, red=red, target_band=target_band)

    @openeo_process
    def neq(self, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
        """
        Not equal to comparison

        :param self: First operand.
        :param y: Second operand.
        :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a
            positive non-zero number the non-equality of two numbers is checked against a delta value. This is
            especially useful to circumvent problems with floating-point inaccuracy in machine-based computation.
            This option is basically an alias for the following computation: `gt(abs(minus([x, y]), delta)`
        :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be
            disabled by setting this parameter to `false`.

        :return: `true` if `x` is *not* equal to `y`, `null` if any operand is `null`, otherwise `false`.
        """
        return neq(x=self, y=y, delta=delta, case_sensitive=case_sensitive)

    @openeo_process
    def normalized_difference(self, y) -> ProcessBuilder:
        """
        Normalized difference

        :param self: The value for the first band.
        :param y: The value for the second band.

        :return: The computed normalized difference.
        """
        return normalized_difference(x=self, y=y)

    @openeo_process
    def not_(self) -> ProcessBuilder:
        """
        Inverting a boolean

        :param self: Boolean value to invert.

        :return: Inverted boolean value.
        """
        return not_(x=self)

    @openeo_process
    def or_(self, y) -> ProcessBuilder:
        """
        Logical OR

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical OR.
        """
        return or_(x=self, y=y)

    @openeo_process
    def order(self, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
        """
        Create a permutation

        :param self: An array to compute the order for.
        :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
            (descending) order, set this parameter to `false`.
        :param nodata: Controls the handling of no-data values (`null`). By default, they are removed. If set
            to `true`, missing values in the data are put last; if set to `false`, they are put first.

        :return: The computed permutation.
        """
        return order(data=self, asc=asc, nodata=nodata)

    @openeo_process
    def pi(self) -> ProcessBuilder:
        """
        Pi (π)

        :return: The numerical value of Pi.
        """
        return pi()

    @openeo_process
    def power(self, p) -> ProcessBuilder:
        """
        Exponentiation

        :param self: The numerical base.
        :param p: The numerical exponent.

        :return: The computed value for `base` raised to the power of `p`.
        """
        return power(base=self, p=p)

    @openeo_process
    def predict_curve(self, parameters, function, dimension, labels=UNSET) -> ProcessBuilder:
        """
        Predict values

        :param self: A data cube to predict values for.
        :param parameters: A data cube with optimal values from a result of e.g. ``fit_curve()``.
        :param function: The model function. It must take the parameters to fit as array through the first
            argument and the independent variable `x` as the second argument.  It is recommended to store the model
            function as a user-defined process on the back-end.
        :param dimension: The name of the dimension for predictions. Fails with a `DimensionNotAvailable`
            exception if the specified dimension does not exist.
        :param labels: The labels to predict values for. If no labels are given, predicts values only for no-
            data (`null`) values in the data cube.

        :return: A data cube with the predicted values.
        """
        return predict_curve(
            data=self,
            parameters=parameters,
            function=build_child_callback(function, parent_parameters=['x', 'parameters']),
            dimension=dimension,
            labels=labels
        )

    @openeo_process
    def predict_random_forest(self, model) -> ProcessBuilder:
        """
        Predict values from a Random Forest model

        :param self: An array of numbers.
        :param model: A model object that can be trained with the processes ``fit_regr_random_forest()``
            (regression) and ``fit_class_random_forest()`` (classification).

        :return: The predicted value. Returns `null` if any of the given values in the array is a no-data
            value.
        """
        return predict_random_forest(data=self, model=model)

    @openeo_process
    def product(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Compute the product by multiplying numbers

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed product of the sequence of numbers.
        """
        return product(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def quantiles(self, probabilities=UNSET, q=UNSET, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Quantiles

        :param self: An array of numbers.
        :param probabilities: A list of probabilities to calculate quantiles for. The probabilities must be
            between 0 and 1 (inclusive).
        :param q: Number of intervals to calculate quantiles for. Calculates q-quantiles with equal-sized
            intervals.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that an array with `null` values is returned
            if any element is such a value.

        :return: An array with the computed quantiles. The list has either  * as many elements as the given
            list of `probabilities` had or * *`q`-1* elements.  If the input array is empty the resulting array is
            filled with as many `null` values as required according to the list above. See the 'Empty array'
            example for an example.
        """
        return quantiles(data=self, probabilities=probabilities, q=q, ignore_nodata=ignore_nodata)

    @openeo_process
    def rearrange(self, order) -> ProcessBuilder:
        """
        Rearrange an array based on a permutation

        :param self: The array to rearrange.
        :param order: The permutation used for rearranging.

        :return: The rearranged array.
        """
        return rearrange(data=self, order=order)

    @openeo_process
    def reduce_dimension(self, reducer, dimension, context=UNSET) -> ProcessBuilder:
        """
        Reduce dimensions

        :param self: A data cube.
        :param reducer: A reducer to apply on the specified dimension. A reducer is a single process such as
            ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
            'reducer' for such processes.
        :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
            exception if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the newly computed values. It is missing the given dimension, the number of
            dimensions decreases by one. The dimension properties (name, type, labels, reference system and
            resolution) for all other dimensions remain unchanged.
        """
        return reduce_dimension(
            data=self,
            reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
            dimension=dimension,
            context=context
        )

    @openeo_process
    def reduce_spatial(self, reducer, context=UNSET) -> ProcessBuilder:
        """
        Reduce spatial dimensions 'x' and 'y'

        :param self: A data cube.
        :param reducer: A reducer to apply on the horizontal spatial dimensions. A reducer is a single process
            such as ``mean()`` or a set of processes, which computes a single value for a list of values, see the
            category 'reducer' for such processes.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the newly computed values. It is missing the horizontal spatial dimensions,
            the number of dimensions decreases by two. The dimension properties (name, type, labels, reference
            system and resolution) for all other dimensions remain unchanged.
        """
        return reduce_spatial(data=self, reducer=build_child_callback(reducer, parent_parameters=['data', 'context']), context=context)

    @openeo_process
    def rename_dimension(self, source, target) -> ProcessBuilder:
        """
        Rename a dimension

        :param self: The data cube.
        :param source: The current name of the dimension. Fails with a `DimensionNotAvailable` exception if the
            specified dimension does not exist.
        :param target: A new Name for the dimension. Fails with a `DimensionExists` exception if a dimension
            with the specified name exists.

        :return: A data cube with the same dimensions, but the name of one of the dimensions changes. The old
            name can not be referred to any longer. The dimension properties (name, type, labels, reference system
            and resolution) remain unchanged.
        """
        return rename_dimension(data=self, source=source, target=target)

    @openeo_process
    def rename_labels(self, dimension, target, source=UNSET) -> ProcessBuilder:
        """
        Rename dimension labels

        :param self: The data cube.
        :param dimension: The name of the dimension to rename the labels for.
        :param target: The new names for the labels.  If a target dimension label already exists in the data
            cube, a `LabelExists` exception is thrown.
        :param source: The original names of the labels to be renamed to corresponding array elements in the
            parameter `target`. It is allowed to only specify a subset of labels to rename, as long as the `target`
            and `source` parameter have the same length. The order of the labels doesn't need to match the order of
            the dimension labels in the data cube. By default, the array is empty so that the dimension labels in
            the data cube are expected to be enumerated.  If the dimension labels are not enumerated and the given
            array is empty, the `LabelsNotEnumerated` exception is thrown. If one of the source dimension labels
            doesn't exist, the `LabelNotAvailable` exception is thrown.

        :return: The data cube with the same dimensions. The dimension properties (name, type, labels,
            reference system and resolution) remain unchanged, except that for the given dimension the labels
            change. The old labels can not be referred to any longer. The number of labels remains the same.
        """
        return rename_labels(data=self, dimension=dimension, target=target, source=source)

    @openeo_process
    def resample_cube_spatial(self, target, method=UNSET) -> ProcessBuilder:
        """
        Resample the spatial dimensions to match a target data cube

        :param self: A data cube.
        :param target: A data cube that describes the spatial target resolution.
        :param method: Resampling method to use. The following options are available and are meant to align
            with [`gdalwarp`](https://gdal.org/programs/gdalwarp.html#cmdoption-gdalwarp-r):  * `average`: average
            (mean) resampling, computes the weighted average of all valid pixels * `bilinear`: bilinear resampling
            * `cubic`: cubic resampling * `cubicspline`: cubic spline resampling * `lanczos`: Lanczos windowed sinc
            resampling * `max`: maximum resampling, selects the maximum value from all valid pixels * `med`: median
            resampling, selects the median value of all valid pixels * `min`: minimum resampling, selects the
            minimum value from all valid pixels * `mode`: mode resampling, selects the value which appears most
            often of all the sampled points * `near`: nearest neighbour resampling (default) * `q1`: first quartile
            resampling, selects the first quartile value of all valid pixels * `q3`: third quartile resampling,
            selects the third quartile value of all valid pixels * `rms` root mean square (quadratic mean) of all
            valid pixels * `sum`: compute the weighted sum of all valid pixels  Valid pixels are determined based
            on the function ``is_valid()``.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the spatial
            dimensions.
        """
        return resample_cube_spatial(data=self, target=target, method=method)

    @openeo_process
    def resample_cube_temporal(self, target, dimension=UNSET, valid_within=UNSET) -> ProcessBuilder:
        """
        Resample temporal dimensions to match a target data cube

        :param self: A data cube with one or more temporal dimensions.
        :param target: A data cube that describes the temporal target resolution.
        :param dimension: The name of the temporal dimension to resample, which must exist with this name in
            both data cubes. If the dimension is not set or is set to `null`, the process resamples all temporal
            dimensions that exist with the same names in both data cubes.  The following exceptions may occur:  * A
            dimension is given, but it does not exist in any of the data cubes: `DimensionNotAvailable` * A
            dimension is given, but one of them is not temporal: `DimensionMismatch`  * No specific dimension name
            is given and there are no temporal dimensions with the same name in the data: `DimensionMismatch`
        :param valid_within: Setting this parameter to a numerical value enables that the process searches for
            valid values within the given period of days before and after the target timestamps. Valid values are
            determined based on the function ``is_valid()``. For example, the limit of `7` for the target
            timestamps `2020-01-15 12:00:00` looks for a nearest neighbor after `2020-01-08 12:00:00` and before
            `2020-01-22 12:00:00`. If no valid value is found within the given period, the value will be set to no-
            data (`null`).

        :return: A raster data cube with the same dimensions and the same dimension properties (name, type,
            labels, reference system and resolution) for all non-temporal dimensions. For the temporal dimension,
            the name and type remain unchanged, but the dimension labels, resolution and reference system may
            change.
        """
        return resample_cube_temporal(data=self, target=target, dimension=dimension, valid_within=valid_within)

    @openeo_process
    def resample_spatial(self, resolution=UNSET, projection=UNSET, method=UNSET, align=UNSET) -> ProcessBuilder:
        """
        Resample and warp the spatial dimensions

        :param self: A raster data cube.
        :param resolution: Resamples the data cube to the target resolution, which can be specified either as
            separate values for x and y or as a single value for both axes. Specified in the units of the target
            projection. Doesn't change the resolution by default (`0`).
        :param projection: Warps the data cube to the target projection, specified as as [EPSG
            code](http://www.epsg-registry.org/), [WKT2 (ISO 19162)
            string](http://docs.opengeospatial.org/is/18-010r7/18-010r7.html), [PROJ definition
            (deprecated)](https://proj.org/usage/quickstart.html). By default (`null`), the projection is not
            changed.
        :param method: Resampling method to use. The following options are available and are meant to align
            with [`gdalwarp`](https://gdal.org/programs/gdalwarp.html#cmdoption-gdalwarp-r):  * `average`: average
            (mean) resampling, computes the weighted average of all valid pixels * `bilinear`: bilinear resampling
            * `cubic`: cubic resampling * `cubicspline`: cubic spline resampling * `lanczos`: Lanczos windowed sinc
            resampling * `max`: maximum resampling, selects the maximum value from all valid pixels * `med`: median
            resampling, selects the median value of all valid pixels * `min`: minimum resampling, selects the
            minimum value from all valid pixels * `mode`: mode resampling, selects the value which appears most
            often of all the sampled points * `near`: nearest neighbour resampling (default) * `q1`: first quartile
            resampling, selects the first quartile value of all valid pixels * `q3`: third quartile resampling,
            selects the third quartile value of all valid pixels * `rms` root mean square (quadratic mean) of all
            valid pixels * `sum`: compute the weighted sum of all valid pixels  Valid pixels are determined based
            on the function ``is_valid()``.
        :param align: Specifies to which corner of the spatial extent the new resampled data is aligned to.

        :return: A raster data cube with values warped onto the new projection. It has the same dimensions and
            the same dimension properties (name, type, labels, reference system and resolution) for all non-spatial
            or vertical spatial dimensions. For the horizontal spatial dimensions the name and type remain
            unchanged, but reference system, labels and resolution may change depending on the given parameters.
        """
        return resample_spatial(data=self, resolution=resolution, projection=projection, method=method, align=align)

    @openeo_process
    def round(self, p=UNSET) -> ProcessBuilder:
        """
        Round to a specified precision

        :param self: A number to round.
        :param p: A positive number specifies the number of digits after the decimal point to round to. A
            negative number means rounding to a power of ten, so for example *-2* rounds to the nearest hundred.
            Defaults to *0*.

        :return: The rounded number.
        """
        return round(x=self, p=p)

    @openeo_process
    def run_udf(self, udf, runtime, version=UNSET, context=UNSET) -> ProcessBuilder:
        """
        Run a UDF

        :param self: The data to be passed to the UDF.
        :param udf: Either source code, an absolute URL or a path to a UDF script.
        :param runtime: A UDF runtime identifier available at the back-end.
        :param version: An UDF runtime version. If set to `null`, the default runtime version specified for
            each runtime is used.
        :param context: Additional data such as configuration options to be passed to the UDF.

        :return: The data processed by the UDF. The returned value can be of any data type and is exactly what
            the UDF code returns.
        """
        return run_udf(data=self, udf=udf, runtime=runtime, version=version, context=context)

    @openeo_process
    def run_udf_externally(self, url, context=UNSET) -> ProcessBuilder:
        """
        Run an externally hosted UDF container

        :param self: The data to be passed to the UDF.
        :param url: Absolute URL to a remote UDF service.
        :param context: Additional data such as configuration options to be passed to the UDF.

        :return: The data processed by the UDF. The returned value can in principle be of any data type, but it
            depends on what is returned by the UDF code. Please see the implemented UDF interface for details.
        """
        return run_udf_externally(data=self, url=url, context=context)

    @openeo_process
    def sar_backscatter(self, coefficient=UNSET, elevation_model=UNSET, mask=UNSET, contributing_area=UNSET, local_incidence_angle=UNSET, ellipsoid_incidence_angle=UNSET, noise_removal=UNSET, options=UNSET) -> ProcessBuilder:
        """
        Computes backscatter from SAR input

        :param self: The source data cube containing SAR input.
        :param coefficient: Select the radiometric correction coefficient. The following options are available:
            * `beta0`: radar brightness * `sigma0-ellipsoid`: ground area computed with ellipsoid earth model *
            `sigma0-terrain`: ground area computed with terrain earth model * `gamma0-ellipsoid`: ground area
            computed with ellipsoid earth model in sensor line of sight * `gamma0-terrain`: ground area computed
            with terrain earth model in sensor line of sight (default) * `null`: non-normalized backscatter
        :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the
            back-end to choose, which will improve portability, but reduce reproducibility.
        :param mask: If set to `true`, a data mask is added to the bands with the name `mask`. It indicates
            which values are valid (1), invalid (0) or contain no-data (null).
        :param contributing_area: If set to `true`, a DEM-based local contributing area band named
            `contributing_area` is added. The values are given in square meters.
        :param local_incidence_angle: If set to `true`, a DEM-based local incidence angle band named
            `local_incidence_angle` is added. The values are given in degrees.
        :param ellipsoid_incidence_angle: If set to `true`, an ellipsoidal incidence angle band named
            `ellipsoid_incidence_angle` is added. The values are given in degrees.
        :param noise_removal: If set to `false`, no noise removal is applied. Defaults to `true`, which removes
            noise.
        :param options: Proprietary options for the backscatter computations. Specifying proprietary options
            will reduce portability.

        :return: Backscatter values corresponding to the chosen parametrization. The values are given in linear
            scale.
        """
        return sar_backscatter(
            data=self,
            coefficient=coefficient,
            elevation_model=elevation_model,
            mask=mask,
            contributing_area=contributing_area,
            local_incidence_angle=local_incidence_angle,
            ellipsoid_incidence_angle=ellipsoid_incidence_angle,
            noise_removal=noise_removal,
            options=options
        )

    @openeo_process
    def save_ml_model(self, options=UNSET) -> ProcessBuilder:
        """
        Save a ML model

        :param self: The data to store as a machine learning model.
        :param options: Additional parameters to create the file(s).

        :return: Returns `false` if the process failed to store the model, `true` otherwise.
        """
        return save_ml_model(data=self, options=options)

    @openeo_process
    def save_result(self, format, options=UNSET) -> ProcessBuilder:
        """
        Save processed data

        :param self: The data to deliver in the given file format.
        :param format: The file format to use. It must be one of the values that the server reports as
            supported output file formats, which usually correspond to the short GDAL/OGR codes. If the format is
            not suitable for storing the underlying data structure, a `FormatUnsuitable` exception will be thrown.
            This parameter is *case insensitive*.
        :param options: The file format parameters to be used to create the file(s). Must correspond to the
            parameters that the server reports as supported parameters for the chosen `format`. The parameter names
            and valid values usually correspond to the GDAL/OGR format options.

        :return: Returns `false` if the process failed to make the data available, `true` otherwise.
        """
        return save_result(data=self, format=format, options=options)

    @openeo_process
    def sd(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Standard deviation

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sample standard deviation.
        """
        return sd(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def sgn(self) -> ProcessBuilder:
        """
        Signum

        :param self: A number.

        :return: The computed signum value of `x`.
        """
        return sgn(x=self)

    @openeo_process
    def sin(self) -> ProcessBuilder:
        """
        Sine

        :param self: An angle in radians.

        :return: The computed sine of `x`.
        """
        return sin(x=self)

    @openeo_process
    def sinh(self) -> ProcessBuilder:
        """
        Hyperbolic sine

        :param self: An angle in radians.

        :return: The computed hyperbolic sine of `x`.
        """
        return sinh(x=self)

    @openeo_process
    def sort(self, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
        """
        Sort data

        :param self: An array with data to sort.
        :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
            (descending) order, set this parameter to `false`.
        :param nodata: Controls the handling of no-data values (`null`). By default, they are removed. If set
            to `true`, missing values in the data are put last; if set to `false`, they are put first.

        :return: The sorted array.
        """
        return sort(data=self, asc=asc, nodata=nodata)

    @openeo_process
    def sqrt(self) -> ProcessBuilder:
        """
        Square root

        :param self: A number.

        :return: The computed square root.
        """
        return sqrt(x=self)

    @openeo_process
    def subtract(self, y) -> ProcessBuilder:
        """
        Subtraction of two numbers

        :param self: The minuend.
        :param y: The subtrahend.

        :return: The computed result.
        """
        return subtract(x=self, y=y)

    @openeo_process
    def sum(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Compute the sum by adding up numbers

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sum of the sequence of numbers.
        """
        return sum(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def tan(self) -> ProcessBuilder:
        """
        Tangent

        :param self: An angle in radians.

        :return: The computed tangent of `x`.
        """
        return tan(x=self)

    @openeo_process
    def tanh(self) -> ProcessBuilder:
        """
        Hyperbolic tangent

        :param self: An angle in radians.

        :return: The computed hyperbolic tangent of `x`.
        """
        return tanh(x=self)

    @openeo_process
    def text_begins(self, pattern, case_sensitive=UNSET) -> ProcessBuilder:
        """
        Text begins with another text

        :param self: Text in which to find something at the beginning.
        :param pattern: Text to find at the beginning of `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` begins with `pattern`, false` otherwise.
        """
        return text_begins(data=self, pattern=pattern, case_sensitive=case_sensitive)

    @openeo_process
    def text_concat(self, separator=UNSET) -> ProcessBuilder:
        """
        Concatenate elements to a single text

        :param self: A set of elements. Numbers, boolean values and null values get converted to their (lower
            case) string representation. For example: `1` (integer), `-1.5` (number), `true` / `false` (boolean
            values)
        :param separator: A separator to put between each of the individual texts. Defaults to an empty string.

        :return: A string containing a string representation of all the array elements in the same order, with
            the separator between each element.
        """
        return text_concat(data=self, separator=separator)

    @openeo_process
    def text_contains(self, pattern, case_sensitive=UNSET) -> ProcessBuilder:
        """
        Text contains another text

        :param self: Text in which to find something in.
        :param pattern: Text to find in `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` contains the `pattern`, false` otherwise.
        """
        return text_contains(data=self, pattern=pattern, case_sensitive=case_sensitive)

    @openeo_process
    def text_ends(self, pattern, case_sensitive=UNSET) -> ProcessBuilder:
        """
        Text ends with another text

        :param self: Text in which to find something at the end.
        :param pattern: Text to find at the end of `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` ends with `pattern`, false` otherwise.
        """
        return text_ends(data=self, pattern=pattern, case_sensitive=case_sensitive)

    @openeo_process
    def trim_cube(self) -> ProcessBuilder:
        """
        Remove dimension labels with no-data values

        :param self: A raster data cube to trim.

        :return: A trimmed raster data cube with the same dimensions. The dimension properties name, type,
            reference system and resolution remain unchanged. The number of dimension labels may decrease.
        """
        return trim_cube(data=self)

    @openeo_process
    def unflatten_dimension(self, dimension, target_dimensions, label_separator=UNSET) -> ProcessBuilder:
        """
        Split a single dimensions into multiple dimensions

        :param self: A data cube that is consistently structured so that operation can execute flawlessly (e.g.
            the dimension labels need to contain the `label_separator` exactly 1 time for two target dimensions, 2
            times for three target dimensions etc.).
        :param dimension: The name of the dimension to split.
        :param target_dimensions: The names of the new target dimensions. New dimensions will be created with
            the given names and type `other` (see ``add_dimension()``). Fails with a `TargetDimensionExists`
            exception if any of the dimensions exists.  The order of the array defines the order in which the
            dimensions and dimension labels are added to the data cube (see the example in the process
            description).
        :param label_separator: The string that will be used as a separator to split the dimension labels.

        :return: A data cube with the new shape. The dimension properties (name, type, labels, reference system
            and resolution) for all other dimensions remain unchanged.
        """
        return unflatten_dimension(data=self, dimension=dimension, target_dimensions=target_dimensions, label_separator=label_separator)

    @openeo_process
    def variance(self, ignore_nodata=UNSET) -> ProcessBuilder:
        """
        Variance

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sample variance.
        """
        return variance(data=self, ignore_nodata=ignore_nodata)

    @openeo_process
    def vector_buffer(self, distance) -> ProcessBuilder:
        """
        Buffer geometries by distance

        :param self: Geometries to apply the buffer on. Vector properties are preserved for vector data cubes
            and all GeoJSON Features.  To maximize interoperability, a nested `GeometryCollection` should be
            avoided. Furthermore, a `GeometryCollection` composed of a single type of geometries should be avoided
            in favour of the corresponding multi-part type (e.g. `MultiPolygon`).
        :param distance: The distance of the buffer in the unit of the spatial reference system. A positive
            distance expands the geometries and results in outward buffering (dilation) while a negative distance
            shrinks the geometries and results in inward buffering (erosion).

        :return: Returns a vector data cube with the computed new geometries.
        """
        return vector_buffer(geometries=self, distance=distance)

    @openeo_process
    def vector_to_random_points(self, geometry_count=UNSET, total_count=UNSET, group=UNSET, seed=UNSET) -> ProcessBuilder:
        """
        Sample random points from geometries

        :param self: Input geometries for sample extraction.  To maximize interoperability, a nested
            `GeometryCollection` should be avoided. Furthermore, a `GeometryCollection` composed of a single type
            of geometries should be avoided in favour of the corresponding multi-part type (e.g. `MultiPolygon`).
        :param geometry_count: The maximum number of points to compute per geometry.  Points in the input
            geometries can be selected only once by the sampling.
        :param total_count: The maximum number of points to compute overall.  Throws a `CountMismatch`
            exception if the specified value is less than the provided number of geometries.
        :param group: Specifies whether the sampled points should be grouped by input geometry (default) or be
            generated as independent points.  * If the sampled points are grouped, the process generates a
            `MultiPoint` per geometry given which keeps the original identifier if present. * Otherwise, each
            sampled point is generated as a distinct `Point` geometry without identifier.
        :param seed: A randomization seed to use for random sampling. If not given or `null`, no seed is used
            and results may differ on subsequent use.

        :return: Returns a vector data cube with the sampled points.
        """
        return vector_to_random_points(data=self, geometry_count=geometry_count, total_count=total_count, group=group, seed=seed)

    @openeo_process
    def vector_to_regular_points(self, distance, group=UNSET) -> ProcessBuilder:
        """
        Sample regular points from geometries

        :param self: Input geometries for sample extraction.  To maximize interoperability, a nested
            `GeometryCollection` should be avoided. Furthermore, a `GeometryCollection` composed of a single type
            of geometries should be avoided in favour of the corresponding multi-part type (e.g. `MultiPolygon`).
        :param distance: Defines the minimum distance in the unit of the reference system that is required
            between two samples generated *inside* a single geometry.  - For **polygons**, the distance defines the
            cell sizes of a regular grid that starts at the upper-left bound of each polygon. The centroid of each
            cell is then a sample point. If the centroid is not enclosed in the polygon, no point is sampled. If no
            point can be sampled for the geometry at all, the first coordinate of the geometry is returned as
            point. - For **lines** (line strings), the sampling starts with a point at the first coordinate of the
            line and then walks along the line and samples a new point each time the distance to the previous point
            has been reached again. - For **points**, the point is returned as given.
        :param group: Specifies whether the sampled points should be grouped by input geometry (default) or be
            generated as independent points.  * If the sampled points are grouped, the process generates a
            `MultiPoint` per geometry given which keeps the original identifier if present. * Otherwise, each
            sampled point is generated as a distinct `Point` geometry without identifier.

        :return: Returns a vector data cube with the sampled points.
        """
        return vector_to_regular_points(data=self, distance=distance, group=group)

    @openeo_process
    def xor(self, y) -> ProcessBuilder:
        """
        Logical XOR (exclusive or)

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical XOR.
        """
        return xor(x=self, y=y)


# Public shortcut
process = ProcessBuilder.process
# Private shortcut that has lower chance to collide with a process argument named `process`
_process = ProcessBuilder.process


@openeo_process
def absolute(x) -> ProcessBuilder:
    """
    Absolute value

    :param x: A number.

    :return: The computed absolute value.
    """
    return _process('absolute', x=x)


@openeo_process
def add(x, y) -> ProcessBuilder:
    """
    Addition of two numbers

    :param x: The first summand.
    :param y: The second summand.

    :return: The computed sum of the two numbers.
    """
    return _process('add', x=x, y=y)


@openeo_process
def add_dimension(data, name, label, type=UNSET) -> ProcessBuilder:
    """
    Add a new dimension

    :param data: A data cube to add the dimension to.
    :param name: Name for the dimension.
    :param label: A dimension label.
    :param type: The type of dimension, defaults to `other`.

    :return: The data cube with a newly added dimension. The new dimension has exactly one dimension label. All
        other dimensions remain unchanged.
    """
    return _process('add_dimension', data=data, name=name, label=label, type=type)


@openeo_process
def aggregate_spatial(data, geometries, reducer, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Zonal statistics for geometries

    :param data: A raster data cube.  The data cube must have been reduced to only contain two spatial
        dimensions and a third dimension the values are aggregated for, for example the temporal dimension to get a
        time series. Otherwise, this process fails with the `TooManyDimensions` exception.  The data cube
        implicitly gets restricted to the bounds of the geometries as if ``filter_spatial()`` would have been used
        with the same values for the corresponding parameters immediately before this process.
    :param geometries: Geometries as GeoJSON on which the aggregation will be based. Vector properties are
        preserved for vector data cubes and all GeoJSON Features.  One value will be computed per GeoJSON
        `Feature`, `Geometry` or `GeometryCollection`. For a `FeatureCollection` multiple values will be computed,
        one value per contained `Feature`. For example, a single value will be computed for a `MultiPolygon`, but
        two values will be computed for a `FeatureCollection` containing two polygons.  - For **polygons**, the
        process considers all pixels for which the point at the pixel center intersects with the corresponding
        polygon (as defined in the Simple Features standard by the OGC). - For **points**, the process considers
        the closest pixel center. - For **lines** (line strings), the process considers all the pixels whose
        centers are closest to at least one point on the line.  Thus, pixels may be part of multiple geometries and
        be part of multiple aggregations.  To maximize interoperability, a nested `GeometryCollection` should be
        avoided. Furthermore, a `GeometryCollection` composed of a single type of geometries should be avoided in
        favour of the corresponding multi-part type (e.g. `MultiPolygon`).
    :param reducer: A reducer to be applied on all values of each geometry. A reducer is a single process such
        as ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
        'reducer' for such processes.
    :param target_dimension: The name of a new dimensions that is used to store the results. A new dimension
        will be created with the given name and type `other` (see ``add_dimension()``). Defaults to the dimension
        name `result`. Fails with a `TargetDimensionExists` exception if a dimension with the specified name
        exists.
    :param context: Additional data to be passed to the reducer.

    :return: A vector data cube with the computed results and restricted to the bounds of the geometries.  The
        computed value is used for the dimension with the name that was specified in the parameter
        `target_dimension`.  The computation also stores information about the total count of pixels (valid +
        invalid pixels) and the number of valid pixels (see ``is_valid()``) for each geometry. These values are
        added as a new dimension with a dimension name derived from `target_dimension` by adding the suffix
        `_meta`. The new dimension has the dimension labels `total_count` and `valid_count`.
    """
    return _process('aggregate_spatial', 
        data=data,
        geometries=geometries,
        reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
        target_dimension=target_dimension,
        context=context
    )


@openeo_process
def aggregate_spatial_window(data, reducer, size, boundary=UNSET, align=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Zonal statistics for rectangular windows

    :param data: A raster data cube with exactly two horizontal spatial dimensions and an arbitrary number of
        additional dimensions. The process is applied to all additional dimensions individually.
    :param reducer: A reducer to be applied on the list of values, which contain all pixels covered by the
        window. A reducer is a single process such as ``mean()`` or a set of processes, which computes a single
        value for a list of values, see the category 'reducer' for such processes.
    :param size: Window size in pixels along the horizontal spatial dimensions.  The first value corresponds to
        the `x` axis, the second value corresponds to the `y` axis.
    :param boundary: Behavior to apply if the number of values for the axes `x` and `y` is not a multiple of
        the corresponding value in the `size` parameter. Options are:  - `pad` (default): pad the data cube with
        the no-data value `null` to fit the required window size.  - `trim`: trim the data cube to fit the required
        window size.  Set the parameter `align` to specifies to which corner the data is aligned to.
    :param align: If the data requires padding or trimming (see parameter `boundary`), specifies to which
        corner of the spatial extent the data is aligned to. For example, if the data is aligned to the upper left,
        the process pads/trims at the lower-right.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the newly computed values and the same dimensions.  The resolution will change
        depending on the chosen values for the `size` and `boundary` parameter. It usually decreases for the
        dimensions which have the corresponding parameter `size` set to values greater than 1.  The dimension
        labels will be set to the coordinate at the center of the window. The other dimension properties (name,
        type and reference system) remain unchanged.
    """
    return _process('aggregate_spatial_window', 
        data=data,
        reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
        size=size,
        boundary=boundary,
        align=align,
        context=context
    )


@openeo_process
def aggregate_temporal(data, intervals, reducer, labels=UNSET, dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Temporal aggregations

    :param data: A data cube.
    :param intervals: Left-closed temporal intervals, which are allowed to overlap. Each temporal interval in
        the array has exactly two elements:  1. The first element is the start of the temporal interval. The
        specified instance in time is **included** in the interval. 2. The second element is the end of the
        temporal interval. The specified instance in time is **excluded** from the interval.  The specified
        temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Although [RFC 3339
        prohibits the hour to be '24'](https://www.rfc-editor.org/rfc/rfc3339.html#section-5.7), **this process
        allows the value '24' for the hour** of an end time in order to make it possible that left-closed time
        intervals can fully cover the day.
    :param reducer: A reducer to be applied for the values contained in each interval. A reducer is a single
        process such as ``mean()`` or a set of processes, which computes a single value for a list of values, see
        the category 'reducer' for such processes. Intervals may not contain any values, which for most reducers
        leads to no-data (`null`) values by default.
    :param labels: Distinct labels for the intervals, which can contain dates and/or times. Is only required to
        be specified if the values for the start of the temporal intervals are not distinct and thus the default
        labels would not be unique. The number of labels and the number of groups need to be equal.
    :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
        passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
        expected to only have one temporal dimension. Fails with a `TooManyDimensions` exception if it has more
        dimensions. Fails with a `DimensionNotAvailable` exception if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A new data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the given
        temporal dimension.
    """
    return _process('aggregate_temporal', 
        data=data,
        intervals=intervals,
        reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
        labels=labels,
        dimension=dimension,
        context=context
    )


@openeo_process
def aggregate_temporal_period(data, period, reducer, dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Temporal aggregations based on calendar hierarchies

    :param data: The source data cube.
    :param period: The time intervals to aggregate. The following pre-defined values are available:  * `hour`:
        Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten day periods, counted per
        year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The third dekad of the month
        can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10 each year. * `month`: Month
        of the year * `season`: Three month periods of the calendar seasons (December - February, March - May, June
        - August, September - November). * `tropical-season`: Six month periods of the tropical seasons (November -
        April, May - October). * `year`: Proleptic years * `decade`: Ten year periods ([0-to-9
        decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the next year
        ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
        decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the anno Domini (AD)
        calendar era, from a year ending in a 1 to the next year ending in a 0.
    :param reducer: A reducer to be applied for the values contained in each period. A reducer is a single
        process such as ``mean()`` or a set of processes, which computes a single value for a list of values, see
        the category 'reducer' for such processes. Periods may not contain any values, which for most reducers
        leads to no-data (`null`) values by default.
    :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
        passed through the specified reducer. If the dimension is not set or set to `null`, the source data cube is
        expected to only have one temporal dimension. Fails with a `TooManyDimensions` exception if it has more
        dimensions. Fails with a `DimensionNotAvailable` exception if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A new data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the given
        temporal dimension. The specified temporal dimension has the following dimension labels (`YYYY` = four-
        digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`: `YYYY-MM-DD-00` - `YYYY-MM-
        DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` * `dekad`: `YYYY-00` - `YYYY-36` *
        `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December - February), `YYYY-mam` (March - May),
        `YYYY-jja` (June - August), `YYYY-son` (September - November). * `tropical-season`: `YYYY-ndjfma` (November
        - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` * `decade`: `YYY0` * `decade-ad`: `YYY1`  The
        dimension labels in the new data cube are complete for the whole extent of the source data cube. For
        example, if `period` is set to `day` and the source data cube has two dimension labels at the beginning of
        the year (`2020-01-01`) and the end of a year (`2020-12-31`), the process returns a data cube with 365
        dimension labels (`2020-001`, `2020-002`, ..., `2020-365`). In contrast, if `period` is set to `day` and
        the source data cube has just one dimension label `2020-01-05`, the process returns a data cube with just a
        single dimension label (`2020-005`).
    """
    return _process('aggregate_temporal_period', 
        data=data,
        period=period,
        reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
        dimension=dimension,
        context=context
    )


@openeo_process
def all(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Are all of the values true?

    :param data: A set of boolean values.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

    :return: Boolean result of the logical operation.
    """
    return _process('all', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def and_(x, y) -> ProcessBuilder:
    """
    Logical AND

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical AND.
    """
    return _process('and', x=x, y=y)


@openeo_process
def anomaly(data, normals, period) -> ProcessBuilder:
    """
    Compute anomalies

    :param data: A data cube with exactly one temporal dimension and the following dimension labels for the
        given period (`YYYY` = four-digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`:
        `YYYY-MM-DD-00` - `YYYY-MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` *
        `dekad`: `YYYY-00` - `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December -
        February), `YYYY-mam` (March - May), `YYYY-jja` (June - August), `YYYY-son` (September - November). *
        `tropical-season`: `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` *
        `decade`: `YYY0` * `decade-ad`: `YYY1` * `single-period` / `climatology-period`: Any
        ``aggregate_temporal_period()`` can compute such a data cube.
    :param normals: A data cube with normals, e.g. daily, monthly or yearly values computed from a process such
        as ``climatological_normal()``. Must contain exactly one temporal dimension with the following dimension
        labels for the given period:  * `hour`: `00` - `23` * `day`: `001` - `365` * `week`: `01` - `52` * `dekad`:
        `00` - `36` * `month`: `01` - `12` * `season`: `djf` (December - February), `mam` (March - May), `jja`
        (June - August), `son` (September - November) * `tropical-season`: `ndjfma` (November - April), `mjjaso`
        (May - October) * `year`: Four-digit year numbers * `decade`: Four-digit year numbers, the last digit being
        a `0` * `decade-ad`: Four-digit year numbers, the last digit being a `1` * `single-period` / `climatology-
        period`: A single dimension label with any name is expected.
    :param period: Specifies the time intervals available in the normals data cube. The following options are
        available:  * `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten
        day periods, counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The
        third dekad of the month can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10
        each year. * `month`: Month of the year * `season`: Three month periods of the calendar seasons (December -
        February, March - May, June - August, September - November). * `tropical-season`: Six month periods of the
        tropical seasons (November - April, May - October). * `year`: Proleptic years * `decade`: Ten year periods
        ([0-to-9 decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the
        next year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
        decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the anno Domini (AD)
        calendar era, from a year ending in a 1 to the next year ending in a 0. * `single-period` / `climatology-
        period`: A single period of arbitrary length

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged.
    """
    return _process('anomaly', data=data, normals=normals, period=period)


@openeo_process
def any(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Is at least one value true?

    :param data: A set of boolean values.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

    :return: Boolean result of the logical operation.
    """
    return _process('any', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def apply(data, process, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to each pixel

    :param data: A data cube.
    :param process: A process that accepts and returns a single value and is applied on each individual value
        in the data cube. The process may consist of multiple sub-processes and could, for example, consist of
        processes such as ``absolute()`` or ``linear_scale_range()``.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return _process('apply', data=data, process=build_child_callback(process, parent_parameters=['x', 'context']), context=context)


@openeo_process
def apply_dimension(data, process, dimension, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to pixels along a dimension

    :param data: A data cube.
    :param process: Process to be applied on all pixel values. The specified process needs to accept an array
        and must return an array with at least one element. A process may consist of multiple sub-processes.
    :param dimension: The name of the source dimension to apply the process on. Fails with a
        `DimensionNotAvailable` exception if the specified dimension does not exist.
    :param target_dimension: The name of the target dimension or `null` (the default) to use the source
        dimension specified in the parameter `dimension`.  By specifying a target dimension, the source dimension
        is removed. The target dimension with the specified name and the type `other` (see ``add_dimension()``) is
        created, if it doesn't exist yet.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values.  All dimensions stay the same, except for the
        dimensions specified in corresponding parameters. There are three cases how the dimensions can change:  1.
        The source dimension is the target dimension:    - The (number of) dimensions remain unchanged as the
        source dimension is the target dimension.    - The source dimension properties name and type remain
        unchanged.    - The dimension labels, the reference system and the resolution are preserved only if the
        number of pixel values in the source dimension is equal to the number of values computed by the process.
        Otherwise, all other dimension properties change as defined in the list below. 2. The source dimension is
        not the target dimension and the latter exists:    - The number of dimensions decreases by one as the
        source dimension is dropped.    - The target dimension properties name and type remain unchanged. All other
        dimension properties change as defined in the list below. 3. The source dimension is not the target
        dimension and the latter does not exist:    - The number of dimensions remain unchanged, but the source
        dimension is replaced with the target dimension.    - The target dimension has the specified name and the
        type other. All other dimension properties are set as defined in the list below.  Unless otherwise stated
        above, for the given (target) dimension the following applies:  - the number of dimension labels is equal
        to the number of values computed by the process, - the dimension labels are incrementing integers starting
        from zero, - the resolution changes, and - the reference system is undefined.
    """
    return _process('apply_dimension', 
        data=data,
        process=build_child_callback(process, parent_parameters=['data', 'context']),
        dimension=dimension,
        target_dimension=target_dimension,
        context=context
    )


@openeo_process
def apply_kernel(data, kernel, factor=UNSET, border=UNSET, replace_invalid=UNSET) -> ProcessBuilder:
    """
    Apply a spatial convolution with a kernel

    :param data: A data cube.
    :param kernel: Kernel as a two-dimensional array of weights. The inner level of the nested array aligns
        with the `x` axis and the outer level aligns with the `y` axis. Each level of the kernel must have an
        uneven number of elements, otherwise the process throws a `KernelDimensionsUneven` exception.
    :param factor: A factor that is multiplied to each value after the kernel has been applied.  This is
        basically a shortcut for explicitly multiplying each value by a factor afterwards, which is often required
        for some kernel-based algorithms such as the Gaussian blur.
    :param border: Determines how the data is extended when the kernel overlaps with the borders. Defaults to
        fill the border with zeroes.  The following options are available:  * *numeric value* - fill with a user-
        defined constant number `n`: `nnnnnn|abcdefgh|nnnnnn` (default, with `n` = 0) * `replicate` - repeat the
        value from the pixel at the border: `aaaaaa|abcdefgh|hhhhhh` * `reflect` - mirror/reflect from the border:
        `fedcba|abcdefgh|hgfedc` * `reflect_pixel` - mirror/reflect from the center of the pixel at the border:
        `gfedcb|abcdefgh|gfedcb` * `wrap` - repeat/wrap the image: `cdefgh|abcdefgh|abcdef`
    :param replace_invalid: This parameter specifies the value to replace non-numerical or infinite numerical
        values with. By default, those values are replaced with zeroes.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return _process('apply_kernel', data=data, kernel=kernel, factor=factor, border=border, replace_invalid=replace_invalid)


@openeo_process
def apply_neighborhood(data, process, size, overlap=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to pixels in a n-dimensional neighborhood

    :param data: A data cube.
    :param process: Process to be applied on all neighborhoods.
    :param size: Neighborhood sizes along each dimension.  This object maps dimension names to either a
        physical measure (e.g. 100 m, 10 days) or pixels (e.g. 32 pixels). For dimensions not specified, the
        default is to provide all values. Be aware that including all values from overly large dimensions may not
        be processed at once.
    :param overlap: Overlap of neighborhoods along each dimension to avoid border effects. By default no
        overlap is provided.  For instance a temporal dimension can add 1 month before and after a neighborhood. In
        the spatial dimensions, this is often a number of pixels. The overlap specified is added before and after,
        so an overlap of 8 pixels will add 8 pixels on both sides of the window, so 16 in total.  Be aware that
        large overlaps increase the need for computational resources and modifying overlapping data in subsequent
        operations have no effect.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return _process('apply_neighborhood', 
        data=data,
        process=build_child_callback(process, parent_parameters=['data', 'context']),
        size=size,
        overlap=overlap,
        context=context
    )


@openeo_process
def arccos(x) -> ProcessBuilder:
    """
    Inverse cosine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('arccos', x=x)


@openeo_process
def arcosh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic cosine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('arcosh', x=x)


@openeo_process
def arcsin(x) -> ProcessBuilder:
    """
    Inverse sine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('arcsin', x=x)


@openeo_process
def arctan(x) -> ProcessBuilder:
    """
    Inverse tangent

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('arctan', x=x)


@openeo_process
def arctan2(y, x) -> ProcessBuilder:
    """
    Inverse tangent of two numbers

    :param y: A number to be used as the dividend.
    :param x: A number to be used as the divisor.

    :return: The computed angle in radians.
    """
    return _process('arctan2', y=y, x=x)


@openeo_process
def ard_normalized_radar_backscatter(data, elevation_model=UNSET, contributing_area=UNSET, ellipsoid_incidence_angle=UNSET, noise_removal=UNSET, options=UNSET) -> ProcessBuilder:
    """
    CARD4L compliant SAR NRB generation

    :param data: The source data cube containing SAR input.
    :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the back-
        end to choose, which will improve portability, but reduce reproducibility.
    :param contributing_area: If set to `true`, a DEM-based local contributing area band named
        `contributing_area` is added. The values are given in square meters.
    :param ellipsoid_incidence_angle: If set to `true`, an ellipsoidal incidence angle band named
        `ellipsoid_incidence_angle` is added. The values are given in degrees.
    :param noise_removal: If set to `false`, no noise removal is applied. Defaults to `true`, which removes
        noise.
    :param options: Proprietary options for the backscatter computations. Specifying proprietary options will
        reduce portability.

    :return: Backscatter values expressed as gamma0 in linear scale.  In addition to the bands
        `contributing_area` and `ellipsoid_incidence_angle` that can optionally be added with corresponding
        parameters, the following bands are always added to the data cube:  - `mask`: A data mask that indicates
        which values are valid (1), invalid (0) or contain no-data (null). - `local_incidence_angle`: A band with
        DEM-based local incidence angles in degrees.  The data returned is CARD4L compliant with corresponding
        metadata.
    """
    return _process('ard_normalized_radar_backscatter', 
        data=data,
        elevation_model=elevation_model,
        contributing_area=contributing_area,
        ellipsoid_incidence_angle=ellipsoid_incidence_angle,
        noise_removal=noise_removal,
        options=options
    )


@openeo_process
def ard_surface_reflectance(data, atmospheric_correction_method, cloud_detection_method, elevation_model=UNSET, atmospheric_correction_options=UNSET, cloud_detection_options=UNSET) -> ProcessBuilder:
    """
    CARD4L compliant Surface Reflectance generation

    :param data: The source data cube containing multi-spectral optical top of the atmosphere (TOA)
        reflectances. There must be a single dimension of type `bands` available.
    :param atmospheric_correction_method: The atmospheric correction method to use.
    :param cloud_detection_method: The cloud detection method to use.  Each method supports detecting different
        atmospheric disturbances such as clouds, cloud shadows, aerosols, haze, ozone and/or water vapour in
        optical imagery.
    :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the back-
        end to choose, which will improve portability, but reduce reproducibility.
    :param atmospheric_correction_options: Proprietary options for the atmospheric correction method.
        Specifying proprietary options will reduce portability.
    :param cloud_detection_options: Proprietary options for the cloud detection method. Specifying proprietary
        options will reduce portability.

    :return: Data cube containing bottom of atmosphere reflectances for each spectral band in the source data
        cube, with atmospheric disturbances like clouds and cloud shadows removed. No-data values (null) are
        directly set in the bands. Depending on the methods used, several additional bands will be added to the
        data cube:  Data cube containing bottom of atmosphere reflectances for each spectral band in the source
        data cube, with atmospheric disturbances like clouds and cloud shadows removed. Depending on the methods
        used, several additional bands will be added to the data cube:  - `date` (optional): Specifies per-pixel
        acquisition timestamps. - `incomplete-testing` (required): Identifies pixels with a value of 1 for which
        the per-pixel tests (at least saturation, cloud and cloud shadows, see CARD4L specification for details)
        have not all been successfully completed. Otherwise, the value is 0. - `saturation` (required) /
        `saturation_{band}` (optional): Indicates where pixels in the input spectral bands are saturated (1) or not
        (0). If the saturation is given per band, the band names are `saturation_{band}` with `{band}` being the
        band name from the source data cube. - `cloud`, `shadow` (both required),`aerosol`, `haze`, `ozone`,
        `water_vapor` (all optional): Indicates the probability of pixels being an atmospheric disturbance such as
        clouds. All bands have values between 0 (clear) and 1, which describes the probability that it is an
        atmospheric disturbance. - `snow-ice` (optional): Points to a file that indicates whether a pixel is
        assessed as being snow/ice (1) or not (0). All values describe the probability and must be between 0 and 1.
        - `land-water` (optional): Indicates whether a pixel is assessed as being land (1) or water (0). All values
        describe the probability and must be between 0 and 1. - `incidence-angle` (optional): Specifies per-pixel
        incidence angles in degrees. - `azimuth` (optional): Specifies per-pixel azimuth angles in degrees. - `sun-
        azimuth:` (optional): Specifies per-pixel sun azimuth angles in degrees. - `sun-elevation` (optional):
        Specifies per-pixel sun elevation angles in degrees. - `terrain-shadow` (optional): Indicates with a value
        of 1 whether a pixel is not directly illuminated due to terrain shadowing. Otherwise, the value is 0. -
        `terrain-occlusion` (optional): Indicates with a value of 1 whether a pixel is not visible to the sensor
        due to terrain occlusion during off-nadir viewing. Otherwise, the value is 0. - `terrain-illumination`
        (optional): Contains coefficients used for terrain illumination correction are provided for each pixel.
        The data returned is CARD4L compliant with corresponding metadata.
    """
    return _process('ard_surface_reflectance', 
        data=data,
        atmospheric_correction_method=atmospheric_correction_method,
        cloud_detection_method=cloud_detection_method,
        elevation_model=elevation_model,
        atmospheric_correction_options=atmospheric_correction_options,
        cloud_detection_options=cloud_detection_options
    )


@openeo_process
def array_append(data, value, label=UNSET) -> ProcessBuilder:
    """
    Append a value to an array

    :param data: An array.
    :param value: Value to append to the array.
    :param label: If the given array is a labeled array, a new label for the new value should be given. If not
        given or `null`, the array index as string is used as the label. If in any case the label exists, a
        `LabelExists` exception is thrown.

    :return: The new array with the value being appended.
    """
    return _process('array_append', data=data, value=value, label=label)


@openeo_process
def array_apply(data, process, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to each array element

    :param data: An array.
    :param process: A process that accepts and returns a single value and is applied on each individual value
        in the array. The process may consist of multiple sub-processes and could, for example, consist of
        processes such as ``absolute()`` or ``linear_scale_range()``.
    :param context: Additional data to be passed to the process.

    :return: An array with the newly computed values. The number of elements are the same as for the original
        array.
    """
    return _process('array_apply', 
        data=data,
        process=build_child_callback(process, parent_parameters=['x', 'index', 'label', 'context']),
        context=context
    )


@openeo_process
def array_concat(array1, array2) -> ProcessBuilder:
    """
    Merge two arrays

    :param array1: The first array.
    :param array2: The second array.

    :return: The merged array.
    """
    return _process('array_concat', array1=array1, array2=array2)


@openeo_process
def array_contains(data, value) -> ProcessBuilder:
    """
    Check whether the array contains a given value

    :param data: List to find the value in.
    :param value: Value to find in `data`. If the value is `null`, this process returns always `false`.

    :return: `true` if the list contains the value, false` otherwise.
    """
    return _process('array_contains', data=data, value=value)


@openeo_process
def array_create(data=UNSET, repeat=UNSET) -> ProcessBuilder:
    """
    Create an array

    :param data: A (native) array to fill the newly created array with. Defaults to an empty array.
    :param repeat: The number of times the (native) array specified in `data` is repeatedly added after each
        other to the new array being created. Defaults to `1`.

    :return: The newly created array.
    """
    return _process('array_create', data=data, repeat=repeat)


@openeo_process
def array_create_labeled(data, labels) -> ProcessBuilder:
    """
    Create a labeled array

    :param data: An array of values to be used.
    :param labels: An array of labels to be used.

    :return: The newly created labeled array.
    """
    return _process('array_create_labeled', data=data, labels=labels)


@openeo_process
def array_element(data, index=UNSET, label=UNSET, return_nodata=UNSET) -> ProcessBuilder:
    """
    Get an element from an array

    :param data: An array.
    :param index: The zero-based index of the element to retrieve.
    :param label: The label of the element to retrieve. Throws an `ArrayNotLabeled` exception, if the given
        array is not a labeled array and this parameter is set.
    :param return_nodata: By default this process throws an `ArrayElementNotAvailable` exception if the index
        or label is invalid. If you want to return `null` instead, set this flag to `true`.

    :return: The value of the requested element.
    """
    return _process('array_element', data=data, index=index, label=label, return_nodata=return_nodata)


@openeo_process
def array_filter(data, condition, context=UNSET) -> ProcessBuilder:
    """
    Filter an array based on a condition

    :param data: An array.
    :param condition: A condition that is evaluated against each value, index and/or label in the array. Only
        the array elements for which the condition returns `true` are preserved.
    :param context: Additional data to be passed to the condition.

    :return: An array filtered by the specified condition. The number of elements are less than or equal
        compared to the original array.
    """
    return _process('array_filter', 
        data=data,
        condition=build_child_callback(condition, parent_parameters=['x', 'index', 'label', 'context']),
        context=context
    )


@openeo_process
def array_find(data, value, reverse=UNSET) -> ProcessBuilder:
    """
    Get the index for a value in an array

    :param data: List to find the value in.
    :param value: Value to find in `data`. If the value is `null`, this process returns always `null`.
    :param reverse: By default, this process finds the index of the first match. To return the index of the
        last match instead, set this flag to `true`.

    :return: The index of the first element with the specified value. If no element was found, `null` is
        returned.
    """
    return _process('array_find', data=data, value=value, reverse=reverse)


@openeo_process
def array_find_label(data, label) -> ProcessBuilder:
    """
    Get the index for a label in a labeled array

    :param data: List to find the label in.
    :param label: Label to find in `data`.

    :return: The index of the element with the specified label assigned. If no such label was found, `null` is
        returned.
    """
    return _process('array_find_label', data=data, label=label)


@openeo_process
def array_interpolate_linear(data) -> ProcessBuilder:
    """
    One-dimensional linear interpolation for arrays

    :param data: An array of numbers and no-data values.  If the given array is a labeled array, the labels
        must have a natural/inherent label order and the process expects the labels to be sorted accordingly. This
        is the default behavior in openEO for spatial and temporal dimensions.

    :return: An array with no-data values being replaced with interpolated values. If not at least 2 numerical
        values are available in the array, the array stays the same.
    """
    return _process('array_interpolate_linear', data=data)


@openeo_process
def array_labels(data) -> ProcessBuilder:
    """
    Get the labels for an array

    :param data: An array.

    :return: The labels or indices as array.
    """
    return _process('array_labels', data=data)


@openeo_process
def array_modify(data, values, index, length=UNSET) -> ProcessBuilder:
    """
    Change the content of an array (remove, insert, update)

    :param data: The array to modify.
    :param values: The values to insert into the `data` array.
    :param index: The index in the `data` array of the element to insert the value(s) before. If the index is
        greater than the number of elements in the `data` array, the process throws an `ArrayElementNotAvailable`
        exception.  To insert after the last element, there are two options:  1. Use the simpler processes
        ``array_append()`` to append a single value or ``array_concat()`` to append multiple values. 2. Specify the
        number of elements in the array. You can retrieve the number of elements with the process ``count()``,
        having the parameter `condition` set to `true`.
    :param length: The number of elements in the `data` array to remove (or replace) starting from the given
        index. If the array contains fewer elements, the process simply removes all elements up to the end.

    :return: An array with values added, updated or removed.
    """
    return _process('array_modify', data=data, values=values, index=index, length=length)


@openeo_process
def arsinh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic sine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('arsinh', x=x)


@openeo_process
def artanh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic tangent

    :param x: A number.

    :return: The computed angle in radians.
    """
    return _process('artanh', x=x)


@openeo_process
def atmospheric_correction(data, method, elevation_model=UNSET, options=UNSET) -> ProcessBuilder:
    """
    Apply atmospheric correction

    :param data: Data cube containing multi-spectral optical top of atmosphere reflectances to be corrected.
    :param method: The atmospheric correction method to use. To get reproducible results, you have to set a
        specific method.  Set to `null` to allow the back-end to choose, which will improve portability, but reduce
        reproducibility as you *may* get different results if you run the processes multiple times.
    :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the back-
        end to choose, which will improve portability, but reduce reproducibility.
    :param options: Proprietary options for the atmospheric correction method. Specifying proprietary options
        will reduce portability.

    :return: Data cube containing bottom of atmosphere reflectances.
    """
    return _process('atmospheric_correction', data=data, method=method, elevation_model=elevation_model, options=options)


@openeo_process
def between(x, min, max, exclude_max=UNSET) -> ProcessBuilder:
    """
    Between comparison

    :param x: The value to check.
    :param min: Lower boundary (inclusive) to check against.
    :param max: Upper boundary (inclusive) to check against.
    :param exclude_max: Exclude the upper boundary `max` if set to `true`. Defaults to `false`.

    :return: `true` if `x` is between the specified bounds, otherwise `false`.
    """
    return _process('between', x=x, min=min, max=max, exclude_max=exclude_max)


@openeo_process
def ceil(x) -> ProcessBuilder:
    """
    Round fractions up

    :param x: A number to round up.

    :return: The number rounded up.
    """
    return _process('ceil', x=x)


@openeo_process
def climatological_normal(data, period, climatology_period=UNSET) -> ProcessBuilder:
    """
    Compute climatology normals

    :param data: A data cube with exactly one temporal dimension. The data cube must span at least the temporal
        interval specified in the parameter `climatology-period`.  Seasonal periods may span two consecutive years,
        e.g. temporal winter that includes months December, January and February. If the required months before the
        actual climate period are available, the season is taken into account. If not available, the first season
        is not taken into account and the seasonal mean is based on one year less than the other seasonal normals.
        The incomplete season at the end of the last year is never taken into account.
    :param period: The time intervals to aggregate the average value for. The following pre-defined frequencies
        are supported:  * `day`: Day of the year * `month`: Month of the year * `climatology-period`: The period
        specified in the `climatology-period`. * `season`: Three month periods of the calendar seasons (December -
        February, March - May, June - August, September - November). * `tropical-season`: Six month periods of the
        tropical seasons (November - April, May - October).
    :param climatology_period: The climatology period as a closed temporal interval. The first element of the
        array is the first year to be fully included in the temporal interval. The second element is the last year
        to be fully included in the temporal interval. The default period is from 1981 until 2010 (both inclusive).

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the temporal
        dimension. The temporal dimension has the following dimension labels:  * `day`: `001` - `365` * `month`:
        `01` - `12` * `climatology-period`: `climatology-period` * `season`: `djf` (December - February), `mam`
        (March - May), `jja` (June - August), `son` (September - November) * `tropical-season`: `ndjfma` (November
        - April), `mjjaso` (May - October)
    """
    return _process('climatological_normal', data=data, period=period, climatology_period=climatology_period)


@openeo_process
def clip(x, min, max) -> ProcessBuilder:
    """
    Clip a value between a minimum and a maximum

    :param x: A number.
    :param min: Minimum value. If the value is lower than this value, the process will return the value of this
        parameter.
    :param max: Maximum value. If the value is greater than this value, the process will return the value of
        this parameter.

    :return: The value clipped to the specified range.
    """
    return _process('clip', x=x, min=min, max=max)


@openeo_process
def cloud_detection(data, method, options=UNSET) -> ProcessBuilder:
    """
    Create cloud masks

    :param data: The source data cube containing multi-spectral optical top of the atmosphere (TOA)
        reflectances on which to perform cloud detection.
    :param method: The cloud detection method to use. To get reproducible results, you have to set a specific
        method.  Set to `null` to allow the back-end to choose, which will improve portability, but reduce
        reproducibility as you *may* get different results if you run the processes multiple times.
    :param options: Proprietary options for the cloud detection method. Specifying proprietary options will
        reduce portability.

    :return: A data cube with bands for the atmospheric disturbances. Each of the masks contains values between
        0 and 1. The data cube has the same spatial and temporal dimensions as the source data cube and a dimension
        that contains a dimension label for each of the supported/considered atmospheric disturbance.
    """
    return _process('cloud_detection', data=data, method=method, options=options)


@openeo_process
def constant(x) -> ProcessBuilder:
    """
    Define a constant value

    :param x: The value of the constant.

    :return: The value of the constant.
    """
    return _process('constant', x=x)


@openeo_process
def cos(x) -> ProcessBuilder:
    """
    Cosine

    :param x: An angle in radians.

    :return: The computed cosine of `x`.
    """
    return _process('cos', x=x)


@openeo_process
def cosh(x) -> ProcessBuilder:
    """
    Hyperbolic cosine

    :param x: An angle in radians.

    :return: The computed hyperbolic cosine of `x`.
    """
    return _process('cosh', x=x)


@openeo_process
def count(data, condition=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Count the number of elements

    :param data: An array with elements of any data type.
    :param condition: A condition consists of one or more processes, which in the end return a boolean value.
        It is evaluated against each element in the array. An element is counted only if the condition returns
        `true`. Defaults to count valid elements in a list (see ``is_valid()``). Setting this parameter to boolean
        `true` counts all elements in the list.
    :param context: Additional data to be passed to the condition.

    :return: The counted number of elements.
    """
    return _process('count', data=data, condition=condition, context=context)


@openeo_process
def create_raster_cube() -> ProcessBuilder:
    """
    Create an empty raster data cube

    :return: An empty raster data cube with zero dimensions.
    """
    return _process('create_raster_cube', )


@openeo_process
def cummax(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative maxima

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
        Setting this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative maxima.
    """
    return _process('cummax', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def cummin(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative minima

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
        Setting this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative minima.
    """
    return _process('cummin', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def cumproduct(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative products

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
        Setting this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative products.
    """
    return _process('cumproduct', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def cumsum(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative sums

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.
        Setting this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative sums.
    """
    return _process('cumsum', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def date_shift(date, value, unit) -> ProcessBuilder:
    """
    Manipulates dates and times by addition or subtraction

    :param date: The date (and optionally time) to manipulate.  If the given date doesn't include the time, the
        process assumes that the time component is `00:00:00Z` (i.e. midnight, in UTC). The millisecond part of the
        time is optional and defaults to `0` if not given.
    :param value: The period of time in the unit given that is added (positive numbers) or subtracted (negative
        numbers). The value `0` doesn't have any effect.
    :param unit: The unit for the value given. The following pre-defined units are available:  - millisecond:
        Milliseconds - second: Seconds - leap seconds are ignored in computations. - minute: Minutes - hour: Hours
        - day: Days - changes only the the day part of a date - week: Weeks (equivalent to 7 days) - month: Months
        - year: Years  Manipulations with the unit `year`, `month`, `week` or `day` do never change the time. If
        any of the manipulations result in an invalid date or time, the corresponding part is rounded down to the
        next valid date or time respectively. For example, adding a month to `2020-01-31` would result in
        `2020-02-29`.

    :return: The manipulated date. If a time component was given in the parameter `date`, the time component is
        returned with the date.
    """
    return _process('date_shift', date=date, value=value, unit=unit)


@openeo_process
def dimension_labels(data, dimension) -> ProcessBuilder:
    """
    Get the dimension labels

    :param data: The data cube.
    :param dimension: The name of the dimension to get the labels for.

    :return: The labels as an array.
    """
    return _process('dimension_labels', data=data, dimension=dimension)


@openeo_process
def divide(x, y) -> ProcessBuilder:
    """
    Division of two numbers

    :param x: The dividend.
    :param y: The divisor.

    :return: The computed result.
    """
    return _process('divide', x=x, y=y)


@openeo_process
def drop_dimension(data, name) -> ProcessBuilder:
    """
    Remove a dimension

    :param data: The data cube to drop a dimension from.
    :param name: Name of the dimension to drop.

    :return: A data cube without the specified dimension. The number of dimensions decreases by one, but the
        dimension properties (name, type, labels, reference system and resolution) for all other dimensions remain
        unchanged.
    """
    return _process('drop_dimension', data=data, name=name)


@openeo_process
def e() -> ProcessBuilder:
    """
    Euler's number (e)

    :return: The numerical value of Euler's number.
    """
    return _process('e', )


@openeo_process
def eq(x, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Equal to comparison

    :param x: First operand.
    :param y: Second operand.
    :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a positive
        non-zero number the equality of two numbers is checked against a delta value. This is especially useful to
        circumvent problems with floating-point inaccuracy in machine-based computation.  This option is basically
        an alias for the following computation: `lte(abs(minus([x, y]), delta)`
    :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be disabled
        by setting this parameter to `false`.

    :return: `true` if `x` is equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return _process('eq', x=x, y=y, delta=delta, case_sensitive=case_sensitive)


@openeo_process
def exp(p) -> ProcessBuilder:
    """
    Exponentiation to the base e

    :param p: The numerical exponent.

    :return: The computed value for *e* raised to the power of `p`.
    """
    return _process('exp', p=p)


@openeo_process
def extrema(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Minimum and maximum values

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that an array with two `null` values is returned if any
        value is such a value.

    :return: An array containing the minimum and maximum values for the specified numbers. The first element is
        the minimum, the second element is the maximum. If the input array is empty both elements are set to
        `null`.
    """
    return _process('extrema', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def filter_bands(data, bands=UNSET, wavelengths=UNSET) -> ProcessBuilder:
    """
    Filter the bands by names

    :param data: A data cube with bands.
    :param bands: A list of band names. Either the unique band name (metadata field `name` in bands) or one of
        the common band names (metadata field `common_name` in bands). If the unique band name and the common name
        conflict, the unique band name has a higher priority.  The order of the specified array defines the order
        of the bands in the data cube. If multiple bands match a common name, all matched bands are included in the
        original order.
    :param wavelengths: A list of sub-lists with each sub-list consisting of two elements. The first element is
        the minimum wavelength and the second element is the maximum wavelength. Wavelengths are specified in
        micrometers (μm).  The order of the specified array defines the order of the bands in the data cube. If
        multiple bands match the wavelengths, all matched bands are included in the original order.

    :return: A data cube limited to a subset of its original bands. The dimensions and dimension properties
        (name, type, labels, reference system and resolution) remain unchanged, except that the dimension of type
        `bands` has less (or the same) dimension labels.
    """
    return _process('filter_bands', data=data, bands=bands, wavelengths=wavelengths)


@openeo_process
def filter_bbox(data, extent) -> ProcessBuilder:
    """
    Spatial filter using a bounding box

    :param data: A data cube.
    :param extent: A bounding box, which may include a vertical axis (see `base` and `height`).

    :return: A data cube restricted to the bounding box. The dimensions and dimension properties (name, type,
        labels, reference system and resolution) remain unchanged, except that the spatial dimensions have less (or
        the same) dimension labels.
    """
    return _process('filter_bbox', data=data, extent=extent)


@openeo_process
def filter_labels(data, condition, dimension, context=UNSET) -> ProcessBuilder:
    """
    Filter dimension labels based on a condition

    :param data: A data cube.
    :param condition: A condition that is evaluated against each dimension label in the specified dimension. A
        dimension label and the corresponding data is preserved for the given dimension, if the condition returns
        `true`.
    :param dimension: The name of the dimension to filter on. Fails with a `DimensionNotAvailable` exception if
        the specified dimension does not exist.
    :param context: Additional data to be passed to the condition.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except that the given dimension has less (or the same) dimension
        labels.
    """
    return _process('filter_labels', 
        data=data,
        condition=build_child_callback(condition, parent_parameters=['value', 'context']),
        dimension=dimension,
        context=context
    )


@openeo_process
def filter_spatial(data, geometries) -> ProcessBuilder:
    """
    Spatial filter using geometries

    :param data: A data cube.
    :param geometries: One or more geometries used for filtering, specified as GeoJSON.

    :return: A data cube restricted to the specified geometries. The dimensions and dimension properties (name,
        type, labels, reference system and resolution) remain unchanged, except that the spatial dimensions have
        less (or the same) dimension labels.
    """
    return _process('filter_spatial', data=data, geometries=geometries)


@openeo_process
def filter_temporal(data, extent, dimension=UNSET) -> ProcessBuilder:
    """
    Temporal filter based on temporal intervals

    :param data: A data cube.
    :param extent: Left-closed temporal interval, i.e. an array with exactly two elements:  1. The first
        element is the start of the temporal interval. The specified instance in time is **included** in the
        interval. 2. The second element is the end of the temporal interval. The specified instance in time is
        **excluded** from the interval.  The specified temporal strings follow [RFC 3339](https://www.rfc-
        editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but
        never both.
    :param dimension: The name of the temporal dimension to filter on. If no specific dimension is specified or
        it is set to `null`, the filter applies to all temporal dimensions. Fails with a `DimensionNotAvailable`
        exception if the specified dimension does not exist.

    :return: A data cube restricted to the specified temporal extent. The dimensions and dimension properties
        (name, type, labels, reference system and resolution) remain unchanged, except that the temporal dimensions
        (determined by `dimensions` parameter) may have less dimension labels.
    """
    return _process('filter_temporal', data=data, extent=extent, dimension=dimension)


@openeo_process
def first(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    First element

    :param data: An array with elements of any data type.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if the first value is such a
        value.

    :return: The first element of the input array.
    """
    return _process('first', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def fit_class_random_forest(predictors, target, max_variables, num_trees=UNSET, seed=UNSET) -> ProcessBuilder:
    """
    Train a random forest classification model

    :param predictors: The predictors for the classification model as a vector data cube. Aggregated to the
        features (vectors) of the target input variable.
    :param target: The training sites for the classification model as a vector data cube. This is associated
        with the target variable for the Random Forest model. The geometry has to associated with a value to
        predict (e.g. fractional forest canopy cover).
    :param max_variables: Specifies how many split variables will be used at a node.  The following options are
        available:  - *integer*: The given number of variables are considered for each split. - `all`: All
        variables are considered for each split. - `log2`: The logarithm with base 2 of the number of variables are
        considered for each split. - `onethird`: A third of the number of variables are considered for each split.
        - `sqrt`: The square root of the number of variables are considered for each split. This is often the
        default for classification.
    :param num_trees: The number of trees build within the Random Forest classification.
    :param seed: A randomization seed to use for the random sampling in training. If not given or `null`, no
        seed is used and results may differ on subsequent use.

    :return: A model object that can be saved with ``save_ml_model()`` and restored with ``load_ml_model()``.
    """
    return _process('fit_class_random_forest', predictors=predictors, target=target, max_variables=max_variables, num_trees=num_trees, seed=seed)


@openeo_process
def fit_curve(data, parameters, function, dimension) -> ProcessBuilder:
    """
    Curve fitting

    :param data: A data cube.
    :param parameters: Defined the number of parameters for the model function and provides an initial guess
        for them. At least one parameter is required.
    :param function: The model function. It must take the parameters to fit as array through the first argument
        and the independent variable `x` as the second argument.  It is recommended to store the model function as
        a user-defined process on the back-end to be able to re-use the model function with the computed optimal
        values for the parameters afterwards.
    :param dimension: The name of the dimension for curve fitting. Must be a dimension with labels that have a
        order (i.e. numerical labels or a temporal dimension). Fails with a `DimensionNotAvailable` exception if
        the specified dimension does not exist.

    :return: A data cube with the optimal values for the parameters.
    """
    return _process('fit_curve', 
        data=data,
        parameters=parameters,
        function=build_child_callback(function, parent_parameters=['x', 'parameters']),
        dimension=dimension
    )


@openeo_process
def fit_regr_random_forest(predictors, target, max_variables, num_trees=UNSET, seed=UNSET) -> ProcessBuilder:
    """
    Train a random forest regression model

    :param predictors: The predictors for the regression model as a vector data cube. Aggregated to the
        features (vectors) of the target input variable.
    :param target: The training sites for the regression model as a vector data cube. This is associated with
        the target variable for the Random Forest model. The geometry has to associated with a value to predict
        (e.g. fractional forest canopy cover).
    :param max_variables: Specifies how many split variables will be used at a node.  The following options are
        available:  - *integer*: The given number of variables are considered for each split. - `all`: All
        variables are considered for each split. - `log2`: The logarithm with base 2 of the number of variables are
        considered for each split. - `onethird`: A third of the number of variables are considered for each split.
        This is often the default for regression. - `sqrt`: The square root of the number of variables are
        considered for each split.
    :param num_trees: The number of trees build within the Random Forest regression.
    :param seed: A randomization seed to use for the random sampling in training. If not given or `null`, no
        seed is used and results may differ on subsequent use.

    :return: A model object that can be saved with ``save_ml_model()`` and restored with ``load_ml_model()``.
    """
    return _process('fit_regr_random_forest', predictors=predictors, target=target, max_variables=max_variables, num_trees=num_trees, seed=seed)


@openeo_process
def flatten_dimensions(data, dimensions, target_dimension, label_separator=UNSET) -> ProcessBuilder:
    """
    Combine multiple dimensions into a single dimension

    :param data: A data cube.
    :param dimensions: The names of the dimension to combine. The order of the array defines the order in which
        the dimension labels and values are combined (see the example in the process description). Fails with a
        `DimensionNotAvailable` exception if at least one of the specified dimensions does not exist.
    :param target_dimension: The name of the new target dimension. A new dimensions will be created with the
        given names and type `other` (see ``add_dimension()``). Fails with a `TargetDimensionExists` exception if a
        dimension with the specified name exists.
    :param label_separator: The string that will be used as a separator for the concatenated dimension labels.
        To unambiguously revert the dimension labels with the process ``unflatten_dimension()``, the given string
        must not be contained in any of the dimension labels.

    :return: A data cube with the new shape. The dimension properties (name, type, labels, reference system and
        resolution) for all other dimensions remain unchanged.
    """
    return _process('flatten_dimensions', data=data, dimensions=dimensions, target_dimension=target_dimension, label_separator=label_separator)


@openeo_process
def floor(x) -> ProcessBuilder:
    """
    Round fractions down

    :param x: A number to round down.

    :return: The number rounded down.
    """
    return _process('floor', x=x)


@openeo_process
def gt(x, y) -> ProcessBuilder:
    """
    Greater than comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is strictly greater than `y` or `null` if any operand is `null`, otherwise `false`.
    """
    return _process('gt', x=x, y=y)


@openeo_process
def gte(x, y) -> ProcessBuilder:
    """
    Greater than or equal to comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is greater than or equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return _process('gte', x=x, y=y)


@openeo_process
def if_(value, accept, reject=UNSET) -> ProcessBuilder:
    """
    If-Then-Else conditional

    :param value: A boolean value.
    :param accept: A value that is returned if the boolean value is `true`.
    :param reject: A value that is returned if the boolean value is **not** `true`. Defaults to `null`.

    :return: Either the `accept` or `reject` argument depending on the given boolean value.
    """
    return _process('if', value=value, accept=accept, reject=reject)


@openeo_process
def inspect(data, code=UNSET, level=UNSET, message=UNSET) -> ProcessBuilder:
    """
    Add information to the logs

    :param data: Data to log.
    :param code: A label to help identify one or more log entries originating from this process in the list of
        all log entries. It can help to group or filter log entries and is usually not unique.
    :param level: The severity level of this message, defaults to `info`.
    :param message: A message to send in addition to the data.

    :return: The data as passed to the `data` parameter without any modification.
    """
    return _process('inspect', data=data, code=code, level=level, message=message)


@openeo_process
def int(x) -> ProcessBuilder:
    """
    Integer part of a number

    :param x: A number.

    :return: Integer part of the number.
    """
    return _process('int', x=x)


@openeo_process
def is_infinite(x) -> ProcessBuilder:
    """
    Value is an infinite number

    :param x: The data to check.

    :return: `true` if the data is an infinite number, otherwise `false`.
    """
    return _process('is_infinite', x=x)


@openeo_process
def is_nan(x) -> ProcessBuilder:
    """
    Value is not a number

    :param x: The data to check.

    :return: `true` if the data is not a number, otherwise `false`.
    """
    return _process('is_nan', x=x)


@openeo_process
def is_nodata(x) -> ProcessBuilder:
    """
    Value is a no-data value

    :param x: The data to check.

    :return: `true` if the data is a no-data value, otherwise `false`.
    """
    return _process('is_nodata', x=x)


@openeo_process
def is_valid(x) -> ProcessBuilder:
    """
    Value is valid data

    :param x: The data to check.

    :return: `true` if the data is valid, otherwise `false`.
    """
    return _process('is_valid', x=x)


@openeo_process
def last(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Last element

    :param data: An array with elements of any data type.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if the last value is such a value.

    :return: The last element of the input array.
    """
    return _process('last', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def linear_scale_range(x, inputMin, inputMax, outputMin=UNSET, outputMax=UNSET) -> ProcessBuilder:
    """
    Linear transformation between two ranges

    :param x: A number to transform. The number gets clipped to the bounds specified in `inputMin` and
        `inputMax`.
    :param inputMin: Minimum value the input can obtain.
    :param inputMax: Maximum value the input can obtain.
    :param outputMin: Minimum value of the desired output range.
    :param outputMax: Maximum value of the desired output range.

    :return: The transformed number.
    """
    return _process('linear_scale_range', x=x, inputMin=inputMin, inputMax=inputMax, outputMin=outputMin, outputMax=outputMax)


@openeo_process
def ln(x) -> ProcessBuilder:
    """
    Natural logarithm

    :param x: A number to compute the natural logarithm for.

    :return: The computed natural logarithm.
    """
    return _process('ln', x=x)


@openeo_process
def load_collection(id, spatial_extent, temporal_extent, bands=UNSET, properties=UNSET) -> ProcessBuilder:
    """
    Load a collection

    :param id: The collection id.
    :param spatial_extent: Limits the data to load from the collection to the specified bounding box or
        polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects with the
        bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).  The GeoJSON
        can be one of the following feature types:  * A `Polygon` or `MultiPolygon` geometry, * a `Feature` with a
        `Polygon` or `MultiPolygon` geometry, * a `FeatureCollection` containing at least one `Feature` with
        `Polygon` or `MultiPolygon` geometries, or * a `GeometryCollection` containing `Polygon` or `MultiPolygon`
        geometries. To maximize interoperability, `GeometryCollection` should be avoided in favour of one of the
        alternatives above.  Set this parameter to `null` to set no limit for the spatial extent. Be careful with
        this when loading large datasets! It is recommended to use this parameter instead of using
        ``filter_bbox()`` or ``filter_spatial()`` directly after loading unbounded data.
    :param temporal_extent: Limits the data to load from the collection to the specified left-closed temporal
        interval. Applies to all temporal dimensions. The interval has to be specified as an array with exactly two
        elements:  1. The first element is the start of the temporal interval. The specified instance in time is
        **included** in the interval. 2. The second element is the end of the temporal interval. The specified
        instance in time is **excluded** from the interval.  The specified temporal strings follow [RFC
        3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the
        boundaries to `null`, but never both.  Set this parameter to `null` to set no limit for the temporal
        extent. Be careful with this when loading large datasets! It is recommended to use this parameter instead
        of using ``filter_temporal()`` directly after loading unbounded data.
    :param bands: Only adds the specified bands into the data cube so that bands that don't match the list of
        band names are not available. Applies to all dimensions of type `bands`.  Either the unique band name
        (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in bands)
        can be specified. If the unique band name and the common name conflict, the unique band name has a higher
        priority.  The order of the specified array defines the order of the bands in the data cube. If multiple
        bands match a common name, all matched bands are included in the original order.  It is recommended to use
        this parameter instead of using ``filter_bands()`` directly after loading unbounded data.
    :param properties: Limits the data by metadata properties to include only data in the data cube which all
        given conditions return `true` for (AND operation).  Specify key-value-pairs with the key being the name of
        the metadata property, which can be retrieved with the openEO Data Discovery for Collections. The value
        must be a condition (user-defined process) to be evaluated against the collection metadata, see the
        example.

    :return: A data cube for further processing. The dimensions and dimension properties (name, type, labels,
        reference system and resolution) correspond to the collection's metadata, but the dimension labels are
        restricted as specified in the parameters.
    """
    return _process('load_collection', id=id, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands, properties=properties)


@openeo_process
def load_ml_model(id) -> ProcessBuilder:
    """
    Load a ML model

    :param id: The STAC Item to load the machine learning model from. The STAC Item must implement the `ml-
        model` extension.

    :return: A machine learning model to be used with machine learning processes such as
        ``predict_random_forest()``.
    """
    return _process('load_ml_model', id=id)


@openeo_process
def load_result(id, spatial_extent=UNSET, temporal_extent=UNSET, bands=UNSET) -> ProcessBuilder:
    """
    Load batch job results

    :param id: The id of a batch job with results.
    :param spatial_extent: Limits the data to load from the batch job result to the specified bounding box or
        polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects with the
        bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).  The GeoJSON
        can be one of the following feature types:  * A `Polygon` or `MultiPolygon` geometry, * a `Feature` with a
        `Polygon` or `MultiPolygon` geometry, * a `FeatureCollection` containing at least one `Feature` with
        `Polygon` or `MultiPolygon` geometries, or * a `GeometryCollection` containing `Polygon` or `MultiPolygon`
        geometries. To maximize interoperability, `GeometryCollection` should be avoided in favour of one of the
        alternatives above.  Set this parameter to `null` to set no limit for the spatial extent. Be careful with
        this when loading large datasets! It is recommended to use this parameter instead of using
        ``filter_bbox()`` or ``filter_spatial()`` directly after loading unbounded data.
    :param temporal_extent: Limits the data to load from the batch job result to the specified left-closed
        temporal interval. Applies to all temporal dimensions. The interval has to be specified as an array with
        exactly two elements:  1. The first element is the start of the temporal interval. The specified instance
        in time is **included** in the interval. 2. The second element is the end of the temporal interval. The
        specified instance in time is **excluded** from the interval.  The specified temporal strings follow [RFC
        3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the
        boundaries to `null`, but never both.  Set this parameter to `null` to set no limit for the temporal
        extent. Be careful with this when loading large datasets! It is recommended to use this parameter instead
        of using ``filter_temporal()`` directly after loading unbounded data.
    :param bands: Only adds the specified bands into the data cube so that bands that don't match the list of
        band names are not available. Applies to all dimensions of type `bands`.  Either the unique band name
        (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in bands)
        can be specified. If the unique band name and the common name conflict, the unique band name has a higher
        priority.  The order of the specified array defines the order of the bands in the data cube. If multiple
        bands match a common name, all matched bands are included in the original order.  It is recommended to use
        this parameter instead of using ``filter_bands()`` directly after loading unbounded data.

    :return: A data cube for further processing.
    """
    return _process('load_result', id=id, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands)


@openeo_process
def load_uploaded_files(paths, format, options=UNSET) -> ProcessBuilder:
    """
    Load files from the user workspace

    :param paths: The files to read. Folders can't be specified, specify all files instead. An exception is
        thrown if a file can't be read.
    :param format: The file format to read from. It must be one of the values that the server reports as
        supported input file formats, which usually correspond to the short GDAL/OGR codes. If the format is not
        suitable for loading the data, a `FormatUnsuitable` exception will be thrown. This parameter is *case
        insensitive*.
    :param options: The file format parameters to be used to read the files. Must correspond to the parameters
        that the server reports as supported parameters for the chosen `format`. The parameter names and valid
        values usually correspond to the GDAL/OGR format options.

    :return: A data cube for further processing.
    """
    return _process('load_uploaded_files', paths=paths, format=format, options=options)


@openeo_process
def log(x, base) -> ProcessBuilder:
    """
    Logarithm to a base

    :param x: A number to compute the logarithm for.
    :param base: The numerical base.

    :return: The computed logarithm.
    """
    return _process('log', x=x, base=base)


@openeo_process
def lt(x, y) -> ProcessBuilder:
    """
    Less than comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is strictly less than `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return _process('lt', x=x, y=y)


@openeo_process
def lte(x, y) -> ProcessBuilder:
    """
    Less than or equal to comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is less than or equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return _process('lte', x=x, y=y)


@openeo_process
def mask(data, mask, replacement=UNSET) -> ProcessBuilder:
    """
    Apply a raster mask

    :param data: A raster data cube.
    :param mask: A mask as a raster data cube. Every pixel in `data` must have a corresponding element in
        `mask`.
    :param replacement: The value used to replace masked values with.

    :return: A masked raster data cube with the same dimensions. The dimension properties (name, type, labels,
        reference system and resolution) remain unchanged.
    """
    return _process('mask', data=data, mask=mask, replacement=replacement)


@openeo_process
def mask_polygon(data, mask, replacement=UNSET, inside=UNSET) -> ProcessBuilder:
    """
    Apply a polygon mask

    :param data: A raster data cube.
    :param mask: A GeoJSON object containing at least one polygon. The provided feature types can be one of the
        following:  * A `Polygon` or `MultiPolygon` geometry, * a `Feature` with a `Polygon` or `MultiPolygon`
        geometry, * a `FeatureCollection` containing at least one `Feature` with `Polygon` or `MultiPolygon`
        geometries, or * a `GeometryCollection` containing `Polygon` or `MultiPolygon` geometries. To maximize
        interoperability, `GeometryCollection` should be avoided in favour of one of the alternatives above.
    :param replacement: The value used to replace masked values with.
    :param inside: If set to `true` all pixels for which the point at the pixel center **does** intersect with
        any polygon are replaced.

    :return: A masked raster data cube with the same dimensions. The dimension properties (name, type, labels,
        reference system and resolution) remain unchanged.
    """
    return _process('mask_polygon', data=data, mask=mask, replacement=replacement, inside=inside)


@openeo_process
def max(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Maximum value

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The maximum value.
    """
    return _process('max', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def mean(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Arithmetic mean (average)

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed arithmetic mean.
    """
    return _process('mean', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def median(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Statistical median

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed statistical median.
    """
    return _process('median', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def merge_cubes(cube1, cube2, overlap_resolver=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Merge two data cubes

    :param cube1: The first data cube.
    :param cube2: The second data cube.
    :param overlap_resolver: A reduction operator that resolves the conflict if the data overlaps. The reducer
        must return a value of the same data type as the input values are. The reduction operator may be a single
        process such as ``multiply()`` or consist of multiple sub-processes. `null` (the default) can be specified
        if no overlap resolver is required.
    :param context: Additional data to be passed to the overlap resolver.

    :return: The merged data cube. See the process description for details regarding the dimensions and
        dimension properties (name, type, labels, reference system and resolution).
    """
    return _process('merge_cubes', 
        cube1=cube1,
        cube2=cube2,
        overlap_resolver=build_child_callback(overlap_resolver, parent_parameters=['x', 'y', 'context']),
        context=context
    )


@openeo_process
def min(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Minimum value

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The minimum value.
    """
    return _process('min', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def mod(x, y) -> ProcessBuilder:
    """
    Modulo

    :param x: A number to be used as the dividend.
    :param y: A number to be used as the divisor.

    :return: The remainder after division.
    """
    return _process('mod', x=x, y=y)


@openeo_process
def multiply(x, y) -> ProcessBuilder:
    """
    Multiplication of two numbers

    :param x: The multiplier.
    :param y: The multiplicand.

    :return: The computed product of the two numbers.
    """
    return _process('multiply', x=x, y=y)


@openeo_process
def nan() -> ProcessBuilder:
    """
    Not a Number (NaN)

    :return: Returns `NaN`.
    """
    return _process('nan', )


@openeo_process
def ndvi(data, nir=UNSET, red=UNSET, target_band=UNSET) -> ProcessBuilder:
    """
    Normalized Difference Vegetation Index

    :param data: A raster data cube with two bands that have the common names `red` and `nir` assigned.
    :param nir: The name of the NIR band. Defaults to the band that has the common name `nir` assigned.  Either
        the unique band name (metadata field `name` in bands) or one of the common band names (metadata field
        `common_name` in bands) can be specified. If the unique band name and the common name conflict, the unique
        band name has a higher priority.
    :param red: The name of the red band. Defaults to the band that has the common name `red` assigned.  Either
        the unique band name (metadata field `name` in bands) or one of the common band names (metadata field
        `common_name` in bands) can be specified. If the unique band name and the common name conflict, the unique
        band name has a higher priority.
    :param target_band: By default, the dimension of type `bands` is dropped. To keep the dimension specify a
        new band name in this parameter so that a new dimension label with the specified name will be added for the
        computed values.

    :return: A raster data cube containing the computed NDVI values. The structure of the data cube differs
        depending on the value passed to `target_band`:  * `target_band` is `null`: The data cube does not contain
        the dimension of type `bands`, the number of dimensions decreases by one. The dimension properties (name,
        type, labels, reference system and resolution) for all other dimensions remain unchanged. * `target_band`
        is a string: The data cube keeps the same dimensions. The dimension properties remain unchanged, but the
        number of dimension labels for the dimension of type `bands` increases by one. The additional label is
        named as specified in `target_band`.
    """
    return _process('ndvi', data=data, nir=nir, red=red, target_band=target_band)


@openeo_process
def neq(x, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Not equal to comparison

    :param x: First operand.
    :param y: Second operand.
    :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a positive
        non-zero number the non-equality of two numbers is checked against a delta value. This is especially useful
        to circumvent problems with floating-point inaccuracy in machine-based computation.  This option is
        basically an alias for the following computation: `gt(abs(minus([x, y]), delta)`
    :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be disabled
        by setting this parameter to `false`.

    :return: `true` if `x` is *not* equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return _process('neq', x=x, y=y, delta=delta, case_sensitive=case_sensitive)


@openeo_process
def normalized_difference(x, y) -> ProcessBuilder:
    """
    Normalized difference

    :param x: The value for the first band.
    :param y: The value for the second band.

    :return: The computed normalized difference.
    """
    return _process('normalized_difference', x=x, y=y)


@openeo_process
def not_(x) -> ProcessBuilder:
    """
    Inverting a boolean

    :param x: Boolean value to invert.

    :return: Inverted boolean value.
    """
    return _process('not', x=x)


@openeo_process
def or_(x, y) -> ProcessBuilder:
    """
    Logical OR

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical OR.
    """
    return _process('or', x=x, y=y)


@openeo_process
def order(data, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
    """
    Create a permutation

    :param data: An array to compute the order for.
    :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
        (descending) order, set this parameter to `false`.
    :param nodata: Controls the handling of no-data values (`null`). By default, they are removed. If set to
        `true`, missing values in the data are put last; if set to `false`, they are put first.

    :return: The computed permutation.
    """
    return _process('order', data=data, asc=asc, nodata=nodata)


@openeo_process
def pi() -> ProcessBuilder:
    """
    Pi (π)

    :return: The numerical value of Pi.
    """
    return _process('pi', )


@openeo_process
def power(base, p) -> ProcessBuilder:
    """
    Exponentiation

    :param base: The numerical base.
    :param p: The numerical exponent.

    :return: The computed value for `base` raised to the power of `p`.
    """
    return _process('power', base=base, p=p)


@openeo_process
def predict_curve(data, parameters, function, dimension, labels=UNSET) -> ProcessBuilder:
    """
    Predict values

    :param data: A data cube to predict values for.
    :param parameters: A data cube with optimal values from a result of e.g. ``fit_curve()``.
    :param function: The model function. It must take the parameters to fit as array through the first argument
        and the independent variable `x` as the second argument.  It is recommended to store the model function as
        a user-defined process on the back-end.
    :param dimension: The name of the dimension for predictions. Fails with a `DimensionNotAvailable` exception
        if the specified dimension does not exist.
    :param labels: The labels to predict values for. If no labels are given, predicts values only for no-data
        (`null`) values in the data cube.

    :return: A data cube with the predicted values.
    """
    return _process('predict_curve', 
        data=data,
        parameters=parameters,
        function=build_child_callback(function, parent_parameters=['x', 'parameters']),
        dimension=dimension,
        labels=labels
    )


@openeo_process
def predict_random_forest(data, model) -> ProcessBuilder:
    """
    Predict values from a Random Forest model

    :param data: An array of numbers.
    :param model: A model object that can be trained with the processes ``fit_regr_random_forest()``
        (regression) and ``fit_class_random_forest()`` (classification).

    :return: The predicted value. Returns `null` if any of the given values in the array is a no-data value.
    """
    return _process('predict_random_forest', data=data, model=model)


@openeo_process
def product(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Compute the product by multiplying numbers

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed product of the sequence of numbers.
    """
    return _process('product', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def quantiles(data, probabilities=UNSET, q=UNSET, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Quantiles

    :param data: An array of numbers.
    :param probabilities: A list of probabilities to calculate quantiles for. The probabilities must be between
        0 and 1 (inclusive).
    :param q: Number of intervals to calculate quantiles for. Calculates q-quantiles with equal-sized
        intervals.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that an array with `null` values is returned if any
        element is such a value.

    :return: An array with the computed quantiles. The list has either  * as many elements as the given list of
        `probabilities` had or * *`q`-1* elements.  If the input array is empty the resulting array is filled with
        as many `null` values as required according to the list above. See the 'Empty array' example for an
        example.
    """
    return _process('quantiles', data=data, probabilities=probabilities, q=q, ignore_nodata=ignore_nodata)


@openeo_process
def rearrange(data, order) -> ProcessBuilder:
    """
    Rearrange an array based on a permutation

    :param data: The array to rearrange.
    :param order: The permutation used for rearranging.

    :return: The rearranged array.
    """
    return _process('rearrange', data=data, order=order)


@openeo_process
def reduce_dimension(data, reducer, dimension, context=UNSET) -> ProcessBuilder:
    """
    Reduce dimensions

    :param data: A data cube.
    :param reducer: A reducer to apply on the specified dimension. A reducer is a single process such as
        ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
        'reducer' for such processes.
    :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
        exception if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the newly computed values. It is missing the given dimension, the number of
        dimensions decreases by one. The dimension properties (name, type, labels, reference system and resolution)
        for all other dimensions remain unchanged.
    """
    return _process('reduce_dimension', 
        data=data,
        reducer=build_child_callback(reducer, parent_parameters=['data', 'context']),
        dimension=dimension,
        context=context
    )


@openeo_process
def reduce_spatial(data, reducer, context=UNSET) -> ProcessBuilder:
    """
    Reduce spatial dimensions 'x' and 'y'

    :param data: A data cube.
    :param reducer: A reducer to apply on the horizontal spatial dimensions. A reducer is a single process such
        as ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
        'reducer' for such processes.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the newly computed values. It is missing the horizontal spatial dimensions, the
        number of dimensions decreases by two. The dimension properties (name, type, labels, reference system and
        resolution) for all other dimensions remain unchanged.
    """
    return _process('reduce_spatial', data=data, reducer=build_child_callback(reducer, parent_parameters=['data', 'context']), context=context)


@openeo_process
def rename_dimension(data, source, target) -> ProcessBuilder:
    """
    Rename a dimension

    :param data: The data cube.
    :param source: The current name of the dimension. Fails with a `DimensionNotAvailable` exception if the
        specified dimension does not exist.
    :param target: A new Name for the dimension. Fails with a `DimensionExists` exception if a dimension with
        the specified name exists.

    :return: A data cube with the same dimensions, but the name of one of the dimensions changes. The old name
        can not be referred to any longer. The dimension properties (name, type, labels, reference system and
        resolution) remain unchanged.
    """
    return _process('rename_dimension', data=data, source=source, target=target)


@openeo_process
def rename_labels(data, dimension, target, source=UNSET) -> ProcessBuilder:
    """
    Rename dimension labels

    :param data: The data cube.
    :param dimension: The name of the dimension to rename the labels for.
    :param target: The new names for the labels.  If a target dimension label already exists in the data cube,
        a `LabelExists` exception is thrown.
    :param source: The original names of the labels to be renamed to corresponding array elements in the
        parameter `target`. It is allowed to only specify a subset of labels to rename, as long as the `target` and
        `source` parameter have the same length. The order of the labels doesn't need to match the order of the
        dimension labels in the data cube. By default, the array is empty so that the dimension labels in the data
        cube are expected to be enumerated.  If the dimension labels are not enumerated and the given array is
        empty, the `LabelsNotEnumerated` exception is thrown. If one of the source dimension labels doesn't exist,
        the `LabelNotAvailable` exception is thrown.

    :return: The data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except that for the given dimension the labels change. The old
        labels can not be referred to any longer. The number of labels remains the same.
    """
    return _process('rename_labels', data=data, dimension=dimension, target=target, source=source)


@openeo_process
def resample_cube_spatial(data, target, method=UNSET) -> ProcessBuilder:
    """
    Resample the spatial dimensions to match a target data cube

    :param data: A data cube.
    :param target: A data cube that describes the spatial target resolution.
    :param method: Resampling method to use. The following options are available and are meant to align with
        [`gdalwarp`](https://gdal.org/programs/gdalwarp.html#cmdoption-gdalwarp-r):  * `average`: average (mean)
        resampling, computes the weighted average of all valid pixels * `bilinear`: bilinear resampling * `cubic`:
        cubic resampling * `cubicspline`: cubic spline resampling * `lanczos`: Lanczos windowed sinc resampling *
        `max`: maximum resampling, selects the maximum value from all valid pixels * `med`: median resampling,
        selects the median value of all valid pixels * `min`: minimum resampling, selects the minimum value from
        all valid pixels * `mode`: mode resampling, selects the value which appears most often of all the sampled
        points * `near`: nearest neighbour resampling (default) * `q1`: first quartile resampling, selects the
        first quartile value of all valid pixels * `q3`: third quartile resampling, selects the third quartile
        value of all valid pixels * `rms` root mean square (quadratic mean) of all valid pixels * `sum`: compute
        the weighted sum of all valid pixels  Valid pixels are determined based on the function ``is_valid()``.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the spatial
        dimensions.
    """
    return _process('resample_cube_spatial', data=data, target=target, method=method)


@openeo_process
def resample_cube_temporal(data, target, dimension=UNSET, valid_within=UNSET) -> ProcessBuilder:
    """
    Resample temporal dimensions to match a target data cube

    :param data: A data cube with one or more temporal dimensions.
    :param target: A data cube that describes the temporal target resolution.
    :param dimension: The name of the temporal dimension to resample, which must exist with this name in both
        data cubes. If the dimension is not set or is set to `null`, the process resamples all temporal dimensions
        that exist with the same names in both data cubes.  The following exceptions may occur:  * A dimension is
        given, but it does not exist in any of the data cubes: `DimensionNotAvailable` * A dimension is given, but
        one of them is not temporal: `DimensionMismatch`  * No specific dimension name is given and there are no
        temporal dimensions with the same name in the data: `DimensionMismatch`
    :param valid_within: Setting this parameter to a numerical value enables that the process searches for
        valid values within the given period of days before and after the target timestamps. Valid values are
        determined based on the function ``is_valid()``. For example, the limit of `7` for the target timestamps
        `2020-01-15 12:00:00` looks for a nearest neighbor after `2020-01-08 12:00:00` and before `2020-01-22
        12:00:00`. If no valid value is found within the given period, the value will be set to no-data (`null`).

    :return: A raster data cube with the same dimensions and the same dimension properties (name, type, labels,
        reference system and resolution) for all non-temporal dimensions. For the temporal dimension, the name and
        type remain unchanged, but the dimension labels, resolution and reference system may change.
    """
    return _process('resample_cube_temporal', data=data, target=target, dimension=dimension, valid_within=valid_within)


@openeo_process
def resample_spatial(data, resolution=UNSET, projection=UNSET, method=UNSET, align=UNSET) -> ProcessBuilder:
    """
    Resample and warp the spatial dimensions

    :param data: A raster data cube.
    :param resolution: Resamples the data cube to the target resolution, which can be specified either as
        separate values for x and y or as a single value for both axes. Specified in the units of the target
        projection. Doesn't change the resolution by default (`0`).
    :param projection: Warps the data cube to the target projection, specified as as [EPSG
        code](http://www.epsg-registry.org/), [WKT2 (ISO 19162)
        string](http://docs.opengeospatial.org/is/18-010r7/18-010r7.html), [PROJ definition
        (deprecated)](https://proj.org/usage/quickstart.html). By default (`null`), the projection is not changed.
    :param method: Resampling method to use. The following options are available and are meant to align with
        [`gdalwarp`](https://gdal.org/programs/gdalwarp.html#cmdoption-gdalwarp-r):  * `average`: average (mean)
        resampling, computes the weighted average of all valid pixels * `bilinear`: bilinear resampling * `cubic`:
        cubic resampling * `cubicspline`: cubic spline resampling * `lanczos`: Lanczos windowed sinc resampling *
        `max`: maximum resampling, selects the maximum value from all valid pixels * `med`: median resampling,
        selects the median value of all valid pixels * `min`: minimum resampling, selects the minimum value from
        all valid pixels * `mode`: mode resampling, selects the value which appears most often of all the sampled
        points * `near`: nearest neighbour resampling (default) * `q1`: first quartile resampling, selects the
        first quartile value of all valid pixels * `q3`: third quartile resampling, selects the third quartile
        value of all valid pixels * `rms` root mean square (quadratic mean) of all valid pixels * `sum`: compute
        the weighted sum of all valid pixels  Valid pixels are determined based on the function ``is_valid()``.
    :param align: Specifies to which corner of the spatial extent the new resampled data is aligned to.

    :return: A raster data cube with values warped onto the new projection. It has the same dimensions and the
        same dimension properties (name, type, labels, reference system and resolution) for all non-spatial or
        vertical spatial dimensions. For the horizontal spatial dimensions the name and type remain unchanged, but
        reference system, labels and resolution may change depending on the given parameters.
    """
    return _process('resample_spatial', data=data, resolution=resolution, projection=projection, method=method, align=align)


@openeo_process
def round(x, p=UNSET) -> ProcessBuilder:
    """
    Round to a specified precision

    :param x: A number to round.
    :param p: A positive number specifies the number of digits after the decimal point to round to. A negative
        number means rounding to a power of ten, so for example *-2* rounds to the nearest hundred. Defaults to
        *0*.

    :return: The rounded number.
    """
    return _process('round', x=x, p=p)


@openeo_process
def run_udf(data, udf, runtime, version=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Run a UDF

    :param data: The data to be passed to the UDF.
    :param udf: Either source code, an absolute URL or a path to a UDF script.
    :param runtime: A UDF runtime identifier available at the back-end.
    :param version: An UDF runtime version. If set to `null`, the default runtime version specified for each
        runtime is used.
    :param context: Additional data such as configuration options to be passed to the UDF.

    :return: The data processed by the UDF. The returned value can be of any data type and is exactly what the
        UDF code returns.
    """
    return _process('run_udf', data=data, udf=udf, runtime=runtime, version=version, context=context)


@openeo_process
def run_udf_externally(data, url, context=UNSET) -> ProcessBuilder:
    """
    Run an externally hosted UDF container

    :param data: The data to be passed to the UDF.
    :param url: Absolute URL to a remote UDF service.
    :param context: Additional data such as configuration options to be passed to the UDF.

    :return: The data processed by the UDF. The returned value can in principle be of any data type, but it
        depends on what is returned by the UDF code. Please see the implemented UDF interface for details.
    """
    return _process('run_udf_externally', data=data, url=url, context=context)


@openeo_process
def sar_backscatter(data, coefficient=UNSET, elevation_model=UNSET, mask=UNSET, contributing_area=UNSET, local_incidence_angle=UNSET, ellipsoid_incidence_angle=UNSET, noise_removal=UNSET, options=UNSET) -> ProcessBuilder:
    """
    Computes backscatter from SAR input

    :param data: The source data cube containing SAR input.
    :param coefficient: Select the radiometric correction coefficient. The following options are available:  *
        `beta0`: radar brightness * `sigma0-ellipsoid`: ground area computed with ellipsoid earth model *
        `sigma0-terrain`: ground area computed with terrain earth model * `gamma0-ellipsoid`: ground area computed
        with ellipsoid earth model in sensor line of sight * `gamma0-terrain`: ground area computed with terrain
        earth model in sensor line of sight (default) * `null`: non-normalized backscatter
    :param elevation_model: The digital elevation model to use. Set to `null` (the default) to allow the back-
        end to choose, which will improve portability, but reduce reproducibility.
    :param mask: If set to `true`, a data mask is added to the bands with the name `mask`. It indicates which
        values are valid (1), invalid (0) or contain no-data (null).
    :param contributing_area: If set to `true`, a DEM-based local contributing area band named
        `contributing_area` is added. The values are given in square meters.
    :param local_incidence_angle: If set to `true`, a DEM-based local incidence angle band named
        `local_incidence_angle` is added. The values are given in degrees.
    :param ellipsoid_incidence_angle: If set to `true`, an ellipsoidal incidence angle band named
        `ellipsoid_incidence_angle` is added. The values are given in degrees.
    :param noise_removal: If set to `false`, no noise removal is applied. Defaults to `true`, which removes
        noise.
    :param options: Proprietary options for the backscatter computations. Specifying proprietary options will
        reduce portability.

    :return: Backscatter values corresponding to the chosen parametrization. The values are given in linear
        scale.
    """
    return _process('sar_backscatter', 
        data=data,
        coefficient=coefficient,
        elevation_model=elevation_model,
        mask=mask,
        contributing_area=contributing_area,
        local_incidence_angle=local_incidence_angle,
        ellipsoid_incidence_angle=ellipsoid_incidence_angle,
        noise_removal=noise_removal,
        options=options
    )


@openeo_process
def save_ml_model(data, options=UNSET) -> ProcessBuilder:
    """
    Save a ML model

    :param data: The data to store as a machine learning model.
    :param options: Additional parameters to create the file(s).

    :return: Returns `false` if the process failed to store the model, `true` otherwise.
    """
    return _process('save_ml_model', data=data, options=options)


@openeo_process
def save_result(data, format, options=UNSET) -> ProcessBuilder:
    """
    Save processed data

    :param data: The data to deliver in the given file format.
    :param format: The file format to use. It must be one of the values that the server reports as supported
        output file formats, which usually correspond to the short GDAL/OGR codes. If the format is not suitable
        for storing the underlying data structure, a `FormatUnsuitable` exception will be thrown. This parameter is
        *case insensitive*.
    :param options: The file format parameters to be used to create the file(s). Must correspond to the
        parameters that the server reports as supported parameters for the chosen `format`. The parameter names and
        valid values usually correspond to the GDAL/OGR format options.

    :return: Returns `false` if the process failed to make the data available, `true` otherwise.
    """
    return _process('save_result', data=data, format=format, options=options)


@openeo_process
def sd(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Standard deviation

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sample standard deviation.
    """
    return _process('sd', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def sgn(x) -> ProcessBuilder:
    """
    Signum

    :param x: A number.

    :return: The computed signum value of `x`.
    """
    return _process('sgn', x=x)


@openeo_process
def sin(x) -> ProcessBuilder:
    """
    Sine

    :param x: An angle in radians.

    :return: The computed sine of `x`.
    """
    return _process('sin', x=x)


@openeo_process
def sinh(x) -> ProcessBuilder:
    """
    Hyperbolic sine

    :param x: An angle in radians.

    :return: The computed hyperbolic sine of `x`.
    """
    return _process('sinh', x=x)


@openeo_process
def sort(data, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
    """
    Sort data

    :param data: An array with data to sort.
    :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
        (descending) order, set this parameter to `false`.
    :param nodata: Controls the handling of no-data values (`null`). By default, they are removed. If set to
        `true`, missing values in the data are put last; if set to `false`, they are put first.

    :return: The sorted array.
    """
    return _process('sort', data=data, asc=asc, nodata=nodata)


@openeo_process
def sqrt(x) -> ProcessBuilder:
    """
    Square root

    :param x: A number.

    :return: The computed square root.
    """
    return _process('sqrt', x=x)


@openeo_process
def subtract(x, y) -> ProcessBuilder:
    """
    Subtraction of two numbers

    :param x: The minuend.
    :param y: The subtrahend.

    :return: The computed result.
    """
    return _process('subtract', x=x, y=y)


@openeo_process
def sum(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Compute the sum by adding up numbers

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sum of the sequence of numbers.
    """
    return _process('sum', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def tan(x) -> ProcessBuilder:
    """
    Tangent

    :param x: An angle in radians.

    :return: The computed tangent of `x`.
    """
    return _process('tan', x=x)


@openeo_process
def tanh(x) -> ProcessBuilder:
    """
    Hyperbolic tangent

    :param x: An angle in radians.

    :return: The computed hyperbolic tangent of `x`.
    """
    return _process('tanh', x=x)


@openeo_process
def text_begins(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text begins with another text

    :param data: Text in which to find something at the beginning.
    :param pattern: Text to find at the beginning of `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` begins with `pattern`, false` otherwise.
    """
    return _process('text_begins', data=data, pattern=pattern, case_sensitive=case_sensitive)


@openeo_process
def text_concat(data, separator=UNSET) -> ProcessBuilder:
    """
    Concatenate elements to a single text

    :param data: A set of elements. Numbers, boolean values and null values get converted to their (lower case)
        string representation. For example: `1` (integer), `-1.5` (number), `true` / `false` (boolean values)
    :param separator: A separator to put between each of the individual texts. Defaults to an empty string.

    :return: A string containing a string representation of all the array elements in the same order, with the
        separator between each element.
    """
    return _process('text_concat', data=data, separator=separator)


@openeo_process
def text_contains(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text contains another text

    :param data: Text in which to find something in.
    :param pattern: Text to find in `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` contains the `pattern`, false` otherwise.
    """
    return _process('text_contains', data=data, pattern=pattern, case_sensitive=case_sensitive)


@openeo_process
def text_ends(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text ends with another text

    :param data: Text in which to find something at the end.
    :param pattern: Text to find at the end of `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` ends with `pattern`, false` otherwise.
    """
    return _process('text_ends', data=data, pattern=pattern, case_sensitive=case_sensitive)


@openeo_process
def trim_cube(data) -> ProcessBuilder:
    """
    Remove dimension labels with no-data values

    :param data: A raster data cube to trim.

    :return: A trimmed raster data cube with the same dimensions. The dimension properties name, type,
        reference system and resolution remain unchanged. The number of dimension labels may decrease.
    """
    return _process('trim_cube', data=data)


@openeo_process
def unflatten_dimension(data, dimension, target_dimensions, label_separator=UNSET) -> ProcessBuilder:
    """
    Split a single dimensions into multiple dimensions

    :param data: A data cube that is consistently structured so that operation can execute flawlessly (e.g. the
        dimension labels need to contain the `label_separator` exactly 1 time for two target dimensions, 2 times
        for three target dimensions etc.).
    :param dimension: The name of the dimension to split.
    :param target_dimensions: The names of the new target dimensions. New dimensions will be created with the
        given names and type `other` (see ``add_dimension()``). Fails with a `TargetDimensionExists` exception if
        any of the dimensions exists.  The order of the array defines the order in which the dimensions and
        dimension labels are added to the data cube (see the example in the process description).
    :param label_separator: The string that will be used as a separator to split the dimension labels.

    :return: A data cube with the new shape. The dimension properties (name, type, labels, reference system and
        resolution) for all other dimensions remain unchanged.
    """
    return _process('unflatten_dimension', data=data, dimension=dimension, target_dimensions=target_dimensions, label_separator=label_separator)


@openeo_process
def variance(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Variance

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sample variance.
    """
    return _process('variance', data=data, ignore_nodata=ignore_nodata)


@openeo_process
def vector_buffer(geometries, distance) -> ProcessBuilder:
    """
    Buffer geometries by distance

    :param geometries: Geometries to apply the buffer on. Vector properties are preserved for vector data cubes
        and all GeoJSON Features.  To maximize interoperability, a nested `GeometryCollection` should be avoided.
        Furthermore, a `GeometryCollection` composed of a single type of geometries should be avoided in favour of
        the corresponding multi-part type (e.g. `MultiPolygon`).
    :param distance: The distance of the buffer in the unit of the spatial reference system. A positive
        distance expands the geometries and results in outward buffering (dilation) while a negative distance
        shrinks the geometries and results in inward buffering (erosion).

    :return: Returns a vector data cube with the computed new geometries.
    """
    return _process('vector_buffer', geometries=geometries, distance=distance)


@openeo_process
def vector_to_random_points(data, geometry_count=UNSET, total_count=UNSET, group=UNSET, seed=UNSET) -> ProcessBuilder:
    """
    Sample random points from geometries

    :param data: Input geometries for sample extraction.  To maximize interoperability, a nested
        `GeometryCollection` should be avoided. Furthermore, a `GeometryCollection` composed of a single type of
        geometries should be avoided in favour of the corresponding multi-part type (e.g. `MultiPolygon`).
    :param geometry_count: The maximum number of points to compute per geometry.  Points in the input
        geometries can be selected only once by the sampling.
    :param total_count: The maximum number of points to compute overall.  Throws a `CountMismatch` exception if
        the specified value is less than the provided number of geometries.
    :param group: Specifies whether the sampled points should be grouped by input geometry (default) or be
        generated as independent points.  * If the sampled points are grouped, the process generates a `MultiPoint`
        per geometry given which keeps the original identifier if present. * Otherwise, each sampled point is
        generated as a distinct `Point` geometry without identifier.
    :param seed: A randomization seed to use for random sampling. If not given or `null`, no seed is used and
        results may differ on subsequent use.

    :return: Returns a vector data cube with the sampled points.
    """
    return _process('vector_to_random_points', data=data, geometry_count=geometry_count, total_count=total_count, group=group, seed=seed)


@openeo_process
def vector_to_regular_points(data, distance, group=UNSET) -> ProcessBuilder:
    """
    Sample regular points from geometries

    :param data: Input geometries for sample extraction.  To maximize interoperability, a nested
        `GeometryCollection` should be avoided. Furthermore, a `GeometryCollection` composed of a single type of
        geometries should be avoided in favour of the corresponding multi-part type (e.g. `MultiPolygon`).
    :param distance: Defines the minimum distance in the unit of the reference system that is required between
        two samples generated *inside* a single geometry.  - For **polygons**, the distance defines the cell sizes
        of a regular grid that starts at the upper-left bound of each polygon. The centroid of each cell is then a
        sample point. If the centroid is not enclosed in the polygon, no point is sampled. If no point can be
        sampled for the geometry at all, the first coordinate of the geometry is returned as point. - For **lines**
        (line strings), the sampling starts with a point at the first coordinate of the line and then walks along
        the line and samples a new point each time the distance to the previous point has been reached again. - For
        **points**, the point is returned as given.
    :param group: Specifies whether the sampled points should be grouped by input geometry (default) or be
        generated as independent points.  * If the sampled points are grouped, the process generates a `MultiPoint`
        per geometry given which keeps the original identifier if present. * Otherwise, each sampled point is
        generated as a distinct `Point` geometry without identifier.

    :return: Returns a vector data cube with the sampled points.
    """
    return _process('vector_to_regular_points', data=data, distance=distance, group=group)


@openeo_process
def xor(x, y) -> ProcessBuilder:
    """
    Logical XOR (exclusive or)

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical XOR.
    """
    return _process('xor', x=x, y=y)
