import json
from typing import List

import pkg_resources

NEXTLAND_SERVICES_RESOURCE_ROOT = "nextland_services.resources"


def get_resource_filename(name: str) -> str:
    """
    Get filename to given resource

    :param name: path relative to `nextland_services/resources` folder
    """
    return pkg_resources.resource_filename(NEXTLAND_SERVICES_RESOURCE_ROOT, name)


def list_resources(name: str) -> List[str]:
    return pkg_resources.resource_listdir(NEXTLAND_SERVICES_RESOURCE_ROOT, name)


def get_process_graph(name: str) -> dict:
    """
    Get process graph

    :param name: path or filename relative to `nextland_services/resources/process_graphs` folder
    """
    stream = pkg_resources.resource_stream(NEXTLAND_SERVICES_RESOURCE_ROOT, "process_graphs/" + name)
    return json.load(stream)


def list_process_graphs() -> List[str]:
    """List filenames of process graphs"""
    return list_resources("process_graphs")
