/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tub!\u0002\u0015*\u0001=*\u0004\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00115\u0004!\u0011!Q\u0001\n9DQ!\u001d\u0001\u0005\u0002IDq! \u0001C\u0002\u0013Ec\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B@\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\b\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0011\u0005m\u0002\u0001\"\u0001*\u0003{Aq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011q\u0012\u0001\u0005B\u00055\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u0003S\u0003A\u0011IAV\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a1\u0001\t\u0003\n)\rC\u0004\u0002L\u0002!\t%!4\t\u000f\u0005]\u0007\u0001\"\u0015\u0002Z\"9\u0011Q\u001e\u0001\u0005R\u0005=hABA|\u0001\u0011\tI\u0010\u0003\u0004rC\u0011\u0005\u00111 \u0005\b\u0003\u007f\fC\u0011\u0002B\u0001\u0011\u001d\u0011y!\tC!\u0005#AqAa\t\"\t\u0003\u0012)\u0003\u0003\b\u00032\u0001\u0001\n1!A\u0001\n\u0013\tIIa\r\t\u001d\te\u0002\u0001%A\u0002\u0002\u0003%I!!$\u0003<\t\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011!fK\u0001\u0004Wb\u001a(B\u0001\u0017.\u0003\u001d\u0019G.^:uKJT!AL\u0018\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0014\u0005\u00011\u0004CA\u001c9\u001b\u0005Y\u0013BA\u001d,\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$7\u0001\u0001\t\u0003yuj\u0011!L\u0005\u0003}5\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003\t\u00198\r\u0005\u0002B\u00056\tq&\u0003\u0002D_\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000baa\u00197jK:$(B\u0001&L\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u00196\u000bqAZ1ce&\u001c\u0007HC\u0001O\u0003\tIw.\u0003\u0002Q\u000f\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0010Kb,7-\u001e;peN+'O^5dKB\u00111KW\u0007\u0002)*\u0011QKV\u0001\u000bG>t7-\u001e:sK:$(BA,Y\u0003\u0011)H/\u001b7\u000b\u0003e\u000bAA[1wC&\u00111\f\u0016\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003=~k\u0011!K\u0005\u0003A&\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fA\u0002]8e\u00032dwnY1u_J\u0004\"AX2\n\u0005\u0011L#!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0016Y&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\tqv-\u0003\u0002iS\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC<bi\u000eDWI^3oiN\u0004\"AX6\n\u00051L#aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006Q\u0001o\u001c7m\u000bZ,g\u000e^:\u0011\u0005y{\u0017B\u00019*\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0003\u0019a\u0014N\\5u}QQ1\u000f^;wobL(p\u001f?\u0011\u0005y\u0003\u0001\"\u0002\u0018\u000b\u0001\u0004Y\u0004\"B \u000b\u0001\u0004\u0001\u0005\"\u0002#\u000b\u0001\u0004)\u0005\"B)\u000b\u0001\u0004\u0011\u0006\"\u0002/\u000b\u0001\u0004i\u0006\"B1\u000b\u0001\u0004\u0011\u0007\"B3\u000b\u0001\u00041\u0007\"B5\u000b\u0001\u0004Q\u0007\"B7\u000b\u0001\u0004q\u0017AE7j]J+w-[:uKJ,GMU1uS>,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0011\u0011QA\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0004E_V\u0014G.Z\u0001\u0014[&t'+Z4jgR,'/\u001a3SCRLw\u000eI\u0001\u0011S:LG/[1m\u000bb,7-\u001e;peN,\"!!\u0005\u0011\t\u0005\u0005\u00111C\u0005\u0005\u0003+\t\u0019AA\u0002J]R\f\u0011#\u001b8ji&\fG.\u0012=fGV$xN]:!\u0003e\u0019\bn\\;mI\u0012+G.\u001a;f\tJLg/\u001a:TKJ4\u0018nY3\u0016\u0005\u0005u\u0001\u0003BA\u0001\u0003?IA!!\t\u0002\u0004\t9!i\\8mK\u0006t\u0017AG:i_VdG\rR3mKR,GI]5wKJ\u001cVM\u001d<jG\u0016\u0004\u0013!F:i_VdG\rR3mKR,W\t_3dkR|'o]\u0001\u0017g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:tA\u0005qA-\u001a4bk2$\bK]8gS2,WCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001a_\u0005A!/Z:pkJ\u001cW-\u0003\u0003\u00028\u0005E\"a\u0004*fg>,(oY3Qe>4\u0017\u000e\\3\u0002\u001f\u0011,g-Y;miB\u0013xNZ5mK\u0002\n\u0001\u0003Z8SK6|g/Z#yK\u000e,Ho\u001c:\u0015\r\u0005}\u0012QIA0!\u0011\t\t!!\u0011\n\t\u0005\r\u00131\u0001\u0002\u0005+:LG\u000fC\u0004\u0002HU\u0001\r!!\u0013\u0002\u0015\u0015DXmY;u_JLE\r\u0005\u0003\u0002L\u0005ec\u0002BA'\u0003+\u0002B!a\u0014\u0002\u00045\u0011\u0011\u0011\u000b\u0006\u0004\u0003'R\u0014A\u0002\u001fs_>$h(\u0003\u0003\u0002X\u0005\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twM\u0003\u0003\u0002X\u0005\r\u0001bBA1+\u0001\u0007\u00111M\u0001\u0007e\u0016\f7o\u001c8\u0011\u0007q\n)'C\u0002\u0002h5\u0012!#\u0012=fGV$xN\u001d'pgN\u0014V-Y:p]\u000612/\u001a;Va\u0016CXmY;u_J\u001cuN\u001c4jO6\u000b\u0007\u000f\u0006\u0003\u0002@\u00055\u0004bBA8-\u0001\u0007\u0011\u0011O\u0001\nIJLg/\u001a:Q_\u0012\u0004b!!\u0001\u0002t\u0005]\u0014\u0002BA;\u0003\u0007\u0011aa\u00149uS>t\u0007\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003\u0003K\u0015aA1qS&!\u0011QQA>\u0005\r\u0001v\u000eZ\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0015\u0005\u0005%\u0013!B:uCJ$HCAA \u0003\u0011\u0019Ho\u001c9\u0002/\u0011|'+Z9vKN$Hk\u001c;bY\u0016CXmY;u_J\u001cH\u0003BAK\u0003?\u0003b!a&\u0002\u001c\u0006uQBAAM\u0015\r)\u00161A\u0005\u0005\u0003;\u000bIJ\u0001\u0004GkR,(/\u001a\u0005\b\u0003CS\u0002\u0019AAR\u0003m\u0011Xm]8ve\u000e,\u0007K]8gS2,Gk\u001c+pi\u0006dW\t_3dgBA\u00111JAS\u0003[\t\t\"\u0003\u0003\u0002(\u0006u#aA'ba\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0002\u001e\u0005qq-\u001a;Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cHCAAY!\u0019\t\u0019,!0\u0002J9!\u0011QWA]\u001d\u0011\ty%a.\n\u0005\u0005\u0015\u0011\u0002BA^\u0003\u0007\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0006\u0005'aA*fc*!\u00111XA\u0002\u0003=!wnS5mY\u0016CXmY;u_J\u001cH\u0003BAK\u0003\u000fDq!!3\u001e\u0001\u0004\t\t,A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\u0018\u0001F2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0002\u0002PB!\u0011\u0011[Aj\u001b\u0005\u0001\u0011bAAkq\tqAI]5wKJ,e\u000e\u001a9pS:$\u0018AE2sK\u0006$X\rV8lK:l\u0015M\\1hKJ$\"!a7\u0011\r\u0005\u0005\u00111OAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0001b]3dkJLG/\u001f\u0006\u0004\u0003O|\u0013A\u00023fa2|\u00170\u0003\u0003\u0002l\u0006\u0005(\u0001\b%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u0013SN,\u00050Z2vi>\u0014X\t_2mk\u0012,G\r\u0006\u0004\u0002\u001e\u0005E\u00181\u001f\u0005\b\u0003\u000f\u0002\u0003\u0019AA%\u0011\u001d\t)\u0010\ta\u0001\u0003\u0013\n\u0001\u0002[8ti:\fW.\u001a\u0002\u0019\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ,e\u000e\u001a9pS:$8cA\u0011\u0002PR\u0011\u0011Q \t\u0004\u0003#\f\u0013AJ5h]>\u0014XMU3hSN$XM]#yK\u000e,Ho\u001c:BiN#x\u000e\u001d9fI\u000e{g\u000e^3yiV\u0011!1\u0001\t\t\u0003\u0003\u0011)A!\u0003\u0002@%!!qAA\u0002\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0003BA\u0001\u0005\u0017IAA!\u0004\u0002\u0004\t\u0019\u0011I\\=\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$BAa\u0001\u0003\u0014!9!Q\u0003\u0013A\u0002\t]\u0011aB2p]R,\u0007\u0010\u001e\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!QD\u0018\u0002\u0007I\u00048-\u0003\u0003\u0003\"\tm!A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\u0011\tyDa\n\t\u000f\t%R\u00051\u0001\u0003,\u0005Q!\u000f]2BI\u0012\u0014Xm]:\u0011\t\te!QF\u0005\u0005\u0005_\u0011YB\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!a\"\u00036%\u0019!qG\u0017\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017AC:va\u0016\u0014He\u001d;pa&\u0019\u0011q\u0012\u001d")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final ExecutorPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteDriverService;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteDriverService() {
        return this.shouldDeleteDriverService;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull(Predef$.MODULE$.$conforms()), (Seq<HasMetadata>)((Seq)new .colon.colon((Object)configMap, (List)Nil$.MODULE$)));
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().create((Object)configMap);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$applicationId());
    }

    public void start() {
        block0: {
            super.start();
            Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
            this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
            this.lifecycleEventHandler.start(this);
            this.podAllocator.start(this.applicationId(), this);
            this.watchEvents.start(this.applicationId());
            this.pollEvents.start(this.applicationId());
            if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) break block0;
            this.setUpExecutorConfigMap(this.podAllocator.driverPod());
        }
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteDriverService()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.services().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.persistentVolumeClaims().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        if (this.shouldDeleteExecutors()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            }
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, ExecutorPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteDriverService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_DELETE_ON_TERMINATION()));
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
    }

    private class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped() ? BoxedUnit.UNIT : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

