/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Divide$;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.RLike;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Remainder$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.UpdateFields$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\u0011%qAB0a\u0011\u0003\u0001\u0007N\u0002\u0004kA\"\u0005\u0001m\u001b\u0005\u0006e\u0006!\t\u0001\u001e\u0005\u0006k\u0006!\tA\u001e\u0005\u0007k\u0006!\taa9\t\u000f\r\u001d\u0018\u0001\"\u0001\u0004j\"A11_\u0001\u0005\u0002\u0001\u001c)\u0010\u0003\u0005\u0004|\u0006!\t\u0001YB\u007f\r\u0011Q\u0007\r\u0001=\t\u0013}D!Q1A\u0005\u0002\u0005\u0005\u0001BCA\n\u0011\t\u0005\t\u0015!\u0003\u0002\u0004!1!\u000f\u0003C\u0001\u0003+AaA\u001d\u0005\u0005\u0002\u0005e\u0001bBA\u001b\u0011\u0011\u0005\u0013q\u0007\u0005\b\u0003sAA\u0011IA\u001e\u0011\u001d\ti\u0005\u0003C!\u0003\u001fBq!a\u0016\t\t\u0013\tI\u0006C\u0004\u0002\\!!I!!\u0018\t\u0011\u0005\r\u0004\u0002\"\u0001a\u0003KBq!!\u001c\t\t\u0003\ty\u0007\u0003\u0004v\u0011\u0011\u0005\u00111\u0013\u0005\b\u00033CA\u0011AAN\u0011\u001d\ti\n\u0003C\u0001\u00037Cq!a(\t\t\u0003\t\t\u000bC\u0004\u0002(\"!\t!!+\t\u000f\u00055\u0006\u0002\"\u0001\u00020\"9\u00111\u0017\u0005\u0005\u0002\u0005U\u0006bBAe\u0011\u0011\u0005\u00111\u001a\u0005\b\u0003\u001fDA\u0011AAi\u0011\u001d\t)\u000e\u0003C\u0001\u0003/Dq!a7\t\t\u0003\ti\u000eC\u0004\u0002b\"!\t!a9\t\u000f\u0005\u001d\b\u0002\"\u0001\u0002j\"9\u0011Q\u001e\u0005\u0005\u0002\u0005=\bbBAz\u0011\u0011\u0005\u0011Q\u001f\u0005\b\u0003sDA\u0011AA~\u0011\u001d\ty\u0010\u0003C\u0001\u0005\u0003AqA!\u0002\t\t\u0003\u00119\u0001C\u0004\u0003\f!!\tA!\u0004\t\u000f\t]\u0001\u0002\"\u0001\u0003\u001a!9!Q\u0004\u0005\u0005\u0002\t}\u0001b\u0002B\u0015\u0011\u0011\u0005\u00111\u0014\u0005\b\u0005WAA\u0011AAN\u0011\u001d\u0011i\u0003\u0003C\u0001\u00037CqAa\f\t\t\u0003\u0011\t\u0004C\u0004\u00036!!\tAa\u000e\t\u000f\tm\u0002\u0002\"\u0001\u0003>!9!\u0011\t\u0005\u0005\u0002\t\r\u0003b\u0002B$\u0011\u0011\u0005!\u0011\n\u0005\b\u0005\u001bBA\u0011\u0001B(\u0011\u001d\u0011\u0019\u0006\u0003C\u0001\u0005+BqA!\u0017\t\t\u0003\u0011Y\u0006C\u0004\u0003`!!\tA!\u0019\t\u000f\t\u0015\u0004\u0002\"\u0001\u0003h!9!1\u000e\u0005\u0005\u0002\t5\u0004b\u0002B9\u0011\u0011\u0005!1\u000f\u0005\b\u0005oBA\u0011\u0001B=\u0011\u001d\u0011i\b\u0003C\u0001\u0005\u007fBqAa!\t\t\u0003\u0011)\tC\u0004\u0003 \"!\tA!)\t\u000f\t}\u0005\u0002\"\u0001\u0003<\"9!Q\u001b\u0005\u0005\u0002\t]\u0007b\u0002Bo\u0011\u0011\u0005!q\u001c\u0005\b\u0005GDA\u0011\u0001Bs\u0011\u001d\u0011Y\u000f\u0003C\u0001\u0005[DqAa>\t\t\u0003\u0011I\u0010C\u0004\u0004\u0002!!\taa\u0001\t\u000f\r\u001d\u0001\u0002\"\u0001\u0004\n!91q\u0001\u0005\u0005\u0002\rM\u0001bBB\r\u0011\u0011\u000511\u0004\u0005\b\u0007?AA\u0011AB\u0011\u0011\u001d\u0019y\u0002\u0003C\u0001\u0007KAqa!\u000b\t\t\u0003\u0019Y\u0003C\u0004\u0004*!!\taa\f\t\u000f\rM\u0002\u0002\"\u0001\u00046!9\u0011Q\u000e\u0005\u0005\u0002\re\u0002bBA7\u0011\u0011\u00051Q\b\u0005\b\u0003[BA\u0011AB+\u0011\u001d\ti\u0007\u0003C\u0001\u0007?Bq!!\u001c\t\t\u0003\u0019I\u0007C\u0004\u0002\u001e!!\ta! \t\u000f\r\u0005\u0005\u0002\"\u0001\u0004\u0004\"91\u0011\u0011\u0005\u0005\u0002\r=\u0005bBBJ\u0011\u0011\u0005\u00111\u0014\u0005\b\u0007+CA\u0011AAN\u0011\u001d\u00199\n\u0003C\u0001\u00037Cqa!'\t\t\u0003\tY\nC\u0004\u0004\u001c\"!\t!a'\t\u000f\ru\u0005\u0002\"\u0001\u0002\u001c\"91q\u0014\u0005\u0005\u0002\r\u0005\u0006bBBW\u0011\u0011\u00051q\u0016\u0005\b\u0007gCA\u0011AB[\u0011\u001d\u0019I\f\u0003C\u0001\u0007wCqaa0\t\t\u0003\u0019\t\rC\u0004\u0004@\"!\ta!5\u0002\r\r{G.^7o\u0015\t\t'-A\u0002tc2T!a\u00193\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00154\u0017AB1qC\u000eDWMC\u0001h\u0003\ry'o\u001a\t\u0003S\u0006i\u0011\u0001\u0019\u0002\u0007\u0007>dW/\u001c8\u0014\u0005\u0005a\u0007CA7q\u001b\u0005q'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005Et'AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005A\u0017!B1qa2LHcA<\u0004`B\u0011\u0011\u000eC\n\u0004\u00111L\bC\u0001>~\u001b\u0005Y(B\u0001?c\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001@|\u0005\u001daunZ4j]\u001e\fA!\u001a=qeV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u00055\u0001-\u0001\u0005dCR\fG._:u\u0013\u0011\t\t\"a\u0002\u0003\u0015\u0015C\bO]3tg&|g.A\u0003fqB\u0014\b\u0005F\u0002x\u0003/Aaa`\u0006A\u0002\u0005\rAcA<\u0002\u001c!9\u0011Q\u0004\u0007A\u0002\u0005}\u0011\u0001\u00028b[\u0016\u0004B!!\t\u000209!\u00111EA\u0016!\r\t)C\\\u0007\u0003\u0003OQ1!!\u000bt\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00068\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\tiC\\\u0001\ti>\u001cFO]5oOR\u0011\u0011qD\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u00121\t\t\u0004[\u0006}\u0012bAA!]\n9!i\\8mK\u0006t\u0007bBA#\u001d\u0001\u0007\u0011qI\u0001\u0005i\"\fG\u000fE\u0002n\u0003\u0013J1!a\u0013o\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u000b\t\u0004[\u0006M\u0013bAA+]\n\u0019\u0011J\u001c;\u0002\u001d9|'/\\1mSj,G-\u0012=qeR\u0011\u00111A\u0001\to&$\b.\u0012=qeR\u0019q/a\u0018\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002\u0004\u00059a.Z<FqB\u0014\u0018!\u00028b[\u0016$WCAA4!\u0011\t)!!\u001b\n\t\u0005-\u0014q\u0001\u0002\u0010\u001d\u0006lW\rZ#yaJ,7o]5p]\u0006\u0011\u0011m]\u000b\u0005\u0003c\ni\b\u0006\u0003\u0002t\u0005%\u0005cB5\u0002v\u0005\u001d\u0013\u0011P\u0005\u0004\u0003o\u0002'a\u0003+za\u0016$7i\u001c7v[:\u0004B!a\u001f\u0002~1\u0001AaBA@'\t\u0007\u0011\u0011\u0011\u0002\u0002+F!\u00111QA$!\ri\u0017QQ\u0005\u0004\u0003\u000fs'a\u0002(pi\"Lgn\u001a\u0005\n\u0003\u0017\u001b\u0012\u0011!a\u0002\u0003\u001b\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015I\u0017qRA=\u0013\r\t\t\n\u0019\u0002\b\u000b:\u001cw\u000eZ3s)\r9\u0018Q\u0013\u0005\b\u0003/#\u0002\u0019AA$\u0003))\u0007\u0010\u001e:bGRLwN\\\u0001\rk:\f'/_0%[&tWo]\u000b\u0002o\u0006YQO\\1ss~##-\u00198h\u0003%!S-\u001d\u0013fc\u0012*\u0017\u000fF\u0002x\u0003GCq!!*\u0018\u0001\u0004\t9%A\u0003pi\",'/A\u0004fcV\fG\u000eV8\u0015\u0007]\fY\u000bC\u0004\u0002&b\u0001\r!a\u0012\u0002\u0017\u0011*\u0017\u000f\n2b]\u001e$S-\u001d\u000b\u0004o\u0006E\u0006bBAS3\u0001\u0007\u0011qI\u0001\fI\t\fgn\u001a\u0013fc\u0012*\u0017\u000fF\u0002x\u0003oCq!!*\u001b\u0001\u0004\t9\u0005K\u0004\u001b\u0003w\u000b\t-!2\u0011\u00075\fi,C\u0002\u0002@:\u0014!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\t\u0019-A\u001f\"{u\u0002Cm\\3tA9|G\u000f\t5bm\u0016\u0004C\u000f[3!g\u0006lW\r\t9sK\u000e,G-\u001a8dK\u0002\n7\u000fI\u001f>{1\u0002So]3!{\u0005j\u0004%\u001b8ti\u0016\fG-\t\u0002\u0002H\u0006)!G\f\u0019/a\u0005Aan\u001c;FcV\fG\u000eF\u0002x\u0003\u001bDq!!*\u001c\u0001\u0004\t9%\u0001\u0005%OJ,\u0017\r^3s)\r9\u00181\u001b\u0005\b\u0003Kc\u0002\u0019AA$\u0003\t9G\u000fF\u0002x\u00033Dq!!*\u001e\u0001\u0004\t9%A\u0003%Y\u0016\u001c8\u000fF\u0002x\u0003?Dq!!*\u001f\u0001\u0004\t9%\u0001\u0002miR\u0019q/!:\t\u000f\u0005\u0015v\u00041\u0001\u0002H\u0005AA\u0005\\3tg\u0012*\u0017\u000fF\u0002x\u0003WDq!!*!\u0001\u0004\t9%A\u0002mKF$2a^Ay\u0011\u001d\t)+\ta\u0001\u0003\u000f\n1\u0002J4sK\u0006$XM\u001d\u0013fcR\u0019q/a>\t\u000f\u0005\u0015&\u00051\u0001\u0002H\u0005\u0019q-Z9\u0015\u0007]\fi\u0010C\u0004\u0002&\u000e\u0002\r!a\u0012\u0002!\u0011bWm]:%KF$sM]3bi\u0016\u0014HcA<\u0003\u0004!9\u0011Q\u0015\u0013A\u0002\u0005\u001d\u0013AC3r\u001dVdGnU1gKR\u0019qO!\u0003\t\u000f\u0005\u0015V\u00051\u0001\u0002H\u0005!q\u000f[3o)\u00159(q\u0002B\n\u0011\u0019\u0011\tB\na\u0001o\u0006I1m\u001c8eSRLwN\u001c\u0005\b\u0005+1\u0003\u0019AA$\u0003\u00151\u0018\r\\;f\u0003%yG\u000f[3so&\u001cX\rF\u0002x\u00057AqA!\u0006(\u0001\u0004\t9%A\u0004cKR<X-\u001a8\u0015\u000b]\u0014\tC!\n\t\u000f\t\r\u0002\u00061\u0001\u0002H\u0005QAn\\<fe\n{WO\u001c3\t\u000f\t\u001d\u0002\u00061\u0001\u0002H\u0005QQ\u000f\u001d9fe\n{WO\u001c3\u0002\u000b%\u001ch*\u0019(\u0002\r%\u001ch*\u001e7m\u0003%I7OT8u\u001dVdG.\u0001\u0005%E\u0006\u0014HEY1s)\r9(1\u0007\u0005\b\u0003Kc\u0003\u0019AA$\u0003\ty'\u000fF\u0002x\u0005sAa!!*.\u0001\u00049\u0018\u0001\u0003\u0013b[B$\u0013-\u001c9\u0015\u0007]\u0014y\u0004C\u0004\u0002&:\u0002\r!a\u0012\u0002\u0007\u0005tG\rF\u0002x\u0005\u000bBa!!*0\u0001\u00049\u0018!\u0002\u0013qYV\u001cHcA<\u0003L!9\u0011Q\u0015\u0019A\u0002\u0005\u001d\u0013\u0001\u00029mkN$2a\u001eB)\u0011\u001d\t)+\ra\u0001\u0003\u000f\na\u0001J7j]V\u001cHcA<\u0003X!9\u0011Q\u0015\u001aA\u0002\u0005\u001d\u0013!B7j]V\u001cHcA<\u0003^!9\u0011QU\u001aA\u0002\u0005\u001d\u0013A\u0002\u0013uS6,7\u000fF\u0002x\u0005GBq!!*5\u0001\u0004\t9%\u0001\u0005nk2$\u0018\u000e\u001d7z)\r9(\u0011\u000e\u0005\b\u0003K+\u0004\u0019AA$\u0003\u0011!C-\u001b<\u0015\u0007]\u0014y\u0007C\u0004\u0002&Z\u0002\r!a\u0012\u0002\r\u0011Lg/\u001b3f)\r9(Q\u000f\u0005\b\u0003K;\u0004\u0019AA$\u0003!!\u0003/\u001a:dK:$HcA<\u0003|!9\u0011Q\u0015\u001dA\u0002\u0005\u001d\u0013aA7pIR\u0019qO!!\t\u000f\u0005\u0015\u0016\b1\u0001\u0002H\u0005!\u0011n]5o)\r9(q\u0011\u0005\b\u0005\u0013S\u0004\u0019\u0001BF\u0003\u0011a\u0017n\u001d;\u0011\u000b5\u0014i)a\u0012\n\u0007\t=eN\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3A\u000fBJ!\u0011\u0011)Ja'\u000e\u0005\t]%b\u0001BM]\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu%q\u0013\u0002\bm\u0006\u0014\u0018M]4t\u00039I7/\u00138D_2dWm\u0019;j_:$2a\u001eBR\u0011\u001d\u0011)k\u000fa\u0001\u0005O\u000baA^1mk\u0016\u001c\b\u0007\u0002BU\u0005o\u0003bAa+\u00032\nUVB\u0001BW\u0015\r\u0011yK\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BZ\u0005[\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003w\u00129\f\u0002\u0007\u0003:\n\r\u0016\u0011!A\u0001\u0006\u0003\t\tIA\u0002`II\"2a\u001eB_\u0011\u001d\u0011)\u000b\u0010a\u0001\u0005\u007f\u0003DA!1\u0003RB1!1\u0019Bg\u0005\u001fl!A!2\u000b\t\t\u001d'\u0011Z\u0001\u0005Y\u0006twM\u0003\u0002\u0003L\u0006!!.\u0019<b\u0013\u0011\u0011\u0019L!2\u0011\t\u0005m$\u0011\u001b\u0003\r\u0005'\u0014i,!A\u0001\u0002\u000b\u0005\u0011\u0011\u0011\u0002\u0004?\u0012\u001a\u0014\u0001\u00027jW\u0016$2a\u001eBm\u0011\u001d\u0011Y.\u0010a\u0001\u0003?\tq\u0001\\5uKJ\fG.A\u0003sY&\\W\rF\u0002x\u0005CDqAa7?\u0001\u0004\ty\"A\u0004hKRLE/Z7\u0015\u0007]\u00149\u000fC\u0004\u0003j~\u0002\r!a\u0012\u0002\u0007-,\u00170A\u0005xSRDg)[3mIR)qOa<\u0003t\"9!\u0011\u001f!A\u0002\u0005}\u0011!\u00034jK2$g*Y7f\u0011\u0019\u0011)\u0010\u0011a\u0001o\u0006\u00191m\u001c7\u0002\u0015\u0011\u0014x\u000e\u001d$jK2$7\u000fF\u0002x\u0005wDqA!@B\u0001\u0004\u0011y0\u0001\u0006gS\u0016dGMT1nKN\u0004R!\u001cBG\u0003?\t\u0001bZ3u\r&,G\u000e\u001a\u000b\u0004o\u000e\u0015\u0001b\u0002By\u0005\u0002\u0007\u0011qD\u0001\u0007gV\u00147\u000f\u001e:\u0015\u000b]\u001cYaa\u0004\t\r\r51\t1\u0001x\u0003!\u0019H/\u0019:u!>\u001c\bBBB\t\u0007\u0002\u0007q/A\u0002mK:$Ra^B\u000b\u0007/Aqa!\u0004E\u0001\u0004\t\t\u0006C\u0004\u0004\u0012\u0011\u0003\r!!\u0015\u0002\u0011\r|g\u000e^1j]N$2a^B\u000f\u0011\u001d\t)+\u0012a\u0001\u0003\u000f\n!b\u001d;beR\u001cx+\u001b;i)\r981\u0005\u0005\u0007\u0003K3\u0005\u0019A<\u0015\u0007]\u001c9\u0003C\u0004\u0003\\\u001e\u0003\r!a\b\u0002\u0011\u0015tGm],ji\"$2a^B\u0017\u0011\u0019\t)\u000b\u0013a\u0001oR\u0019qo!\r\t\u000f\tm\u0017\n1\u0001\u0002 \u0005)\u0011\r\\5bgR\u0019qoa\u000e\t\u000f\rM\"\n1\u0001\u0002 Q\u0019qoa\u000f\t\u000f\rM2\n1\u0001\u0002 Q\u0019qoa\u0010\t\u000f\r\u0005C\n1\u0001\u0004D\u00059\u0011\r\\5bg\u0016\u001c\bCBB#\u0007\u001f\nyB\u0004\u0003\u0004H\r-c\u0002BA\u0013\u0007\u0013J\u0011a\\\u0005\u0004\u0007\u001br\u0017a\u00029bG.\fw-Z\u0005\u0005\u0007#\u001a\u0019FA\u0002TKFT1a!\u0014o)\r98q\u000b\u0005\b\u0007\u0003j\u0005\u0019AB-!\u0015i71LA\u0010\u0013\r\u0019iF\u001c\u0002\u0006\u0003J\u0014\u0018-\u001f\u000b\u0004o\u000e\u0005\u0004bBB\u001a\u001d\u0002\u000711\r\t\u0004[\u000e\u0015\u0014bAB4]\n11+_7c_2$Ra^B6\u0007[Bqaa\rP\u0001\u0004\ty\u0002C\u0004\u0004p=\u0003\ra!\u001d\u0002\u00115,G/\u00193bi\u0006\u0004Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0004\u0007o\u0002\u0017!\u0002;za\u0016\u001c\u0018\u0002BB>\u0007k\u0012\u0001\"T3uC\u0012\fG/\u0019\u000b\u0004o\u000e}\u0004bBB\u001a!\u0002\u0007\u0011qD\u0001\u0005G\u0006\u001cH\u000fF\u0002x\u0007\u000bCqaa\"R\u0001\u0004\u0019I)\u0001\u0002u_B!11OBF\u0013\u0011\u0019ii!\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016$2a^BI\u0011\u001d\u00199I\u0015a\u0001\u0003?\tA\u0001Z3tG\u0006\u0001B-Z:d?:,H\u000e\\:`M&\u00148\u000f^\u0001\u0010I\u0016\u001c8m\u00188vY2\u001cx\f\\1ti\u0006\u0019\u0011m]2\u0002\u001f\u0005\u001c8m\u00188vY2\u001cxLZ5sgR\fa\"Y:d?:,H\u000e\\:`Y\u0006\u001cH/A\u0004fqBd\u0017-\u001b8\u0015\t\r\r6\u0011\u0016\t\u0004[\u000e\u0015\u0016bABT]\n!QK\\5u\u0011\u001d\u0019Y+\u0017a\u0001\u0003{\t\u0001\"\u001a=uK:$W\rZ\u0001\nE&$x/[:f\u001fJ#2a^BY\u0011\u001d\t)K\u0017a\u0001\u0003\u000f\n!BY5uo&\u001cX-\u0011(E)\r98q\u0017\u0005\b\u0003K[\u0006\u0019AA$\u0003)\u0011\u0017\u000e^<jg\u0016DvJ\u0015\u000b\u0004o\u000eu\u0006bBAS9\u0002\u0007\u0011qI\u0001\u0005_Z,'\u000fF\u0002x\u0007\u0007Dqa!2^\u0001\u0004\u00199-\u0001\u0004xS:$wn\u001e\t\u0005\u0007\u0013\u001ci-\u0004\u0002\u0004L*\u0019\u0011\u0011\u00021\n\t\r=71\u001a\u0002\u000b/&tGm\\<Ta\u0016\u001cG#A<)\u0007!\u0019)\u000e\u0005\u0003\u0004X\u000emWBABm\u0015\r\u0011IJY\u0005\u0005\u0007;\u001cIN\u0001\u0004Ti\u0006\u0014G.\u001a\u0005\b\u0007C\u001c\u0001\u0019AA\u0010\u0003\u001d\u0019w\u000e\u001c(b[\u0016$2a^Bs\u0011\u0019yH\u00011\u0001\u0002\u0004\u00059QO\\1qa2LH\u0003BBv\u0007c\u0004R!\\Bw\u0003\u0007I1aa<o\u0005\u0019y\u0005\u000f^5p]\"1!Q_\u0003A\u0002]\fQbZ3oKJ\fG/Z!mS\u0006\u001cH\u0003BA\u0010\u0007oDqa!?\u0007\u0001\u0004\t\u0019!A\u0001f\u0003q\u0019HO]5q\u0007>dW/\u001c8SK\u001a,'/\u001a8dK6+G/\u00193bi\u0006$Baa@\u0005\u0006A!\u0011Q\u0001C\u0001\u0013\u0011!\u0019!a\u0002\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-\u001a\u0005\b\t\u000f9\u0001\u0019AB\u0000\u0003\u0005\t\u0007")
public class Column
implements Logging {
    private final Expression expr;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Expression> unapply(Column column) {
        return Column$.MODULE$.unapply(column);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Column isin(Object ... list) {
        return this.isin((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)list));
    }

    public Expression expr() {
        return this.expr;
    }

    public String toString() {
        return package$.MODULE$.toPrettySQL(this.expr());
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof Column) {
            Column column = (Column)object;
            Expression expression = column.normalizedExpr();
            Expression expression2 = this.normalizedExpr();
            bl = !(expression != null ? !expression.equals(expression2) : expression2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.normalizedExpr().hashCode();
    }

    private Expression normalizedExpr() {
        return (Expression)this.expr().transform((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = Column$.MODULE$.stripColumnReferenceMetadata(attributeReference);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
        });
    }

    private Column withExpr(Expression newExpr) {
        return new Column(newExpr);
    }

    public NamedExpression named() {
        NamedExpression namedExpression;
        Expression expression = this.expr();
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression2;
            namedExpression = namedExpression2 = (NamedExpression)expression;
        } else if (expression instanceof Generator) {
            Generator generator = (Generator)expression;
            namedExpression = new MultiAlias((Expression)generator, (Seq)Nil$.MODULE$);
        } else if (expression instanceof Cast) {
            NamedExpression namedExpression3;
            Cast cast = (Cast)expression;
            Expression expression2 = (Expression)cast.transformUp((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Cast cast;
                    A1 A1 = x1;
                    Object object = A1 instanceof Cast && (cast = (Cast)A1).child() instanceof NamedExpression ? new UnresolvedAlias((Expression)cast, UnresolvedAlias$.MODULE$.apply$default$2()) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    Cast cast;
                    Expression expression = x1;
                    boolean bl = expression instanceof Cast && (cast = (Cast)expression).child() instanceof NamedExpression;
                    return bl;
                }
            });
            Object object = expression2 instanceof NamedExpression ? (namedExpression3 = (NamedExpression)expression2) : new UnresolvedAlias(this.expr(), (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
            namedExpression = object;
        } else if (expression != null) {
            Expression expression3 = expression;
            namedExpression = new UnresolvedAlias(expression3, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else {
            throw new MatchError((Object)expression);
        }
        return namedExpression;
    }

    public <U> TypedColumn<Object, U> as(Encoder<U> evidence$1) {
        return new TypedColumn(this.expr(), org.apache.spark.sql.catalyst.encoders.package$.MODULE$.encoderFor(evidence$1));
    }

    public Column apply(Object extraction) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), functions$.MODULE$.lit(extraction).expr()));
    }

    public Column unary_$minus() {
        return this.withExpr((Expression)new UnaryMinus(this.expr(), UnaryMinus$.MODULE$.apply$default$2()));
    }

    public Column unary_$bang() {
        return this.withExpr((Expression)new Not(this.expr()));
    }

    public Column $eq$eq$eq(Object other) {
        Expression right = functions$.MODULE$.lit(other).expr();
        Expression expression = this.expr();
        Expression expression2 = right;
        if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Constructing trivially true equals predicate, '").append(this.expr()).append(" = ").append(right).append("'. ").append("Perhaps you need to use aliases.").toString());
        }
        return this.withExpr((Expression)new EqualTo(this.expr(), right));
    }

    public Column equalTo(Object other) {
        return this.$eq$eq$eq(other);
    }

    public Column $eq$bang$eq(Object other) {
        return this.withExpr((Expression)new Not((Expression)new EqualTo(this.expr(), functions$.MODULE$.lit(other).expr())));
    }

    public Column $bang$eq$eq(Object other) {
        return this.$eq$bang$eq(other);
    }

    public Column notEqual(Object other) {
        return this.withExpr((Expression)new Not((Expression)new EqualTo(this.expr(), functions$.MODULE$.lit(other).expr())));
    }

    public Column $greater(Object other) {
        return this.withExpr((Expression)new GreaterThan(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column gt(Object other) {
        return this.$greater(other);
    }

    public Column $less(Object other) {
        return this.withExpr((Expression)new LessThan(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column lt(Object other) {
        return this.$less(other);
    }

    public Column $less$eq(Object other) {
        return this.withExpr((Expression)new LessThanOrEqual(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column leq(Object other) {
        return this.$less$eq(other);
    }

    public Column $greater$eq(Object other) {
        return this.withExpr((Expression)new GreaterThanOrEqual(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column geq(Object other) {
        return this.$greater$eq(other);
    }

    public Column $less$eq$greater(Object other) {
        Expression right = functions$.MODULE$.lit(other).expr();
        Expression expression = this.expr();
        Expression expression2 = right;
        if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Constructing trivially true equals predicate, '").append(this.expr()).append(" <=> ").append(right).append("'. ").append("Perhaps you need to use aliases.").toString());
        }
        return this.withExpr((Expression)new EqualNullSafe(this.expr(), right));
    }

    public Column eqNullSafe(Object other) {
        return this.$less$eq$greater(other);
    }

    public Column when(Column condition, Object value) {
        Seq branches;
        block5: {
            Option option;
            CaseWhen caseWhen;
            boolean bl;
            block4: {
                bl = false;
                caseWhen = null;
                Expression expression = this.expr();
                if (!(expression instanceof CaseWhen)) break block4;
                bl = true;
                caseWhen = (CaseWhen)expression;
                branches = caseWhen.branches();
                Option option2 = caseWhen.elseValue();
                if (None$.MODULE$.equals(option2)) break block5;
            }
            if (bl && (option = caseWhen.elseValue()) instanceof Some) {
                throw new IllegalArgumentException("when() cannot be applied once otherwise() is applied");
            }
            throw new IllegalArgumentException("when() can only be applied on a Column previously generated by when() function");
        }
        Column column = this.withExpr((Expression)new CaseWhen((Seq)branches.$colon$plus((Object)new Tuple2((Object)condition.expr(), (Object)functions$.MODULE$.lit(value).expr()), Seq$.MODULE$.canBuildFrom()), CaseWhen$.MODULE$.apply$default$2()));
        return column;
    }

    public Column otherwise(Object value) {
        Seq branches;
        block5: {
            Option option;
            CaseWhen caseWhen;
            boolean bl;
            block4: {
                bl = false;
                caseWhen = null;
                Expression expression = this.expr();
                if (!(expression instanceof CaseWhen)) break block4;
                bl = true;
                caseWhen = (CaseWhen)expression;
                branches = caseWhen.branches();
                Option option2 = caseWhen.elseValue();
                if (None$.MODULE$.equals(option2)) break block5;
            }
            if (bl && (option = caseWhen.elseValue()) instanceof Some) {
                throw new IllegalArgumentException("otherwise() can only be applied once on a Column previously generated by when()");
            }
            throw new IllegalArgumentException("otherwise() can only be applied on a Column previously generated by when()");
        }
        Column column = this.withExpr((Expression)new CaseWhen(branches, Option$.MODULE$.apply((Object)functions$.MODULE$.lit(value).expr())));
        return column;
    }

    public Column between(Object lowerBound, Object upperBound) {
        return this.$greater$eq(lowerBound).$amp$amp(this.$less$eq(upperBound));
    }

    public Column isNaN() {
        return this.withExpr((Expression)new IsNaN(this.expr()));
    }

    public Column isNull() {
        return this.withExpr((Expression)new IsNull(this.expr()));
    }

    public Column isNotNull() {
        return this.withExpr((Expression)new IsNotNull(this.expr()));
    }

    public Column $bar$bar(Object other) {
        return this.withExpr((Expression)new Or(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column or(Column other) {
        return this.$bar$bar(other);
    }

    public Column $amp$amp(Object other) {
        return this.withExpr((Expression)new And(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column and(Column other) {
        return this.$amp$amp(other);
    }

    public Column $plus(Object other) {
        return this.withExpr((Expression)new Add(this.expr(), functions$.MODULE$.lit(other).expr(), Add$.MODULE$.apply$default$3()));
    }

    public Column plus(Object other) {
        return this.$plus(other);
    }

    public Column $minus(Object other) {
        return this.withExpr((Expression)new Subtract(this.expr(), functions$.MODULE$.lit(other).expr(), Subtract$.MODULE$.apply$default$3()));
    }

    public Column minus(Object other) {
        return this.$minus(other);
    }

    public Column $times(Object other) {
        return this.withExpr((Expression)new Multiply(this.expr(), functions$.MODULE$.lit(other).expr(), Multiply$.MODULE$.apply$default$3()));
    }

    public Column multiply(Object other) {
        return this.$times(other);
    }

    public Column $div(Object other) {
        return this.withExpr((Expression)new Divide(this.expr(), functions$.MODULE$.lit(other).expr(), Divide$.MODULE$.apply$default$3()));
    }

    public Column divide(Object other) {
        return this.$div(other);
    }

    public Column $percent(Object other) {
        return this.withExpr((Expression)new Remainder(this.expr(), functions$.MODULE$.lit(other).expr(), Remainder$.MODULE$.apply$default$3()));
    }

    public Column mod(Object other) {
        return this.$percent(other);
    }

    public Column isin(Seq<Object> list) {
        return this.withExpr((Expression)new In(this.expr(), (Seq)list.map((Function1 & Serializable & scala.Serializable)x$1 -> functions$.MODULE$.lit(x$1).expr(), Seq$.MODULE$.canBuildFrom())));
    }

    public Column isInCollection(Iterable<?> values) {
        return this.isin((Seq<Object>)values.toSeq());
    }

    public Column isInCollection(java.lang.Iterable<?> values) {
        return this.isInCollection((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(values).asScala());
    }

    public Column like(String literal) {
        return this.withExpr((Expression)new Like(this.expr(), functions$.MODULE$.lit(literal).expr()));
    }

    public Column rlike(String literal) {
        return this.withExpr((Expression)new RLike(this.expr(), functions$.MODULE$.lit(literal).expr()));
    }

    public Column getItem(Object key) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), (Expression)Literal$.MODULE$.apply(key)));
    }

    public Column withField(String fieldName, Column col) {
        Predef$.MODULE$.require(fieldName != null, (Function0 & Serializable & scala.Serializable)() -> "fieldName cannot be null");
        Predef$.MODULE$.require(col != null, (Function0 & Serializable & scala.Serializable)() -> "col cannot be null");
        return this.withExpr((Expression)UpdateFields$.MODULE$.apply(this.expr(), fieldName, col.expr()));
    }

    public Column dropFields(Seq<String> fieldNames) {
        return this.withExpr((Expression)((TraversableOnce)fieldNames.tail()).foldLeft((Object)UpdateFields$.MODULE$.apply(this.expr(), (String)fieldNames.head()), (Function2 & Serializable & scala.Serializable)(resExpr, fieldName) -> UpdateFields$.MODULE$.apply((Expression)resExpr, fieldName)));
    }

    public Column getField(String fieldName) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), (Expression)Literal$.MODULE$.apply((Object)fieldName)));
    }

    public Column substr(Column startPos, Column len) {
        return this.withExpr((Expression)new Substring(this.expr(), startPos.expr(), len.expr()));
    }

    public Column substr(int startPos, int len) {
        return this.withExpr((Expression)new Substring(this.expr(), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)startPos)).expr(), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)len)).expr()));
    }

    public Column contains(Object other) {
        return this.withExpr((Expression)new Contains(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column startsWith(Column other) {
        return this.withExpr((Expression)new StartsWith(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column startsWith(String literal) {
        return this.startsWith(functions$.MODULE$.lit(literal));
    }

    public Column endsWith(Column other) {
        return this.withExpr((Expression)new EndsWith(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column endsWith(String literal) {
        return this.endsWith(functions$.MODULE$.lit(literal));
    }

    public Column alias(String alias) {
        return this.name(alias);
    }

    public Column as(String alias) {
        return this.name(alias);
    }

    public Column as(Seq<String> aliases) {
        return this.withExpr((Expression)new MultiAlias(this.expr(), aliases));
    }

    public Column as(String[] aliases) {
        return this.withExpr((Expression)new MultiAlias(this.expr(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])aliases)));
    }

    public Column as(Symbol alias) {
        return this.name(alias.name());
    }

    public Column as(String alias, Metadata metadata) {
        Expression x$1 = this.expr();
        String x$2 = alias;
        Some x$3 = new Some((Object)metadata);
        ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
        Seq x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
        Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
        return this.withExpr((Expression)new Alias(x$1, x$2, x$4, x$5, (Option)x$3, x$6));
    }

    public Column name(String alias) {
        Expression x$1 = this.expr();
        String x$2 = alias;
        Seq x$3 = (Seq)new .colon.colon((Object)Dataset$.MODULE$.DATASET_ID_KEY(), (List)new .colon.colon((Object)Dataset$.MODULE$.COL_POS_KEY(), (List)Nil$.MODULE$));
        ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
        Seq x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
        Option x$6 = Alias$.MODULE$.apply$default$5(x$1, x$2);
        return this.withExpr((Expression)new Alias(x$1, x$2, x$4, x$5, x$6, x$3));
    }

    /*
     * WARNING - void declaration
     */
    public Column cast(DataType to) {
        void var2_2;
        Cast cast = new Cast(this.expr(), CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringForCast(to), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        cast.setTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        return this.withExpr((Expression)var2_2);
    }

    public Column cast(String to) {
        return this.cast(CatalystSqlParser$.MODULE$.parseDataType(to));
    }

    public Column desc() {
        return this.withExpr((Expression)SortOrder$.MODULE$.apply(this.expr(), (SortDirection)Descending$.MODULE$, SortOrder$.MODULE$.apply$default$3()));
    }

    public Column desc_nulls_first() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Descending$.MODULE$, (NullOrdering)NullsFirst$.MODULE$, (Seq)Nil$.MODULE$));
    }

    public Column desc_nulls_last() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Descending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, (Seq)Nil$.MODULE$));
    }

    public Column asc() {
        return this.withExpr((Expression)SortOrder$.MODULE$.apply(this.expr(), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()));
    }

    public Column asc_nulls_first() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsFirst$.MODULE$, (Seq)Nil$.MODULE$));
    }

    public Column asc_nulls_last() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, (Seq)Nil$.MODULE$));
    }

    public void explain(boolean extended) {
        if (extended) {
            Predef$.MODULE$.println((Object)this.expr());
        } else {
            Predef$.MODULE$.println((Object)this.expr().sql());
        }
    }

    public Column bitwiseOR(Object other) {
        return this.withExpr((Expression)new BitwiseOr(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column bitwiseAND(Object other) {
        return this.withExpr((Expression)new BitwiseAnd(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column bitwiseXOR(Object other) {
        return this.withExpr((Expression)new BitwiseXor(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column over(WindowSpec window) {
        return window.withAggregate(this);
    }

    public Column over() {
        return this.over(Window$.MODULE$.spec());
    }

    public Column(Expression expr) {
        this.expr = expr;
        Logging.$init$((Logging)this);
    }

    public Column(String name) {
        UnresolvedStar unresolvedStar;
        String string = name;
        if ("*".equals(string)) {
            unresolvedStar = new UnresolvedStar((Option)None$.MODULE$);
        } else if (name.endsWith(".*")) {
            Seq parts = UnresolvedAttribute$.MODULE$.parseAttributeName(name.substring(0, name.length() - 2));
            unresolvedStar = new UnresolvedStar((Option)new Some((Object)parts));
        } else {
            unresolvedStar = UnresolvedAttribute$.MODULE$.quotedString(name);
        }
        this((Expression)unresolvedStar);
    }
}

