######################################################################################################
# anomalydetection.py
# ---------------------------
# Purpose
#       Build OpenEO regional anomaly detection service
#
######################################################################################################

#imports
import json
import openeo
import os
import pandas as pd
import geopandas as gpd
from openeo.rest.udp import build_process_dict

from nextland_services.constants import *
from nextland_services.helper_functions import get_input_datacube_udf_cropsar

OUTPUT_DIR = r'/data/sigma/Nextland/Development/Openeo/Cropsar/'
OUTPUT_DIR_GRAPH = RESOURCES
# Functions

def _get_epsg(lat, zone_nr):
    if lat >= 0:
        epsg_code = '326' + str(zone_nr)
    else:
        epsg_code = '327' + str(zone_nr)
    return int(epsg_code)

def load_udf(udf):
    with open(udf, 'r+', encoding= "utf8") as f:
        return f.read()

#Write content to named file
def fwrite(fname, fcontent):
    f = open(fname, 'w')
    f.write(str(fcontent))
    f.close()




# Test the anomaly detection with an UDF
def test_run_udf_anomaly_detection(eoconn,time_range, shp):


    TS_cube = get_input_datacube_udf_cropsar(eoconn, time_range, shp, biopar_fixed= True)

    TS = TS_cube.execute()

    with open(r'/data/sigma/Nextland/Development/Openeo/Croptypeclassification/Test_TS/EPIPRE_TS_TEST.json', 'w') as file:
        json.dump(TS, file)



    anomaly_detection_code = load_udf("anomaly_detection_udf.py")

    udf = TS_cube.process("run_udf", data = TS_cube, udf = anomaly_detection_code, runtime = "Python")

    res = udf.send_job().start_and_wait().get_result().load_json()
    return res


def test_debug_anomaly_detection_udf():
    from openeo_udf.api.udf_data import UdfData
    from openeo_udf.api.structured_data import StructuredData
    from anomaly_detection_udf import udf_anomaly_detection
    with open(r'/data/sigma/Nextland/Development/Openeo/Croptypeclassification/Test_TS/FIELD_TS_20190701_20190831_2.json',
              'r') as json_file:
        ts = json.load(json_file)
        udfdata = UdfData({"EPSG":4326}, structured_data_list=[StructuredData(description= "timeseries input", data = ts, type = "dict")])
        res = udf_anomaly_detection(udfdata)
        fwrite(os.path.join(OUTPUT_DIR, 'anomalydetection_testudf_result.res'), res.to_dict())

def anomaly_cube(eoconn, file_polygons, time_range, biopar_type = 'FAPAR'):
    timeseries_input = get_input_datacube_udf_cropsar(eoconn, time_range, file_polygons, biopar_type = 'FAPAR')

    return timeseries_input

# Build graph anomaly detection and write it away as a JSON file
def anomaly_detection_build_graph_poly_and_store_udp(eoconn):

    #Define the service parameters
    time_range = date_parameter(
        "Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    biopar_type = biopar_parameter()
    polygon = polygon_param(description='Loaded featurecollection object of the field geometries')

    timeseries_input = anomaly_cube(eoconn, polygon, time_range, biopar_type)

    #load UDF
    anomaly_detection_code = load_udf("anomaly_detection_udf.py")
    udf = timeseries_input.process("run_udf", data=timeseries_input, udf=anomaly_detection_code, runtime="Python",
                                   context={"date": {"from_parameter": "date"}})

    #Build service dict
    anomaly_detection_dict = build_process_dict(
        process_id= "Anomaly_Detection",
        process_graph= udf,
        parameters= [time_range, polygon, biopar_type]
    )

    #Write service graph to json file

    fwrite(os.path.join(OUTPUT_DIR_GRAPH, 'anomaly_detection_graph.json'), json.dumps(anomaly_detection_dict, indent = 4))


def save_udp(eoconn):
    # Define the service parameters
    time_range = date_parameter(
        "Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    biopar_type = biopar_parameter()
    polygon = polygon_param(description='Loaded featurecollection object of the field geometries')
    with open(os.path.join(OUTPUT_DIR_GRAPH,'anomaly_detection_graph.json'),'r') as file:
        graph = json.load(file)
    udp = eoconn.save_user_defined_process(
        'Anomaly_detection',
        graph["process_graph"],
        description= "Calculates the cropsar curve for each field and the derivated regional greeness based on all the fields.",
        parameters=[time_range, polygon, biopar_type], public=True)

def run_nexland_service(eoconn):
    year = 2021
    ID_identifier = 'name'
    shp = r'/data/sigma/Nextland/BDB/In_situ/Carbon_sequestration_WGS84.shp'
    time_range = '{}-01-01'.format(str(year)),'{}-11-20'.format(str(year))
    gpd_shp = gpd.read_file(shp)
    field_ids = gpd_shp[ID_identifier].to_list()
    js_shp = json.loads(gpd_shp.to_json())
    shp_nm = Path(shp).stem.split('_WGS84')[0]
    biopars = ['FAPAR', 'FCOVER']
    for biopar in biopars:
        outdir_nextland = r'/data/sigma/Nextland/BDB/Products/regional_anomaly/{}/{}/{}'.format(shp_nm,str(year),biopar)
        os.makedirs(outdir_nextland, exist_ok= True)
        if not os.path.exists(os.path.join(outdir_nextland,"Regional_anomaly_2021_NRT_{}_{}.csv".format(biopar,shp_nm))):
            reg_anomaly_curve= eoconn.datacube_from_process('Anomaly_detection', date = time_range, polygon = js_shp, biopar_type = biopar).send_job().start_and_wait().get_result().load_json()
            df_cropsar = pd.DataFrame.from_dict(reg_anomaly_curve)
            df_cropsar.columns = field_ids + ['Regional_average']
            df_cropsar.to_csv(os.path.join(outdir_nextland,"Regional_anomaly_2021_NRT_{}_{}.csv".format(biopar,shp_nm)), index = True)

shp = r'/data/sigma/Nextland/BDB/In_situ/EPIPRE_2020_WGS84.shp'
gpd_shp = gpd.read_file(shp)
js_shp = json.loads(gpd_shp.to_json())

time_range = ['2019-07-01','2019-08-31']
eoconn = openeo.connect("https://openeo.vito.be").authenticate_basic('bontek', 'bontek123')
#test_run_udf_anomaly_detection(eoconn, time_range, js_shp)
#test_debug_anomaly_detection_udf()
#anomaly_detection_build_graph_poly_and_store_udp(eoconn)
#save_udp(eoconn)
run_nexland_service(eoconn)

#anomaly_detection = eoconn.datacube_from_process('Anomaly_detection', time_range = time_range, file_polygons = shp_file).send_job().start_and_wait().get_result().load_json()
