#imports
import json
import openeo
import geopandas as gpd
import os

from pathlib import Path
import pandas as pd
from openeo.api.process import Parameter


def save_udp(eoconn):
    # Define the service parameters
    time_range = Parameter(
        name='time_range', description="A time range for which the harvest date will be predicted.",
        schema={"type": "temporal-intervals", "subtype": "date-time"}
    )
    gjson_path = Parameter(
        name="gjson_path", description='Path to a geojson file', default = None,
        schema={"type": "string"}
    )
    gjson = Parameter(
        name='gjson', description='Loaded featurecollection object of the field geometries', schema={"type": "object"}, default = None
    )
    with open(r'/home/bontek/git/nextland_official/src/nextland_services/resources/process_graphs/crop_calendar_graph.json','r') as file:
        graph = json.load(file)
    udp = eoconn.save_user_defined_process(
        'CropCalendar',
        graph["process_graph"],
        description= "Predicts harvest date for some fields.",
        parameters=[time_range, gjson_path, gjson], public=True)


eoconn = openeo.connect("https://openeo.vito.be").authenticate_basic('bontek', 'bontek123')
#save_udp(eoconn)


def run_cropcalendar_call(eoconn):
    time_range = "2021-05-01", "2021-11-21"
    shp_file = r'/data/sigma/Nextland/BDB/In_situ/Irrigation_advice_WGS84.shp'
    outname = Path(shp_file).stem.split('_WGS84')[0] + '_Harvest_date.csv'
    gpd_shp = gpd.read_file(shp_file)
    outdir_nextland = r'/data/sigma/Nextland/BDB/Products/Phenology/Harvest_date/2021/'
    os.makedirs(outdir_nextland, exist_ok=True)
    js_shp = json.loads(gpd_shp.to_json())


    cropcalendar = eoconn.datacube_from_process("CropCalendar", time_range=time_range,
                                        gjson=js_shp, namespace="nextland")  #

    '''polygon = shapely.geometry.Polygon([[bbox['west'], bbox['south']], [bbox['west'], bbox['north']],
                                        [bbox['east'], bbox['north']], [bbox['east'], bbox['south']]])

    poly = geojson.Polygon([[bbox['west'], bbox['south']], [bbox['west'], bbox['north']],
                                        [bbox['east'], bbox['north']], [bbox['east'], bbox['south']]])'''
    # biom = eoconn.datacube_from_process("biomass", namespace="nextland", time_range=time_range, bbox=bbox)
    # biom = eoconn.datacube_from_process("BIOMASS", namespace="nextland", time_range=time_range, polygon=shapely.geometry.mapping(poly))
    # biom.download(os.path.join(OUTPUT_DIR, "biom_res_BDB.json"), format="JSON")


    cropcalendar_result = cropcalendar.send_job().start_and_wait().get_result().load_json()

    #write output away
    lst_df = []
    for feature in cropcalendar_result['features']:
        ID = feature['properties']['name']
        harvest_date = feature['properties']['Harvest_date']
        df = pd.DataFrame([ID, harvest_date]).T
        df.columns = ['ID', 'Harvest_date']
        lst_df.append(df)
    df_harvest = pd.concat(lst_df)
    df_harvest.to_csv(os.path.join(outdir_nextland, outname), index=False)

    return cropcalendar_result

run_cropcalendar_call(eoconn)

