import numpy as np


def combine_s1_orbits(s1_asc, s1_des):
    '''
    function to combine ascending and descending orbits. Inputs should be in dB

    '''
    s1_asc_linear = np.expand_dims(np.power(10, s1_asc/10.), axis=2)
    s1_des_linear = np.expand_dims(np.power(10, s1_des/10.), axis=2)
    s1_combined = 10 * \
        np.log10(np.nanmean(np.concatenate(
            (s1_asc_linear, s1_des_linear), axis=2), axis=2))

    return s1_combined
