/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Partial$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec$;
import org.apache.spark.sql.execution.aggregate.MergingSessionsExec;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec$;
import org.apache.spark.sql.execution.aggregate.SortAggregateExec;
import org.apache.spark.sql.execution.aggregate.UpdatingSessionsExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.StateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.streaming.OutputMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class AggUtils$ {
    public static AggUtils$ MODULE$;

    static {
        new AggUtils$();
    }

    private Seq<AggregateExpression> mayRemoveAggFilters(Seq<AggregateExpression> exprs) {
        return (Seq)exprs.map((Function1 & Serializable & scala.Serializable)ae -> {
            AggregateExpression aggregateExpression;
            if (ae.filter().isDefined()) {
                AggregateExpression aggregateExpression2;
                AggregateMode aggregateMode = ae.mode();
                boolean bl = Partial$.MODULE$.equals(aggregateMode) ? true : Complete$.MODULE$.equals(aggregateMode);
                if (bl) {
                    aggregateExpression2 = ae;
                } else {
                    None$ x$1 = None$.MODULE$;
                    AggregateFunction x$2 = ae.copy$default$1();
                    AggregateMode x$3 = ae.copy$default$2();
                    boolean x$4 = ae.copy$default$3();
                    ExprId x$5 = ae.copy$default$5();
                    aggregateExpression2 = ae.copy(x$2, x$3, x$4, (Option)x$1, x$5);
                }
                aggregateExpression = aggregateExpression2;
            } else {
                aggregateExpression = ae;
            }
            return aggregateExpression;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private SparkPlan createAggregate(Option<Seq<Expression>> requiredChildDistributionExpressions, Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan sparkPlan;
        boolean useHash = HashAggregateExec$.MODULE$.supportsAggregate((Seq<Attribute>)((Seq)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom())));
        if (useHash) {
            sparkPlan = new HashAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        } else {
            boolean objectHashEnabled = child.conf().useObjectHashAggregation();
            boolean useObjectHash = ObjectHashAggregateExec$.MODULE$.supportsAggregate(aggregateExpressions);
            sparkPlan = objectHashEnabled && useObjectHash ? new ObjectHashAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child) : new SortAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        return sparkPlan;
    }

    private Option<Seq<Expression>> createAggregate$default$1() {
        return None$.MODULE$;
    }

    private Seq<NamedExpression> createAggregate$default$2() {
        return Nil$.MODULE$;
    }

    private Seq<AggregateExpression> createAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<Attribute> createAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private int createAggregate$default$5() {
        return 0;
    }

    private Seq<NamedExpression> createAggregate$default$6() {
        return Nil$.MODULE$;
    }

    public Seq<SparkPlan> planAggregateWithoutDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$3.copy$default$1();
            boolean x$32 = x$3.copy$default$3();
            Option x$4 = x$3.copy$default$4();
            ExprId x$5 = x$3.copy$default$5();
            return x$3.copy(x$2, (AggregateMode)x$1, x$32, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateAttributes = (Seq)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
        Seq partialResultExpressions = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialAggregate = this.createAggregate((Option<Seq<Expression>>)None$.MODULE$, groupingExpressions, (Seq<AggregateExpression>)partialAggregateExpressions, (Seq<Attribute>)partialAggregateAttributes, 0, (Seq<NamedExpression>)partialResultExpressions, child);
        SparkPlan interExec = this.mayAppendMergingSessionExec(groupingExpressions, aggregateExpressions, partialAggregate);
        Seq finalAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Final$ x$62 = Final$.MODULE$;
            AggregateFunction x$7 = x$6.copy$default$1();
            boolean x$8 = x$6.copy$default$3();
            Option x$9 = x$6.copy$default$4();
            ExprId x$10 = x$6.copy$default$5();
            return x$6.copy(x$7, (AggregateMode)x$62, x$8, x$9, x$10);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan = finalAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingExpressions.length(), resultExpressions, interExec);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planAggregateWithOneDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithDistinct, Seq<AggregateExpression> functionsWithoutDistinct, Seq<Expression> distinctExpressions, Seq<NamedExpression> normalizedNamedDistinctExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan maySessionChild = this.mayAppendUpdatingSessionExec(groupingExpressions, child);
        Seq distinctAttributes = (Seq)normalizedNamedDistinctExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$11.copy$default$1();
            boolean x$3 = x$11.copy$default$3();
            Option x$4 = x$11.copy$default$4();
            ExprId x$5 = x$11.copy$default$5();
            return x$11.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq x$6 = (Seq)groupingExpressions.$plus$plus(normalizedNamedDistinctExpressions, Seq$.MODULE$.canBuildFrom());
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$92 = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$102 = maySessionChild;
        Option<Seq<Expression>> x$112 = this.createAggregate$default$1();
        int x$122 = this.createAggregate$default$5();
        SparkPlan partialAggregate = this.createAggregate(x$112, (Seq<NamedExpression>)x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$122, (Seq<NamedExpression>)x$92, x$102);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$14 -> {
            PartialMerge$ x$13 = PartialMerge$.MODULE$;
            AggregateFunction x$142 = x$14.copy$default$1();
            boolean x$15 = x$14.copy$default$3();
            Option x$16 = x$14.copy$default$4();
            ExprId x$17 = x$14.copy$default$5();
            return x$14.copy(x$142, (AggregateMode)x$13, x$15, x$16, x$17);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMergeAggregate = this.createAggregate((Option<Seq<Expression>>)new Some(groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())), (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length(), (Seq<NamedExpression>)((Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        Map distinctColumnAttributeLookup = ((TraversableOnce)distinctExpressions.zip((GenIterable)distinctAttributes, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq rewrittenDistinctFunctions = (Seq)functionsWithDistinct.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AggregateFunction aggregateFunction;
            block3: {
                AggregateExpression aggregateExpression;
                block2: {
                    aggregateExpression = x0$1;
                    if (aggregateExpression == null) break block2;
                    aggregateFunction = aggregateExpression.aggregateFunction();
                    boolean bl = aggregateExpression.isDistinct();
                    if (bl) break block3;
                }
                throw new IllegalArgumentException(new StringBuilder(90).append("Non-distinct aggregate is found in functionsWithDistinct ").append("at planAggregateWithOneDistinct: ").append(aggregateExpression).toString());
            }
            AggregateFunction aggregateFunction2 = (AggregateFunction)aggregateFunction.transformDown((PartialFunction)distinctColumnAttributeLookup);
            return aggregateFunction2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$17 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$17.copy$default$1();
            boolean x$20 = x$17.copy$default$3();
            Option x$21 = x$17.copy$default$4();
            ExprId x$22 = x$17.copy$default$5();
            return x$17.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateAttributes = (Seq)mergeAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateFunction func = (AggregateFunction)tuple2._1();
            int i = tuple2._2$mcI$sp();
            AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Partial$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
            Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
            Tuple2 tuple22 = new Tuple2((Object)expr, (Object)attr);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq distinctAggregateExpressions = (Seq)tuple2._1();
        Seq distinctAggregateAttributes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distinctAggregateExpressions, (Object)distinctAggregateAttributes);
        Tuple2 tuple23 = tuple22;
        Seq distinctAggregateExpressions2 = (Seq)tuple23._1();
        Seq distinctAggregateAttributes2 = (Seq)tuple23._2();
        Seq partialAggregateResult = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)mergeAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)distinctAggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> x$21.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq x$232 = groupingAttributes;
        Seq x$24 = (Seq)mergeAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions2, Seq$.MODULE$.canBuildFrom());
        Seq x$25 = (Seq)mergeAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes2, Seq$.MODULE$.canBuildFrom());
        int x$26 = ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length();
        Seq x$27 = partialAggregateResult;
        SparkPlan x$28 = partialMergeAggregate;
        Option<Seq<Expression>> x$29 = this.createAggregate$default$1();
        SparkPlan partialDistinctAggregate = this.createAggregate(x$29, (Seq<NamedExpression>)x$232, (Seq<AggregateExpression>)x$24, (Seq<Attribute>)x$25, x$26, (Seq<NamedExpression>)x$27, x$28);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$22 -> {
            Final$ x$30 = Final$.MODULE$;
            AggregateFunction x$31 = x$22.copy$default$1();
            boolean x$32 = x$22.copy$default$3();
            Option x$33 = x$22.copy$default$4();
            ExprId x$34 = x$22.copy$default$5();
            return x$22.copy(x$31, (AggregateMode)x$30, x$32, x$33, x$34);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple24 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateFunction func = (AggregateFunction)tuple2._1();
            int i = tuple2._2$mcI$sp();
            AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Final$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
            Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
            Tuple2 tuple22 = new Tuple2((Object)expr, (Object)attr);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq distinctAggregateExpressions3 = (Seq)tuple24._1();
        Seq distinctAggregateAttributes3 = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)distinctAggregateExpressions3, (Object)distinctAggregateAttributes3);
        Tuple2 tuple26 = tuple25;
        Seq distinctAggregateExpressions4 = (Seq)tuple26._1();
        Seq distinctAggregateAttributes4 = (Seq)tuple26._2();
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)((Seq)finalAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions4, Seq$.MODULE$.canBuildFrom())), (Seq<Attribute>)((Seq)finalAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes4, Seq$.MODULE$.canBuildFrom())), groupingAttributes.length(), resultExpressions, partialDistinctAggregate);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planStreamingAggregation(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, int stateFormatVersion, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$27 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$27.copy$default$1();
            boolean x$3 = x$27.copy$default$3();
            Option x$4 = x$27.copy$default$4();
            ExprId x$5 = x$27.copy$default$5();
            return x$27.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> x$6 = groupingExpressions;
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$9 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$29 -> x$29.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$10 = child;
        Option<Seq<Expression>> x$11 = this.createAggregate$default$1();
        int x$12 = this.createAggregate$default$5();
        SparkPlan partialAggregate = this.createAggregate(x$11, x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$12, (Seq<NamedExpression>)x$9, x$10);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$30 -> {
            PartialMerge$ x$13 = PartialMerge$.MODULE$;
            AggregateFunction x$14 = x$30.copy$default$1();
            boolean x$15 = x$30.copy$default$3();
            Option x$16 = x$30.copy$default$4();
            ExprId x$17 = x$30.copy$default$5();
            return x$30.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged1 = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$32 -> x$32.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        StateStoreRestoreExec restored = new StateStoreRestoreExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, stateFormatVersion, partialMerged1);
        Seq aggregateExpressions3 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$33 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$33.copy$default$1();
            boolean x$20 = x$33.copy$default$3();
            Option x$21 = x$33.copy$default$4();
            ExprId x$22 = x$33.copy$default$5();
            return x$33.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes3 = (Seq)aggregateExpressions3.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged2 = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions3, (Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions3.flatMap((Function1 & Serializable & scala.Serializable)x$35 -> x$35.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), restored);
        StateStoreSaveExec saved = new StateStoreSaveExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged2);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$36 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$36.copy$default$1();
            boolean x$25 = x$36.copy$default$3();
            Option x$26 = x$36.copy$default$4();
            ExprId x$27 = x$36.copy$default$5();
            return x$36.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planStreamingAggregationForSession(Seq<NamedExpression> groupingExpressions, NamedExpression sessionExpression, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, int stateFormatVersion, boolean mergeSessionsInLocalPartition, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan sparkPlan;
        Seq groupWithoutSessionExpression = (Seq)groupingExpressions.filterNot((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$planStreamingAggregationForSession$1(sessionExpression, p)));
        if (groupWithoutSessionExpression.isEmpty()) {
            throw new AnalysisException("Global aggregation with session window in streaming query is not supported.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        Seq groupingWithoutSessionAttributes = (Seq)groupWithoutSessionExpression.map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$41 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$41.copy$default$1();
            boolean x$3 = x$41.copy$default$3();
            Option x$4 = x$41.copy$default$4();
            ExprId x$5 = x$41.copy$default$5();
            return x$41.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> x$6 = groupingExpressions;
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$9 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$43 -> x$43.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$10 = child;
        Option<Seq<Expression>> x$11 = this.createAggregate$default$1();
        int x$12 = this.createAggregate$default$5();
        SparkPlan partialAggregate = this.createAggregate(x$11, x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$12, (Seq<NamedExpression>)x$9, x$10);
        if (mergeSessionsInLocalPartition) {
            Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$44 -> {
                PartialMerge$ x$13 = PartialMerge$.MODULE$;
                AggregateFunction x$14 = x$44.copy$default$1();
                boolean x$15 = x$44.copy$default$3();
                Option x$16 = x$44.copy$default$4();
                ExprId x$17 = x$44.copy$default$5();
                return x$44.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
            }, Seq$.MODULE$.canBuildFrom());
            Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.resultAttribute(), Seq$.MODULE$.canBuildFrom());
            sparkPlan = new MergingSessionsExec((Option<Seq<Expression>>)None$.MODULE$, (Option<Seq<Distribution>>)None$.MODULE$, (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$46 -> x$46.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        } else {
            sparkPlan = partialAggregate;
        }
        SparkPlan partialMerged1 = sparkPlan;
        SessionWindowStateStoreRestoreExec restored = new SessionWindowStateStoreRestoreExec((Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged1);
        Seq aggregateExpressions3 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$47 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$47.copy$default$1();
            boolean x$20 = x$47.copy$default$3();
            Option x$21 = x$47.copy$default$4();
            ExprId x$22 = x$47.copy$default$5();
            return x$47.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes3 = (Seq)aggregateExpressions3.map((Function1 & Serializable & scala.Serializable)x$48 -> x$48.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        MergingSessionsExec mergedSessions = new MergingSessionsExec((Option<Seq<Expression>>)None$.MODULE$, (Option<Seq<Distribution>>)new Some(restored.requiredChildDistribution()), (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggregateExpressions3, (Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions3.flatMap((Function1 & Serializable & scala.Serializable)x$49 -> x$49.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), restored);
        SessionWindowStateStoreSaveExec saved = new SessionWindowStateStoreSaveExec((Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, mergedSessions);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$50 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$50.copy$default$1();
            boolean x$25 = x$50.copy$default$3();
            Option x$26 = x$50.copy$default$4();
            ExprId x$27 = x$50.copy$default$5();
            return x$50.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$51 -> x$51.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan2 = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan2);
    }

    private SparkPlan mayAppendUpdatingSessionExec(Seq<NamedExpression> groupingExpressions, SparkPlan maybeChildPlan) {
        SparkPlan sparkPlan;
        Option option = groupingExpressions.find((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendUpdatingSessionExec$1(x$53)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            sparkPlan = new UpdatingSessionsExec((Seq<Attribute>)((Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$54 -> x$54.toAttribute(), Seq$.MODULE$.canBuildFrom())), sessionExpression.toAttribute(), maybeChildPlan);
        } else if (None$.MODULE$.equals(option)) {
            sparkPlan = maybeChildPlan;
        } else {
            throw new MatchError((Object)option);
        }
        return sparkPlan;
    }

    private SparkPlan mayAppendMergingSessionExec(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, SparkPlan partialAggregate) {
        SparkPlan sparkPlan;
        Option option = groupingExpressions.find((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendMergingSessionExec$1(x$55)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            Seq aggExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$56 -> {
                PartialMerge$ x$1 = PartialMerge$.MODULE$;
                AggregateFunction x$2 = x$56.copy$default$1();
                boolean x$3 = x$56.copy$default$3();
                Option x$4 = x$56.copy$default$4();
                ExprId x$5 = x$56.copy$default$5();
                return x$56.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
            }, Seq$.MODULE$.canBuildFrom());
            Seq aggAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$57 -> x$57.resultAttribute(), Seq$.MODULE$.canBuildFrom());
            Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$58 -> x$58.toAttribute(), Seq$.MODULE$.canBuildFrom());
            Seq groupingWithoutSessionExpressions = (Seq)groupingExpressions.diff((GenSeq)new .colon.colon((Object)sessionExpression, (List)Nil$.MODULE$));
            Seq groupingWithoutSessionsAttributes = (Seq)groupingWithoutSessionExpressions.map((Function1 & Serializable & scala.Serializable)x$59 -> x$59.toAttribute(), Seq$.MODULE$.canBuildFrom());
            sparkPlan = new MergingSessionsExec((Option<Seq<Expression>>)new Some((Object)groupingWithoutSessionsAttributes), (Option<Seq<Distribution>>)None$.MODULE$, (Seq<NamedExpression>)groupingAttributes, sessionExpression, (Seq<AggregateExpression>)aggExpressions, (Seq<Attribute>)aggAttributes, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$60 -> x$60.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        } else if (None$.MODULE$.equals(option)) {
            sparkPlan = partialAggregate;
        } else {
            throw new MatchError((Object)option);
        }
        return sparkPlan;
    }

    public static final /* synthetic */ boolean $anonfun$planStreamingAggregationForSession$1(NamedExpression sessionExpression$1, NamedExpression p) {
        return ((Expression)p).semanticEquals((Expression)sessionExpression$1);
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendUpdatingSessionExec$1(NamedExpression x$53) {
        return x$53.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendMergingSessionExec$1(NamedExpression x$55) {
        return x$55.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    private AggUtils$() {
        MODULE$ = this;
    }
}

