/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.JoinStrategyHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NO_BROADCAST_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.PREFER_SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.DynamicJoinSelection$;
import org.apache.spark.sql.execution.adaptive.LogicalQueryStage;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class DynamicJoinSelection$
extends Rule<LogicalPlan> {
    public static DynamicJoinSelection$ MODULE$;

    static {
        new DynamicJoinSelection$();
    }

    private boolean shouldDemoteBroadcastHashJoin(MapOutputStatistics mapStats) {
        int partitionCnt = mapStats.bytesByPartitionId().length;
        int nonZeroCnt = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(mapStats.bytesByPartitionId())).count((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
        return partitionCnt > 0 && nonZeroCnt > 0 && (double)nonZeroCnt * 1.0 / (double)partitionCnt < this.conf().nonEmptyPartitionRatioForBroadcastJoin();
    }

    private boolean preferShuffledHashJoin(MapOutputStatistics mapStats) {
        long maxShuffledHashJoinLocalMapThreshold = BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.ADAPTIVE_MAX_SHUFFLE_HASH_JOIN_LOCAL_MAP_THRESHOLD()));
        long advisoryPartitionSize = BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES()));
        return advisoryPartitionSize <= maxShuffledHashJoinLocalMapThreshold && new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(mapStats.bytesByPartitionId())).forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 <= maxShuffledHashJoinLocalMapThreshold);
    }

    public Option<JoinStrategyHint> org$apache$spark$sql$execution$adaptive$DynamicJoinSelection$$selectJoinStrategy(LogicalPlan plan) {
        None$ none$;
        ShuffleQueryStageExec shuffleQueryStageExec;
        LogicalQueryStage logicalQueryStage;
        SparkPlan stage;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalQueryStage && (stage = (logicalQueryStage = (LogicalQueryStage)logicalPlan2).physicalPlan()) instanceof ShuffleQueryStageExec && (shuffleQueryStageExec = (ShuffleQueryStageExec)stage).isMaterialized() && shuffleQueryStageExec.mapStats().isDefined()) {
            boolean demoteBroadcastHash = this.shouldDemoteBroadcastHashJoin((MapOutputStatistics)shuffleQueryStageExec.mapStats().get());
            boolean preferShuffleHash = this.preferShuffledHashJoin((MapOutputStatistics)shuffleQueryStageExec.mapStats().get());
            none$ = demoteBroadcastHash && preferShuffleHash ? new Some((Object)SHUFFLE_HASH$.MODULE$) : (demoteBroadcastHash ? new Some((Object)NO_BROADCAST_HASH$.MODULE$) : (preferShuffleHash ? new Some((Object)PREFER_SHUFFLE_HASH$.MODULE$) : None$.MODULE$));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transformDown((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Join) {
                    Join join;
                    Join join2 = (Join)A1;
                    LogicalPlan left = join2.left();
                    LogicalPlan right = join2.right();
                    JoinHint hint = join2.hint();
                    ObjectRef newHint = ObjectRef.create((Object)hint);
                    if (!hint.leftHint().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.1.$anonfun$applyOrElse$1(x$3)))) {
                        DynamicJoinSelection$.MODULE$.org$apache$spark$sql$execution$adaptive$DynamicJoinSelection$$selectJoinStrategy(left).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
                            anonfun.apply.1.$anonfun$applyOrElse$2(newHint, hint, strategy);
                            return BoxedUnit.UNIT;
                        });
                    }
                    if (!hint.rightHint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.1.$anonfun$applyOrElse$4(x$4)))) {
                        DynamicJoinSelection$.MODULE$.org$apache$spark$sql$execution$adaptive$DynamicJoinSelection$$selectJoinStrategy(right).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
                            anonfun.apply.1.$anonfun$applyOrElse$5(newHint, hint, strategy);
                            return BoxedUnit.UNIT;
                        });
                    }
                    if ((JoinHint)newHint.elem != hint) {
                        JoinHint x$5 = (JoinHint)newHint.elem;
                        LogicalPlan x$6 = join2.copy$default$1();
                        LogicalPlan x$7 = join2.copy$default$2();
                        JoinType x$8 = join2.copy$default$3();
                        Option x$9 = join2.copy$default$4();
                        join = join2.copy(x$6, x$7, x$8, x$9, x$5);
                    } else {
                        join = join2;
                    }
                    object = join;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof Join;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(HintInfo x$3) {
                return x$3.strategy().isDefined();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2(ObjectRef newHint$1, JoinHint hint$1, JoinStrategyHint strategy) {
                JoinHint qual$1 = (JoinHint)newHint$1.elem;
                Some x$1 = new Some((Object)((HintInfo)hint$1.leftHint().getOrElse((Function0 & Serializable & scala.Serializable)() -> new HintInfo(HintInfo$.MODULE$.apply$default$1()))).copy((Option)new Some((Object)strategy)));
                Option x$2 = qual$1.copy$default$2();
                newHint$1.elem = qual$1.copy((Option)x$1, x$2);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$4(HintInfo x$4) {
                return x$4.strategy().isDefined();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$5(ObjectRef newHint$1, JoinHint hint$1, JoinStrategyHint strategy) {
                JoinHint qual$2 = (JoinHint)newHint$1.elem;
                Some x$3 = new Some((Object)((HintInfo)hint$1.rightHint().getOrElse((Function0 & Serializable & scala.Serializable)() -> new HintInfo(HintInfo$.MODULE$.apply$default$1()))).copy((Option)new Some((Object)strategy)));
                Option x$4 = qual$2.copy$default$1();
                newHint$1.elem = qual$2.copy(x$4, (Option)x$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.plans.logical.HintInfo ), $anonfun$applyOrElse$2$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.plans.logical.JoinHint org.apache.spark.sql.catalyst.plans.logical.JoinStrategyHint ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.plans.logical.HintInfo ), $anonfun$applyOrElse$5$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.plans.logical.JoinHint org.apache.spark.sql.catalyst.plans.logical.JoinStrategyHint ), $anonfun$applyOrElse$3(), $anonfun$applyOrElse$6()}, serializedLambda);
            }
        });
    }

    private DynamicJoinSelection$() {
        MODULE$ = this;
    }
}

