/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001\u0002\u001c8\u0001\tC\u0001\u0002\u0014\u0001\u0003\u0002\u0004%I!\u0014\u0005\t#\u0002\u0011\t\u0019!C\u0005%\"A\u0001\f\u0001B\u0001B\u0003&a\n\u0003\u0005Z\u0001\t\u0005\r\u0011\"\u0003N\u0011!Q\u0006A!a\u0001\n\u0013Y\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0015\u0002(\t\u0011y\u0003!\u00111A\u0005\n}C\u0001b\u001b\u0001\u0003\u0002\u0004%I\u0001\u001c\u0005\t]\u0002\u0011\t\u0011)Q\u0005A\"1q\u000e\u0001C\u0001oADQa\u001c\u0001\u0005\u0002YDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u000f\u0001\u0011\u0005\u00111\t\u0005\b\u0003;\u0001A\u0011AA2\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b;q!!&8\u0011\u0003\t9J\u0002\u00047o!\u0005\u0011\u0011\u0014\u0005\u0007_R!\t!a*\u0007\r\u0005%F\u0003QAV\u0011)\t\u0019L\u0006BK\u0002\u0013\u0005\u0011Q\u0017\u0005\u000b\u0003o3\"\u0011#Q\u0001\n\u0005m\u0003\"CA]-\tU\r\u0011\"\u0001N\u0011%\tYL\u0006B\tB\u0003%a\n\u0003\u0004p-\u0011\u0005\u0011Q\u0018\u0005\n\u0003\u000f4\u0012\u0011!C\u0001\u0003\u0013D\u0011\"a4\u0017#\u0003%\t!!5\t\u0013\u0005\u0015h#%A\u0005\u0002\u0005\u001d\b\"CAv-\u0005\u0005I\u0011IAw\u0011!\t\u0019PFA\u0001\n\u0003i\u0005\"CA{-\u0005\u0005I\u0011AA|\u0011%\u0011\tAFA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\u0012Y\t\t\u0011\"\u0001\u0003\u0014!I!Q\u0004\f\u0002\u0002\u0013\u0005#q\u0004\u0005\n\u0005C1\u0012\u0011!C!\u0005GA\u0011B!\n\u0017\u0003\u0003%\tEa\n\b\u0013\t5B#!A\t\u0002\t=b!CAU)\u0005\u0005\t\u0012\u0001B\u0019\u0011\u0019y\u0007\u0006\"\u0001\u0003@!I!\u0011\u0005\u0015\u0002\u0002\u0013\u0015#1\u0005\u0005\n\u0005\u0003B\u0013\u0011!CA\u0005\u0007B\u0011B!\u0013)\u0003\u0003%\tIa\u0013\t\u0013\tu\u0003&!A\u0005\n\t}\u0003\u0002\u0003B4)\u0011\u0005qG!\u001b\t\u0011\t\u001dD\u0003\"\u00018\u0005[B\u0001B!\u001d\u0015\t\u00039$1\u000f\u0005\t\u0005s\"B\u0011A\u001c\u0003|!A!q\u0010\u000b\u0005\u0002]\u0012\t\t\u0003\u0005\u0003\u000eR!\ta\u000eBH\u0011\u001d\u0011I\n\u0006C\u0005\u00057C\u0011B!\u0018\u0015\u0003\u0003%IAa\u0018\u00031A{w/\u001a:Ji\u0016\u0014\u0018\r^5p]\u000ecWo\u001d;fe&twM\u0003\u00029s\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005iZ\u0014!B7mY&\u0014'B\u0001\u001f>\u0003\u0015\u0019\b/\u0019:l\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\u0004\u0001M\u0019\u0001aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\t!%*\u0003\u0002L\u000b\na1+\u001a:jC2L'0\u00192mK\u0006\t1.F\u0001O!\t!u*\u0003\u0002Q\u000b\n\u0019\u0011J\u001c;\u0002\u000b-|F%Z9\u0015\u0005M3\u0006C\u0001#U\u0013\t)VI\u0001\u0003V]&$\bbB,\u0003\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014AA6!\u00035i\u0017\r_%uKJ\fG/[8og\u0006\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005Mc\u0006bB,\u0006\u0003\u0003\u0005\rAT\u0001\u000f[\u0006D\u0018\n^3sCRLwN\\:!\u0003!Ig.\u001b;N_\u0012,W#\u00011\u0011\u0005\u0005DgB\u00012g!\t\u0019W)D\u0001e\u0015\t)\u0017)\u0001\u0004=e>|GOP\u0005\u0003O\u0016\u000ba\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q-R\u0001\rS:LG/T8eK~#S-\u001d\u000b\u0003'6Dqa\u0016\u0005\u0002\u0002\u0003\u0007\u0001-A\u0005j]&$Xj\u001c3fA\u00051A(\u001b8jiz\"B!]:ukB\u0011!\u000fA\u0007\u0002o!)AJ\u0003a\u0001\u001d\")\u0011L\u0003a\u0001\u001d\")aL\u0003a\u0001AR\t\u0011\u000fK\u0002\fqz\u0004\"!\u001f?\u000e\u0003iT!a_\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002~u\n)1+\u001b8dK\u0006\nq0A\u00032]Mr\u0003'\u0001\u0003tKR\\E\u0003BA\u0003\u0003\u000fi\u0011\u0001\u0001\u0005\u0006\u00192\u0001\rA\u0014\u0015\u0004\u0019at\u0018\u0001E:fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8t)\u0011\t)!a\u0004\t\u000bek\u0001\u0019\u0001()\u00075Ah0A\u000btKRLe.\u001b;jC2L'0\u0019;j_:lu\u000eZ3\u0015\t\u0005\u0015\u0011q\u0003\u0005\u0007\u00033q\u0001\u0019\u00011\u0002\t5|G-\u001a\u0015\u0004\u001dat\u0018a\u0001:v]R!\u0011\u0011EA\u0014!\r\u0011\u00181E\u0005\u0004\u0003K9$!\b)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oO6{G-\u001a7\t\u000f\u0005%r\u00021\u0001\u0002,\u0005)qM]1qQBA\u0011QFA\u001a\u0003o\t9$\u0004\u0002\u00020)\u0019\u0011\u0011G\u001e\u0002\r\u001d\u0014\u0018\r\u001d5y\u0013\u0011\t)$a\f\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0007\u0011\u000bI$C\u0002\u0002<\u0015\u0013a\u0001R8vE2,\u0007\u0006B\by\u0003\u007f\t#!!\u0011\u0002\u000bErSG\f\u0019\u0015\t\u0005\u0005\u0012Q\t\u0005\b\u0003\u000f\u0002\u0002\u0019AA%\u00031\u0019\u0018.\\5mCJLG/[3t!\u0019\tY%!\u0015\u0002V5\u0011\u0011Q\n\u0006\u0004\u0003\u001fZ\u0014a\u0001:eI&!\u00111KA'\u0005\r\u0011F\t\u0012\t\n\t\u0006]\u00131LA.\u0003oI1!!\u0017F\u0005\u0019!V\u000f\u001d7fgA\u0019A)!\u0018\n\u0007\u0005}SI\u0001\u0003M_:<\u0007f\u0001\ty}R!\u0011\u0011EA3\u0011\u001d\t9%\u0005a\u0001\u0003O\u0002b!!\u001b\u0002t\u0005]TBAA6\u0015\u0011\ti'a\u001c\u0002\t)\fg/\u0019\u0006\u0004\u0003cZ\u0014aA1qS&!\u0011QOA6\u0005\u001dQ\u0015M^1S\t\u0012\u0003\u0012\u0002RA,\u0003s\nI(!\"\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{RA!a \u0002\u0002\u0006!A.\u00198h\u0015\t\ti'\u0003\u0003\u0002`\u0005u\u0004\u0003BA>\u0003\u000fKA!a\u000f\u0002~!\u001a\u0011\u0003\u001f@\u0002\u0007AL7\r\u0006\u0003\u0002\"\u0005=\u0005bBAI%\u0001\u0007\u00111F\u0001\u0002o\"\u001a\u0001\u0001\u001f@\u00021A{w/\u001a:Ji\u0016\u0014\u0018\r^5p]\u000ecWo\u001d;fe&tw\r\u0005\u0002s)M)AcQAN\u0013B!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"n\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003K\u000byJA\u0004M_\u001e<\u0017N\\4\u0015\u0005\u0005]%AC!tg&<g.\\3oiN)acQAW\u0013B\u0019A)a,\n\u0007\u0005EVIA\u0004Qe>$Wo\u0019;\u0002\u0005%$WCAA.\u0003\rIG\rI\u0001\bG2,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004CCBA`\u0003\u0007\f)\rE\u0002\u0002BZi\u0011\u0001\u0006\u0005\b\u0003g[\u0002\u0019AA.\u0011\u0019\tIl\u0007a\u0001\u001d\u0006!1m\u001c9z)\u0019\ty,a3\u0002N\"I\u00111\u0017\u000f\u0011\u0002\u0003\u0007\u00111\f\u0005\t\u0003sc\u0002\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAjU\u0011\tY&!6,\u0005\u0005]\u0007\u0003BAm\u0003Cl!!a7\u000b\t\u0005u\u0017q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!a_#\n\t\u0005\r\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003ST3ATAk\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001e\t\u0005\u0003w\n\t0C\u0002j\u0003{\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002z\u0006}\bc\u0001#\u0002|&\u0019\u0011Q`#\u0003\u0007\u0005s\u0017\u0010C\u0004XC\u0005\u0005\t\u0019\u0001(\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0002\u0011\r\t\u001d!QBA}\u001b\t\u0011IAC\u0002\u0003\f\u0015\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yA!\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005+\u0011Y\u0002E\u0002E\u0005/I1A!\u0007F\u0005\u001d\u0011un\u001c7fC:D\u0001bV\u0012\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\tQ\u0006\u001c\bnQ8eKR\ta*\u0001\u0005u_N#(/\u001b8h)\t\ty/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005+\u0011I\u0003\u0003\u0005XM\u0005\u0005\t\u0019AA}Q\r1\u0002P`\u0001\u000b\u0003N\u001c\u0018n\u001a8nK:$\bcAAaQM!\u0001Fa\rJ!%\u0011)Da\u000f\u0002\\9\u000by,\u0004\u0002\u00038)\u0019!\u0011H#\u0002\u000fI,h\u000e^5nK&!!Q\bB\u001c\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005_\tQ!\u00199qYf$b!a0\u0003F\t\u001d\u0003bBAZW\u0001\u0007\u00111\f\u0005\u0007\u0003s[\u0003\u0019\u0001(\u0002\u000fUt\u0017\r\u001d9msR!!Q\nB-!\u0015!%q\nB*\u0013\r\u0011\t&\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0011\u0013)&a\u0017O\u0013\r\u00119&\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tmC&!AA\u0002\u0005}\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0007\u0005\u0003\u0002|\t\r\u0014\u0002\u0002B3\u0003{\u0012aa\u00142kK\u000e$\u0018!\u00038pe6\fG.\u001b>f)\u0011\tYCa\u001b\t\u000f\u0005%b\u00061\u0001\u0002,Q!\u00111\u0006B8\u0011\u001d\t9e\fa\u0001\u0003\u0013\n!B]1oI>l\u0017J\\5u)\u0011\tYC!\u001e\t\u000f\t]\u0004\u00071\u0001\u0002,\u0005\tq-\u0001\tj]&$H)Z4sK\u00164Vm\u0019;peR!\u00111\u0006B?\u0011\u001d\u00119(\ra\u0001\u0003W\t\u0011\u0002]8xKJLE/\u001a:\u0015\r\t\r%\u0011\u0012BF!\u0019\tiC!\"\u00028%!!qQA\u0018\u0005%1VM\u001d;fqJ#E\tC\u0004\u0003xI\u0002\r!a\u000b\t\u000be\u0013\u0004\u0019\u0001(\u0002\r-lU-\u00198t)\u0019\u0011\tJa%\u0003\u0018B)\u0011Q\u0006BC\u001d\"9!QS\u001aA\u0002\t\r\u0015!\u0001<\t\u000b1\u001b\u0004\u0019\u0001(\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u0004'\nu\u0005b\u0002B<i\u0001\u0007!q\u0014\u0019\u0007\u0005C\u00139K!.\u0011\u0011\u00055\u00121\u0007BR\u0005g\u0003BA!*\u0003(2\u0001A\u0001\u0004BU\u0005;\u000b\t\u0011!A\u0003\u0002\t-&aA0%cE!!QVA}!\r!%qV\u0005\u0004\u0005c+%a\u0002(pi\"Lgn\u001a\t\u0005\u0005K\u0013)\f\u0002\u0007\u00038\nu\u0015\u0011!A\u0001\u0006\u0003\u0011YKA\u0002`IIB3\u0001\u0006=\u007fQ\r\u0019\u0002P ")
public class PowerIterationClustering
implements scala.Serializable {
    private int k;
    private int maxIterations;
    private String initMode;

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initMode() {
        return this.initMode;
    }

    private void initMode_$eq(String x$1) {
        this.initMode = x$1;
    }

    public PowerIterationClustering setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public PowerIterationClustering setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public PowerIterationClustering setInitializationMode(String mode) {
        String string = mode;
        boolean bl = "random".equals(string) ? true : "degree".equals(string);
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid initialization mode: ").append(mode).toString());
        }
        String string2 = mode;
        this.initMode_$eq(string2);
        return this;
    }

    public PowerIterationClusteringModel run(Graph<Object, Object> graph) {
        Graph<Object, Object> graph2;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(graph);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph2;
        w.unpersist(w.unpersist$default$1());
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(RDD<Tuple3<Object, Object, Object>> similarities) {
        Graph<Object, Object> graph;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(similarities);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph;
        w.unpersist(w.unpersist$default$1());
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(JavaRDD<Tuple3<Long, Long, Double>> similarities) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)similarities.rdd());
    }

    private PowerIterationClusteringModel pic(Graph<Object, Object> w) {
        VertexRDD<Object> v = PowerIterationClustering$.MODULE$.powerIter(w, this.maxIterations());
        RDD assignments = PowerIterationClustering$.MODULE$.kMeans(v, this.k()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            int cluster = tuple2._2$mcI$sp();
            Assignment assignment = new Assignment(id, cluster);
            return assignment;
        }, ClassTag$.MODULE$.apply(Assignment.class));
        return new PowerIterationClusteringModel(this.k(), (RDD<Assignment>)assignments);
    }

    public PowerIterationClustering(int k, int maxIterations, String initMode) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initMode = initMode;
    }

    public PowerIterationClustering() {
        this(2, 100, "random");
    }

    public static class Assignment
    implements Product,
    scala.Serializable {
        private final long id;
        private final int cluster;

        public long id() {
            return this.id;
        }

        public int cluster() {
            return this.cluster;
        }

        public Assignment copy(long id, int cluster) {
            return new Assignment(id, cluster);
        }

        public long copy$default$1() {
            return this.id();
        }

        public int copy$default$2() {
            return this.cluster();
        }

        public String productPrefix() {
            return "Assignment";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                case 0: {
                    number = BoxesRunTime.boxToLong((long)this.id());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.cluster());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Assignment;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)this.cluster());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Assignment)) return false;
            boolean bl = true;
            if (!bl) return false;
            Assignment assignment = (Assignment)x$1;
            if (this.id() != assignment.id()) return false;
            if (this.cluster() != assignment.cluster()) return false;
            if (!assignment.canEqual(this)) return false;
            return true;
        }

        public Assignment(long id, int cluster) {
            this.id = id;
            this.cluster = cluster;
            Product.$init$((Product)this);
        }
    }
}

