/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassifier$;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeClassifierParams;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tE\u0011\u0005\t3\u0002\u0011\t\u0011)A\u0005\u0007\")1\f\u0001C\u00019\")1\f\u0001C\u0001A\")!\r\u0001C\u0001G\")A\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001k\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0015\u0002F!A\u0011q\u000e\u0001\u0005\u0002u\t\t\bC\u0004\u0002\u0014\u0002!\t%!&\b\u000f\u0005=6\u0004#\u0001\u00022\u001a1!d\u0007E\u0001\u0003gCaa\u0017\u000b\u0005\u0002\u0005\u001d\u0007\"CAe)\t\u0007IQAAf\u0011!\t)\u000e\u0006Q\u0001\u000e\u00055\u0007bBAm)\u0011\u0005\u00131\u001c\u0005\n\u0003O$\u0012\u0011!C\u0005\u0003S\u0014a\u0003R3dSNLwN\u001c+sK\u0016\u001cE.Y:tS\u001aLWM\u001d\u0006\u00039u\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u001f?\u0005\u0011Q\u000e\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011\u0003\u0002\u0001(km\u0002R\u0001K\u0015,cIj\u0011aG\u0005\u0003Um\u0011q\u0003\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017.\u001a:\u0011\u00051zS\"A\u0017\u000b\u00059j\u0012A\u00027j]\u0006dw-\u0003\u00021[\t1a+Z2u_J\u0004\"\u0001\u000b\u0001\u0011\u0005!\u001a\u0014B\u0001\u001b\u001c\u0005}!UmY5tS>tGK]3f\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003mej\u0011a\u000e\u0006\u0003qu\tA\u0001\u001e:fK&\u0011!h\u000e\u0002\u001d\t\u0016\u001c\u0017n]5p]R\u0013X-Z\"mCN\u001c\u0018NZ5feB\u000b'/Y7t!\tat(D\u0001>\u0015\tqT$\u0001\u0003vi&d\u0017B\u0001!>\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005\u0019\u0005C\u0001#N\u001d\t)5\n\u0005\u0002G\u00136\tqI\u0003\u0002IK\u00051AH]8pizR\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u000ba\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A*\u0013\u0015\u0004\u0003E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+ \u0003)\tgN\\8uCRLwN\\\u0005\u0003-N\u0013QaU5oG\u0016\f\u0013\u0001W\u0001\u0006c9\"d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003#^\u000ba\u0001P5oSRtDCA\u0019^\u0011\u0015\t5\u00011\u0001DQ\ri\u0016k\u0016\u0015\u0004\u0007E;F#A\u0019)\u0007\u0011\tv+A\u0006tKRl\u0015\r\u001f#faRDGC\u00013f\u001b\u0005\u0001\u0001\"\u00024\u0006\u0001\u00049\u0017!\u0002<bYV,\u0007C\u00015j\u001b\u0005I\u0015B\u00016J\u0005\rIe\u000e\u001e\u0015\u0004\u000bE;\u0016AC:fi6\u000b\u0007PQ5ogR\u0011AM\u001c\u0005\u0006M\u001a\u0001\ra\u001a\u0015\u0004\rE;\u0016AF:fi6Kg.\u00138ti\u0006t7-Z:QKJtu\u000eZ3\u0015\u0005\u0011\u0014\b\"\u00024\b\u0001\u00049\u0007fA\u0004R/\u0006Y2/\u001a;NS:<V-[4ii\u001a\u0013\u0018m\u0019;j_:\u0004VM\u001d(pI\u0016$\"\u0001\u001a<\t\u000b\u0019D\u0001\u0019A<\u0011\u0005!D\u0018BA=J\u0005\u0019!u.\u001e2mK\"\u001a\u0001\"U>\"\u0003q\fQa\r\u00181]A\nab]3u\u001b&t\u0017J\u001c4p\u000f\u0006Lg\u000e\u0006\u0002e\u007f\")a-\u0003a\u0001o\"\u001a\u0011\"U,\u0002!M,G/T1y\u001b\u0016lwN]=J]6\u0013Ec\u00013\u0002\b!)aM\u0003a\u0001O\"\u001a!\"U,\u0002\u001fM,GoQ1dQ\u0016tu\u000eZ3JIN$2\u0001ZA\b\u0011\u001917\u00021\u0001\u0002\u0012A\u0019\u0001.a\u0005\n\u0007\u0005U\u0011JA\u0004C_>dW-\u00198)\u0007-\tv+A\u000btKR\u001c\u0005.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197\u0015\u0007\u0011\fi\u0002C\u0003g\u0019\u0001\u0007q\rK\u0002\r#^\u000b1b]3u\u00136\u0004XO]5usR\u0019A-!\n\t\u000b\u0019l\u0001\u0019A\")\u00075\tv+A\u0004tKR\u001cV-\u001a3\u0015\u0007\u0011\fi\u0003\u0003\u0004g\u001d\u0001\u0007\u0011q\u0006\t\u0004Q\u0006E\u0012bAA\u001a\u0013\n!Aj\u001c8hQ\u0011q\u0011+a\u000e\"\u0005\u0005e\u0012!B\u0019/m9\u0002\u0014\u0001D:fi^+\u0017n\u001a5u\u0007>dGc\u00013\u0002@!)am\u0004a\u0001\u0007\"\u001aq\"U>\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0007I\n9\u0005C\u0004\u0002JA\u0001\r!a\u0013\u0002\u000f\u0011\fG/Y:fiB\"\u0011QJA/!\u0019\ty%!\u0016\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'z\u0012aA:rY&!\u0011qKA)\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0017\u0002^1\u0001A\u0001DA0\u0003\u000f\n\t\u0011!A\u0003\u0002\u0005\u0005$aA0%cE!\u00111MA5!\rA\u0017QM\u0005\u0004\u0003OJ%a\u0002(pi\"Lgn\u001a\t\u0004Q\u0006-\u0014bAA7\u0013\n\u0019\u0011I\\=\u0002\u001d\u001d,Go\u00147e'R\u0014\u0018\r^3hsR1\u00111OAC\u0003\u001f\u0003B!!\u001e\u0002\u00026\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0004q\u0005u$bAA@?\u0005)Q\u000e\u001c7jE&!\u00111QA<\u0005!\u0019FO]1uK\u001eL\bbBAD#\u0001\u0007\u0011\u0011R\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0006\t\u0006-umZ\u0005\u0004\u0003\u001b{%aA'ba\"1\u0011\u0011S\tA\u0002\u001d\f!B\\;n\u00072\f7o]3t\u0003\u0011\u0019w\u000e]=\u0015\u0007E\n9\nC\u0004\u0002\u001aJ\u0001\r!a'\u0002\u000b\u0015DHO]1\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)\u001e\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t)+a(\u0003\u0011A\u000b'/Y7NCBDCAE)\u0002*\u0006\u0012\u00111V\u0001\u0006c9\"d&\r\u0015\u0004\u0001E;\u0016A\u0006#fG&\u001c\u0018n\u001c8Ue\u0016,7\t\\1tg&4\u0017.\u001a:\u0011\u0005!\"2c\u0002\u000b\u00026\u0006m\u0016\u0011\u0019\t\u0004Q\u0006]\u0016bAA]\u0013\n1\u0011I\\=SK\u001a\u0004B\u0001PA_c%\u0019\u0011qX\u001f\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019\u0001.a1\n\u0007\u0005\u0015\u0017J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u00022\u0006\u00192/\u001e9q_J$X\rZ%naV\u0014\u0018\u000e^5fgV\u0011\u0011Q\u001a\t\u0005Q\u0006=7)C\u0002\u0002R&\u0013Q!\u0011:sCfD3AF)X\u0003Q\u0019X\u000f\u001d9peR,G-S7qkJLG/[3tA!\u001aq#U,\u0002\t1|\u0017\r\u001a\u000b\u0004c\u0005u\u0007BBAp1\u0001\u00071)\u0001\u0003qCRD\u0007\u0006\u0002\rR\u0003G\f#!!:\u0002\u000bIr\u0003G\f\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003W\u0004B!!<\u0002x6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190\u0001\u0003mC:<'BAA{\u0003\u0011Q\u0017M^1\n\t\u0005e\u0018q\u001e\u0002\u0007\u001f\nTWm\u0019;)\u0007Q\tv\u000bK\u0002\u0014#^\u0003")
public class DecisionTreeClassifier
extends ProbabilisticClassifier<Vector, DecisionTreeClassifier, DecisionTreeClassificationModel>
implements DecisionTreeClassifierParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> impurity;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static DecisionTreeClassifier load(String string) {
        return DecisionTreeClassifier$.MODULE$.load(string);
    }

    public static String[] supportedImpurities() {
        return DecisionTreeClassifier$.MODULE$.supportedImpurities();
    }

    public static MLReader<DecisionTreeClassifier> read() {
        return DecisionTreeClassifier$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DecisionTreeClassifier setMaxDepth(int value) {
        return (DecisionTreeClassifier)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public DecisionTreeClassifier setMaxBins(int value) {
        return (DecisionTreeClassifier)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    public DecisionTreeClassifier setMinInstancesPerNode(int value) {
        return (DecisionTreeClassifier)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    public DecisionTreeClassifier setMinWeightFractionPerNode(double value) {
        return (DecisionTreeClassifier)this.set(this.minWeightFractionPerNode(), BoxesRunTime.boxToDouble((double)value));
    }

    public DecisionTreeClassifier setMinInfoGain(double value) {
        return (DecisionTreeClassifier)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    public DecisionTreeClassifier setMaxMemoryInMB(int value) {
        return (DecisionTreeClassifier)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    public DecisionTreeClassifier setCacheNodeIds(boolean value) {
        return (DecisionTreeClassifier)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public DecisionTreeClassifier setCheckpointInterval(int value) {
        return (DecisionTreeClassifier)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    public DecisionTreeClassifier setImpurity(String value) {
        return (DecisionTreeClassifier)this.set(this.impurity(), value);
    }

    public DecisionTreeClassifier setSeed(long value) {
        return (DecisionTreeClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public DecisionTreeClassifier setWeightCol(String value) {
        return (DecisionTreeClassifier)this.set(this.weightCol(), value);
    }

    @Override
    public DecisionTreeClassificationModel train(Dataset<?> dataset) {
        return (DecisionTreeClassificationModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
            int numClasses = this.getNumClasses(dataset, this.getNumClasses$default$2());
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            this.validateNumClasses(numClasses);
            RDD<Instance> instances = this.extractInstances(dataset, numClasses);
            Strategy strategy = this.getOldStrategy(categoricalFeatures, numClasses);
            Predef$.MODULE$.require(!strategy.bootstrap(), (Function0 & Serializable & scala.Serializable)() -> "DecisionTreeClassifier does not need bootstrap sampling");
            instr.logNumClasses(numClasses);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.leafCol(), this.maxDepth(), this.maxBins(), this.minInstancesPerNode(), this.minInfoGain(), this.maxMemoryInMB(), this.cacheNodeIds(), this.checkpointInterval(), this.impurity(), this.seed(), this.thresholds()}));
            RDD<Instance> x$1 = instances;
            Strategy x$2 = strategy;
            int x$3 = 1;
            String x$4 = "all";
            long x$5 = BoxesRunTime.unboxToLong((Object)this.$(this.seed()));
            Some x$6 = new Some(instr);
            Some x$7 = new Some((Object)this.uid());
            boolean x$8 = RandomForest$.MODULE$.run$default$7();
            DecisionTreeModel[] trees = RandomForest$.MODULE$.run(x$1, x$2, x$3, x$4, x$5, (Option<Instrumentation>)x$6, x$8, (Option<String>)x$7);
            return (DecisionTreeClassificationModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).head();
        });
    }

    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, Algo$.MODULE$.Classification(), this.getOldImpurity(), 1.0);
    }

    @Override
    public DecisionTreeClassifier copy(ParamMap extra) {
        return (DecisionTreeClassifier)this.defaultCopy(extra);
    }

    public DecisionTreeClassifier(String uid) {
        this.uid = uid;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeClassifierParams.$init$(this);
        DecisionTreeClassifierParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public DecisionTreeClassifier() {
        this(Identifiable$.MODULE$.randomUID("dtc"));
    }
}

