import gunicorn.app.base
from gunicorn.six import iteritems

from openeo_driver.views import app

"""
Script to start a production server. This script can serve as the entry-point for doing spark-submit.
"""


def number_of_workers():
    return 4#(multiprocessing.cpu_count() * 2) + 1


class StandaloneApplication(gunicorn.app.base.BaseApplication):

    def __init__(self, app, options=None):
        self.options = options or {}
        self.application = app
        super(StandaloneApplication, self).__init__()

    def load_config(self):
        config = dict([(key, value) for key, value in iteritems(self.options)
                       if key in self.cfg.settings and value is not None])
        for key, value in iteritems(config):
            self.cfg.set(key.lower(), value)

    def load(self):
        return self.application


if __name__ == '__main__':
    options = {
        'bind': '%s:%s' % ('127.0.0.1', '0'),
        'workers': number_of_workers(),
        'worker_class':'gaiohttp',
        'timeout':1000
    }
    # Modification 3: pass Flask app instead of handler_app
    StandaloneApplication(app, options).run()