import importlib.metadata
import random

import numpy as np
import xarray as xr

__version__ = importlib.metadata.version("evotrain")

BANDS_L2A = {
    10: ["B02", "B03", "B04", "B08"],
    20: ["B05", "B06", "B07", "B8A", "B11", "B12"],
    60: ["B01", "B09"],
}

BANDS_L2A_ALL = BANDS_L2A[10] + BANDS_L2A[20] + BANDS_L2A[60]


def logistic(x, L=1, k=3.60, x0=0, y0=-0.5, s=2):
    return (L / (1 + np.exp(-k * (x - x0))) + y0) * s


def random_uniform_jitter(n):
    return random.uniform(-n, n)


def random_normal_jitter(std, mean=0):
    return random.normalvariate(mean, std)
