/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.vlm;

import geopyspark.geotrellis.GlobalLayout;
import geopyspark.geotrellis.LayoutType;
import geopyspark.geotrellis.LocalLayout;
import geopyspark.geotrellis.PartitionStrategy;
import geopyspark.geotrellis.ProjectedRasterLayer;
import geopyspark.geotrellis.ProjectedRasterLayer$;
import geopyspark.geotrellis.SpatialTiledRasterLayer;
import geopyspark.geotrellis.SpatialTiledRasterLayer$;
import geopyspark.geotrellis.vlm.SourceInfo;
import geotrellis.layer.FloatingLayoutScheme;
import geotrellis.layer.FloatingLayoutScheme$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.LayoutTileSource;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.layer.package$;
import geotrellis.proj4.CRS;
import geotrellis.proj4.CRS$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.GridExtent;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterSource;
import geotrellis.raster.ReadingSource;
import geotrellis.raster.ResampleTarget;
import geotrellis.raster.gdal.GDALPath$;
import geotrellis.raster.gdal.GDALRasterSource;
import geotrellis.raster.gdal.GDALRasterSource$;
import geotrellis.raster.geotiff.GeoTiffPath$;
import geotrellis.raster.geotiff.GeoTiffRasterSource;
import geotrellis.raster.geotiff.GeoTiffRasterSource$;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.RasterSourceRDD$;
import geotrellis.spark.RasterSummary;
import geotrellis.spark.RasterSummary$;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;

public final class RasterSource$ {
    public static RasterSource$ MODULE$;

    static {
        new RasterSource$();
    }

    public ProjectedRasterLayer read(SparkContext sc, String layerType, ArrayList<String> paths, String targetCRS, Integer numPartitions, ResampleMethod resampleMethod, String readMethod) {
        Option option;
        Seq scalaPaths = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).toSeq();
        Integer n = numPartitions;
        if (n != null) {
            Integer n2 = n;
            option = new Some<Integer>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(n2)));
        } else if (n == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(n);
        }
        None$ partitions = option;
        return this.read(sc, layerType, (RDD<String>)sc.parallelize(scalaPaths, BoxesRunTime.unboxToInt(partitions.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> scalaPaths.size())), ClassTag$.MODULE$.apply(String.class)), targetCRS, resampleMethod, readMethod);
    }

    public ProjectedRasterLayer read(SparkContext sc, String layerType, RDD<String> rdd, String targetCRS, ResampleMethod resampleMethod, String readMethod) {
        RDD rDD;
        RDD rDD2;
        String string = readMethod;
        if ("GeoTrellis".equals(string)) {
            rDD2 = rdd.map((Function1<String, RasterSource> & Serializable & scala.Serializable)x$1 -> new GeoTiffRasterSource(GeoTiffPath$.MODULE$.toGeoTiffDataPath(x$1), GeoTiffRasterSource$.MODULE$.$lessinit$greater$default$2(), GeoTiffRasterSource$.MODULE$.$lessinit$greater$default$3()), ClassTag$.MODULE$.apply(RasterSource.class));
        } else if ("GDAL".equals(string)) {
            rDD2 = rdd.map((Function1<String, RasterSource> & Serializable & scala.Serializable)x$2 -> GDALRasterSource$.MODULE$.apply(GDALPath$.MODULE$.toGDALDataPath(x$2), GDALRasterSource$.MODULE$.apply$default$2(), GDALRasterSource$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(RasterSource.class));
        } else {
            throw new MatchError((Object)string);
        }
        RDD rasterSourceRDD = rDD2.cache();
        String string2 = targetCRS;
        if (string2 != null) {
            String string3 = string2;
            rDD = rasterSourceRDD.map((Function1<RasterSource, RasterSource> & Serializable & scala.Serializable)x$3 -> {
                CRS x$1 = CRS$.MODULE$.fromString(string3);
                ResampleMethod x$2 = resampleMethod;
                ResampleTarget x$32 = x$3.reproject$default$2();
                OverviewStrategy x$4 = x$3.reproject$default$4();
                return x$3.reproject(x$1, x$32, x$2, x$4);
            }, ClassTag$.MODULE$.apply(RasterSource.class));
        } else if (string2 == null) {
            rDD = rasterSourceRDD;
        } else {
            throw new MatchError((Object)string2);
        }
        RDD reprojectedSourcesRDD = rDD;
        RDD projectedRasterRDD = reprojectedSourcesRDD.flatMap((Function1<RasterSource, TraversableOnce> & Serializable & scala.Serializable)source -> {
            Iterable<Serializable> iterable;
            Option option = source.read(source.extent());
            if (option instanceof Some) {
                Some some = (Some)option;
                Raster raster = (Raster)some.value();
                iterable = Option$.MODULE$.option2Iterable(new Some<Tuple2<ProjectedExtent, CellGrid>>(new Tuple2<ProjectedExtent, CellGrid>(new ProjectedExtent(raster.extent(), source.crs()), raster.tile())));
            } else if (None$.MODULE$.equals(option)) {
                iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            return iterable;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        rasterSourceRDD.unpersist(rasterSourceRDD.unpersist$default$1());
        return ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)projectedRasterRDD);
    }

    public SpatialTiledRasterLayer readToLayout(SparkContext sc, String layerType, ArrayList<String> paths, LayoutType layoutType, String targetCRS, Integer numPartitions, ResampleMethod resampleMethod, String readMethod) {
        Option option;
        Seq scalaPaths = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).toSeq();
        Integer n = numPartitions;
        if (n != null) {
            Integer n2 = n;
            option = new Some<Integer>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(n2)));
        } else if (n == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(n);
        }
        None$ partitions = option;
        return this.readToLayout(sc, layerType, (RDD<String>)sc.parallelize(scalaPaths, BoxesRunTime.unboxToInt(partitions.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> scalaPaths.size())), ClassTag$.MODULE$.apply(String.class)), this.gps2VLM(layoutType), targetCRS, resampleMethod, readMethod);
    }

    public SpatialTiledRasterLayer readToLayout(SparkContext sc, String layerType, RDD<String> rdd, geotrellis.layer.LayoutType layoutType, String targetCRS, ResampleMethod resampleMethod, String readMethod) {
        LayoutLevel layoutLevel;
        RDD rDD;
        RDD rDD2;
        String string = readMethod;
        if ("GeoTrellis".equals(string)) {
            rDD2 = rdd.map((Function1<String, RasterSource> & Serializable & scala.Serializable)x$4 -> new GeoTiffRasterSource(GeoTiffPath$.MODULE$.toGeoTiffDataPath(x$4), GeoTiffRasterSource$.MODULE$.$lessinit$greater$default$2(), GeoTiffRasterSource$.MODULE$.$lessinit$greater$default$3()), ClassTag$.MODULE$.apply(RasterSource.class));
        } else if ("GDAL".equals(string)) {
            rDD2 = rdd.map((Function1<String, RasterSource> & Serializable & scala.Serializable)x$5 -> GDALRasterSource$.MODULE$.apply(GDALPath$.MODULE$.toGDALDataPath(x$5), GDALRasterSource$.MODULE$.apply$default$2(), GDALRasterSource$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(RasterSource.class));
        } else {
            throw new MatchError((Object)string);
        }
        RDD rasterSourceRDD = rDD2.cache();
        String string2 = targetCRS;
        if (string2 != null) {
            String string3 = string2;
            rDD = rasterSourceRDD.map((Function1<RasterSource, RasterSource> & Serializable & scala.Serializable)x$6 -> {
                CRS x$1 = CRS$.MODULE$.fromString(string3);
                ResampleMethod x$2 = resampleMethod;
                ResampleTarget x$3 = x$6.reproject$default$2();
                OverviewStrategy x$4 = x$6.reproject$default$4();
                return x$6.reproject(x$1, x$3, x$2, x$4);
            }, ClassTag$.MODULE$.apply(RasterSource.class));
        } else if (string2 == null) {
            rDD = rasterSourceRDD;
        } else {
            throw new MatchError((Object)string2);
        }
        RDD reprojectedSourcesRDD = rDD;
        RasterSummary metadata = RasterSummary$.MODULE$.fromRDD(reprojectedSourcesRDD);
        geotrellis.layer.LayoutType layoutType2 = layoutType;
        if (layoutType2 instanceof geotrellis.layer.GlobalLayout) {
            geotrellis.layer.GlobalLayout globalLayout = (geotrellis.layer.GlobalLayout)layoutType2;
            ZoomedLayoutScheme scheme = ZoomedLayoutScheme$.MODULE$.apply(metadata.crs(), globalLayout.tileSize(), ZoomedLayoutScheme$.MODULE$.apply$default$3());
            layoutLevel = scheme.levelForZoom(globalLayout.zoom());
        } else if (layoutType2 instanceof geotrellis.layer.LocalLayout) {
            geotrellis.layer.LocalLayout localLayout = (geotrellis.layer.LocalLayout)layoutType2;
            FloatingLayoutScheme scheme = FloatingLayoutScheme$.MODULE$.apply(localLayout.tileCols(), localLayout.tileRows());
            layoutLevel = metadata.levelFor((LayoutScheme)scheme);
        } else {
            throw new MatchError(layoutType2);
        }
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError(layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2<Integer, LayoutDefinition> tuple2 = new Tuple2<Integer, LayoutDefinition>(BoxesRunTime.boxToInteger(zoom), layout);
        Tuple2<Integer, LayoutDefinition> tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = tuple22._2();
        RDD layoutRDD = reprojectedSourcesRDD.map((Function1<RasterSource, LayoutTileSource> & Serializable & scala.Serializable)x$8 -> package$.MODULE$.TileToLayoutOps(x$8).tileToLayout(layout2, resampleMethod), ClassTag$.MODULE$.apply(LayoutTileSource.class));
        TileLayerMetadata tileLayerMetadata = metadata.toTileLayerMetadata(layout2);
        RDD tiledRDD = layoutRDD.flatMap((Function1<LayoutTileSource, Iterator> & Serializable & scala.Serializable)x$9 -> x$9.readAll(), ClassTag$.MODULE$.apply(Tuple2.class));
        rasterSourceRDD.unpersist(rasterSourceRDD.unpersist$default$1());
        RDD contextRDD = ContextRDD$.MODULE$.apply(tiledRDD, (Object)tileLayerMetadata);
        return SpatialTiledRasterLayer$.MODULE$.apply(Predef$.MODULE$.int2Integer(zoom2), (RDD<Tuple2<SpatialKey, MultibandTile>>)contextRDD);
    }

    public SpatialTiledRasterLayer readOrderedToLayout(SparkContext sc, ArrayList<SourceInfo> paths, LayoutType layoutType, String targetCRS, Integer numPartitions, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy, String readMethod) {
        LayoutLevel layoutLevel;
        Function1<String, RasterSource> & Serializable & scala.Serializable intersect;
        Option option;
        Option option2;
        Option option3;
        Seq scalaSources = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).toSeq();
        Integer n = numPartitions;
        if (n != null) {
            Integer n2 = n;
            option3 = new Some<Integer>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(n2)));
        } else if (n == null) {
            option3 = None$.MODULE$;
        } else {
            throw new MatchError(n);
        }
        None$ partitions = option3;
        PartitionStrategy partitionStrategy2 = partitionStrategy;
        if (partitionStrategy2 != null) {
            PartitionStrategy partitionStrategy3 = partitionStrategy2;
            option2 = partitionStrategy3.producePartitioner(BoxesRunTime.unboxToInt(partitions.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> scalaSources.size())));
        } else if (partitionStrategy2 == null) {
            option2 = None$.MODULE$;
        } else {
            throw new MatchError(partitionStrategy2);
        }
        None$ partitioner = option2;
        String string = targetCRS;
        if (string != null) {
            String string2 = string;
            option = new Some<CRS>(CRS$.MODULE$.fromString(string2));
        } else if (string == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        None$ crs = option;
        String string3 = readMethod;
        if ("GeoTrellis".equals(string3)) {
            Function1<String, RasterSource> & Serializable & scala.Serializable intersect2;
            None$ none$ = crs;
            if (none$ instanceof Some) {
                Some some = (Some)((Object)none$);
                CRS projection = (CRS)some.value();
                intersect2 = (Function1<String, RasterSource> & Serializable & scala.Serializable)path -> {
                    GeoTiffRasterSource qual$1 = GeoTiffRasterSource$.MODULE$.apply(GeoTiffPath$.MODULE$.toGeoTiffDataPath(path), GeoTiffRasterSource$.MODULE$.apply$default$2(), GeoTiffRasterSource$.MODULE$.apply$default$3());
                    CRS x$1 = projection;
                    ResampleMethod x$2 = resampleMethod;
                    ResampleTarget x$3 = qual$1.reproject$default$2();
                    OverviewStrategy x$4 = qual$1.reproject$default$4();
                    return qual$1.reproject(x$1, x$3, x$2, x$4);
                };
            } else if (None$.MODULE$.equals(none$)) {
                intersect2 = (Function1<String, RasterSource> & Serializable & scala.Serializable)path -> GeoTiffRasterSource$.MODULE$.apply(GeoTiffPath$.MODULE$.toGeoTiffDataPath(path), GeoTiffRasterSource$.MODULE$.apply$default$2(), GeoTiffRasterSource$.MODULE$.apply$default$3());
            } else {
                throw new MatchError(none$);
            }
            intersect = intersect2;
        } else if ("GDAL".equals(string3)) {
            Function1<String, RasterSource> & Serializable & scala.Serializable intersect3;
            None$ none$ = crs;
            if (none$ instanceof Some) {
                Some some = (Some)((Object)none$);
                CRS projection = (CRS)some.value();
                intersect3 = (Function1<String, RasterSource> & Serializable & scala.Serializable)path -> {
                    GDALRasterSource qual$2 = GDALRasterSource$.MODULE$.apply(GDALPath$.MODULE$.toGDALDataPath(path), GDALRasterSource$.MODULE$.apply$default$2(), GDALRasterSource$.MODULE$.apply$default$3());
                    CRS x$5 = projection;
                    ResampleMethod x$6 = resampleMethod;
                    ResampleTarget x$7 = qual$2.reproject$default$2();
                    OverviewStrategy x$8 = qual$2.reproject$default$4();
                    return qual$2.reproject(x$5, x$7, x$6, x$8);
                };
            } else if (None$.MODULE$.equals(none$)) {
                intersect3 = (Function1<String, RasterSource> & Serializable & scala.Serializable)path -> GDALRasterSource$.MODULE$.apply(GDALPath$.MODULE$.toGDALDataPath(path), GDALRasterSource$.MODULE$.apply$default$2(), GDALRasterSource$.MODULE$.apply$default$3());
            } else {
                throw new MatchError(none$);
            }
            intersect = intersect3;
        } else {
            throw new MatchError((Object)string3);
        }
        Function1<String, RasterSource> & Serializable & scala.Serializable transformSource = intersect;
        RDD sourceInfoRDD = sc.parallelize(scalaSources, BoxesRunTime.unboxToInt(partitions.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> scalaSources.size())), ClassTag$.MODULE$.apply(SourceInfo.class));
        RDD readingSourcesRDD = sourceInfoRDD.map((Function1<SourceInfo, ReadingSource> & Serializable & scala.Serializable)source -> {
            RasterSource rasterSource = (RasterSource)transformSource.apply(source.source());
            return new ReadingSource(rasterSource, source.sourceToTargetBand());
        }, ClassTag$.MODULE$.apply(ReadingSource.class));
        RDD sourcesRDD = readingSourcesRDD.map((Function1<ReadingSource, RasterSource> & Serializable & scala.Serializable)x$10 -> x$10.source(), ClassTag$.MODULE$.apply(RasterSource.class));
        RasterSummary rasterSummary = RasterSummary$.MODULE$.fromRDD(sourcesRDD);
        LayoutType layoutType2 = layoutType;
        if (layoutType2 instanceof GlobalLayout) {
            GlobalLayout globalLayout = (GlobalLayout)layoutType2;
            ZoomedLayoutScheme scheme = ZoomedLayoutScheme$.MODULE$.apply(rasterSummary.crs(), globalLayout.tileSize(), ZoomedLayoutScheme$.MODULE$.apply$default$3());
            layoutLevel = scheme.levelForZoom(Predef$.MODULE$.Integer2int(globalLayout.zoom()));
        } else if (layoutType2 instanceof LocalLayout) {
            LocalLayout localLayout = (LocalLayout)layoutType2;
            FloatingLayoutScheme scheme = FloatingLayoutScheme$.MODULE$.apply(localLayout.tileCols(), localLayout.tileRows());
            layoutLevel = rasterSummary.levelFor((LayoutScheme)scheme);
        } else {
            throw new MatchError(layoutType2);
        }
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError(layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2<Integer, LayoutDefinition> tuple2 = new Tuple2<Integer, LayoutDefinition>(BoxesRunTime.boxToInteger(zoom), layout);
        Tuple2<Integer, LayoutDefinition> tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = tuple22._2();
        RDD resampledSourcesRDD = readingSourcesRDD.map((Function1<ReadingSource, ReadingSource> & Serializable & scala.Serializable)source -> {
            RasterSource resampledSource = source.source().resampleToGrid((GridExtent)layout2, resampleMethod, source.source().resampleToGrid$default$3());
            return source.copy(resampledSource, source.copy$default$2());
        }, ClassTag$.MODULE$.apply(ReadingSource.class));
        RDD result = RasterSourceRDD$.MODULE$.read(resampledSourcesRDD, layout2, (Option)partitioner, sc);
        return SpatialTiledRasterLayer$.MODULE$.apply(Predef$.MODULE$.int2Integer(zoom2), (RDD<Tuple2<SpatialKey, MultibandTile>>)result);
    }

    public geotrellis.layer.LayoutType gps2VLM(LayoutType layoutType) {
        geotrellis.layer.LocalLayout localLayout;
        LayoutType layoutType2 = layoutType;
        if (layoutType2 instanceof LocalLayout) {
            LocalLayout localLayout2 = (LocalLayout)layoutType2;
            localLayout = new geotrellis.layer.LocalLayout(localLayout2.tileCols(), localLayout2.tileRows());
        } else if (layoutType2 instanceof GlobalLayout) {
            GlobalLayout globalLayout = (GlobalLayout)layoutType2;
            localLayout = new geotrellis.layer.GlobalLayout(globalLayout.tileSize(), Predef$.MODULE$.Integer2int(globalLayout.zoom()), globalLayout.threshold());
        } else {
            throw new MatchError(layoutType2);
        }
        return localLayout;
    }

    private RasterSource$() {
        MODULE$ = this;
    }
}

