/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.tms;

import akka.actor.ActorSystem;
import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.tms.TileReader;
import geopyspark.geotrellis.tms.TileReaders;
import geotrellis.layer.SpatialKey;
import geotrellis.raster.MultibandTile;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerHeader;
import geotrellis.store.LayerHeader$;
import geotrellis.store.LayerId;
import geotrellis.store.ValueReader;
import geotrellis.store.ValueReader$;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering$Int$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class TileReaders$ {
    public static TileReaders$ MODULE$;

    static {
        new TileReaders$();
    }

    public MultibandTile geopyspark$geotrellis$tms$TileReaders$$rezoom(int zoom, int x, int y, int maxZoom, Function1<SpatialKey, MultibandTile> read) {
        int dz = zoom - maxZoom;
        SpatialKey key = new SpatialKey((int)((double)x / package$.MODULE$.pow(2.0, dz)), (int)((double)y / package$.MODULE$.pow(2.0, dz)));
        int dx = x - key._1() * (int)package$.MODULE$.pow(2.0, dz);
        int dy = y - key._2() * (int)package$.MODULE$.pow(2.0, dz);
        MultibandTile tile = read.apply(key);
        int w = tile.cols$mcI$sp();
        int h = tile.rows$mcI$sp();
        int tw = (int)((double)w / package$.MODULE$.pow(2.0, dz));
        int th = (int)((double)h / package$.MODULE$.pow(2.0, dz));
        int x0 = tw * dx;
        int x1 = tw * (dx + 1);
        int y0 = th * dy;
        int y1 = th * (dy + 1);
        return (MultibandTile)geotrellis.raster.package$.MODULE$.withMultibandResampleMethods((MultibandTile)geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(tile).crop(x0, y0, x1, y1)).resample(w, h);
    }

    public TileReader createCatalogReader(String uriString, String layerName, boolean overzooming) {
        TileReader tileReader;
        URI uri = new URI(uriString);
        ValueReader valueReader = ValueReader$.MODULE$.apply(uri);
        AttributeStore attributeStore = valueReader.attributeStore();
        Seq ids = (Seq)attributeStore.layerIds().filter((Function1<LayerId, Object> & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean(TileReaders$.$anonfun$createCatalogReader$1(layerName, id)));
        Seq<Object> zoomLevels = ids.map((Function1<LayerId, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.zoom()), Seq$.MODULE$.canBuildFrom());
        int maxZoom = BoxesRunTime.unboxToInt(zoomLevels.max(Ordering$Int$.MODULE$));
        String valueClass = ((LayerHeader)attributeStore.readHeader((LayerId)ids.head(), LayerHeader$.MODULE$.layerHeaderDecoder())).valueClass();
        String string = valueClass;
        if ("geotrellis.raster.Tile".equals(string)) {
            tileReader = new TileReaders.CatalogTileReader((ValueReader<LayerId>)valueReader, layerName, overzooming, zoomLevels, maxZoom);
        } else if ("geotrellis.raster.MultibandTile".equals(string)) {
            tileReader = new TileReaders.CatalogMultibandTileReader((ValueReader<LayerId>)valueReader, layerName, overzooming, zoomLevels, maxZoom);
        } else {
            throw new MatchError((Object)string);
        }
        return tileReader;
    }

    public TileReader createSpatialRddReader(HashMap<Object, TiledRasterLayer<SpatialKey>> levels, ActorSystem system, boolean overzooming) {
        Map<Object, RDD<Tuple2<SpatialKey, MultibandTile>>> tiles = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(levels).mapValues((Function1<TiledRasterLayer, RDD> & Serializable & scala.Serializable)x$3 -> x$3.rdd());
        return new TileReaders.SpatialRddTileReader(tiles, system, overzooming);
    }

    public static final /* synthetic */ boolean $anonfun$createCatalogReader$1(String layerName$1, LayerId id) {
        String string = id.name();
        String string2 = layerName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private TileReaders$() {
        MODULE$ = this;
    }
}

