/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.protobufs;

import geopyspark.util.ProtoBufCodec;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteCells$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleCells$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.FloatArrayTile;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatCells$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntCells$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.PaddedTile;
import geotrellis.raster.RawArrayTile$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortCells$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteCells$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortCells$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import protos.tileMessages.ProtoCellType;
import protos.tileMessages.ProtoCellType$;
import protos.tileMessages.ProtoCellType$DataType$BIT$;
import protos.tileMessages.ProtoCellType$DataType$BYTE$;
import protos.tileMessages.ProtoCellType$DataType$DOUBLE$;
import protos.tileMessages.ProtoCellType$DataType$FLOAT$;
import protos.tileMessages.ProtoCellType$DataType$INT$;
import protos.tileMessages.ProtoCellType$DataType$SHORT$;
import protos.tileMessages.ProtoCellType$DataType$UBYTE$;
import protos.tileMessages.ProtoCellType$DataType$USHORT$;
import protos.tileMessages.ProtoTile;
import protos.tileMessages.ProtoTile$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2qAB\u0004\u0011\u0002\u0007\u0005a\u0002C\u0003\u0016\u0001\u0011\u0005a\u0003C\u0003\u001b\u0001\u0011\r1dB\u00035\u000f!\u0005QGB\u0003\u0007\u000f!\u0005q\u0007C\u0003:\t\u0011\u0005!H\u0001\u0007US2,\u0007K]8u_\n+hM\u0003\u0002\t\u0013\u0005I\u0001O]8u_\n,hm\u001d\u0006\u0003\u0015-\t!bZ3piJ,G\u000e\\5t\u0015\u0005a\u0011AC4f_BL8\u000f]1sW\u000e\u00011C\u0001\u0001\u0010!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\"\u0012a\u0006\t\u0003!aI!!G\t\u0003\tUs\u0017\u000e^\u0001\u0012i&dW\r\u0015:pi>\u0014UOZ\"pI\u0016\u001cW#\u0001\u000f\u0013\u0007uyqD\u0002\u0003\u001f\u0005\u0001a\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003\u0002\u0011$K1j\u0011!\t\u0006\u0003E-\tA!\u001e;jY&\u0011A%\t\u0002\u000e!J|Go\u001c\"vM\u000e{G-Z2\u0011\u0005\u0019RS\"A\u0014\u000b\u0005!J\u0013A\u0002:bgR,'OC\u0001\u000b\u0013\tYsE\u0001\u0003US2,\u0007CA\u00173\u001b\u0005q#BA\u00181\u00031!\u0018\u000e\\3NKN\u001c\u0018mZ3t\u0015\u0005\t\u0014A\u00029s_R|7/\u0003\u00024]\tI\u0001K]8u_RKG.Z\u0001\r)&dW\r\u0015:pi>\u0014UO\u001a\t\u0003m\u0011i\u0011aB\n\u0004\t=A\u0004C\u0001\u001c\u0001\u0003\u0019a\u0014N\\5u}Q\tQ\u0007")
public interface TileProtoBuf {
    public static /* synthetic */ ProtoBufCodec tileProtoBufCodec$(TileProtoBuf $this) {
        return $this.tileProtoBufCodec();
    }

    default public ProtoBufCodec<Tile, ProtoTile> tileProtoBufCodec() {
        return new ProtoBufCodec<Tile, ProtoTile>(null){

            private ProtoCellType cellTypeToMessage(DataType ct) {
                ProtoCellType protoCellType;
                DataType dataType = ct;
                if (BitCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$BIT$.MODULE$, -128.0, false);
                } else if (ByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$BYTE$.MODULE$, -128.0, true);
                } else if (ByteCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$BYTE$ x$1 = ProtoCellType$DataType$BYTE$.MODULE$;
                    boolean x$2 = false;
                    double x$3 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$1, x$3, x$2);
                } else if (dataType instanceof ByteUserDefinedNoDataCellType) {
                    ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)dataType;
                    byte v = byteUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$BYTE$.MODULE$, v, true);
                } else if (UByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$UBYTE$.MODULE$, 0.0, true);
                } else if (UByteCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$UBYTE$ x$4 = ProtoCellType$DataType$UBYTE$.MODULE$;
                    boolean x$5 = false;
                    double x$6 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$4, x$6, x$5);
                } else if (dataType instanceof UByteUserDefinedNoDataCellType) {
                    UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)dataType;
                    byte v = uByteUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$UBYTE$.MODULE$, v, true);
                } else if (ShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$SHORT$.MODULE$, -32768.0, true);
                } else if (ShortCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$SHORT$ x$7 = ProtoCellType$DataType$SHORT$.MODULE$;
                    boolean x$8 = false;
                    double x$9 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$7, x$9, x$8);
                } else if (dataType instanceof ShortUserDefinedNoDataCellType) {
                    ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)dataType;
                    short v = shortUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$SHORT$.MODULE$, v, true);
                } else if (UShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$USHORT$.MODULE$, 0.0, true);
                } else if (UShortCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$USHORT$ x$10 = ProtoCellType$DataType$USHORT$.MODULE$;
                    boolean x$11 = false;
                    double x$12 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$10, x$12, x$11);
                } else if (dataType instanceof UShortUserDefinedNoDataCellType) {
                    UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)dataType;
                    short v = uShortUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$USHORT$.MODULE$, v, true);
                } else if (IntConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$INT$.MODULE$, -2.147483648E9, true);
                } else if (IntCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$INT$ x$13 = ProtoCellType$DataType$INT$.MODULE$;
                    boolean x$14 = false;
                    double x$15 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$13, x$15, x$14);
                } else if (dataType instanceof IntUserDefinedNoDataCellType) {
                    IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)dataType;
                    int v = intUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$INT$.MODULE$, v, true);
                } else if (FloatConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$FLOAT$.MODULE$, Double.NaN, true);
                } else if (FloatCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$FLOAT$ x$16 = ProtoCellType$DataType$FLOAT$.MODULE$;
                    boolean x$17 = false;
                    double x$18 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$16, x$18, x$17);
                } else if (dataType instanceof FloatUserDefinedNoDataCellType) {
                    FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)dataType;
                    float v = floatUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$FLOAT$.MODULE$, v, true);
                } else if (DoubleConstantNoDataCellType$.MODULE$.equals(dataType)) {
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$DOUBLE$.MODULE$, Double.NaN, true);
                } else if (DoubleCellType$.MODULE$.equals(dataType)) {
                    ProtoCellType$DataType$DOUBLE$ x$19 = ProtoCellType$DataType$DOUBLE$.MODULE$;
                    boolean x$20 = false;
                    double x$21 = ProtoCellType$.MODULE$.apply$default$2();
                    protoCellType = new ProtoCellType(x$19, x$21, x$20);
                } else if (dataType instanceof DoubleUserDefinedNoDataCellType) {
                    DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)dataType;
                    double v = doubleUserDefinedNoDataCellType.noDataValue();
                    protoCellType = new ProtoCellType(ProtoCellType$DataType$DOUBLE$.MODULE$, v, true);
                } else {
                    throw new MatchError(dataType);
                }
                return protoCellType;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private DataType messageToCellType(ProtoCellType ctm) {
                ProtoCellType protoCellType = ctm;
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$BIT$.MODULE$.equals(dataType) && !bl) {
                        return BitCellType$.MODULE$;
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$BYTE$.MODULE$.equals(dataType) && bl) {
                        return (DataType)ByteCells$.MODULE$.withNoData(new Some<Byte>(BoxesRunTime.boxToByte((byte)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$BYTE$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)ByteCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$UBYTE$.MODULE$.equals(dataType) && bl) {
                        return (DataType)UByteCells$.MODULE$.withNoData(new Some<Byte>(BoxesRunTime.boxToByte((byte)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$UBYTE$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)UByteCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$SHORT$.MODULE$.equals(dataType) && bl) {
                        return (DataType)ShortCells$.MODULE$.withNoData(new Some<Short>(BoxesRunTime.boxToShort((short)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$SHORT$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)ShortCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$USHORT$.MODULE$.equals(dataType) && bl) {
                        return (DataType)UShortCells$.MODULE$.withNoData(new Some<Short>(BoxesRunTime.boxToShort((short)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$USHORT$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)UShortCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$INT$.MODULE$.equals(dataType) && bl) {
                        return (DataType)IntCells$.MODULE$.withNoData(new Some<Integer>(BoxesRunTime.boxToInteger((int)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$INT$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)IntCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$FLOAT$.MODULE$.equals(dataType) && bl) {
                        return (DataType)FloatCells$.MODULE$.withNoData(new Some<Float>(BoxesRunTime.boxToFloat((float)nd)));
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$FLOAT$.MODULE$.equals(dataType) && !bl) {
                        return (DataType)FloatCells$.MODULE$.withNoData((Option)None$.MODULE$);
                    }
                }
                if (protoCellType != null) {
                    ProtoCellType.DataType dataType = protoCellType.dataType();
                    double nd = protoCellType.nd();
                    boolean bl = protoCellType.hasNoData();
                    if (ProtoCellType$DataType$DOUBLE$.MODULE$.equals(dataType) && bl) {
                        return (DataType)DoubleCells$.MODULE$.withNoData(new Some<Double>(BoxesRunTime.boxToDouble(nd)));
                    }
                }
                if (protoCellType == null) throw new MatchError(protoCellType);
                ProtoCellType.DataType dataType = protoCellType.dataType();
                boolean bl = protoCellType.hasNoData();
                if (!ProtoCellType$DataType$DOUBLE$.MODULE$.equals(dataType)) throw new MatchError(protoCellType);
                if (false != bl) throw new MatchError(protoCellType);
                return (DataType)DoubleCells$.MODULE$.withNoData((Option)None$.MODULE$);
            }

            public ProtoTile encode(Tile targetTile) {
                ProtoTile protoTile;
                PaddedTile paddedTile;
                Tile chunk;
                ProtoCellType protoCellType = this.cellTypeToMessage(targetTile.cellType());
                Tile tile = targetTile;
                Object object = tile instanceof PaddedTile ? ((chunk = (paddedTile = (PaddedTile)tile).chunk()).cols() != paddedTile.cols() || chunk.rows() != paddedTile.rows() ? paddedTile.toArrayTile() : chunk) : targetTile;
                Tile tile2 = object;
                ProtoTile initialProtoTile = new ProtoTile(tile2.cols(), tile2.rows(), new Some<ProtoCellType>(protoCellType), ProtoTile$.MODULE$.apply$default$4(), ProtoTile$.MODULE$.apply$default$5(), ProtoTile$.MODULE$.apply$default$6(), ProtoTile$.MODULE$.apply$default$7());
                String string = protoCellType.dataType().toString();
                if ("BIT".equals(string)) {
                    protoTile = initialProtoTile.withUint32Cells(Predef$.MODULE$.wrapIntArray(tile2.toArray()));
                } else if ("BYTE".equals(string)) {
                    protoTile = initialProtoTile.withSint32Cells(Predef$.MODULE$.wrapIntArray(tile2.interpretAs((DataType)ByteCellType$.MODULE$).toArray()));
                } else if ("UBYTE".equals(string)) {
                    protoTile = initialProtoTile.withUint32Cells(Predef$.MODULE$.wrapIntArray(tile2.interpretAs((DataType)UByteCellType$.MODULE$).toArray()));
                } else if ("SHORT".equals(string)) {
                    protoTile = initialProtoTile.withSint32Cells(Predef$.MODULE$.wrapIntArray(tile2.interpretAs((DataType)ShortCellType$.MODULE$).toArray()));
                } else if ("USHORT".equals(string)) {
                    protoTile = initialProtoTile.withUint32Cells(Predef$.MODULE$.wrapIntArray(tile2.interpretAs((DataType)UShortCellType$.MODULE$).toArray()));
                } else if ("INT".equals(string)) {
                    protoTile = initialProtoTile.withSint32Cells(Predef$.MODULE$.wrapIntArray(tile2.toArray()));
                } else if ("FLOAT".equals(string)) {
                    protoTile = initialProtoTile.withFloatCells(Predef$.MODULE$.wrapFloatArray(((FloatArrayTile)tile2).array()));
                } else if ("DOUBLE".equals(string)) {
                    protoTile = initialProtoTile.withDoubleCells(Predef$.MODULE$.wrapDoubleArray(((DoubleArrayTile)tile2).array()));
                } else {
                    throw new MatchError((Object)string);
                }
                return protoTile;
            }

            public Tile decode(ProtoTile message) {
                Tile tile;
                ProtoCellType messageCellType = message.cellType().get();
                DataType ct = this.messageToCellType(messageCellType);
                String string = message.cellType().get().dataType().toString();
                boolean bl = "BYTE".equals(string) ? true : ("SHORT".equals(string) ? true : "INT".equals(string));
                if (bl) {
                    tile = RawArrayTile$.MODULE$.apply((int[])message.sint32Cells().toArray(ClassTag$.MODULE$.Int()), message.cols(), message.rows()).interpretAs(ct);
                } else {
                    boolean bl2 = "BIT".equals(string) ? true : ("UBYTE".equals(string) ? true : "USHORT".equals(string));
                    if (bl2) {
                        tile = RawArrayTile$.MODULE$.apply((int[])message.uint32Cells().toArray(ClassTag$.MODULE$.Int()), message.cols(), message.rows()).interpretAs(ct);
                    } else if ("FLOAT".equals(string)) {
                        tile = ArrayTile$.MODULE$.apply((float[])message.floatCells().toArray(ClassTag$.MODULE$.Float()), message.cols(), message.rows()).interpretAs(ct);
                    } else if ("DOUBLE".equals(string)) {
                        tile = ArrayTile$.MODULE$.apply((double[])message.doubleCells().toArray(ClassTag$.MODULE$.Double()), message.cols(), message.rows()).interpretAs(ct);
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
                return tile;
            }
        };
    }

    public static void $init$(TileProtoBuf $this) {
    }
}

