/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.io.geotiff;

import geopyspark.geotrellis.GeoTrellisUtils$;
import geopyspark.geotrellis.ProjectedRasterLayer;
import geopyspark.geotrellis.ProjectedRasterLayer$;
import geopyspark.geotrellis.RasterLayer;
import geopyspark.geotrellis.TemporalRasterLayer;
import geopyspark.geotrellis.TemporalRasterLayer$;
import geopyspark.geotrellis.io.geotiff.GeoTiffRDD$HadoopGeoTiffRDDOptions$;
import geopyspark.geotrellis.io.geotiff.GeoTiffRDD$S3GeoTiffRDDOptions$;
import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.raster.MultibandTile;
import geotrellis.spark.store.hadoop.HadoopGeoTiffRDD;
import geotrellis.spark.store.hadoop.HadoopGeoTiffRDD$;
import geotrellis.spark.store.s3.S3GeoTiffRDD;
import geotrellis.spark.store.s3.S3GeoTiffRDD$;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class GeoTiffRDD$ {
    public static GeoTiffRDD$ MODULE$;

    static {
        new GeoTiffRDD$();
    }

    public RasterLayer<?> get(SparkContext sc, String keyType, List<String> paths, java.util.Map<String, Object> options, String partitionBytes) {
        LazyRef conf$lzy = new LazyRef();
        Buffer uris = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(paths).map((Function1<String, URI> & Serializable & scala.Serializable)path -> new URI((String)path), Buffer$.MODULE$.canBuildFrom());
        Tuple2<Map<String, String>, Map<String, Object>> tuple2 = GeoTrellisUtils$.MODULE$.convertToScalaMap(options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, String> stringMap = tuple2._1();
        Map<String, Object> intMap = tuple2._2();
        Tuple2<Map<String, String>, Map<String, Object>> tuple22 = new Tuple2<Map<String, String>, Map<String, Object>>(stringMap, intMap);
        Tuple2<Map<String, String>, Map<String, Object>> tuple23 = tuple22;
        Map<String, String> stringMap2 = tuple23._1();
        Map<String, Object> intMap2 = tuple23._2();
        Some<Long> bytes = new Some<Long>(BoxesRunTime.boxToLong(new StringOps(Predef$.MODULE$.augmentString(partitionBytes)).toLong()));
        return (RasterLayer)((TraversableOnce)uris.map((Function1<URI, RasterLayer> & Serializable & scala.Serializable)uri -> {
            String string = uri.getScheme();
            boolean bl = "s3".equals(string) ? true : ("s3a".equals(string) ? true : "s3n".equals(string));
            RasterLayer<?> rasterLayer = bl ? MODULE$.getS3GeoTiffRDD(sc, keyType, (URI)uri, GeoTiffRDD$S3GeoTiffRDDOptions$.MODULE$.setValues(GeoTiffRDD$.conf$1(conf$lzy, sc), uri.getScheme(), intMap2, stringMap2, bytes)) : MODULE$.getHadoopGeoTiffRDD(sc, keyType, new Path(uri), GeoTiffRDD$HadoopGeoTiffRDDOptions$.MODULE$.setValues(intMap2, stringMap2, bytes));
            return rasterLayer;
        }, Buffer$.MODULE$.canBuildFrom())).reduce((Function2<RasterLayer, RasterLayer, RasterLayer> & Serializable & scala.Serializable)(r1, r2) -> {
            RasterLayer rasterLayer;
            String string = keyType;
            if ("ProjectedExtent".equals(string)) {
                rasterLayer = ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)((ProjectedRasterLayer)r1).rdd().union(((ProjectedRasterLayer)r2).rdd()));
            } else if ("TemporalProjectedExtent".equals(string)) {
                rasterLayer = TemporalRasterLayer$.MODULE$.apply((RDD<Tuple2<TemporalProjectedExtent, MultibandTile>>)((TemporalRasterLayer)r1).rdd().union(((TemporalRasterLayer)r2).rdd()));
            } else {
                throw new MatchError((Object)string);
            }
            return rasterLayer;
        });
    }

    private RasterLayer<?> getHadoopGeoTiffRDD(SparkContext sc, String keyType, Path path, HadoopGeoTiffRDD.Options options) {
        RasterLayer rasterLayer;
        String string = keyType;
        if ("ProjectedExtent".equals(string)) {
            rasterLayer = ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)HadoopGeoTiffRDD$.MODULE$.spatialMultiband(path, options, sc));
        } else if ("TemporalProjectedExtent".equals(string)) {
            rasterLayer = TemporalRasterLayer$.MODULE$.apply((RDD<Tuple2<TemporalProjectedExtent, MultibandTile>>)HadoopGeoTiffRDD$.MODULE$.temporalMultiband(path, options, sc));
        } else {
            throw new MatchError((Object)string);
        }
        return rasterLayer;
    }

    private RasterLayer<?> getS3GeoTiffRDD(SparkContext sc, String keyType, URI uri, S3GeoTiffRDD.Options options) {
        RasterLayer rasterLayer;
        String string = keyType;
        if ("ProjectedExtent".equals(string)) {
            rasterLayer = ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)S3GeoTiffRDD$.MODULE$.spatialMultiband(uri.getHost(), (String)new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).tail(), options, sc));
        } else if ("TemporalProjectedExtent".equals(string)) {
            rasterLayer = TemporalRasterLayer$.MODULE$.apply((RDD<Tuple2<TemporalProjectedExtent, MultibandTile>>)S3GeoTiffRDD$.MODULE$.temporalMultiband(uri.getHost(), (String)new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).tail(), options, sc));
        } else {
            throw new MatchError((Object)string);
        }
        return rasterLayer;
    }

    private static final /* synthetic */ SparkConf conf$lzycompute$1(LazyRef conf$lzy$1, SparkContext sc$1) {
        SparkConf sparkConf;
        LazyRef lazyRef = conf$lzy$1;
        synchronized (lazyRef) {
            sparkConf = conf$lzy$1.initialized() ? (SparkConf)conf$lzy$1.value() : conf$lzy$1.initialize(sc$1.getConf());
        }
        return sparkConf;
    }

    private static final SparkConf conf$1(LazyRef conf$lzy$1, SparkContext sc$1) {
        return conf$lzy$1.initialized() ? (SparkConf)conf$lzy$1.value() : GeoTiffRDD$.conf$lzycompute$1(conf$lzy$1, sc$1);
    }

    private GeoTiffRDD$() {
        MODULE$ = this;
    }
}

