/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.io;

import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.io.LayerWriterWrapper$;
import geotrellis.layer.Boundable;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.crop.Implicits;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader$;
import geotrellis.raster.merge.Implicits;
import geotrellis.raster.prototype.Implicits;
import geotrellis.spark.store.LayerWriter;
import geotrellis.spark.store.LayerWriter$;
import geotrellis.spark.store.cog.COGLayerWriter;
import geotrellis.spark.store.cog.COGLayerWriter$;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerId;
import geotrellis.store.index.HilbertKeyIndexMethod;
import geotrellis.store.index.HilbertKeyIndexMethod$;
import geotrellis.store.index.KeyIndexMethod;
import geotrellis.store.index.RowMajorKeyIndexMethod;
import geotrellis.store.index.RowMajorKeyIndexMethod$;
import geotrellis.store.index.ZCurveKeyIndexMethod;
import geotrellis.store.index.ZCurveKeyIndexMethod$;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\n\u0014\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003:\u0001\u0011\u0005!\bC\u0004A\u0001\t\u0007I\u0011A!\t\rm\u0003\u0001\u0015!\u0003C\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u00159\b\u0001\"\u0003y\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u001dI\u0011qJ\n\u0002\u0002#\u0005\u0011\u0011\u000b\u0004\t%M\t\t\u0011#\u0001\u0002T!1\u0011h\u0004C\u0001\u0003+B\u0011\"a\u0016\u0010#\u0003%\t!!\u0017\u0003%1\u000b\u00170\u001a:Xe&$XM],sCB\u0004XM\u001d\u0006\u0003)U\t!![8\u000b\u0005Y9\u0012AC4f_R\u0014X\r\u001c7jg*\t\u0001$\u0001\u0006hK>\u0004\u0018p\u001d9be.\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X\r\u0005\u0002$O5\tAE\u0003\u0002&M\u0005)1\u000f^8sK*\ta#\u0003\u0002)I\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0017aA;sSB\u00111F\r\b\u0003YA\u0002\"!L\u000f\u000e\u00039R!aL\r\u0002\rq\u0012xn\u001c;?\u0013\t\tT$\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019\u001e\u0003\u001d)8/Z\"P\u000fN\u0004\"\u0001H\u001c\n\u0005aj\"a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmjdh\u0010\t\u0003y\u0001i\u0011a\u0005\u0005\u0006C\u0011\u0001\rA\t\u0005\u0006S\u0011\u0001\rA\u000b\u0005\bk\u0011\u0001\n\u00111\u00017\u0003-a\u0017-_3s/JLG/\u001a:\u0016\u0003\t\u0003Ba\u0011%L):\u0011AI\u0012\b\u0003[\u0015K\u0011AH\u0005\u0003\u000fv\tq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\n1Q)\u001b;iKJT!aR\u000f\u0011\u00051\u0013V\"A'\u000b\u00059{\u0015aA2pO*\u0011Q\u0005\u0015\u0006\u0003#\u001a\nQa\u001d9be.L!aU'\u0003\u001d\r{u\tT1zKJ<&/\u001b;feB\u0019QK\u0016-\u000e\u0003=K!aV(\u0003\u00171\u000b\u00170\u001a:Xe&$XM\u001d\t\u0003GeK!A\u0017\u0013\u0003\u000f1\u000b\u00170\u001a:JI\u0006aA.Y=fe^\u0013\u0018\u000e^3sA\u0005)r-\u001a;Ta\u0006$\u0018.\u00197J]\u0012,\u00070T3uQ>$GC\u00010k!\ry&\rZ\u0007\u0002A*\u0011\u0011\rJ\u0001\u0006S:$W\r_\u0005\u0003G\u0002\u0014abS3z\u0013:$W\r_'fi\"|G\r\u0005\u0002fQ6\taM\u0003\u0002hM\u0005)A.Y=fe&\u0011\u0011N\u001a\u0002\u000b'B\fG/[1m\u0017\u0016L\b\"B6\b\u0001\u0004Q\u0013!D5oI\u0016D8\u000b\u001e:bi\u0016<\u00170\u0001\fhKR$V-\u001c9pe\u0006d\u0017J\u001c3fq6+G\u000f[8e)\u0011q'\u000f\u001e<\u0011\u0007}\u0013w\u000e\u0005\u0002fa&\u0011\u0011O\u001a\u0002\r'B\f7-\u001a+j[\u0016\\U-\u001f\u0005\u0006g\"\u0001\rAK\u0001\u000bi&lWm\u0015;sS:<\u0007\"B;\t\u0001\u0004Q\u0013A\u0004;j[\u0016\u0014Vm]8mkRLwN\u001c\u0005\u0006W\"\u0001\rAK\u0001\u000bO\u0016$H*Y=fe&#Gc\u0001-zw\")!0\u0003a\u0001U\u0005IA.Y=fe:\u000bW.\u001a\u0005\u0006O&\u0001\r\u0001 \u0019\u0004{\u0006\u001d\u0001\u0003\u0002@\u0000\u0003\u0007i\u0011!F\u0005\u0004\u0003\u0003)\"\u0001\u0005+jY\u0016$'+Y:uKJd\u0015-_3s!\u0011\t)!a\u0002\r\u0001\u0011Y\u0011\u0011B>\u0002\u0002\u0003\u0005)\u0011AA\u0006\u0005\ryF%M\t\u0005\u0003\u001b\t\u0019\u0002E\u0002\u001d\u0003\u001fI1!!\u0005\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001HA\u000b\u0013\r\t9\"\b\u0002\u0004\u0003:L\u0018\u0001D<sSR,7\u000b]1uS\u0006dG\u0003CA\u000f\u0003G\t)#a\u000b\u0011\u0007q\ty\"C\u0002\u0002\"u\u0011A!\u00168ji\")!P\u0003a\u0001U!9\u0011q\u0005\u0006A\u0002\u0005%\u0012AC:qCRL\u0017\r\u001c*E\tB\u0019ap 3\t\u000b-T\u0001\u0019\u0001\u0016\u0002\u001b]\u0014\u0018\u000e^3UK6\u0004xN]1m)1\ti\"!\r\u00024\u0005e\u00121HA\u001f\u0011\u0015Q8\u00021\u0001+\u0011\u001d\t)d\u0003a\u0001\u0003o\t1\u0002^3na>\u0014\u0018\r\u001c*E\tB\u0019ap`8\t\u000bM\\\u0001\u0019\u0001\u0016\t\u000bU\\\u0001\u0019\u0001\u0016\t\u000b-\\\u0001\u0019\u0001\u0016\u0002\u001bU\u0004H-\u0019;f'B\fG/[1m)\u0019\ti\"a\u0011\u0002F!)!\u0010\u0004a\u0001U!9\u0011q\u0005\u0007A\u0002\u0005%\u0012AD;qI\u0006$X\rV3na>\u0014\u0018\r\u001c\u000b\u0007\u0003;\tY%!\u0014\t\u000bil\u0001\u0019\u0001\u0016\t\u000f\u0005UR\u00021\u0001\u00028\u0005\u0011B*Y=fe^\u0013\u0018\u000e^3s/J\f\u0007\u000f]3s!\tatb\u0005\u0002\u00107Q\u0011\u0011\u0011K\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m#f\u0001\u001c\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002ju\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LayerWriterWrapper {
    private final Either<COGLayerWriter, LayerWriter<LayerId>> layerWriter;

    public static boolean $lessinit$greater$default$3() {
        return LayerWriterWrapper$.MODULE$.$lessinit$greater$default$3();
    }

    public Either<COGLayerWriter, LayerWriter<LayerId>> layerWriter() {
        return this.layerWriter;
    }

    private KeyIndexMethod<SpatialKey> getSpatialIndexMethod(String indexStrategy) {
        KeyIndexMethod keyIndexMethod;
        String string = indexStrategy;
        if ("zorder".equals(string)) {
            keyIndexMethod = ZCurveKeyIndexMethod$.MODULE$.spatialKeyIndexMethod((ZCurveKeyIndexMethod)ZCurveKeyIndexMethod$.MODULE$);
        } else if ("hilbert".equals(string)) {
            keyIndexMethod = HilbertKeyIndexMethod$.MODULE$.spatialKeyIndexIndex((HilbertKeyIndexMethod)HilbertKeyIndexMethod$.MODULE$);
        } else if ("rowmajor".equals(string)) {
            keyIndexMethod = RowMajorKeyIndexMethod$.MODULE$.spatialKeyIndexMethod((RowMajorKeyIndexMethod)RowMajorKeyIndexMethod$.MODULE$);
        } else {
            throw new Exception();
        }
        return keyIndexMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyIndexMethod<SpaceTimeKey> getTemporalIndexMethod(String timeString, String timeResolution, String indexStrategy) {
        KeyIndexMethod keyIndexMethod;
        Tuple3<String, String, String> tuple3 = new Tuple3<String, String, String>(indexStrategy, timeString, timeResolution);
        if (tuple3 != null) {
            String string = tuple3._1();
            String string2 = tuple3._2();
            String string3 = tuple3._3();
            if ("zorder".equals(string) && "millis".equals(string2) && string3 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byMilliseconds(1L);
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string4 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "millis".equals(string4)) {
                return ZCurveKeyIndexMethod$.MODULE$.byMilliseconds(new StringOps(Predef$.MODULE$.augmentString(r)).toLong());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string5 = tuple3._2();
            String string6 = tuple3._3();
            if ("zorder".equals(string) && "seconds".equals(string5) && string6 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.bySecond();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string7 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "seconds".equals(string7)) {
                return ZCurveKeyIndexMethod$.MODULE$.bySeconds(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string8 = tuple3._2();
            String string9 = tuple3._3();
            if ("zorder".equals(string) && "minutes".equals(string8) && string9 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byMinute();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string10 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "minutes".equals(string10)) {
                return ZCurveKeyIndexMethod$.MODULE$.byMinutes(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string11 = tuple3._2();
            String string12 = tuple3._3();
            if ("zorder".equals(string) && "hours".equals(string11) && string12 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byHour();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string13 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "hours".equals(string13)) {
                return ZCurveKeyIndexMethod$.MODULE$.byHours(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string14 = tuple3._2();
            String string15 = tuple3._3();
            if ("zorder".equals(string) && "days".equals(string14) && string15 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byDay();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string16 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "days".equals(string16)) {
                return ZCurveKeyIndexMethod$.MODULE$.byDays(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string17 = tuple3._2();
            String string18 = tuple3._3();
            if ("zorder".equals(string) && "weeks".equals(string17) && string18 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byDays(7);
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string19 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "weeks".equals(string19)) {
                return ZCurveKeyIndexMethod$.MODULE$.byDays(new StringOps(Predef$.MODULE$.augmentString(r)).toInt() * 7);
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string20 = tuple3._2();
            String string21 = tuple3._3();
            if ("zorder".equals(string) && "months".equals(string20) && string21 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byMonth();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string22 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "months".equals(string22)) {
                return ZCurveKeyIndexMethod$.MODULE$.byMonths(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string23 = tuple3._2();
            String string24 = tuple3._3();
            if ("zorder".equals(string) && "years".equals(string23) && string24 == null) {
                return ZCurveKeyIndexMethod$.MODULE$.byYear();
            }
        }
        if (tuple3 != null) {
            String string = tuple3._1();
            String string25 = tuple3._2();
            String r = tuple3._3();
            if ("zorder".equals(string) && "years".equals(string25)) {
                return ZCurveKeyIndexMethod$.MODULE$.byYears(new StringOps(Predef$.MODULE$.augmentString(r)).toInt());
            }
        }
        if (tuple3 == null) throw new Exception();
        String string = tuple3._1();
        if (!"hilbert".equals(string)) throw new Exception();
        String[] stringArray = timeString.split(",");
        Option option = Array$.MODULE$.unapplySeq(stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            String minDate = (String)((SeqLike)option.get()).apply(0);
            String maxDate = (String)((SeqLike)option.get()).apply(1);
            String resolution = (String)((SeqLike)option.get()).apply(2);
            keyIndexMethod = HilbertKeyIndexMethod$.MODULE$.apply(ZonedDateTime.parse(minDate), ZonedDateTime.parse(maxDate), new StringOps(Predef$.MODULE$.augmentString(resolution)).toInt());
            return keyIndexMethod;
        } else {
            Option option2 = Array$.MODULE$.unapplySeq(stringArray);
            if (option2.isEmpty()) throw new Exception(new StringBuilder(20).append("Invalid timeString: ").append(timeString).toString());
            if (option2.get() == null) throw new Exception(new StringBuilder(20).append("Invalid timeString: ").append(timeString).toString());
            if (((SeqLike)option2.get()).lengthCompare(1) != 0) throw new Exception(new StringBuilder(20).append("Invalid timeString: ").append(timeString).toString());
            String resolution = (String)((SeqLike)option2.get()).apply(0);
            keyIndexMethod = HilbertKeyIndexMethod$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(resolution)).toInt());
        }
        return keyIndexMethod;
    }

    private LayerId getLayerId(String layerName, TiledRasterLayer<?> layer) {
        LayerId layerId;
        Option<Object> option = layer.zoomLevel();
        if (option instanceof Some) {
            Some some = (Some)option;
            int zoom = BoxesRunTime.unboxToInt(some.value());
            layerId = new LayerId(layerName, zoom);
        } else if (None$.MODULE$.equals(option)) {
            layerId = new LayerId(layerName, 0);
        } else {
            throw new MatchError(option);
        }
        return layerId;
    }

    public void writeSpatial(String layerName, TiledRasterLayer<SpatialKey> spatialRDD, String indexStrategy) {
        KeyIndexMethod<SpatialKey> indexMethod = this.getSpatialIndexMethod(indexStrategy);
        Either<COGLayerWriter, LayerWriter<LayerId>> either = this.layerWriter();
        if (either instanceof Left) {
            Left left = (Left)either;
            COGLayerWriter cogWriter = (COGLayerWriter)left.value();
            int zoom = BoxesRunTime.unboxToInt(spatialRDD.zoomLevel().getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
            cogWriter.write(layerName, spatialRDD.rdd(), zoom, indexMethod, geotrellis.util.package$.MODULE$.identityComponent(), SpatialKey$.MODULE$.ordering(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey(), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), GeoTiffReader$.MODULE$.multibandGeoTiffReader(), GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            LayerId layerId;
            Right right = (Right)either;
            LayerWriter avroWriter = (LayerWriter)right.value();
            Option<Object> option = spatialRDD.zoomLevel();
            if (option instanceof Some) {
                Some some = (Some)option;
                int zoom = BoxesRunTime.unboxToInt(some.value());
                layerId = new LayerId(layerName, zoom);
            } else if (None$.MODULE$.equals(option)) {
                layerId = new LayerId(layerName, 0);
            } else {
                throw new MatchError(option);
            }
            LayerId id = layerId;
            avroWriter.write((Object)id, spatialRDD.rdd(), indexMethod, geotrellis.store.package$.MODULE$.spatialKeyAvroFormat(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey(), ClassTag$.MODULE$.apply(SpatialKey.class), geotrellis.store.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(geotrellis.util.package$.MODULE$.identityComponent(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey()), TileLayerMetadata$.MODULE$.boundsComponent(geotrellis.util.package$.MODULE$.identityComponent()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    public void writeTemporal(String layerName, TiledRasterLayer<SpaceTimeKey> temporalRDD, String timeString, String timeResolution, String indexStrategy) {
        KeyIndexMethod<SpaceTimeKey> indexMethod = this.getTemporalIndexMethod(timeString, timeResolution, indexStrategy);
        Either<COGLayerWriter, LayerWriter<LayerId>> either = this.layerWriter();
        if (either instanceof Left) {
            Left left = (Left)either;
            COGLayerWriter cogWriter = (COGLayerWriter)left.value();
            int zoom = BoxesRunTime.unboxToInt(temporalRDD.zoomLevel().getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
            cogWriter.write(layerName, temporalRDD.rdd(), zoom, indexMethod, SpaceTimeKey$.MODULE$.spatialComponent(), SpaceTimeKey$.MODULE$.ordering(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), GeoTiffReader$.MODULE$.multibandGeoTiffReader(), GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            LayerId layerId;
            Right right = (Right)either;
            LayerWriter avroWriter = (LayerWriter)right.value();
            Option<Object> option = temporalRDD.zoomLevel();
            if (option instanceof Some) {
                Some some = (Some)option;
                int zoom = BoxesRunTime.unboxToInt(some.value());
                layerId = new LayerId(layerName, zoom);
            } else if (None$.MODULE$.equals(option)) {
                layerId = new LayerId(layerName, 0);
            } else {
                throw new MatchError(option);
            }
            LayerId id = layerId;
            avroWriter.write((Object)id, temporalRDD.rdd(), indexMethod, geotrellis.store.package$.MODULE$.spaceTimeKeyAvroFormat(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), geotrellis.store.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()), TileLayerMetadata$.MODULE$.boundsComponent(SpaceTimeKey$.MODULE$.spatialComponent()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    public void updateSpatial(String layerName, TiledRasterLayer<SpatialKey> spatialRDD) {
        Either<COGLayerWriter, LayerWriter<LayerId>> either = this.layerWriter();
        if (either instanceof Left) {
            Left left = (Left)either;
            COGLayerWriter cogWriter = (COGLayerWriter)left.value();
            LayerId id = this.getLayerId(layerName, spatialRDD);
            cogWriter.update(id.name(), spatialRDD.rdd(), id.zoom(), (Option)None$.MODULE$, cogWriter.update$default$5(), geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, SpatialKey$.MODULE$.ordering(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey(), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), GeoTiffReader$.MODULE$.multibandGeoTiffReader(), GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            LayerWriter avroWriter = (LayerWriter)right.value();
            avroWriter.update((Object)this.getLayerId(layerName, spatialRDD), spatialRDD.rdd(), avroWriter.update$default$3(), geotrellis.store.package$.MODULE$.spatialKeyAvroFormat(), (Boundable)SpatialKey.Boundable$.MODULE$, (Encoder)SpatialKey$.MODULE$.codecForSpatialKey(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey(), ClassTag$.MODULE$.apply(SpatialKey.class), geotrellis.store.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(geotrellis.util.package$.MODULE$.identityComponent(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey()), TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(geotrellis.util.package$.MODULE$.identityComponent(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey()), TileLayerMetadata$.MODULE$.boundsComponent(geotrellis.util.package$.MODULE$.identityComponent()), TileLayerMetadata$.MODULE$.semigroup((Boundable)SpatialKey.Boundable$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    public void updateTemporal(String layerName, TiledRasterLayer<SpaceTimeKey> temporalRDD) {
        Either<COGLayerWriter, LayerWriter<LayerId>> either = this.layerWriter();
        if (either instanceof Left) {
            Left left = (Left)either;
            COGLayerWriter cogWriter = (COGLayerWriter)left.value();
            LayerId id = this.getLayerId(layerName, temporalRDD);
            cogWriter.update(id.name(), temporalRDD.rdd(), id.zoom(), (Option)None$.MODULE$, cogWriter.update$default$5(), SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, SpaceTimeKey$.MODULE$.ordering(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), GeoTiffReader$.MODULE$.multibandGeoTiffReader(), GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            LayerWriter avroWriter = (LayerWriter)right.value();
            avroWriter.update((Object)this.getLayerId(layerName, temporalRDD), temporalRDD.rdd(), avroWriter.update$default$3(), geotrellis.store.package$.MODULE$.spaceTimeKeyAvroFormat(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), geotrellis.store.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()), TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()), TileLayerMetadata$.MODULE$.boundsComponent(SpaceTimeKey$.MODULE$.spatialComponent()), TileLayerMetadata$.MODULE$.semigroup((Boundable)SpaceTimeKey.Boundable$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    public LayerWriterWrapper(AttributeStore attributeStore, String uri, boolean useCOGs) {
        this.layerWriter = useCOGs ? package$.MODULE$.Left().apply(COGLayerWriter$.MODULE$.apply(attributeStore, uri)) : package$.MODULE$.Right().apply(LayerWriter$.MODULE$.apply(attributeStore, uri));
    }
}

