/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis.io;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.io.package$;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.store.AttributeStore;
import geotrellis.store.AttributeStore$;
import geotrellis.store.COGLayerType$;
import geotrellis.store.LayerHeader;
import geotrellis.store.LayerId;
import geotrellis.store.LayerType;
import geotrellis.store.cog.COGLayerStorageMetadata;
import geotrellis.store.cog.COGLayerStorageMetadata$;
import geotrellis.store.package;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001y3Aa\u0003\u0007\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003'\u0001\u0011\u0005q\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rQ\u0002\u0001\u0015!\u0003.\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015y\u0005\u0001\"\u0001U\u0011\u00159\u0006\u0001\"\u0001Y\u0005U\tE\u000f\u001e:jEV$Xm\u0015;pe\u0016<&/\u00199qKJT!!\u0004\b\u0002\u0005%|'BA\b\u0011\u0003)9Wm\u001c;sK2d\u0017n\u001d\u0006\u0002#\u0005Qq-Z8qsN\u0004\u0018M]6\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u0007U\u0014\u0018\u000e\u0005\u0002\u001dG9\u0011Q$\t\t\u0003=Yi\u0011a\b\u0006\u0003AI\ta\u0001\u0010:p_Rt\u0014B\u0001\u0012\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t2\u0012A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0019!)!D\u0001a\u00017\u0005q\u0011\r\u001e;sS\n,H/Z*u_J,W#A\u0017\u0011\u00059\u0012T\"A\u0018\u000b\u0005A\n\u0014!B:u_J,'\"A\b\n\u0005Mz#AD!uiJL'-\u001e;f'R|'/Z\u0001\u0010CR$(/\u001b2vi\u0016\u001cFo\u001c:fA\u0005a!/Z1e\u001b\u0016$\u0018\rZ1uCR\u00191dN\u001d\t\u000ba*\u0001\u0019A\u000e\u0002\t9\fW.\u001a\u0005\u0006u\u0015\u0001\raO\u0001\u0005u>|W\u000e\u0005\u0002\u0016y%\u0011QH\u0006\u0002\u0004\u0013:$\u0018\u0001\u0002:fC\u0012$Ba\u0007!C\u0007\")\u0011I\u0002a\u00017\u0005IA.Y=fe:\u000bW.\u001a\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\t\u001a\u0001\raG\u0001\u000eCR$(/\u001b2vi\u0016t\u0015-\\3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000b\u001dS5\nT'\u0011\u0005UA\u0015BA%\u0017\u0005\u0011)f.\u001b;\t\u000b\u0005;\u0001\u0019A\u000e\t\u000bi:\u0001\u0019A\u001e\t\u000b\u0011;\u0001\u0019A\u000e\t\u000b9;\u0001\u0019A\u000e\u0002\u000bY\fG.^3\u0002\r\u0011,G.\u001a;f)\u00119\u0015KU*\t\u000b\u0005C\u0001\u0019A\u000e\t\u000biB\u0001\u0019A\u001e\t\u000baB\u0001\u0019A\u000e\u0015\u0007\u001d+f\u000bC\u0003B\u0013\u0001\u00071\u0004C\u0003;\u0013\u0001\u00071(\u0001\u0005d_:$\u0018-\u001b8t)\rIF,\u0018\t\u0003+iK!a\u0017\f\u0003\u000f\t{w\u000e\\3b]\")\u0011I\u0003a\u00017!)!H\u0003a\u0001w\u0001")
public class AttributeStoreWrapper {
    private final AttributeStore attributeStore;

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public String readMetadata(String name, int zoom) {
        Json json;
        LayerId id = new LayerId(name, zoom);
        LayerHeader header = package$.MODULE$.produceHeader(this.attributeStore(), id);
        LayerType layerType = header.layerType();
        if (COGLayerType$.MODULE$.equals(layerType)) {
            Json json2;
            String string = header.keyClass();
            if ("geotrellis.layer.SpatialKey".equals(string)) {
                json2 = package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)((COGLayerStorageMetadata)this.attributeStore().readMetadata(new LayerId(id.name(), 0), COGLayerStorageMetadata$.MODULE$.cogLayerStorageMetadataDecoder(geotrellis.util.package$.MODULE$.identityComponent(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey(), ClassTag$.MODULE$.apply(SpatialKey.class)))).metadata().tileLayerMetadata(id.zoom())), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(geotrellis.util.package$.MODULE$.identityComponent(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey()));
            } else if ("geotrellis.layer.SpaceTimeKey".equals(string)) {
                json2 = package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)((COGLayerStorageMetadata)this.attributeStore().readMetadata(new LayerId(id.name(), 0), COGLayerStorageMetadata$.MODULE$.cogLayerStorageMetadataDecoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey(), ClassTag$.MODULE$.apply(SpaceTimeKey.class)))).metadata().tileLayerMetadata(id.zoom())), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()));
            } else {
                throw new MatchError((Object)string);
            }
            json = json2;
        } else {
            json = (Json)this.attributeStore().readMetadata(id, Decoder$.MODULE$.decodeJson());
        }
        Json json3 = json;
        return json3.noSpaces();
    }

    public String read(String layerName, int zoom, String attributeName) {
        LayerId id = new LayerId(layerName, zoom);
        try {
            Json json = (Json)this.attributeStore().read(id, attributeName, Decoder$.MODULE$.decodeJson());
            return json.noSpaces();
        }
        catch (package.AttributeNotFoundError e) {
            return null;
        }
    }

    public void write(String layerName, int zoom, String attributeName, String value) {
        LayerId id = new LayerId(layerName, zoom);
        if (value == null) {
            return;
        }
        Json json = (Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(value)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$1 -> {
            throw x$1;
        });
        this.attributeStore().write(id, attributeName, (Object)json, Encoder$.MODULE$.encodeJson());
    }

    public void delete(String layerName, int zoom, String name) {
        LayerId id = new LayerId(layerName, zoom);
        this.attributeStore().delete(id, name);
    }

    public void delete(String layerName, int zoom) {
        LayerId id = new LayerId(layerName, zoom);
        this.attributeStore().delete(id);
    }

    public boolean contains(String layerName, int zoom) {
        LayerId id = new LayerId(layerName, zoom);
        return this.attributeStore().layerExists(id);
    }

    public AttributeStoreWrapper(String uri) {
        this.attributeStore = AttributeStore$.MODULE$.apply(uri);
    }
}

