/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.ZFactorCalculator;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.KeyDecoder$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcDD$sp;

public final class ZFactorCalculator$
implements scala.Serializable {
    public static ZFactorCalculator$ MODULE$;

    static {
        new ZFactorCalculator$();
    }

    public ZFactorCalculator createLatLngZFactorCalculator(String units) {
        ZFactorCalculator zFactorCalculator;
        String string = units;
        if ("Meters".equals(string)) {
            zFactorCalculator = this.apply((JFunction1$mcDD$sp & scala.Serializable)lat -> 1.0 / ((double)11320 * scala.math.package$.MODULE$.cos(scala.math.package$.MODULE$.toRadians(lat))));
        } else if ("Feet".equals(string)) {
            zFactorCalculator = this.apply((JFunction1$mcDD$sp & scala.Serializable)lat -> 1.0 / (365217.6 * scala.math.package$.MODULE$.cos(scala.math.package$.MODULE$.toRadians(lat))));
        } else {
            throw new MatchError((Object)string);
        }
        return zFactorCalculator;
    }

    public ZFactorCalculator createZFactorCalculator(String table) {
        Map zFactorTable = ((TraversableLike)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.parse(table)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$1 -> {
            throw x$1;
        })).as(Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$2 -> {
            throw x$2;
        })).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2<Double, Double> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(k)).toDouble())), BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(v)).toDouble()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        double[] lattitudes = (double[])zFactorTable.keys().toArray(ClassTag$.MODULE$.Double());
        double[] zfactors = (double[])zFactorTable.values().toArray(ClassTag$.MODULE$.Double());
        LinearInterpolator interp = new LinearInterpolator();
        PolynomialSplineFunction spline = interp.interpolate(lattitudes, zfactors);
        return this.apply((JFunction1$mcDD$sp & scala.Serializable)lat -> spline.value(lat));
    }

    public ZFactorCalculator apply(Function1<Object, Object> producer) {
        return new ZFactorCalculator(producer);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ZFactorCalculator$() {
        MODULE$ = this;
    }
}

