/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import geopyspark.geotrellis.PartitionStrategy;
import geopyspark.geotrellis.SpatialPartitioner$;
import geopyspark.geotrellis.TileLayer;
import geotrellis.proj4.CRS;
import geotrellis.proj4.CRS$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped$;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.DeflateCompression$;
import geotrellis.raster.io.geotiff.compression.NoCompression$;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.resample.Average$;
import geotrellis.raster.resample.Bilinear$;
import geotrellis.raster.resample.CubicConvolution$;
import geotrellis.raster.resample.CubicSpline$;
import geotrellis.raster.resample.Lanczos$;
import geotrellis.raster.resample.Max$;
import geotrellis.raster.resample.Median$;
import geotrellis.raster.resample.Min$;
import geotrellis.raster.resample.Mode$;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.util.package$;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Try$;

public final class TileLayer$ {
    public static TileLayer$ MODULE$;

    static {
        new TileLayer$();
    }

    public ResampleMethod getResampleMethod(String resampleMethod) {
        NearestNeighbor$ nearestNeighbor$;
        String string = resampleMethod;
        if ("NearestNeighbor".equals(string)) {
            nearestNeighbor$ = NearestNeighbor$.MODULE$;
        } else if ("Bilinear".equals(string)) {
            nearestNeighbor$ = Bilinear$.MODULE$;
        } else if ("CubicConvolution".equals(string)) {
            nearestNeighbor$ = CubicConvolution$.MODULE$;
        } else if ("CubicSpline".equals(string)) {
            nearestNeighbor$ = CubicSpline$.MODULE$;
        } else if ("Lanczos".equals(string)) {
            nearestNeighbor$ = Lanczos$.MODULE$;
        } else if ("Average".equals(string)) {
            nearestNeighbor$ = Average$.MODULE$;
        } else if ("Mode".equals(string)) {
            nearestNeighbor$ = Mode$.MODULE$;
        } else if ("Median".equals(string)) {
            nearestNeighbor$ = Median$.MODULE$;
        } else if ("Max".equals(string)) {
            nearestNeighbor$ = Max$.MODULE$;
        } else if ("Min".equals(string)) {
            nearestNeighbor$ = Min$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        return nearestNeighbor$;
    }

    public Option<Partitioner> getPartitioner(PartitionStrategy partitionStrategy, int defaultNumPartitions) {
        Option option;
        PartitionStrategy partitionStrategy2 = partitionStrategy;
        if (partitionStrategy2 != null) {
            PartitionStrategy partitionStrategy3 = partitionStrategy2;
            option = partitionStrategy3.producePartitioner(defaultNumPartitions);
        } else if (partitionStrategy2 == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(partitionStrategy2);
        }
        return option;
    }

    public Partitioner getPartitioner(int partitions, String partitioner) {
        Object object;
        String string = partitioner;
        if ("HashPartitioner".equals(string)) {
            object = new HashPartitioner(partitions);
        } else if ("SpatialPartitioner".equals(string)) {
            object = SpatialPartitioner$.MODULE$.apply(partitions, package$.MODULE$.identityComponent());
        } else {
            throw new MatchError((Object)string);
        }
        return object;
    }

    public Option<CRS> getCRS(String crs2) {
        return Option$.MODULE$.apply(crs2).flatMap((Function1<String, Option> & Serializable & scala.Serializable)crs -> Try$.MODULE$.apply((Function0<CRS> & Serializable & scala.Serializable)() -> CRS$.MODULE$.fromName(crs)).recover(new scala.Serializable((String)crs){
            public static final long serialVersionUID = 0L;
            private final String crs$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                CRS cRS = CRS$.MODULE$.fromString(this.crs$1);
                return (B1)cRS;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.crs$1 = crs$1;
            }
        }).recover(new scala.Serializable((String)crs){
            public static final long serialVersionUID = 0L;
            private final String crs$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                CRS cRS = CRS$.MODULE$.fromEpsgCode(new StringOps(Predef$.MODULE$.augmentString(this.crs$1)).toInt());
                return (B1)cRS;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = true;
                return bl;
            }
            {
                this.crs$1 = crs$1;
            }
        }).toOption());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StorageMethod getStorageMethod(String storageMethod, int rowsPerStrip, ArrayList<Object> tileDimensions) {
        Tuple2<String, Integer> tuple2 = new Tuple2<String, Integer>(storageMethod, BoxesRunTime.boxToInteger(rowsPerStrip));
        if (tuple2 != null) {
            String string = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if ("Striped".equals(string) && 0 == n) {
                return Striped$.MODULE$.apply();
            }
        }
        if (tuple2 != null) {
            String string = tuple2._1();
            int x = tuple2._2$mcI$sp();
            if ("Striped".equals(string)) {
                return Striped$.MODULE$.apply(x);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        String string = tuple2._1();
        if (!"Tiled".equals(string)) throw new MatchError(tuple2);
        return new Tiled(BoxesRunTime.unboxToInt(tileDimensions.get(0)), BoxesRunTime.unboxToInt(tileDimensions.get(1)));
    }

    public Compression getCompression(String compressionType) {
        NoCompression$ noCompression$;
        String string = compressionType;
        if ("NoCompression".equals(string)) {
            noCompression$ = NoCompression$.MODULE$;
        } else if ("DeflateCompression".equals(string)) {
            noCompression$ = DeflateCompression$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        return noCompression$;
    }

    public TargetCell getTarget(String target) {
        TargetCell$All$ targetCell$All$;
        String string = target;
        if ("All".equals(string)) {
            targetCell$All$ = TargetCell$All$.MODULE$;
        } else if ("Data".equals(string)) {
            targetCell$All$ = TargetCell.Data$.MODULE$;
        } else if ("NoData".equals(string)) {
            targetCell$All$ = TargetCell.NoData$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        return targetCell$All$;
    }

    public <K, L extends TileLayer<K>> RDD<Tuple2<K, MultibandTile>> combineBands(SparkContext sc, ArrayList<L> layers, ClassTag<K> evidence$2, ClassTag<L> evidence$3) {
        RDD bands;
        RDD unioned;
        TileLayer[] scalaLayers = (TileLayer[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(layers).asScala()).toArray(evidence$3);
        RDD[] rdds = (RDD[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])scalaLayers)).map((Function1<TileLayer, RDD> & Serializable & scala.Serializable)x0$1 -> {
            TileLayer tileLayer = x0$1;
            Option option = evidence$3.unapply(tileLayer);
            if (option.isEmpty() || option.get() == null) {
                throw new MatchError(tileLayer);
            }
            RDD rDD = tileLayer.rdd();
            return rDD;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RDD.class)));
        RDD[] arr = (RDD[])Array$.MODULE$.ofDim(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])rdds)).size(), ClassTag$.MODULE$.apply(RDD.class));
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])rdds)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TileLayer$.$anonfun$combineBands$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$5 -> {
            TileLayer$.$anonfun$combineBands$3(arr, evidence$2, x$5);
            return BoxedUnit.UNIT;
        });
        RDD x$52 = unioned = sc.union((Seq)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])arr)).toSeq(), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$6 = evidence$2;
        ClassTag x$7 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$52);
        RDD x$9 = bands = RDD$.MODULE$.rddToPairRDDFunctions(x$52, x$6, x$7, null).combineByKey((Function1<Tuple2, Map> & Serializable & scala.Serializable)value -> (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(value._1$mcI$sp())), ((MultibandTile)value._2()).bands())})), (Function2<Map, Tuple2, Map> & Serializable & scala.Serializable)(bandMap, value) -> bandMap.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(value._1$mcI$sp())), ((MultibandTile)value._2()).bands())), (Function2<Map, Map, Map> & Serializable & scala.Serializable)(m1, m2) -> m1.$plus$plus(m2));
        ClassTag x$10 = evidence$2;
        ClassTag x$11 = ClassTag$.MODULE$.apply(Map.class);
        Null$ x$12 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$9);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$9, x$10, x$11, null).mapValues((Function1<Map, MultibandTile> & Serializable & scala.Serializable)x0$2 -> {
            Map map = x0$2;
            if (map == null) {
                throw new MatchError(map);
            }
            Map map2 = map;
            MultibandTile multibandTile = MultibandTile$.MODULE$.apply((Traversable)((GenericTraversableTemplate)((TraversableLike)map2.toSeq().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean(TileLayer$.$anonfun$combineBands$9(x$6, x$7)))).map((Function1<Tuple2, Vector> & Serializable & scala.Serializable)x0$3 -> {
                Vector values;
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Vector vector = values = (Vector)tuple2._2();
                return vector;
            }, Seq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.$conforms()));
            return multibandTile;
        });
    }

    public static final /* synthetic */ boolean $anonfun$combineBands$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$combineBands$3(RDD[] arr$1, ClassTag evidence$2$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD layer = (RDD)tuple2._1();
        int index = tuple2._2$mcI$sp();
        RDD x$1 = layer;
        ClassTag x$2 = evidence$2$1;
        ClassTag x$3 = ClassTag$.MODULE$.apply(MultibandTile.class);
        Null$ x$42 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        arr$1[index] = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).mapValues((Function1<MultibandTile, Tuple2> & Serializable & scala.Serializable)x$4 -> new Tuple2<Integer, MultibandTile>(BoxesRunTime.boxToInteger(index), (MultibandTile)x$4));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$combineBands$9(Tuple2 x$6, Tuple2 x$7) {
        return x$6._1$mcI$sp() < x$7._1$mcI$sp();
    }

    private TileLayer$() {
        MODULE$ = this;
    }
}

