/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.GeoTrellisUtils$;
import geopyspark.geotrellis.TemporalTiledRasterLayer;
import geopyspark.geotrellis.TileLayer$;
import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.package$;
import geopyspark.util.PythonTranslator$;
import geotrellis.layer.Boundable;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.merge.Implicits;
import geotrellis.raster.prototype.Implicits;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.Implicits;
import geotrellis.spark.package;
import geotrellis.util.GetComponent;
import geotrellis.vector.io.wkb.WKB$;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.ParsingFailure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.rdd.RDD;
import protos.tupleMessages.ProtoTuple;
import protos.tupleMessages.ProtoTuple$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class TemporalTiledRasterLayer$
implements scala.Serializable {
    public static TemporalTiledRasterLayer$ MODULE$;

    static {
        new TemporalTiledRasterLayer$();
    }

    public TemporalTiledRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD, String metadata) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(metadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$20 -> {
            throw x$20;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$21 -> {
            throw x$21;
        });
        RDD tileLayer = package.MultibandTileLayerRDD$.MODULE$.apply(PythonTranslator$.MODULE$.fromPython((RDD<byte[]>)JavaRDD$.MODULE$.toRDD(javaRDD), (Function1<byte[], ProtoTuple> & Serializable & scala.Serializable)s2 -> (ProtoTuple)ProtoTuple$.MODULE$.parseFrom((byte[])s2), ClassTag$.MODULE$.apply(Tuple2.class), package$.MODULE$.tupleSpaceTimeKeyProtoBufCodec()), md);
        return this.apply(None$.MODULE$, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)tileLayer);
    }

    public TemporalTiledRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD, int zoomLevel, String metadata) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(metadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$22 -> {
            throw x$22;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$23 -> {
            throw x$23;
        });
        RDD tileLayer = package.MultibandTileLayerRDD$.MODULE$.apply(PythonTranslator$.MODULE$.fromPython((RDD<byte[]>)JavaRDD$.MODULE$.toRDD(javaRDD), (Function1<byte[], ProtoTuple> & Serializable & scala.Serializable)s2 -> (ProtoTuple)ProtoTuple$.MODULE$.parseFrom((byte[])s2), ClassTag$.MODULE$.apply(Tuple2.class), package$.MODULE$.tupleSpaceTimeKeyProtoBufCodec()), md);
        return this.apply(new Some<Object>(BoxesRunTime.boxToInteger(zoomLevel)), (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)tileLayer);
    }

    public TemporalTiledRasterLayer apply(Integer zoomLevel, RDD<Tuple2<SpaceTimeKey, MultibandTile>> rdd) {
        TemporalTiledRasterLayer temporalTiledRasterLayer;
        Integer n = zoomLevel;
        if (n != null) {
            Integer n2 = n;
            temporalTiledRasterLayer = this.apply(new Some<Object>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(n2))), rdd);
        } else if (n == null) {
            temporalTiledRasterLayer = this.apply(None$.MODULE$, rdd);
        } else {
            throw new MatchError(n);
        }
        return temporalTiledRasterLayer;
    }

    public TemporalTiledRasterLayer apply(Option<Object> zoomLevel, RDD<Tuple2<SpaceTimeKey, MultibandTile>> rdd) {
        return new TemporalTiledRasterLayer(zoomLevel, rdd);
    }

    public TiledRasterLayer<SpaceTimeKey> rasterize(SparkContext sc, byte[] geometryBytes, Map<String, Object> extent, String crs, int instant, int cols, int rows, int fillValue) {
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(GeoTrellisUtils$.MODULE$.JavaMapExtensions(extent).toExtent(), cols, rows);
        TemporalProjectedExtent temporalExtent = new TemporalProjectedExtent(rasterExtent.extent(), TileLayer$.MODULE$.getCRS(crs).get(), (long)instant);
        Tile tile = Rasterizer$.MODULE$.rasterizeWithValue(WKB$.MODULE$.read(geometryBytes), rasterExtent, fillValue);
        RDD rdd = sc.parallelize(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<TemporalProjectedExtent, MultibandTile>(temporalExtent, MultibandTile$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{tile})))}), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        TileLayout tileLayout = new TileLayout(1, 1, cols, rows);
        LayoutDefinition layoutDefinition = new LayoutDefinition(rasterExtent.extent(), tileLayout);
        TileLayerMetadata metadata = geotrellis.spark.package$.MODULE$.withCollectMetadataMethods(rdd).collectMetadata(layoutDefinition, (Boundable)SpaceTimeKey.Boundable$.MODULE$, SpaceTimeKey$.MODULE$.spatialComponent(), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()), (GetComponent)TemporalProjectedExtent$.MODULE$.projectedExtentComponent());
        return this.apply(None$.MODULE$, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(geotrellis.spark.package$.MODULE$.withTilerMethods(rdd, ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(metadata, SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent())), metadata));
    }

    public TemporalTiledRasterLayer unionLayers(SparkContext sc, ArrayList<TemporalTiledRasterLayer> layers) {
        Buffer<TemporalTiledRasterLayer> scalaLayers = JavaConverters$.MODULE$.asScalaBufferConverter(layers).asScala();
        RDD result = sc.union((Seq)scalaLayers.map((Function1<TemporalTiledRasterLayer, RDD> & Serializable & scala.Serializable)x$24 -> x$24.rdd(), Buffer$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Tuple2.class));
        TemporalTiledRasterLayer firstLayer = (TemporalTiledRasterLayer)scalaLayers.head();
        Option<Object> zoomLevel = firstLayer.zoomLevel();
        ObjectRef<TileLayerMetadata> unionedMetadata = ObjectRef.create((TileLayerMetadata)((Metadata)firstLayer.rdd()).metadata());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), scalaLayers.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)x -> {
            TileLayerMetadata otherMetadata = (TileLayerMetadata)((Metadata)((TemporalTiledRasterLayer)scalaLayers.apply(x)).rdd()).metadata();
            unionedMetadata$1.elem = ((TileLayerMetadata)unionedMetadata$1.elem).combine(otherMetadata, (Boundable)SpaceTimeKey.Boundable$.MODULE$);
        });
        return this.apply(zoomLevel, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)ContextRDD$.MODULE$.apply(result, (Object)((TileLayerMetadata)unionedMetadata.elem)));
    }

    public TemporalTiledRasterLayer combineBands(SparkContext sc, ArrayList<TemporalTiledRasterLayer> layers) {
        TemporalTiledRasterLayer baseLayer = layers.get(0);
        RDD result = TileLayer$.MODULE$.combineBands(sc, layers, ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(TemporalTiledRasterLayer.class));
        return this.apply(baseLayer.zoomLevel(), (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)ContextRDD$.MODULE$.apply(result, ((Metadata)baseLayer.rdd()).metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TemporalTiledRasterLayer$() {
        MODULE$ = this;
    }
}

