/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.GlobalLayout;
import geopyspark.geotrellis.LayoutType;
import geopyspark.geotrellis.LocalLayout;
import geopyspark.geotrellis.LocalLayout$;
import geopyspark.geotrellis.PartitionStrategy;
import geopyspark.geotrellis.ProjectedRasterLayer;
import geopyspark.geotrellis.ProjectedRasterLayer$;
import geopyspark.geotrellis.RasterLayer;
import geopyspark.geotrellis.RasterSummary;
import geopyspark.geotrellis.RasterSummary$;
import geopyspark.geotrellis.TemporalRasterLayer$;
import geopyspark.geotrellis.TemporalTiledRasterLayer;
import geopyspark.geotrellis.TemporalTiledRasterLayer$;
import geopyspark.geotrellis.TileLayer$;
import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.package$;
import geopyspark.util.PythonTranslator$;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.FloatingLayoutScheme$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.crop.Implicits;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.merge.Implicits;
import geotrellis.raster.prototype.Implicits;
import geotrellis.raster.reproject.Implicits;
import geotrellis.raster.reproject.RasterRegionReproject$;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.Implicits;
import geotrellis.spark.package;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.reproject.TileRDDReproject$;
import geotrellis.spark.tiling.Tiler;
import geotrellis.vector.ProjectedExtent;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001\u0002\u0010 \u0001\u0011B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005e!)!\n\u0001C\u0001\u0017\")a\n\u0001C\u0001\u001f\")a\n\u0001C\u0001A\")a\r\u0001C\u0001O\")a\r\u0001C\u0001{\"1a\r\u0001C\u0001\u0003\u0007Aq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\f\u0001!\t!!\u0006\t\u000f\u0005-\u0001\u0001\"\u0001\u0002 !9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u00111\u0016\u0001\u0005\u0002\u0005}\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003'\u0004A\u0011AAk\u000f\u001d\tin\bE\u0001\u0003?4aAH\u0010\t\u0002\u0005\u0005\bB\u0002&\u0018\t\u0003\ty\u000fC\u0004\u0002r^!\t!a=\t\u000f\u0005ex\u0003\"\u0001\u0002|\"9\u0011q`\f\u0005\u0002\t\u0005\u0001b\u0002B\u000b/\u0011\u0005!q\u0003\u0005\n\u0005;9\u0012\u0011!C\u0005\u0005?\u00111\u0003V3na>\u0014\u0018\r\u001c*bgR,'\u000fT1zKJT!\u0001I\u0011\u0002\u0015\u001d,w\u000e\u001e:fY2L7OC\u0001#\u0003)9Wm\u001c9zgB\f'o[\u0002\u0001'\t\u0001Q\u0005E\u0002'O%j\u0011aH\u0005\u0003Q}\u00111BU1ti\u0016\u0014H*Y=feB\u0011!FL\u0007\u0002W)\u0011A&L\u0001\u0006Y\u0006LXM\u001d\u0006\u0002A%\u0011qf\u000b\u0002\u0018)\u0016l\u0007o\u001c:bYB\u0013xN[3di\u0016$W\t\u001f;f]R\f1A\u001d3e+\u0005\u0011\u0004cA\u001a<{5\tAG\u0003\u00021k)\u0011agN\u0001\u0006gB\f'o\u001b\u0006\u0003qe\na!\u00199bG\",'\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=i\t\u0019!\u000b\u0012#\u0011\ty\n\u0015fQ\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1A+\u001e9mKJ\u0002\"\u0001R$\u000e\u0003\u0015S!AR\u0017\u0002\rI\f7\u000f^3s\u0013\tAUIA\u0007Nk2$\u0018NY1oIRKG.Z\u0001\u0005e\u0012$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u00196\u0003\"A\n\u0001\t\u000bA\u001a\u0001\u0019\u0001\u001a\u0002\u001f\r|G\u000e\\3di6+G/\u00193bi\u0006$\"\u0001U.\u0011\u0005ECfB\u0001*W!\t\u0019v(D\u0001U\u0015\t)6%\u0001\u0004=e>|GOP\u0005\u0003/~\na\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qk\u0010\u0005\u00069\u0012\u0001\r!X\u0001\u000bY\u0006Lx.\u001e;UsB,\u0007C\u0001\u0014_\u0013\tyvD\u0001\u0006MCf|W\u000f\u001e+za\u0016$\"\u0001U1\t\u000b\t,\u0001\u0019A2\u0002!1\f\u0017p\\;u\t\u00164\u0017N\\5uS>t\u0007C\u0001\u0016e\u0013\t)7F\u0001\tMCf|W\u000f\u001e#fM&t\u0017\u000e^5p]\u0006aA/\u001b7f)>d\u0015-_8viR!\u0001N\u001c9y!\r1\u0013n[\u0005\u0003U~\u0011\u0001\u0003V5mK\u0012\u0014\u0016m\u001d;fe2\u000b\u00170\u001a:\u0011\u0005)b\u0017BA7,\u00051\u0019\u0006/Y2f)&lWmS3z\u0011\u0015yg\u00011\u0001Q\u00035a\u0017-_3s\u001b\u0016$\u0018\rZ1uC\")\u0011O\u0002a\u0001e\u0006q!/Z:b[BdW-T3uQ>$\u0007CA:w\u001b\u0005!(BA;F\u0003!\u0011Xm]1na2,\u0017BA<u\u00059\u0011Vm]1na2,W*\u001a;i_\u0012DQ!\u001f\u0004A\u0002i\f\u0011\u0003]1si&$\u0018n\u001c8TiJ\fG/Z4z!\t130\u0003\u0002}?\t\t\u0002+\u0019:uSRLwN\\*ue\u0006$XmZ=\u0015\u000b!tx0!\u0001\t\u000b\t<\u0001\u0019A2\t\u000bE<\u0001\u0019\u0001:\t\u000be<\u0001\u0019\u0001>\u0015\u000f!\f)!a\u0002\u0002\n!)A\f\u0003a\u0001;\")\u0011\u000f\u0003a\u0001e\")\u0011\u0010\u0003a\u0001u\u0006I!/\u001a9s_*,7\r\u001e\u000b\u0006\u0019\u0006=\u00111\u0003\u0005\u0007\u0003#I\u0001\u0019\u0001)\u0002\u0013Q\f'oZ3u\u0007J\u001b\u0006\"B9\n\u0001\u0004\u0011H#\u00035\u0002\u0018\u0005e\u00111DA\u000f\u0011\u0019\t\tB\u0003a\u0001!\")AL\u0003a\u0001;\")\u0011O\u0003a\u0001e\")\u0011P\u0003a\u0001uRI\u0001.!\t\u0002$\u0005\u0015\u0012q\u0005\u0005\u0007\u0003#Y\u0001\u0019\u0001)\t\u000b\t\\\u0001\u0019A2\t\u000bE\\\u0001\u0019\u0001:\t\u000be\\\u0001\u0019\u0001>\u0002\u0015I,7\r\\1tg&4\u0017\u0010F\u0002&\u0003[Aa!a\f\r\u0001\u0004\u0011\u0014a\u0004:fG2\f7o]5gS\u0016$'\u000b\u0012#\u0002!I,7\r\\1tg&4\u0017\u0010R8vE2,GcA\u0013\u00026!1\u0011qF\u0007A\u0002I\nqa^5uQJ#E\tF\u0002&\u0003wAa!!\u0010\u000f\u0001\u0004\u0011\u0014A\u0002:fgVdG/\u0001\u0006u_B\u0013x\u000e^8S\t\u0012#\"!a\u0011\u0011\r\u0005\u0015\u0013qJA*\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00026bm\u0006T1!!\u00146\u0003\r\t\u0007/[\u0005\u0005\u0003#\n9EA\u0004KCZ\f'\u000b\u0012#\u0011\u000by\n)&!\u0017\n\u0007\u0005]sHA\u0003BeJ\f\u0017\u0010E\u0002?\u00037J1!!\u0018@\u0005\u0011\u0011\u0015\u0010^3\u0002\u0011Q|\u0007K\\4S\t\u0012#B!a\u0011\u0002d!9\u0011Q\r\tA\u0002\u0005\u001d\u0014A\u00029oOJ#E\t\u0005\u00034w\u0005%\u0004#\u0002 BS\u0005M\u0013\u0001\u0004;p\u000f\u0016|G+\u001b4g%\u0012#ECCA\"\u0003_\n\u0019)!\"\u0002\"\"9\u0011\u0011O\tA\u0002\u0005M\u0014\u0001\u0002;bON\u0004B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0004hK>$\u0018N\u001a4\u000b\u0007\u0005uT)\u0001\u0002j_&!\u0011\u0011QA<\u0005\u0011!\u0016mZ:\t\u000bE\f\u0002\u0019\u0001:\t\u000f\u0005\u001d\u0015\u00031\u0001\u0002\n\u0006YA-Z2j[\u0006$\u0018n\u001c8t!\u0019\tY)!&\u0002\u001c:!\u0011QRAI\u001d\r\u0019\u0016qR\u0005\u0002\u0001&\u0019\u00111S \u0002\u000fA\f7m[1hK&!\u0011qSAM\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005Mu\bE\u0002?\u0003;K1!a(@\u0005\rIe\u000e\u001e\u0005\b\u0003G\u000b\u0002\u0019AAS\u000399Wm\u001c+jM\u001a|\u0005\u000f^5p]N\u0004B!!\u001e\u0002(&!\u0011\u0011VA<\u000599Um\u001c+jM\u001a|\u0005\u000f^5p]N\fa\u0002^8Ta\u0006$\u0018.\u00197MCf,'\u000f\u0006\u0003\u00020\u0006U\u0006c\u0001\u0014\u00022&\u0019\u00111W\u0010\u0003)A\u0013xN[3di\u0016$'+Y:uKJd\u0015-_3s\u0011\u001d\t9L\u0005a\u0001\u0003s\u000bq!\u001b8ti\u0006tG\u000fE\u0002?\u0003wK1!!0@\u0005\u0011auN\\4\u0015\u0005\u0005=\u0016aC2pY2,7\r^&fsN$\"!!2\u0011\r\u0005\u001d\u0017qZA*\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017\u0001B;uS2T!!!\u0013\n\t\u0005E\u0017\u0011\u001a\u0002\n\u0003J\u0014\u0018-\u001f'jgR\fQBZ5mi\u0016\u0014()\u001f+j[\u0016\u001cHc\u0001'\u0002X\"9\u0011\u0011\\\u000bA\u0002\u0005m\u0017!\u0002;j[\u0016\u001c\b#BAd\u0003\u001f\u0004\u0016a\u0005+f[B|'/\u00197SCN$XM\u001d'bs\u0016\u0014\bC\u0001\u0014\u0018'\u00159\u00121]Au!\rq\u0014Q]\u0005\u0004\u0003O|$AB!osJ+g\rE\u0002?\u0003WL1!!<@\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ty.A\nge>l\u0007K]8u_\u0016s7m\u001c3fIJ#E\tF\u0002M\u0003kDq!a>\u001a\u0001\u0004\t\u0019%A\u0004kCZ\f'\u000b\u0012#\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00071\u000bi\u0010C\u000315\u0001\u0007!'A\u0006v]&|g\u000eT1zKJ\u001cH#\u0002'\u0003\u0004\t=\u0001b\u0002B\u00037\u0001\u0007!qA\u0001\u0003g\u000e\u0004BA!\u0003\u0003\f5\tQ'C\u0002\u0003\u000eU\u0012Ab\u00159be.\u001cuN\u001c;fqRDqA!\u0005\u001c\u0001\u0004\u0011\u0019\"\u0001\u0004mCf,'o\u001d\t\u0006\u0003\u000f\fy\rT\u0001\rG>l'-\u001b8f\u0005\u0006tGm\u001d\u000b\u0006\u0019\ne!1\u0004\u0005\b\u0005\u000ba\u0002\u0019\u0001B\u0004\u0011\u001d\u0011\t\u0002\ba\u0001\u0005'\t1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0005\t\u0005\u0005G\u0011I#\u0004\u0002\u0003&)!!qEAg\u0003\u0011a\u0017M\\4\n\t\t-\"Q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class TemporalRasterLayer
extends RasterLayer<TemporalProjectedExtent> {
    private final RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> rdd;

    public static TemporalRasterLayer combineBands(SparkContext sparkContext, ArrayList<TemporalRasterLayer> arrayList) {
        return TemporalRasterLayer$.MODULE$.combineBands(sparkContext, arrayList);
    }

    public static TemporalRasterLayer unionLayers(SparkContext sparkContext, ArrayList<TemporalRasterLayer> arrayList) {
        return TemporalRasterLayer$.MODULE$.unionLayers(sparkContext, arrayList);
    }

    public static TemporalRasterLayer apply(RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> rDD) {
        return TemporalRasterLayer$.MODULE$.apply(rDD);
    }

    public static TemporalRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD) {
        return TemporalRasterLayer$.MODULE$.fromProtoEncodedRDD(javaRDD);
    }

    @Override
    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> rdd() {
        return this.rdd;
    }

    @Override
    public String collectMetadata(LayoutType layoutType) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(TemporalProjectedExtent.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()), TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), SpaceTimeKey$.MODULE$.spatialComponent(), SpaceTimeKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$1 -> x$1.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        return package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(((RasterSummary)sms.head()).toTileLayerMetadata(layoutType, SpaceTimeKey$.MODULE$.spatialComponent())._1()), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey())).noSpaces();
    }

    @Override
    public String collectMetadata(LayoutDefinition layoutDefinition) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(TemporalProjectedExtent.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()), TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), SpaceTimeKey$.MODULE$.spatialComponent(), SpaceTimeKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$2 -> x$2.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        return package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)new TileLayerMetadata(sm.cellType(), layoutDefinition, sm.extent(), sm.crs(), (Bounds)sm.bounds().setSpatialBounds(layoutDefinition.mapTransform().apply(sm.extent()), SpaceTimeKey$.MODULE$.spatialComponent()))), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Encoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey())).noSpaces();
    }

    @Override
    public TiledRasterLayer<SpaceTimeKey> tileToLayout(String layerMetadata, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(layerMetadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$3 -> {
            throw x$3;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(SpaceTimeKey$.MODULE$.spatialComponent(), (Decoder)SpaceTimeKey$.MODULE$.codecForSpaceTimeKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$4 -> {
            throw x$4;
        });
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        return new TemporalTiledRasterLayer(None$.MODULE$, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(md, options, SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent())), md));
    }

    @Override
    public TiledRasterLayer<SpaceTimeKey> tileToLayout(LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(TemporalProjectedExtent.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()), TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), SpaceTimeKey$.MODULE$.spatialComponent(), SpaceTimeKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$5 -> x$5.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        TileLayerMetadata metadata = new TileLayerMetadata(sm.cellType(), layoutDefinition, sm.extent(), sm.crs(), (Bounds)sm.bounds().setSpatialBounds(layoutDefinition.mapTransform().apply(sm.extent()), SpaceTimeKey$.MODULE$.spatialComponent()));
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        return TemporalTiledRasterLayer$.MODULE$.apply(None$.MODULE$, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(metadata, options, SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent())), metadata));
    }

    @Override
    public TiledRasterLayer<SpaceTimeKey> tileToLayout(LayoutType layoutType, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(TemporalProjectedExtent.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()), TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), SpaceTimeKey$.MODULE$.spatialComponent(), SpaceTimeKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$6 -> x$6.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        Tuple2 tuple2 = sm.toTileLayerMetadata(layoutType, SpaceTimeKey$.MODULE$.spatialComponent());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TileLayerMetadata metadata = tuple2._1();
        Option<Object> zoom = tuple2._2();
        Tuple2 tuple22 = new Tuple2(metadata, zoom);
        Tuple2 tuple23 = tuple22;
        TileLayerMetadata metadata2 = tuple23._1();
        Option<Object> zoom2 = tuple23._2();
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        RDD tiled = geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(metadata2, options, SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Function1<TemporalProjectedExtent, Implicits.withProjectedExtentTemporalTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()));
        return new TemporalTiledRasterLayer(zoom2, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(tiled, metadata2));
    }

    public TemporalRasterLayer reproject(String targetCRS, ResampleMethod resampleMethod) {
        CRS crs = TileLayer$.MODULE$.getCRS(targetCRS).get();
        return new TemporalRasterLayer((RDD<Tuple2<TemporalProjectedExtent, MultibandTile>>)geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(this.rdd(), TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self)).reproject(crs, Reproject.Options$.MODULE$.methodToOptions(resampleMethod)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TiledRasterLayer<SpaceTimeKey> reproject(String targetCRS, LayoutType layoutType, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        RDD reprojected;
        Option<Partitioner> partitioner = TileLayer$.MODULE$.getPartitioner(partitionStrategy, this.rdd().getNumPartitions());
        CRS crs = TileLayer$.MODULE$.getCRS(targetCRS).get();
        RDD<Tuple2<SpaceTimeKey, MultibandTile>> tiled = this.tileToLayout(LocalLayout$.MODULE$.apply(256), resampleMethod, partitionStrategy).rdd();
        boolean bl = false;
        GlobalLayout globalLayout = null;
        LayoutType layoutType2 = layoutType;
        if (layoutType2 instanceof GlobalLayout) {
            bl = true;
            globalLayout = (GlobalLayout)layoutType2;
            int tileSize = globalLayout.tileSize();
            Integer n = globalLayout.zoom();
            double threshold = globalLayout.threshold();
            if (n == null) {
                ZoomedLayoutScheme scheme = new ZoomedLayoutScheme(crs, tileSize, threshold);
                Tuple2 tuple2 = geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(tiled, SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).reproject(crs, (LayoutScheme)scheme, Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner);
                if (tuple2 == null) throw new MatchError(tuple2);
                int zoom = tuple2._1$mcI$sp();
                RDD reprojected2 = (RDD)tuple2._2();
                Tuple2<Integer, RDD> tuple22 = new Tuple2<Integer, RDD>(BoxesRunTime.boxToInteger(zoom), reprojected2);
                Tuple2<Integer, RDD> tuple23 = tuple22;
                int zoom2 = tuple23._1$mcI$sp();
                RDD reprojected3 = tuple23._2();
                return new TemporalTiledRasterLayer(new Some<Object>(BoxesRunTime.boxToInteger(zoom2)), (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)reprojected3);
            }
        }
        if (bl) {
            RDD reprojected4;
            int tileSize = globalLayout.tileSize();
            Integer zoom = globalLayout.zoom();
            double threshold = globalLayout.threshold();
            ZoomedLayoutScheme scheme = new ZoomedLayoutScheme(crs, tileSize, threshold);
            Tuple2 tuple2 = TileRDDReproject$.MODULE$.apply(tiled, crs, new Right(scheme.levelForZoom(Predef$.MODULE$.Integer2int(zoom)).layout()), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner, SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self));
            if (tuple2 == null) throw new MatchError(tuple2);
            RDD rDD = reprojected4 = (RDD)tuple2._2();
            RDD reprojected5 = rDD;
            return new TemporalTiledRasterLayer(new Some<Object>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(zoom))), (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)reprojected5);
        }
        if (!(layoutType2 instanceof LocalLayout)) throw new MatchError(layoutType2);
        LocalLayout localLayout = (LocalLayout)layoutType2;
        int tileCols = localLayout.tileCols();
        int tileRows = localLayout.tileRows();
        Tuple2 tuple2 = geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(tiled, SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).reproject(crs, (LayoutScheme)FloatingLayoutScheme$.MODULE$.apply(tileCols, tileRows), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner);
        if (tuple2 == null) throw new MatchError(tuple2);
        RDD rDD = reprojected = (RDD)tuple2._2();
        RDD reprojected6 = rDD;
        return new TemporalTiledRasterLayer(None$.MODULE$, (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)reprojected6);
    }

    @Override
    public TiledRasterLayer<SpaceTimeKey> reproject(String targetCRS, LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Option<Partitioner> partitioner = TileLayer$.MODULE$.getPartitioner(partitionStrategy, this.rdd().getNumPartitions());
        RDD<Tuple2<SpaceTimeKey, MultibandTile>> tiled = this.tileToLayout(layoutDefinition, resampleMethod, partitionStrategy).rdd();
        Tuple2 tuple2 = TileRDDReproject$.MODULE$.apply(tiled, TileLayer$.MODULE$.getCRS(targetCRS).get(), new Right(layoutDefinition), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner, SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpaceTimeKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int zoom = tuple2._1$mcI$sp();
        RDD reprojected = (RDD)tuple2._2();
        Tuple2<Integer, RDD> tuple22 = new Tuple2<Integer, RDD>(BoxesRunTime.boxToInteger(zoom), reprojected);
        Tuple2<Integer, RDD> tuple23 = tuple22;
        int zoom2 = tuple23._1$mcI$sp();
        RDD reprojected2 = tuple23._2();
        return TemporalTiledRasterLayer$.MODULE$.apply(new Some<Object>(BoxesRunTime.boxToInteger(zoom2)), (RDD<Tuple2<SpaceTimeKey, MultibandTile>>)reprojected2);
    }

    @Override
    public RasterLayer<TemporalProjectedExtent> reclassify(RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> reclassifiedRDD) {
        return TemporalRasterLayer$.MODULE$.apply(reclassifiedRDD);
    }

    @Override
    public RasterLayer<TemporalProjectedExtent> reclassifyDouble(RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> reclassifiedRDD) {
        return TemporalRasterLayer$.MODULE$.apply(reclassifiedRDD);
    }

    @Override
    public RasterLayer<TemporalProjectedExtent> withRDD(RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> result) {
        return TemporalRasterLayer$.MODULE$.apply(result);
    }

    @Override
    public JavaRDD<byte[]> toProtoRDD() {
        return PythonTranslator$.MODULE$.toPython(this.rdd(), package$.MODULE$.tupleTemporalProjectedExtentProtoBufCodec());
    }

    @Override
    public JavaRDD<byte[]> toPngRDD(RDD<Tuple2<TemporalProjectedExtent, byte[]>> pngRDD) {
        return PythonTranslator$.MODULE$.toPython(pngRDD, package$.MODULE$.tupleTemporalProjectedExtentImageProtoBufCodec());
    }

    @Override
    public JavaRDD<byte[]> toGeoTiffRDD(Tags tags, ResampleMethod resampleMethod, List<Object> decimations, GeoTiffOptions geoTiffOptions) {
        RDD geotiffRDD = this.rdd().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TemporalProjectedExtent k = (TemporalProjectedExtent)tuple2._1();
            MultibandTile v = (MultibandTile)tuple2._2();
            MultibandGeoTiff qual$1 = new MultibandGeoTiff(v, k.extent(), k.crs(), tags, geoTiffOptions, MultibandGeoTiff$.MODULE$.apply$default$6());
            ResampleMethod x$1 = resampleMethod;
            List x$2 = decimations;
            int x$3 = qual$1.withOverviews$default$3();
            MultibandGeoTiff geoTiff = qual$1.withOverviews(x$1, x$2, x$3);
            Tuple2<TemporalProjectedExtent, byte[]> tuple22 = new Tuple2<TemporalProjectedExtent, byte[]>(k, geoTiff.toByteArray());
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return PythonTranslator$.MODULE$.toPython(geotiffRDD, package$.MODULE$.tupleTemporalProjectedExtentImageProtoBufCodec());
    }

    public ProjectedRasterLayer toSpatialLayer(long instant) {
        RDD spatialRDD = this.rdd().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TemporalRasterLayer.$anonfun$toSpatialLayer$1(instant, x0$1))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x -> new Tuple2(((TemporalProjectedExtent)x._1()).projectedExtent(), x._2()), ClassTag$.MODULE$.apply(Tuple2.class));
        return ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)spatialRDD);
    }

    public ProjectedRasterLayer toSpatialLayer() {
        return ProjectedRasterLayer$.MODULE$.apply((RDD<Tuple2<ProjectedExtent, MultibandTile>>)this.rdd().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x -> new Tuple2(((TemporalProjectedExtent)x._1()).projectedExtent(), x._2()), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public ArrayList<byte[]> collectKeys() {
        RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> x$1 = this.rdd();
        ClassTag x$2 = ClassTag$.MODULE$.apply(TemporalProjectedExtent.class);
        ClassTag x$3 = ClassTag$.MODULE$.apply(MultibandTile.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return PythonTranslator$.MODULE$.toPython(Predef$.MODULE$.wrapRefArray((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).keys().collect()), package$.MODULE$.temporalProjectedExtentProtoBufCodec());
    }

    public TemporalRasterLayer filterByTimes(ArrayList<String> times2) {
        Tuple2[] timeBoundaries = (Tuple2[])((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(times2).asScala()).grouped(2).map((Function1<Buffer, Tuple2> & Serializable & scala.Serializable)list -> {
            Tuple2$mcJJ$sp tuple2$mcJJ$sp;
            Buffer buffer = list;
            Some<Buffer> some = Buffer$.MODULE$.unapplySeq(buffer);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                String a = (String)((BufferLike)some.get()).apply(0);
                String b = (String)((BufferLike)some.get()).apply(1);
                tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(ZonedDateTime.parse(a).toInstant().toEpochMilli(), ZonedDateTime.parse(b).toInstant().toEpochMilli());
            } else {
                Some<Buffer> some2 = Buffer$.MODULE$.unapplySeq(buffer);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                    String a = (String)((BufferLike)some2.get()).apply(0);
                    tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(ZonedDateTime.parse(a).toInstant().toEpochMilli(), ZonedDateTime.parse(a).toInstant().toEpochMilli());
                } else {
                    throw new MatchError(buffer);
                }
            }
            return tuple2$mcJJ$sp;
        }).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Function2<TemporalProjectedExtent, Tuple2, Object> & Serializable & scala.Serializable inRange = (Function2<TemporalProjectedExtent, Tuple2, Object> & Serializable & scala.Serializable)(tpe, range) -> BoxesRunTime.boxToBoolean(TemporalRasterLayer.$anonfun$filterByTimes$2(tpe, range));
        RDD filteredRDD = this.rdd().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TemporalRasterLayer.$anonfun$filterByTimes$3(timeBoundaries, inRange, x0$1)));
        return TemporalRasterLayer$.MODULE$.apply((RDD<Tuple2<TemporalProjectedExtent, MultibandTile>>)filteredRDD);
    }

    public static final /* synthetic */ boolean $anonfun$toSpatialLayer$1(long instant$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TemporalProjectedExtent key = (TemporalProjectedExtent)tuple2._1();
        boolean bl = key.instant() == instant$1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterByTimes$2(TemporalProjectedExtent tpe, Tuple2 range) {
        return range._1$mcJ$sp() <= tpe.instant() && tpe.instant() <= range._2$mcJ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$filterByTimes$4(Function2 inRange$1, TemporalProjectedExtent key$1, Tuple2 x$10) {
        return BoxesRunTime.unboxToBoolean(inRange$1.apply(key$1, x$10));
    }

    public static final /* synthetic */ boolean $anonfun$filterByTimes$3(Tuple2[] timeBoundaries$1, Function2 inRange$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TemporalProjectedExtent key = (TemporalProjectedExtent)tuple2._1();
        boolean bl = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])timeBoundaries$1)).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(TemporalRasterLayer.$anonfun$filterByTimes$4(inRange$1, key, x$10))))).size() != 0;
        return bl;
    }

    public TemporalRasterLayer(RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> rdd) {
        this.rdd = rdd;
        super(ClassTag$.MODULE$.apply(TemporalProjectedExtent.class), TemporalProjectedExtent$.MODULE$.projectedExtentComponent());
    }
}

