/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.PartitionStrategy;
import geopyspark.geotrellis.SpatialTiledRasterLayer;
import geopyspark.geotrellis.TileLayer$;
import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.package$;
import geopyspark.util.PythonTranslator$;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellType$;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.distance.EuclideanDistanceTile$;
import geotrellis.raster.rasterize.CellValue;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.package;
import geotrellis.spark.rasterize.RasterizeRDD$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.io.wkb.WKB$;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.DelaunayTriangulation$;
import geotrellis.vector.voronoi.VoronoiDiagram;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.ParsingFailure;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import protos.featureMessages.ProtoFeatureCellValue;
import protos.featureMessages.ProtoFeatureCellValue$;
import protos.tupleMessages.ProtoTuple;
import protos.tupleMessages.ProtoTuple$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction2$mcVII$sp;

public final class SpatialTiledRasterLayer$
implements scala.Serializable {
    public static SpatialTiledRasterLayer$ MODULE$;

    static {
        new SpatialTiledRasterLayer$();
    }

    public SpatialTiledRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD, String metadata) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(metadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$17 -> {
            throw x$17;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(geotrellis.util.package$.MODULE$.identityComponent(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$18 -> {
            throw x$18;
        });
        RDD tileLayer = package.MultibandTileLayerRDD$.MODULE$.apply(PythonTranslator$.MODULE$.fromPython((RDD<byte[]>)JavaRDD$.MODULE$.toRDD(javaRDD), (Function1<byte[], ProtoTuple> & Serializable & scala.Serializable)s2 -> (ProtoTuple)ProtoTuple$.MODULE$.parseFrom((byte[])s2), ClassTag$.MODULE$.apply(Tuple2.class), package$.MODULE$.tupleSpatialKeyProtoBufCodec()), md);
        return this.apply(None$.MODULE$, (RDD<Tuple2<SpatialKey, MultibandTile>>)tileLayer);
    }

    public SpatialTiledRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD, int zoomLevel, String metadata) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(metadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$19 -> {
            throw x$19;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(geotrellis.util.package$.MODULE$.identityComponent(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$20 -> {
            throw x$20;
        });
        RDD tileLayer = package.MultibandTileLayerRDD$.MODULE$.apply(PythonTranslator$.MODULE$.fromPython((RDD<byte[]>)JavaRDD$.MODULE$.toRDD(javaRDD), (Function1<byte[], ProtoTuple> & Serializable & scala.Serializable)s2 -> (ProtoTuple)ProtoTuple$.MODULE$.parseFrom((byte[])s2), ClassTag$.MODULE$.apply(Tuple2.class), package$.MODULE$.tupleSpatialKeyProtoBufCodec()), md);
        return this.apply(new Some<Object>(BoxesRunTime.boxToInteger(zoomLevel)), (RDD<Tuple2<SpatialKey, MultibandTile>>)tileLayer);
    }

    public SpatialTiledRasterLayer apply(Integer zoomLevel, RDD<Tuple2<SpatialKey, MultibandTile>> rdd) {
        SpatialTiledRasterLayer spatialTiledRasterLayer;
        Integer n = zoomLevel;
        if (n != null) {
            Integer n2 = n;
            spatialTiledRasterLayer = this.apply(new Some<Object>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(n2))), rdd);
        } else if (n == null) {
            spatialTiledRasterLayer = this.apply(None$.MODULE$, rdd);
        } else {
            throw new MatchError(n);
        }
        return spatialTiledRasterLayer;
    }

    public SpatialTiledRasterLayer apply(Option<Object> zoomLevel, RDD<Tuple2<SpatialKey, MultibandTile>> rdd) {
        return new SpatialTiledRasterLayer(zoomLevel, rdd);
    }

    public SpatialTiledRasterLayer rasterizeGeometry(RDD<byte[]> geomWKB, String geomCRS, int requestedZoom, double fillValue, String cellType, Rasterizer.Options options, PartitionStrategy partitionStrategy) {
        RDD geomRDD = geomWKB.map((Function1<byte[], Geometry> & Serializable & scala.Serializable)value -> WKB$.MODULE$.read(value), ClassTag$.MODULE$.apply(Geometry.class));
        Extent fullEnvelope = (Extent)geomRDD.map((Function1<Geometry, Extent> & Serializable & scala.Serializable)x$21 -> geotrellis.vector.package$.MODULE$.withExtraGeometryMethods(x$21).extent(), ClassTag$.MODULE$.apply(Extent.class)).reduce((Function2<Extent, Extent, Extent> & Serializable & scala.Serializable)(x$22, x$23) -> x$22.combine(x$23));
        return this.rasterizeGeometry((RDD<Geometry>)geomRDD, geomCRS, requestedZoom, fillValue, cellType, fullEnvelope, options, partitionStrategy);
    }

    public SpatialTiledRasterLayer rasterizeGeometry(SparkContext sc, ArrayList<byte[]> geomWKB, String geomCRS, int requestedZoom, double fillValue, String cellType, Rasterizer.Options options, PartitionStrategy partitionStrategy) {
        Buffer geoms = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(geomWKB).asScala()).map((Function1<byte[], Geometry> & Serializable & scala.Serializable)value -> WKB$.MODULE$.read(value), Buffer$.MODULE$.canBuildFrom());
        Extent fullEnvelope = (Extent)((TraversableOnce)geoms.map((Function1<Geometry, Extent> & Serializable & scala.Serializable)x$24 -> geotrellis.vector.package$.MODULE$.withExtraGeometryMethods(x$24).extent(), Buffer$.MODULE$.canBuildFrom())).reduce((Function2<Extent, Extent, Extent> & Serializable & scala.Serializable)(x$25, x$26) -> x$25.combine(x$26));
        RDD geomRDD = sc.parallelize(geoms, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Geometry.class));
        return this.rasterizeGeometry((RDD<Geometry>)geomRDD, geomCRS, requestedZoom, fillValue, cellType, fullEnvelope, options, partitionStrategy);
    }

    public SpatialTiledRasterLayer rasterizeGeometry(RDD<Geometry> geomRDD, String geomCRS, int requestedZoom, double fillValue, String requestedCellType, Extent extent, Rasterizer.Options options, PartitionStrategy partitionStrategy) {
        Option option;
        DataType cellType = CellType$.MODULE$.fromName(requestedCellType);
        CRS srcCRS = TileLayer$.MODULE$.getCRS(geomCRS).get();
        LayoutLevel layoutLevel = ZoomedLayoutScheme$.MODULE$.apply(srcCRS, ZoomedLayoutScheme$.MODULE$.apply$default$2(), ZoomedLayoutScheme$.MODULE$.apply$default$3()).levelForZoom(requestedZoom);
        if (layoutLevel == null) {
            throw new MatchError(layoutLevel);
        }
        int z = layoutLevel.zoom();
        LayoutDefinition ld = layoutLevel.layout();
        Tuple2<Integer, LayoutDefinition> tuple2 = new Tuple2<Integer, LayoutDefinition>(BoxesRunTime.boxToInteger(z), ld);
        Tuple2<Integer, LayoutDefinition> tuple22 = tuple2;
        int n = tuple22._1$mcI$sp();
        LayoutDefinition ld2 = tuple22._2();
        MapKeyTransform maptrans = ld2.mapTransform();
        GridBounds gridBounds = maptrans.apply(extent);
        if (gridBounds == null) {
            throw new MatchError(gridBounds);
        }
        int cmin = gridBounds.colMin$mcI$sp();
        int rmin = gridBounds.rowMin$mcI$sp();
        int cmax = gridBounds.colMax$mcI$sp();
        int rmax = gridBounds.rowMax$mcI$sp();
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple5 = new Tuple5<GridBounds, Integer, Integer, Integer, Integer>(gridBounds, BoxesRunTime.boxToInteger(cmin), BoxesRunTime.boxToInteger(rmin), BoxesRunTime.boxToInteger(cmax), BoxesRunTime.boxToInteger(rmax));
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple52 = tuple5;
        GridBounds gb = tuple52._1();
        int n2 = BoxesRunTime.unboxToInt(tuple52._2());
        int n3 = BoxesRunTime.unboxToInt(tuple52._3());
        int n4 = BoxesRunTime.unboxToInt(tuple52._4());
        int n5 = BoxesRunTime.unboxToInt(tuple52._5());
        PartitionStrategy partitionStrategy2 = partitionStrategy;
        if (partitionStrategy2 != null) {
            PartitionStrategy partitionStrategy3 = partitionStrategy2;
            option = partitionStrategy3.producePartitioner(scala.math.package$.MODULE$.max(gb.size$mcI$sp() / 512, 1));
        } else if (partitionStrategy2 == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(partitionStrategy2);
        }
        None$ partitioner = option;
        RDD<Geometry> x$1 = geomRDD;
        LayoutDefinition x$2 = ld2;
        DataType x$3 = cellType;
        double x$4 = fillValue;
        Rasterizer.Options x$5 = (Rasterizer.Options)Option$.MODULE$.apply(options).getOrElse((Function0<Rasterizer.Options> & Serializable & scala.Serializable)() -> Rasterizer.Options$.MODULE$.DEFAULT());
        None$ x$6 = partitioner;
        RDD tiles = RasterizeRDD$.MODULE$.fromGeometry(x$1, x$4, x$3, x$2, x$5, (Option)x$6);
        TileLayerMetadata metadata = new TileLayerMetadata(cellType, ld2, maptrans.apply(gb), srcCRS, (Bounds)KeyBounds$.MODULE$.apply(gb));
        return this.apply(new Some<Object>(BoxesRunTime.boxToInteger(requestedZoom)), (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(RDD$.MODULE$.rddToPairRDDFunctions(tiles, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tile.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1<Tile, MultibandTile> & Serializable & scala.Serializable)x$29 -> MultibandTile$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{x$29}))), metadata));
    }

    public SpatialTiledRasterLayer rasterizeFeaturesWithZIndex(RDD<byte[]> featureRDD, String geomCRS, int requestedZoom, String requestedCellType, Rasterizer.Options options, String zIndexCellType, PartitionStrategy partitionStrategy) {
        Option option;
        RDD<Feature<Geometry, CellValue>> scalaRDD = PythonTranslator$.MODULE$.fromPython(featureRDD, (Function1<byte[], ProtoFeatureCellValue> & Serializable & scala.Serializable)s2 -> (ProtoFeatureCellValue)ProtoFeatureCellValue$.MODULE$.parseFrom((byte[])s2), ClassTag$.MODULE$.apply(Feature.class), package$.MODULE$.featureCellValueProtoBufCodec());
        Extent fullEnvelope = (Extent)scalaRDD.map((Function1<Feature, Extent> & Serializable & scala.Serializable)x$30 -> geotrellis.vector.package$.MODULE$.withExtraGeometryMethods(x$30.geom()).extent(), ClassTag$.MODULE$.apply(Extent.class)).reduce((Function2<Extent, Extent, Extent> & Serializable & scala.Serializable)(x$31, x$32) -> x$31.combine(x$32));
        DataType cellType = CellType$.MODULE$.fromName(requestedCellType);
        DataType zCellType = CellType$.MODULE$.fromName(zIndexCellType);
        CRS srcCRS = TileLayer$.MODULE$.getCRS(geomCRS).get();
        LayoutLevel layoutLevel = ZoomedLayoutScheme$.MODULE$.apply(srcCRS, ZoomedLayoutScheme$.MODULE$.apply$default$2(), ZoomedLayoutScheme$.MODULE$.apply$default$3()).levelForZoom(requestedZoom);
        if (layoutLevel == null) {
            throw new MatchError(layoutLevel);
        }
        int z = layoutLevel.zoom();
        LayoutDefinition ld = layoutLevel.layout();
        Tuple2<Integer, LayoutDefinition> tuple2 = new Tuple2<Integer, LayoutDefinition>(BoxesRunTime.boxToInteger(z), ld);
        Tuple2<Integer, LayoutDefinition> tuple22 = tuple2;
        int n = tuple22._1$mcI$sp();
        LayoutDefinition ld2 = tuple22._2();
        MapKeyTransform maptrans = ld2.mapTransform();
        GridBounds gridBounds = maptrans.apply(fullEnvelope);
        if (gridBounds == null) {
            throw new MatchError(gridBounds);
        }
        int cmin = gridBounds.colMin$mcI$sp();
        int rmin = gridBounds.rowMin$mcI$sp();
        int cmax = gridBounds.colMax$mcI$sp();
        int rmax = gridBounds.rowMax$mcI$sp();
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple5 = new Tuple5<GridBounds, Integer, Integer, Integer, Integer>(gridBounds, BoxesRunTime.boxToInteger(cmin), BoxesRunTime.boxToInteger(rmin), BoxesRunTime.boxToInteger(cmax), BoxesRunTime.boxToInteger(rmax));
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple52 = tuple5;
        GridBounds gb = tuple52._1();
        int n2 = BoxesRunTime.unboxToInt(tuple52._2());
        int n3 = BoxesRunTime.unboxToInt(tuple52._3());
        int n4 = BoxesRunTime.unboxToInt(tuple52._4());
        int n5 = BoxesRunTime.unboxToInt(tuple52._5());
        PartitionStrategy partitionStrategy2 = partitionStrategy;
        if (partitionStrategy2 != null) {
            PartitionStrategy partitionStrategy3 = partitionStrategy2;
            option = partitionStrategy3.producePartitioner(scala.math.package$.MODULE$.max(gb.size$mcI$sp() / 512, 1));
        } else if (partitionStrategy2 == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(partitionStrategy2);
        }
        None$ partitioner = option;
        RDD tiles = RasterizeRDD$.MODULE$.fromFeatureWithZIndex(scalaRDD, cellType, ld2, (Rasterizer.Options)Option$.MODULE$.apply(options).getOrElse((Function0<Rasterizer.Options> & Serializable & scala.Serializable)() -> Rasterizer.Options$.MODULE$.DEFAULT()), (Option)partitioner, zCellType);
        TileLayerMetadata metadata = new TileLayerMetadata(cellType, ld2, maptrans.apply(gb), srcCRS, (Bounds)KeyBounds$.MODULE$.apply(gb));
        return this.apply(new Some<Object>(BoxesRunTime.boxToInteger(requestedZoom)), (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(RDD$.MODULE$.rddToPairRDDFunctions(tiles, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tile.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1<Tile, MultibandTile> & Serializable & scala.Serializable)x$35 -> MultibandTile$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{x$35}))), metadata));
    }

    public TiledRasterLayer<SpatialKey> euclideanDistance(SparkContext sc, byte[] geomWKB, String geomCRSStr, String cellTypeString, int requestedZoom) {
        Coordinate[] coordinateArray;
        DataType cellType = CellType$.MODULE$.fromName(cellTypeString);
        Geometry geom = WKB$.MODULE$.read(geomWKB);
        CRS srcCRS = TileLayer$.MODULE$.getCRS(geomCRSStr).get();
        LayoutLevel layoutLevel = ZoomedLayoutScheme$.MODULE$.apply(srcCRS, ZoomedLayoutScheme$.MODULE$.apply$default$2(), ZoomedLayoutScheme$.MODULE$.apply$default$3()).levelForZoom(requestedZoom);
        if (layoutLevel == null) {
            throw new MatchError(layoutLevel);
        }
        int z = layoutLevel.zoom();
        LayoutDefinition ld = layoutLevel.layout();
        Tuple2<Integer, LayoutDefinition> tuple2 = new Tuple2<Integer, LayoutDefinition>(BoxesRunTime.boxToInteger(z), ld);
        Tuple2<Integer, LayoutDefinition> tuple22 = tuple2;
        int z2 = tuple22._1$mcI$sp();
        LayoutDefinition ld2 = tuple22._2();
        MapKeyTransform maptrans = ld2.mapTransform();
        GridBounds gridBounds = maptrans.apply(geotrellis.vector.package$.MODULE$.withExtraGeometryMethods(geom).extent());
        if (gridBounds == null) {
            throw new MatchError(gridBounds);
        }
        int cmin = gridBounds.colMin$mcI$sp();
        int rmin = gridBounds.rowMin$mcI$sp();
        int cmax = gridBounds.colMax$mcI$sp();
        int rmax = gridBounds.rowMax$mcI$sp();
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple5 = new Tuple5<GridBounds, Integer, Integer, Integer, Integer>(gridBounds, BoxesRunTime.boxToInteger(cmin), BoxesRunTime.boxToInteger(rmin), BoxesRunTime.boxToInteger(cmax), BoxesRunTime.boxToInteger(rmax));
        Tuple5<GridBounds, Integer, Integer, Integer, Integer> tuple52 = tuple5;
        GridBounds gb = tuple52._1();
        int cmin2 = BoxesRunTime.unboxToInt(tuple52._2());
        int rmin2 = BoxesRunTime.unboxToInt(tuple52._3());
        int cmax2 = BoxesRunTime.unboxToInt(tuple52._4());
        int rmax2 = BoxesRunTime.unboxToInt(tuple52._5());
        IndexedSeq keys = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(rmin2), rmax2).flatMap((Function1<Object, IndexedSeq> & Serializable & scala.Serializable)r -> SpatialTiledRasterLayer$.$anonfun$euclideanDistance$1(cmin2, cmax2, BoxesRunTime.unboxToInt(r)), IndexedSeq$.MODULE$.canBuildFrom());
        if (geom instanceof MultiPoint) {
            coordinateArray = (Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPointMethods((MultiPoint)geom).points())).map((Function1<Point, Coordinate> & Serializable & scala.Serializable)x$38 -> x$38.getCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class)));
        } else {
            ListBuffer coords = (ListBuffer)ListBuffer$.MODULE$.empty();
            keys.foreach((Function1<SpatialKey, Object> & Serializable & scala.Serializable)sk -> {
                SpatialTiledRasterLayer$.createPoints$1(sk, maptrans, ld2, coords, geom);
                return BoxedUnit.UNIT;
            });
            coordinateArray = (Coordinate[])coords.toArray(ClassTag$.MODULE$.apply(Coordinate.class));
        }
        Coordinate[] pts = coordinateArray;
        KryoWrapper dt = KryoWrapper$.MODULE$.apply((Object)DelaunayTriangulation$.MODULE$.apply(IndexedPointSet$.MODULE$.coordinateArrayToIndexedPointSet(pts), DelaunayTriangulation$.MODULE$.apply$default$2(), DelaunayTriangulation$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(DelaunayTriangulation.class));
        RDD skRDD = sc.parallelize(keys, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(SpatialKey.class));
        RDD mbtileRDD = skRDD.mapPartitions((Function1<Iterator, Iterator> & Serializable & scala.Serializable)skiter -> skiter.map((Function1<SpatialKey, Tuple2> & Serializable & scala.Serializable)sk -> {
            Extent ex = maptrans.apply(sk);
            RasterExtent re = RasterExtent$.MODULE$.apply(ex, ld2.tileCols(), ld2.tileRows());
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, re.cols(), re.rows());
            VoronoiDiagram vd = new VoronoiDiagram((DelaunayTriangulation)dt.value(), ex);
            vd.voronoiCellsWithPoints().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$40 -> {
                EuclideanDistanceTile$.MODULE$.rasterizeDistanceCell(re, tile, x$40);
                return BoxedUnit.UNIT;
            });
            return new Tuple2<SpatialKey, MultibandTile>((SpatialKey)sk, MultibandTile$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{tile})));
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        TileLayerMetadata metadata = new TileLayerMetadata(cellType, ld2, maptrans.apply(gb), srcCRS, (Bounds)KeyBounds$.MODULE$.apply(gb));
        return this.apply(new Some<Object>(BoxesRunTime.boxToInteger(z2)), (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(mbtileRDD, metadata));
    }

    public SpatialTiledRasterLayer unionLayers(SparkContext sc, ArrayList<SpatialTiledRasterLayer> layers) {
        Buffer<SpatialTiledRasterLayer> scalaLayers = JavaConverters$.MODULE$.asScalaBufferConverter(layers).asScala();
        RDD result = sc.union((Seq)scalaLayers.map((Function1<SpatialTiledRasterLayer, RDD> & Serializable & scala.Serializable)x$41 -> x$41.rdd(), Buffer$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Tuple2.class));
        SpatialTiledRasterLayer firstLayer = (SpatialTiledRasterLayer)scalaLayers.head();
        Option<Object> zoomLevel = firstLayer.zoomLevel();
        ObjectRef<TileLayerMetadata> unionedMetadata = ObjectRef.create((TileLayerMetadata)((Metadata)firstLayer.rdd()).metadata());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), scalaLayers.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)x -> {
            TileLayerMetadata otherMetadata = (TileLayerMetadata)((Metadata)((SpatialTiledRasterLayer)scalaLayers.apply(x)).rdd()).metadata();
            unionedMetadata$1.elem = ((TileLayerMetadata)unionedMetadata$1.elem).combine(otherMetadata, (Boundable)SpatialKey.Boundable$.MODULE$);
        });
        return this.apply(zoomLevel, (RDD<Tuple2<SpatialKey, MultibandTile>>)ContextRDD$.MODULE$.apply(result, (Object)((TileLayerMetadata)unionedMetadata.elem)));
    }

    public SpatialTiledRasterLayer combineBands(SparkContext sc, ArrayList<SpatialTiledRasterLayer> layers) {
        SpatialTiledRasterLayer baseLayer = layers.get(0);
        RDD result = TileLayer$.MODULE$.combineBands(sc, layers, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(SpatialTiledRasterLayer.class));
        return this.apply(baseLayer.zoomLevel(), (RDD<Tuple2<SpatialKey, MultibandTile>>)ContextRDD$.MODULE$.apply(result, ((Metadata)baseLayer.rdd()).metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ SpatialKey $anonfun$euclideanDistance$2(int r$1, int c) {
        return new SpatialKey(c, r$1);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$euclideanDistance$1(int cmin$1, int cmax$1, int r) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(cmin$1), cmax$1).map((Function1<Object, SpatialKey> & Serializable & scala.Serializable)c -> SpatialTiledRasterLayer$.$anonfun$euclideanDistance$2(r, BoxesRunTime.unboxToInt(c)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private static final void rasterizeToPoints$1(int px, int py, RasterExtent re$1, ListBuffer coords$1) {
        Tuple2 tuple2 = re$1.gridToMap$mcI$sp(px, py);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2$mcDD$sp tuple2$mcDD$sp = new Tuple2$mcDD$sp(x, y);
        Tuple2$mcDD$sp tuple2$mcDD$sp2 = tuple2$mcDD$sp;
        double x2 = ((Tuple2)tuple2$mcDD$sp2)._1$mcD$sp();
        double y2 = ((Tuple2)tuple2$mcDD$sp2)._2$mcD$sp();
        Coordinate coord = new Coordinate(x2, y2);
        coords$1.$plus$eq(coord);
    }

    private static final void createPoints$1(SpatialKey sk, MapKeyTransform maptrans$1, LayoutDefinition ld$1, ListBuffer coords$1, Geometry geom$2) {
        Extent ex = maptrans$1.apply(sk);
        RasterExtent re = RasterExtent$.MODULE$.apply(ex, ld$1.tileCols(), ld$1.tileRows());
        Rasterizer$.MODULE$.foreachCellByGeometry(geom$2, re, (JFunction2$mcVII$sp & scala.Serializable)(px, py) -> SpatialTiledRasterLayer$.rasterizeToPoints$1(px, py, re, coords$1));
    }

    private SpatialTiledRasterLayer$() {
        MODULE$ = this;
    }
}

