/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import geopyspark.geotrellis.LayoutType;
import geopyspark.geotrellis.RasterSummary$;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.MultibandTile;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t-h\u0001\u0002\u0014(\u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005y!AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005W\u0001\tE\t\u0015!\u0003G\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B-\t\u0011y\u0003!Q3A\u0005\u0002}C\u0001B\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\tO\u0002\u0011)\u001a!C\u0001Q\"A!\u0010\u0001B\tB\u0003%\u0011\u000e\u0003\u0005|\u0001\tU\r\u0011\"\u0001}\u0011%\t\t\u0001\u0001B\tB\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\ty\bAI\u0001\n\u0003\t\t\tC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0001\u0002\u001e\"I\u0011Q\u0015\u0001\u0012\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u0003cC\u0011\"!/\u0001#\u0003%\t!a/\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0007\"CAg\u0001\u0005\u0005I\u0011IAh\u0011%\t\t\u000fAA\u0001\n\u0003\t\u0019\u000fC\u0005\u0002f\u0002\t\t\u0011\"\u0001\u0002h\"I\u0011Q\u001e\u0001\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003{\u0004\u0011\u0011!C\u0001\u0003\u007fD\u0011B!\u0003\u0001\u0003\u0003%\tEa\u0003\t\u0013\t5\u0001!!A\u0005B\t=\u0001\"\u0003B\t\u0001\u0005\u0005I\u0011\tB\n\u000f\u001d\u00119b\nE\u0001\u000531aAJ\u0014\t\u0002\tm\u0001bBA\u0002A\u0011\u0005!Q\u0004\u0005\b\u0005?\u0001C\u0011\u0001B\u0011\u0011%\u0011i\u000bIA\u0001\n\u0003\u0013y\u000bC\u0005\u0003H\u0002\n\t\u0011\"!\u0003J\"I!\u0011\u001d\u0011\u0002\u0002\u0013%!1\u001d\u0002\u000e%\u0006\u001cH/\u001a:Tk6l\u0017M]=\u000b\u0005!J\u0013AC4f_R\u0014X\r\u001c7jg*\t!&\u0001\u0006hK>\u0004\u0018p\u001d9be.\u001c\u0001!\u0006\u0002.cN!\u0001A\f\u001b8!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011q&N\u0005\u0003mA\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00020q%\u0011\u0011\b\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004GJ\u001cX#\u0001\u001f\u0011\u0005u\nU\"\u0001 \u000b\u0005}\u0002\u0015!\u00029s_*$$\"\u0001\u0015\n\u0005\ts$aA\"S'\u0006!1M]:!\u0003!\u0019W\r\u001c7UsB,W#\u0001$\u0011\u0005\u001d\u001bfB\u0001%Q\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002MW\u00051AH]8pizJ\u0011\u0001K\u0005\u0003\u001f\u0002\u000baA]1ti\u0016\u0014\u0018BA)S\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0014!\n\u0005Q+&\u0001C\"fY2$\u0016\u0010]3\u000b\u0005E\u0013\u0016!C2fY2$\u0016\u0010]3!\u0003!\u0019W\r\u001c7TSj,W#A-\u0011\u0005i[V\"\u0001*\n\u0005q\u0013&\u0001C\"fY2\u001c\u0016N_3\u0002\u0013\r,G\u000e\\*ju\u0016\u0004\u0013AB3yi\u0016tG/F\u0001a!\t\tG-D\u0001c\u0015\t\u0019\u0007)\u0001\u0004wK\u000e$xN]\u0005\u0003K\n\u0014a!\u0012=uK:$\u0018aB3yi\u0016tG\u000fI\u0001\u0007E>,h\u000eZ:\u0016\u0003%\u00042A[7p\u001b\u0005Y'B\u00017A\u0003\u0015a\u0017-_3s\u0013\tq7NA\u0005LKf\u0014u.\u001e8egB\u0011\u0001/\u001d\u0007\u0001\t\u0015\u0011\bA1\u0001t\u0005\u0005Y\u0015C\u0001;x!\tyS/\u0003\u0002wa\t9aj\u001c;iS:<\u0007CA\u0018y\u0013\tI\bGA\u0002B]f\fqAY8v]\u0012\u001c\b%A\u0005uS2,7i\\;oiV\tQ\u0010\u0005\u00020}&\u0011q\u0010\r\u0002\u0005\u0019>tw-\u0001\u0006uS2,7i\\;oi\u0002\na\u0001P5oSRtDCDA\u0004\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011Q\u0003\t\u0005\u0003\u0013\u0001q.D\u0001(\u0011\u0015QT\u00021\u0001=\u0011\u0015!U\u00021\u0001G\u0011\u00159V\u00021\u0001Z\u0011\u0015qV\u00021\u0001a\u0011\u00159W\u00021\u0001j\u0011\u0015YX\u00021\u0001~\u0003\u001d\u0019w.\u001c2j]\u0016$B!a\u0007\u0002(Q!\u0011qAA\u000f\u0011\u001d\tyB\u0004a\u0002\u0003C\t!!\u001a<\u0011\t)\f\u0019c\\\u0005\u0004\u0003KY'!\u0003\"pk:$\u0017M\u00197f\u0011\u001d\tIC\u0004a\u0001\u0003\u000f\tQa\u001c;iKJ\f1\u0003^8US2,G*Y=fe6+G/\u00193bi\u0006$B!a\f\u0002\\Q!\u0011\u0011GA%!\u001dy\u00131GA\u001c\u0003{I1!!\u000e1\u0005\u0019!V\u000f\u001d7feA!!.!\u000fp\u0013\r\tYd\u001b\u0002\u0012)&dW\rT1zKJlU\r^1eCR\f\u0007#B\u0018\u0002@\u0005\r\u0013bAA!a\t1q\n\u001d;j_:\u00042aLA#\u0013\r\t9\u0005\r\u0002\u0004\u0013:$\bbBA\u0010\u001f\u0001\u000f\u00111\n\t\u0006\u0003\u001b\n)f\u001c\b\u0005\u0003\u001f\n\u0019FD\u0002J\u0003#J!\u0001\u001c!\n\u0005E[\u0017\u0002BA,\u00033\u0012\u0001c\u00159bi&\fGnQ8na>tWM\u001c;\u000b\u0005E[\u0007bBA/\u001f\u0001\u0007\u0011qL\u0001\u000bY\u0006Lx.\u001e;UsB,\u0007\u0003BA\u0005\u0003CJ1!a\u0019(\u0005)a\u0015-_8viRK\b/Z\u0001\u0005G>\u0004\u00180\u0006\u0003\u0002j\u0005=DCDA6\u0003c\n\u0019(!\u001e\u0002x\u0005e\u0014Q\u0010\t\u0006\u0003\u0013\u0001\u0011Q\u000e\t\u0004a\u0006=D!\u0002:\u0011\u0005\u0004\u0019\bb\u0002\u001e\u0011!\u0003\u0005\r\u0001\u0010\u0005\b\tB\u0001\n\u00111\u0001G\u0011\u001d9\u0006\u0003%AA\u0002eCqA\u0018\t\u0011\u0002\u0003\u0007\u0001\r\u0003\u0005h!A\u0005\t\u0019AA>!\u0011QW.!\u001c\t\u000fm\u0004\u0002\u0013!a\u0001{\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BAB\u00033+\"!!\"+\u0007q\n9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019\nM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015\u0011\u0018C1\u0001t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*B!a(\u0002$V\u0011\u0011\u0011\u0015\u0016\u0004\r\u0006\u001dE!\u0002:\u0013\u0005\u0004\u0019\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0005\u0003S\u000bi+\u0006\u0002\u0002,*\u001a\u0011,a\"\u0005\u000bI\u001c\"\u0019A:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU!\u00111WA\\+\t\t)LK\u0002a\u0003\u000f#QA\u001d\u000bC\u0002M\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0003\u0002>\u0006\u0005WCAA`U\rI\u0017q\u0011\u0003\u0006eV\u0011\ra]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\u0011\t9-a3\u0016\u0005\u0005%'fA?\u0002\b\u0012)!O\u0006b\u0001g\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!5\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006!A.\u00198h\u0015\t\tY.\u0001\u0003kCZ\f\u0017\u0002BAp\u0003+\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\"\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a^Au\u0011%\tY/GA\u0001\u0002\u0004\t\u0019%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0004R!a=\u0002z^l!!!>\u000b\u0007\u0005]\b'\u0001\u0006d_2dWm\u0019;j_:LA!a?\u0002v\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tAa\u0002\u0011\u0007=\u0012\u0019!C\u0002\u0003\u0006A\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002ln\t\t\u00111\u0001x\u0003!A\u0017m\u001d5D_\u0012,GCAA\"\u0003!!xn\u0015;sS:<GCAAi\u0003\u0019)\u0017/^1mgR!!\u0011\u0001B\u000b\u0011!\tYOHA\u0001\u0002\u00049\u0018!\u0004*bgR,'oU;n[\u0006\u0014\u0018\u0010E\u0002\u0002\n\u0001\u001a2\u0001\t\u00188)\t\u0011I\"A\u0004d_2dWm\u0019;\u0016\r\t\r\"q\nB\u001e)\u0011\u0011)C!$\u0015\u0019\t\u001d\"q\bB)\u0005W\u0012\tIa\"\u0011\r\t%\"\u0011\u0007B\u001c\u001d\u0011\u0011YCa\f\u000f\u0007)\u0013i#C\u00012\u0013\t\t\u0006'\u0003\u0003\u00034\tU\"aA*fc*\u0011\u0011\u000b\r\t\u0006\u0003\u0013\u0001!\u0011\b\t\u0004a\nmBA\u0002B\u001fE\t\u00071O\u0001\u0002Le!9\u0011q\u0004\u0012A\u0004\t\u0005\u0003C\u0002B\"\u0005\u0013\u0012i%\u0004\u0002\u0003F)\u0019!q\t\u0019\u0002\u000fI,g\r\\3di&!!1\nB#\u0005!\u0019E.Y:t)\u0006<\u0007c\u00019\u0003P\u0011)!O\tb\u0001g\"9!1\u000b\u0012A\u0004\tU\u0013aA3waA9qFa\u0016\u0003N\tm\u0013b\u0001B-a\tIa)\u001e8di&|g.\r\t\t\u0005;\u00129G!\u0014\u0003:5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'\u0001\u0004uS2Lgn\u001a\u0006\u0004\u0005K\u0002\u0015!B:qCJ\\\u0017\u0002\u0002B5\u0005?\u0012q\u0002V5mKJ\\U-_'fi\"|Gm\u001d\u0005\b\u0005[\u0012\u00039\u0001B8\u0003\r)g/\r\t\t\u0005c\u00129H!\u0014\u0003|5\u0011!1\u000f\u0006\u0004\u0005k\u0002\u0015\u0001B;uS2LAA!\u001f\u0003t\taq)\u001a;D_6\u0004xN\\3oiB\u0019\u0011M! \n\u0007\t}$MA\bQe>TWm\u0019;fI\u0016CH/\u001a8u\u0011\u001d\u0011\u0019I\ta\u0002\u0005\u000b\u000b1!\u001a<3!\u0019\ti%!\u0016\u0003:!9!\u0011\u0012\u0012A\u0004\t-\u0015aA3wgA)!.a\t\u0003:!9!q\u0012\u0012A\u0002\tE\u0015a\u0001:eIB1!1\u0013BQ\u0005Kk!A!&\u000b\t\t=%q\u0013\u0006\u0005\u0005K\u0012IJ\u0003\u0003\u0003\u001c\nu\u0015AB1qC\u000eDWM\u0003\u0002\u0003 \u0006\u0019qN]4\n\t\t\r&Q\u0013\u0002\u0004%\u0012#\u0005cB\u0018\u00024\t5#q\u0015\t\u00045\n%\u0016b\u0001BV%\niQ*\u001e7uS\n\fg\u000e\u001a+jY\u0016\fQ!\u00199qYf,BA!-\u00038Rq!1\u0017B]\u0005w\u0013iLa0\u0003B\n\u0015\u0007#BA\u0005\u0001\tU\u0006c\u00019\u00038\u0012)!o\tb\u0001g\")!h\ta\u0001y!)Ai\ta\u0001\r\")qk\ta\u00013\")al\ta\u0001A\"1qm\ta\u0001\u0005\u0007\u0004BA[7\u00036\")1p\ta\u0001{\u00069QO\\1qa2LX\u0003\u0002Bf\u00053$BA!4\u0003\\B)q&a\u0010\u0003PBQqF!5=\rf\u0003'Q[?\n\u0007\tM\u0007G\u0001\u0004UkBdWM\u000e\t\u0005U6\u00149\u000eE\u0002q\u00053$QA\u001d\u0013C\u0002MD\u0011B!8%\u0003\u0003\u0005\rAa8\u0002\u0007a$\u0003\u0007E\u0003\u0002\n\u0001\u00119.A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bs!\u0011\t\u0019Na:\n\t\t%\u0018Q\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class RasterSummary<K>
implements Product,
scala.Serializable {
    private final CRS crs;
    private final DataType cellType;
    private final CellSize cellSize;
    private final Extent extent;
    private final KeyBounds<K> bounds;
    private final long tileCount;

    public static <K> Option<Tuple6<CRS, DataType, CellSize, Extent, KeyBounds<K>, Object>> unapply(RasterSummary<K> rasterSummary) {
        return RasterSummary$.MODULE$.unapply(rasterSummary);
    }

    public static <K> RasterSummary<K> apply(CRS cRS, DataType dataType, CellSize cellSize, Extent extent, KeyBounds<K> keyBounds, long l) {
        return RasterSummary$.MODULE$.apply(cRS, dataType, cellSize, extent, keyBounds, l);
    }

    public static <K, K2> Seq<RasterSummary<K2>> collect(RDD<Tuple2<K, MultibandTile>> rDD, ClassTag<K> classTag, Function1<K, TilerKeyMethods<K, K2>> function1, GetComponent<K, ProjectedExtent> getComponent, Component<K2, SpatialKey> component, Boundable<K2> boundable) {
        return RasterSummary$.MODULE$.collect(rDD, classTag, function1, getComponent, component, boundable);
    }

    public CRS crs() {
        return this.crs;
    }

    public DataType cellType() {
        return this.cellType;
    }

    public CellSize cellSize() {
        return this.cellSize;
    }

    public Extent extent() {
        return this.extent;
    }

    public KeyBounds<K> bounds() {
        return this.bounds;
    }

    public long tileCount() {
        return this.tileCount;
    }

    public RasterSummary<K> combine(RasterSummary<K> other, Boundable<K> ev) {
        CRS cRS = other.crs();
        CRS cRS2 = this.crs();
        Predef$.MODULE$.require(!(cRS != null ? !cRS.equals(cRS2) : cRS2 != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Can't combine LayerExtent for different CRS: ").append(this.crs()).append(", ").append(other.crs()).toString());
        CellSize smallestCellSize = this.cellSize().resolution() < other.cellSize().resolution() ? this.cellSize() : other.cellSize();
        return new RasterSummary<K>(this.crs(), this.cellType().union(other.cellType()), smallestCellSize, this.extent().combine(other.extent()), this.bounds().combine(other.bounds(), ev), this.tileCount() + other.tileCount());
    }

    public Tuple2<TileLayerMetadata<K>, Option<Object>> toTileLayerMetadata(LayoutType layoutType, Component<K, SpatialKey> ev) {
        Tuple2<LayoutDefinition, Option<Object>> tuple2 = layoutType.layoutDefinitionWithZoom(this.crs(), this.extent(), this.cellSize());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LayoutDefinition ld = tuple2._1();
        Option<Object> zoom = tuple2._2();
        Tuple2<LayoutDefinition, Option<Object>> tuple22 = new Tuple2<LayoutDefinition, Option<Object>>(ld, zoom);
        Tuple2<LayoutDefinition, Option<Object>> tuple23 = tuple22;
        LayoutDefinition ld2 = tuple23._1();
        Option<Object> zoom2 = tuple23._2();
        KeyBounds dataBounds = this.bounds().setSpatialBounds(ld2.mapTransform().apply(this.extent()), ev);
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TileLayerMetadata(this.cellType(), ld2, this.extent(), this.crs(), (Bounds)dataBounds)), zoom2);
    }

    public <K> RasterSummary<K> copy(CRS crs, DataType cellType, CellSize cellSize, Extent extent, KeyBounds<K> bounds, long tileCount) {
        return new RasterSummary<K>(crs, cellType, cellSize, extent, bounds, tileCount);
    }

    public <K> CRS copy$default$1() {
        return this.crs();
    }

    public <K> DataType copy$default$2() {
        return this.cellType();
    }

    public <K> CellSize copy$default$3() {
        return this.cellSize();
    }

    public <K> Extent copy$default$4() {
        return this.extent();
    }

    public <K> KeyBounds<K> copy$default$5() {
        return this.bounds();
    }

    public <K> long copy$default$6() {
        return this.tileCount();
    }

    @Override
    public String productPrefix() {
        return "RasterSummary";
    }

    @Override
    public int productArity() {
        return 6;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.crs();
                break;
            }
            case 1: {
                object = this.cellType();
                break;
            }
            case 2: {
                object = this.cellSize();
                break;
            }
            case 3: {
                object = this.extent();
                break;
            }
            case 4: {
                object = this.bounds();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToLong(this.tileCount());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof RasterSummary;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, Statics.anyHash(this.crs()));
        n = Statics.mix(n, Statics.anyHash(this.cellType()));
        n = Statics.mix(n, Statics.anyHash(this.cellSize()));
        n = Statics.mix(n, Statics.anyHash(this.extent()));
        n = Statics.mix(n, Statics.anyHash(this.bounds()));
        n = Statics.mix(n, Statics.longHash(this.tileCount()));
        return Statics.finalizeHash(n, 6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RasterSummary)) return false;
        boolean bl = true;
        if (!bl) return false;
        RasterSummary rasterSummary = (RasterSummary)x$1;
        CRS cRS = this.crs();
        CRS cRS2 = rasterSummary.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        DataType dataType = this.cellType();
        DataType dataType2 = rasterSummary.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        CellSize cellSize = this.cellSize();
        CellSize cellSize2 = rasterSummary.cellSize();
        if (cellSize == null) {
            if (cellSize2 != null) {
                return false;
            }
        } else if (!cellSize.equals(cellSize2)) return false;
        Extent extent = this.extent();
        Extent extent2 = rasterSummary.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        KeyBounds<K> keyBounds = this.bounds();
        KeyBounds<K> keyBounds2 = rasterSummary.bounds();
        if (keyBounds == null) {
            if (keyBounds2 != null) {
                return false;
            }
        } else if (!keyBounds.equals(keyBounds2)) return false;
        if (this.tileCount() != rasterSummary.tileCount()) return false;
        if (!rasterSummary.canEqual(this)) return false;
        return true;
    }

    public RasterSummary(CRS crs, DataType cellType, CellSize cellSize, Extent extent, KeyBounds<K> bounds, long tileCount) {
        this.crs = crs;
        this.cellType = cellType;
        this.cellSize = cellSize;
        this.extent = extent;
        this.bounds = bounds;
        this.tileCount = tileCount;
        Product.$init$(this);
    }
}

