/*
 * Decompiled with CFR 0.152.
 */
package geopyspark.geotrellis;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geopyspark.geotrellis.GlobalLayout;
import geopyspark.geotrellis.LayoutType;
import geopyspark.geotrellis.LocalLayout;
import geopyspark.geotrellis.LocalLayout$;
import geopyspark.geotrellis.PartitionStrategy;
import geopyspark.geotrellis.ProjectedRasterLayer$;
import geopyspark.geotrellis.RasterLayer;
import geopyspark.geotrellis.RasterSummary;
import geopyspark.geotrellis.RasterSummary$;
import geopyspark.geotrellis.SpatialTiledRasterLayer;
import geopyspark.geotrellis.SpatialTiledRasterLayer$;
import geopyspark.geotrellis.TileLayer$;
import geopyspark.geotrellis.TiledRasterLayer;
import geopyspark.geotrellis.package$;
import geopyspark.util.PythonTranslator$;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.FloatingLayoutScheme$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.crop.Implicits;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.merge.Implicits;
import geotrellis.raster.prototype.Implicits;
import geotrellis.raster.reproject.Implicits;
import geotrellis.raster.reproject.RasterRegionReproject$;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.Implicits;
import geotrellis.spark.package;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.reproject.TileRDDReproject$;
import geotrellis.spark.tiling.Tiler;
import geotrellis.vector.ProjectedExtent;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u000e\u001d\u0001\u0005B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\t\r\u0002\u0011\t\u0011)A\u0005_!)q\t\u0001C\u0001\u0011\")1\n\u0001C\u0001\u0019\")1\n\u0001C\u0001;\")a\r\u0001C\u0001O\")a\r\u0001C\u0001{\"1a\r\u0001C\u0001\u0003\u0007Aq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\f\u0001!\t!!\u0006\t\u000f\u0005-\u0001\u0001\"\u0001\u0002 !9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u001e9\u0011q\u0018\u000f\t\u0002\u0005\u0005gAB\u000e\u001d\u0011\u0003\t\u0019\r\u0003\u0004H)\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003'$B\u0011AAk\u0011\u001d\tY\u000e\u0006C\u0001\u0003;Dq!!9\u0015\t\u0003\t\u0019\u000fC\u0004\u0002xR!\t!!?\t\u0013\u0005}H#!A\u0005\n\t\u0005!\u0001\u0006)s_*,7\r^3e%\u0006\u001cH/\u001a:MCf,'O\u0003\u0002\u001e=\u0005Qq-Z8ue\u0016dG.[:\u000b\u0003}\t!bZ3paf\u001c\b/\u0019:l\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0007\r\"c%D\u0001\u001d\u0013\t)CDA\u0006SCN$XM\u001d'bs\u0016\u0014\bCA\u0014,\u001b\u0005A#BA\u0015+\u0003\u00191Xm\u0019;pe*\tQ$\u0003\u0002-Q\ty\u0001K]8kK\u000e$X\rZ#yi\u0016tG/A\u0002sI\u0012,\u0012a\f\t\u0004aaRT\"A\u0019\u000b\u00055\u0012$BA\u001a5\u0003\u0015\u0019\b/\u0019:l\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\n$a\u0001*E\tB!1H\u0010\u0014A\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$A\u0002+va2,'\u0007\u0005\u0002B\t6\t!I\u0003\u0002DU\u00051!/Y:uKJL!!\u0012\"\u0003\u001b5+H\u000e^5cC:$G+\u001b7f\u0003\u0011\u0011H\r\u001a\u0011\u0002\rqJg.\u001b;?)\tI%\n\u0005\u0002$\u0001!)Qf\u0001a\u0001_\u0005y1m\u001c7mK\u000e$X*\u001a;bI\u0006$\u0018\r\u0006\u0002N1B\u0011a*\u0016\b\u0003\u001fN\u0003\"\u0001\u0015\u001f\u000e\u0003ES!A\u0015\u0011\u0002\rq\u0012xn\u001c;?\u0013\t!F(\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+=\u0011\u0015IF\u00011\u0001[\u0003)a\u0017-_8viRK\b/\u001a\t\u0003GmK!\u0001\u0018\u000f\u0003\u00151\u000b\u0017p\\;u)f\u0004X\r\u0006\u0002N=\")q,\u0002a\u0001A\u0006\u0001B.Y=pkR$UMZ5oSRLwN\u001c\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G*\nQ\u0001\\1zKJL!!\u001a2\u0003!1\u000b\u0017p\\;u\t\u00164\u0017N\\5uS>t\u0017\u0001\u0004;jY\u0016$v\u000eT1z_V$H\u0003\u00025oab\u00042aI5l\u0013\tQGD\u0001\tUS2,GMU1ti\u0016\u0014H*Y=feB\u0011\u0011\r\\\u0005\u0003[\n\u0014!b\u00159bi&\fGnS3z\u0011\u0015yg\u00011\u0001N\u0003E!\u0018\u000e\\3MCf,'/T3uC\u0012\fG/\u0019\u0005\u0006c\u001a\u0001\rA]\u0001\u000fe\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e!\t\u0019h/D\u0001u\u0015\t)()\u0001\u0005sKN\fW\u000e\u001d7f\u0013\t9HO\u0001\bSKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3\t\u000be4\u0001\u0019\u0001>\u0002#A\f'\u000f^5uS>t7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002$w&\u0011A\u0010\b\u0002\u0012!\u0006\u0014H/\u001b;j_:\u001cFO]1uK\u001eLH#\u00025\u007f\u007f\u0006\u0005\u0001\"B0\b\u0001\u0004\u0001\u0007\"B9\b\u0001\u0004\u0011\b\"B=\b\u0001\u0004QHc\u00025\u0002\u0006\u0005\u001d\u0011\u0011\u0002\u0005\u00063\"\u0001\rA\u0017\u0005\u0006c\"\u0001\rA\u001d\u0005\u0006s\"\u0001\rA_\u0001\ne\u0016\u0004(o\u001c6fGR$R!SA\b\u0003'Aa!!\u0005\n\u0001\u0004i\u0015!\u0003;be\u001e,Go\u0011*T\u0011\u0015\t\u0018\u00021\u0001s)%A\u0017qCA\r\u00037\ti\u0002\u0003\u0004\u0002\u0012)\u0001\r!\u0014\u0005\u00063*\u0001\rA\u0017\u0005\u0006c*\u0001\rA\u001d\u0005\u0006s*\u0001\rA\u001f\u000b\nQ\u0006\u0005\u0012QEA\u0014\u0003SAa!a\t\f\u0001\u0004i\u0015A\u0003;be\u001e,GoX2sg\")ql\u0003a\u0001A\")\u0011o\u0003a\u0001e\")\u0011p\u0003a\u0001u\u0006Q!/Z2mCN\u001c\u0018NZ=\u0015\u0007\t\ny\u0003\u0003\u0004\u000221\u0001\raL\u0001\u0010e\u0016\u001cG.Y:tS\u001aLW\r\u001a*E\t\u0006\u0001\"/Z2mCN\u001c\u0018NZ=E_V\u0014G.\u001a\u000b\u0004E\u0005]\u0002BBA\u0019\u001b\u0001\u0007q&A\u0004xSRD'\u000b\u0012#\u0015\u0007\t\ni\u0004\u0003\u0004\u0002@9\u0001\raL\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0002\u0015Q|\u0007K]8u_J#E\t\u0006\u0002\u0002FA1\u0011qIA)\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005U\u00064\u0018MC\u0002\u0002PI\n1!\u00199j\u0013\u0011\t\u0019&!\u0013\u0003\u000f)\u000bg/\u0019*E\tB)1(a\u0016\u0002\\%\u0019\u0011\u0011\f\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0007m\ni&C\u0002\u0002`q\u0012AAQ=uK\u0006AAo\u001c)oOJ#E\t\u0006\u0003\u0002F\u0005\u0015\u0004bBA4!\u0001\u0007\u0011\u0011N\u0001\u0007a:<'\u000b\u0012#\u0011\tAB\u00141\u000e\t\u0006wy2\u0013QK\u0001\ri><Um\u001c+jM\u001a\u0014F\t\u0012\u000b\u000b\u0003\u000b\n\t(!\"\u0002\b\u0006\r\u0006bBA:#\u0001\u0007\u0011QO\u0001\u0005i\u0006<7\u000f\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u000f\u001d,w\u000e^5gM*\u0019\u0011q\u0010\"\u0002\u0005%|\u0017\u0002BAB\u0003s\u0012A\u0001V1hg\")\u0011/\u0005a\u0001e\"9\u0011\u0011R\tA\u0002\u0005-\u0015a\u00033fG&l\u0017\r^5p]N\u0004b!!$\u0002\u0018\u0006ue\u0002BAH\u0003's1\u0001UAI\u0013\u0005i\u0014bAAKy\u00059\u0001/Y2lC\u001e,\u0017\u0002BAM\u00037\u0013A\u0001T5ti*\u0019\u0011Q\u0013\u001f\u0011\u0007m\ny*C\u0002\u0002\"r\u00121!\u00138u\u0011\u001d\t)+\u0005a\u0001\u0003O\u000babZ3p)&4gm\u00149uS>t7\u000f\u0005\u0003\u0002x\u0005%\u0016\u0002BAV\u0003s\u0012abR3p)&4gm\u00149uS>t7/A\u0006d_2dWm\u0019;LKf\u001cHCAAY!\u0019\t\u0019,a/\u0002V5\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,\u0001\u0003vi&d'BAA&\u0013\u0011\ti,!.\u0003\u0013\u0005\u0013(/Y=MSN$\u0018\u0001\u0006)s_*,7\r^3e%\u0006\u001cH/\u001a:MCf,'\u000f\u0005\u0002$)M)A#!2\u0002LB\u00191(a2\n\u0007\u0005%GH\u0001\u0004B]f\u0014VM\u001a\t\u0004w\u00055\u0017bAAhy\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011Y\u0001\u0014MJ|W\u000e\u0015:pi>,enY8eK\u0012\u0014F\t\u0012\u000b\u0004\u0013\u0006]\u0007bBAm-\u0001\u0007\u0011QI\u0001\bU\u00064\u0018M\u0015#E\u0003\u0015\t\u0007\u000f\u001d7z)\rI\u0015q\u001c\u0005\u0006[]\u0001\raL\u0001\fk:LwN\u001c'bs\u0016\u00148\u000fF\u0003J\u0003K\f\t\u0010C\u0004\u0002hb\u0001\r!!;\u0002\u0005M\u001c\u0007\u0003BAv\u0003[l\u0011AM\u0005\u0004\u0003_\u0014$\u0001D*qCJ\\7i\u001c8uKb$\bbBAz1\u0001\u0007\u0011Q_\u0001\u0007Y\u0006LXM]:\u0011\u000b\u0005M\u00161X%\u0002\u0019\r|WNY5oK\n\u000bg\u000eZ:\u0015\u000b%\u000bY0!@\t\u000f\u0005\u001d\u0018\u00041\u0001\u0002j\"9\u00111_\rA\u0002\u0005U\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0001\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQAA!\u0003\u0002:\u0006!A.\u00198h\u0013\u0011\u0011iAa\u0002\u0003\r=\u0013'.Z2u\u0001")
public class ProjectedRasterLayer
extends RasterLayer<ProjectedExtent> {
    private final RDD<Tuple2<ProjectedExtent, MultibandTile>> rdd;

    public static ProjectedRasterLayer combineBands(SparkContext sparkContext, ArrayList<ProjectedRasterLayer> arrayList) {
        return ProjectedRasterLayer$.MODULE$.combineBands(sparkContext, arrayList);
    }

    public static ProjectedRasterLayer unionLayers(SparkContext sparkContext, ArrayList<ProjectedRasterLayer> arrayList) {
        return ProjectedRasterLayer$.MODULE$.unionLayers(sparkContext, arrayList);
    }

    public static ProjectedRasterLayer apply(RDD<Tuple2<ProjectedExtent, MultibandTile>> rDD) {
        return ProjectedRasterLayer$.MODULE$.apply(rDD);
    }

    public static ProjectedRasterLayer fromProtoEncodedRDD(JavaRDD<byte[]> javaRDD) {
        return ProjectedRasterLayer$.MODULE$.fromProtoEncodedRDD(javaRDD);
    }

    @Override
    public RDD<Tuple2<ProjectedExtent, MultibandTile>> rdd() {
        return this.rdd;
    }

    @Override
    public String collectMetadata(LayoutType layoutType) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(ProjectedExtent.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()), geotrellis.util.package$.MODULE$.identityComponent(), geotrellis.util.package$.MODULE$.identityComponent(), SpatialKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$1 -> x$1.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        return package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(((RasterSummary)sms.head()).toTileLayerMetadata(layoutType, geotrellis.util.package$.MODULE$.identityComponent())._1()), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(geotrellis.util.package$.MODULE$.identityComponent(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey())).noSpaces();
    }

    @Override
    public String collectMetadata(LayoutDefinition layoutDefinition) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(ProjectedExtent.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()), geotrellis.util.package$.MODULE$.identityComponent(), geotrellis.util.package$.MODULE$.identityComponent(), SpatialKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$2 -> x$2.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        return package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)new TileLayerMetadata(sm.cellType(), layoutDefinition, sm.extent(), sm.crs(), (Bounds)sm.bounds().setSpatialBounds(layoutDefinition.mapTransform().apply(sm.extent()), geotrellis.util.package$.MODULE$.identityComponent()))), TileLayerMetadata$.MODULE$.tileLayerMetadataEncoder(geotrellis.util.package$.MODULE$.identityComponent(), (Encoder)SpatialKey$.MODULE$.codecForSpatialKey())).noSpaces();
    }

    @Override
    public TiledRasterLayer<SpatialKey> tileToLayout(String tileLayerMetadata, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        TileLayerMetadata md = (TileLayerMetadata)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(((Json)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(tileLayerMetadata)), (Function1<ParsingFailure, Nothing$> & Serializable & scala.Serializable)x$3 -> {
            throw x$3;
        })).as(TileLayerMetadata$.MODULE$.tileLayerMetadataDecoder(geotrellis.util.package$.MODULE$.identityComponent(), (Decoder)SpatialKey$.MODULE$.codecForSpatialKey()))), (Function1<DecodingFailure, Nothing$> & Serializable & scala.Serializable)x$4 -> {
            throw x$4;
        });
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        return new SpatialTiledRasterLayer(None$.MODULE$, (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(md, options, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent())), md));
    }

    @Override
    public TiledRasterLayer<SpatialKey> tileToLayout(LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(ProjectedExtent.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()), geotrellis.util.package$.MODULE$.identityComponent(), geotrellis.util.package$.MODULE$.identityComponent(), SpatialKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$5 -> x$5.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        TileLayerMetadata metadata = new TileLayerMetadata(sm.cellType(), layoutDefinition, sm.extent(), sm.crs(), (Bounds)sm.bounds().setSpatialBounds(layoutDefinition.mapTransform().apply(sm.extent()), geotrellis.util.package$.MODULE$.identityComponent()));
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        return SpatialTiledRasterLayer$.MODULE$.apply(None$.MODULE$, (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(metadata, options, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent())), metadata));
    }

    @Override
    public TiledRasterLayer<SpatialKey> tileToLayout(LayoutType layoutType, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Seq sms = RasterSummary$.MODULE$.collect(this.rdd(), ClassTag$.MODULE$.apply(ProjectedExtent.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()), geotrellis.util.package$.MODULE$.identityComponent(), geotrellis.util.package$.MODULE$.identityComponent(), SpatialKey.Boundable$.MODULE$);
        Predef$.MODULE$.require(sms.length() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Multiple raster CRS layers found: ").append(((TraversableOnce)sms.map((Function1<RasterSummary, CRS> & Serializable & scala.Serializable)x$6 -> x$6.crs(), Seq$.MODULE$.canBuildFrom())).toList()).toString());
        RasterSummary sm = (RasterSummary)sms.head();
        Tuple2 tuple2 = sm.toTileLayerMetadata(layoutType, geotrellis.util.package$.MODULE$.identityComponent());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TileLayerMetadata metadata = tuple2._1();
        Option<Object> zoom = tuple2._2();
        Tuple2 tuple22 = new Tuple2(metadata, zoom);
        Tuple2 tuple23 = tuple22;
        TileLayerMetadata metadata2 = tuple23._1();
        Option<Object> zoom2 = tuple23._2();
        Tiler.Options options = this.getTilerOptions(resampleMethod, partitionStrategy);
        RDD tiled = geotrellis.spark.package$.MODULE$.withTilerMethods(this.rdd(), ClassTag$.MODULE$.apply(MultibandTile.class), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).tileToLayout(metadata2, options, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), (Function1<ProjectedExtent, Implicits.withProjectedExtentTilerKeyMethods> & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()));
        return new SpatialTiledRasterLayer(zoom2, (RDD<Tuple2<SpatialKey, MultibandTile>>)package.MultibandTileLayerRDD$.MODULE$.apply(tiled, metadata2));
    }

    public ProjectedRasterLayer reproject(String targetCRS, ResampleMethod resampleMethod) {
        CRS crs = TileLayer$.MODULE$.getCRS(targetCRS).get();
        return new ProjectedRasterLayer((RDD<Tuple2<ProjectedExtent, MultibandTile>>)geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(this.rdd(), geotrellis.util.package$.MODULE$.identityComponent(), (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self)).reproject(crs, Reproject.Options$.MODULE$.methodToOptions(resampleMethod)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TiledRasterLayer<SpatialKey> reproject(String targetCRS, LayoutType layoutType, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        RDD reprojected;
        Option<Partitioner> partitioner = TileLayer$.MODULE$.getPartitioner(partitionStrategy, this.rdd().getNumPartitions());
        CRS crs = TileLayer$.MODULE$.getCRS(targetCRS).get();
        RDD<Tuple2<SpatialKey, MultibandTile>> tiled = this.tileToLayout(LocalLayout$.MODULE$.apply(256), resampleMethod, partitionStrategy).rdd();
        boolean bl = false;
        GlobalLayout globalLayout = null;
        LayoutType layoutType2 = layoutType;
        if (layoutType2 instanceof GlobalLayout) {
            bl = true;
            globalLayout = (GlobalLayout)layoutType2;
            int tileSize = globalLayout.tileSize();
            Integer n = globalLayout.zoom();
            double threshold = globalLayout.threshold();
            if (n == null) {
                ZoomedLayoutScheme scheme = new ZoomedLayoutScheme(crs, tileSize, threshold);
                Tuple2 tuple2 = geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(tiled, geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).reproject(crs, (LayoutScheme)scheme, Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner);
                if (tuple2 == null) throw new MatchError(tuple2);
                int zoom = tuple2._1$mcI$sp();
                RDD reprojected2 = (RDD)tuple2._2();
                Tuple2<Integer, RDD> tuple22 = new Tuple2<Integer, RDD>(BoxesRunTime.boxToInteger(zoom), reprojected2);
                Tuple2<Integer, RDD> tuple23 = tuple22;
                int zoom2 = tuple23._1$mcI$sp();
                RDD reprojected3 = tuple23._2();
                return new SpatialTiledRasterLayer(new Some<Object>(BoxesRunTime.boxToInteger(zoom2)), (RDD<Tuple2<SpatialKey, MultibandTile>>)reprojected3);
            }
        }
        if (bl) {
            RDD reprojected4;
            int tileSize = globalLayout.tileSize();
            Integer zoom = globalLayout.zoom();
            double threshold = globalLayout.threshold();
            ZoomedLayoutScheme scheme = new ZoomedLayoutScheme(crs, tileSize, threshold);
            Tuple2 tuple2 = TileRDDReproject$.MODULE$.apply(tiled, crs, new Right(scheme.levelForZoom(Predef$.MODULE$.Integer2int(zoom)).layout()), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner, geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self));
            if (tuple2 == null) throw new MatchError(tuple2);
            RDD rDD = reprojected4 = (RDD)tuple2._2();
            RDD reprojected5 = rDD;
            return new SpatialTiledRasterLayer(new Some<Object>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(zoom))), (RDD<Tuple2<SpatialKey, MultibandTile>>)reprojected5);
        }
        if (!(layoutType2 instanceof LocalLayout)) throw new MatchError(layoutType2);
        LocalLayout localLayout = (LocalLayout)layoutType2;
        int tileCols = localLayout.tileCols();
        int tileRows = localLayout.tileRows();
        Tuple2 tuple2 = geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(tiled, geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandReprojectMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandReprojectMethods(self), (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self)).reproject(crs, (LayoutScheme)FloatingLayoutScheme$.MODULE$.apply(tileCols, tileRows), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner);
        if (tuple2 == null) throw new MatchError(tuple2);
        RDD rDD = reprojected = (RDD)tuple2._2();
        RDD reprojected6 = rDD;
        return new SpatialTiledRasterLayer(None$.MODULE$, (RDD<Tuple2<SpatialKey, MultibandTile>>)reprojected6);
    }

    @Override
    public TiledRasterLayer<SpatialKey> reproject(String target_crs, LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, PartitionStrategy partitionStrategy) {
        Option<Partitioner> partitioner = TileLayer$.MODULE$.getPartitioner(partitionStrategy, this.rdd().getNumPartitions());
        RDD<Tuple2<SpatialKey, MultibandTile>> tiled = this.tileToLayout(layoutDefinition, resampleMethod, partitionStrategy).rdd();
        Tuple2 tuple2 = TileRDDReproject$.MODULE$.apply(tiled, TileLayer$.MODULE$.getCRS(target_crs).get(), new Right(layoutDefinition), Reproject.Options$.MODULE$.resampleMethodToOptions(resampleMethod), partitioner, geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MultibandTile.class), RasterRegionReproject$.MODULE$.multibandInstance(), (Stitcher)Stitcher.MultibandTileStitcher$.MODULE$, (Function1<MultibandTile, Implicits.withMultibandTileCropMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTileCropMethods(self), (Function1<MultibandTile, Implicits.withMultibandMergeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandMergeMethods(self), (Function1<MultibandTile, Implicits.withMultibandTilePrototypeMethods> & Serializable & scala.Serializable)self -> geotrellis.raster.package$.MODULE$.withMultibandTilePrototypeMethods(self));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int zoom = tuple2._1$mcI$sp();
        RDD reprojected = (RDD)tuple2._2();
        Tuple2<Integer, RDD> tuple22 = new Tuple2<Integer, RDD>(BoxesRunTime.boxToInteger(zoom), reprojected);
        Tuple2<Integer, RDD> tuple23 = tuple22;
        int zoom2 = tuple23._1$mcI$sp();
        RDD reprojected2 = tuple23._2();
        return SpatialTiledRasterLayer$.MODULE$.apply(new Some<Object>(BoxesRunTime.boxToInteger(zoom2)), (RDD<Tuple2<SpatialKey, MultibandTile>>)reprojected2);
    }

    @Override
    public RasterLayer<ProjectedExtent> reclassify(RDD<Tuple2<ProjectedExtent, MultibandTile>> reclassifiedRDD) {
        return ProjectedRasterLayer$.MODULE$.apply(reclassifiedRDD);
    }

    @Override
    public RasterLayer<ProjectedExtent> reclassifyDouble(RDD<Tuple2<ProjectedExtent, MultibandTile>> reclassifiedRDD) {
        return ProjectedRasterLayer$.MODULE$.apply(reclassifiedRDD);
    }

    @Override
    public RasterLayer<ProjectedExtent> withRDD(RDD<Tuple2<ProjectedExtent, MultibandTile>> result) {
        return ProjectedRasterLayer$.MODULE$.apply(result);
    }

    @Override
    public JavaRDD<byte[]> toProtoRDD() {
        return PythonTranslator$.MODULE$.toPython(this.rdd(), package$.MODULE$.tupleProjectedExtentProtoBufCodec());
    }

    @Override
    public JavaRDD<byte[]> toPngRDD(RDD<Tuple2<ProjectedExtent, byte[]>> pngRDD) {
        return PythonTranslator$.MODULE$.toPython(pngRDD, package$.MODULE$.tupleProjectedExtentImageProtoBufCodec());
    }

    @Override
    public JavaRDD<byte[]> toGeoTiffRDD(Tags tags, ResampleMethod resampleMethod, List<Object> decimations, GeoTiffOptions geoTiffOptions) {
        RDD geotiffRDD = this.rdd().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ProjectedExtent k = (ProjectedExtent)tuple2._1();
            MultibandTile v = (MultibandTile)tuple2._2();
            MultibandGeoTiff qual$1 = new MultibandGeoTiff(v, k.extent(), k.crs(), tags, geoTiffOptions, MultibandGeoTiff$.MODULE$.apply$default$6());
            ResampleMethod x$1 = resampleMethod;
            List x$2 = decimations;
            int x$3 = qual$1.withOverviews$default$3();
            MultibandGeoTiff geoTiff = qual$1.withOverviews(x$1, x$2, x$3);
            Tuple2<ProjectedExtent, byte[]> tuple22 = new Tuple2<ProjectedExtent, byte[]>(k, geoTiff.toByteArray());
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return PythonTranslator$.MODULE$.toPython(geotiffRDD, package$.MODULE$.tupleProjectedExtentImageProtoBufCodec());
    }

    @Override
    public ArrayList<byte[]> collectKeys() {
        RDD<Tuple2<ProjectedExtent, MultibandTile>> x$1 = this.rdd();
        ClassTag x$2 = ClassTag$.MODULE$.apply(ProjectedExtent.class);
        ClassTag x$3 = ClassTag$.MODULE$.apply(MultibandTile.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return PythonTranslator$.MODULE$.toPython(Predef$.MODULE$.wrapRefArray((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).keys().collect()), package$.MODULE$.projectedExtentProtoBufCodec());
    }

    public ProjectedRasterLayer(RDD<Tuple2<ProjectedExtent, MultibandTile>> rdd) {
        this.rdd = rdd;
        super(ClassTag$.MODULE$.apply(ProjectedExtent.class), geotrellis.util.package$.MODULE$.identityComponent());
    }
}

