/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;

public class ImmutableSortedSetSerializer
extends Serializer<ImmutableSortedSet<Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableSortedSetSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, ImmutableSortedSet<Object> object) {
        kryo.writeClassAndObject(output, (Object)object.comparator());
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    public ImmutableSortedSet<Object> read(Kryo kryo, Input input, Class<ImmutableSortedSet<Object>> type2) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)((Comparator)kryo.readClassAndObject(input)));
        int size = input.readInt(true);
        for (int i = 0; i < size; ++i) {
            builder.add(kryo.readClassAndObject(input));
        }
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableSortedSetSerializer serializer = new ImmutableSortedSetSerializer();
        kryo.register(ImmutableSortedSet.class, (Serializer)serializer);
        kryo.register(ImmutableSortedSet.of().getClass(), (Serializer)serializer);
        kryo.register(ImmutableSortedSet.of((Comparable)((Object)"")).getClass(), (Serializer)serializer);
        kryo.register(ImmutableSortedSet.of().descendingSet().getClass(), (Serializer)serializer);
    }
}

