/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;

public class ImmutableSetSerializer
extends Serializer<ImmutableSet<Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableSetSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, ImmutableSet<Object> object) {
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    public ImmutableSet<Object> read(Kryo kryo, Input input, Class<ImmutableSet<Object>> type2) {
        int size = input.readInt(true);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(kryo.readClassAndObject(input));
        }
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableSetSerializer serializer = new ImmutableSetSerializer();
        kryo.register(ImmutableSet.class, (Serializer)serializer);
        kryo.register(ImmutableSet.of().getClass(), (Serializer)serializer);
        kryo.register(ImmutableSet.of((Object)1).getClass(), (Serializer)serializer);
        kryo.register(ImmutableSet.of((Object)1, (Object)2, (Object)3).getClass(), (Serializer)serializer);
        kryo.register(Sets.immutableEnumSet((Enum)SomeEnum.A, (Enum[])new SomeEnum[]{SomeEnum.B, SomeEnum.C}).getClass(), (Serializer)serializer);
    }

    private static enum SomeEnum {
        A,
        B,
        C;

    }
}

