/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ImmutableMapSerializer
extends Serializer<ImmutableMap<Object, ? extends Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public ImmutableMapSerializer() {
        super(true, true);
    }

    public void write(Kryo kryo, Output output, ImmutableMap<Object, ? extends Object> immutableMap) {
        kryo.writeObject(output, (Object)Maps.newHashMap(immutableMap));
    }

    public ImmutableMap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableMap<Object, ? extends Object>> type2) {
        Map map = (Map)kryo.readObject(input, HashMap.class);
        return ImmutableMap.copyOf((Map)map);
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableMapSerializer serializer = new ImmutableMapSerializer();
        kryo.register(ImmutableMap.class, (Serializer)serializer);
        kryo.register(ImmutableMap.of().getClass(), (Serializer)serializer);
        Object o1 = new Object();
        Object o2 = new Object();
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1).getClass(), (Serializer)serializer);
        kryo.register(ImmutableMap.of((Object)o1, (Object)o1, (Object)o2, (Object)o2).getClass(), (Serializer)serializer);
        EnumMap<DummyEnum, Object> enumMap = new EnumMap<DummyEnum, Object>(DummyEnum.class);
        for (DummyEnum e : DummyEnum.values()) {
            enumMap.put(e, o1);
        }
        kryo.register(ImmutableMap.copyOf(enumMap).getClass(), (Serializer)serializer);
    }

    private static enum DummyEnum {
        VALUE1,
        VALUE2;

    }
}

