/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FieldAnnotationAwareSerializer<T>
extends FieldSerializer<T> {
    private final Set<Class<? extends Annotation>> marked;
    private final boolean disregarding;

    public FieldAnnotationAwareSerializer(Kryo kryo, Class<?> type2, Collection<Class<? extends Annotation>> marked, boolean disregarding) {
        super(kryo, type2);
        this.disregarding = disregarding;
        this.marked = new HashSet<Class<? extends Annotation>>(marked);
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        if (this.marked == null) {
            return;
        }
        super.rebuildCachedFields();
        this.removeFields();
    }

    private void removeFields() {
        FieldSerializer.CachedField[] cachedFields;
        for (FieldSerializer.CachedField cachedField : cachedFields = this.getFields()) {
            Field field2 = cachedField.getField();
            if (!this.isRemove(field2)) continue;
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)String.format("Ignoring field %s tag: %s", this.disregarding ? "without" : "with", cachedField));
            }
            super.removeField(field2.getName());
        }
    }

    private boolean isRemove(Field field2) {
        return !this.isMarked(field2) ^ this.disregarding;
    }

    private boolean isMarked(Field field2) {
        for (Annotation annotation : field2.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.marked.contains(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean addAnnotation(Class<? extends Annotation> clazz) {
        if (this.disregarding && this.marked.add(clazz)) {
            this.initializeCachedFields();
            return true;
        }
        return false;
    }

    public boolean removeAnnotation(Class<? extends Annotation> clazz) {
        if (!this.disregarding && this.marked.remove(clazz)) {
            this.initializeCachedFields();
            return true;
        }
        return false;
    }

    public static class Factory
    implements SerializerFactory {
        private final Collection<Class<? extends Annotation>> marked;
        private final boolean disregarding;

        public Factory(Collection<Class<? extends Annotation>> marked, boolean disregarding) {
            this.marked = marked;
            this.disregarding = disregarding;
        }

        public Serializer<?> makeSerializer(Kryo kryo, Class<?> type2) {
            return new FieldAnnotationAwareSerializer(kryo, type2, this.marked, this.disregarding);
        }
    }
}

