/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.akka;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.sslconfig.akka.AkkaSSLConfig$;
import com.typesafe.sslconfig.akka.DefaultSSLEngineConfigurator;
import com.typesafe.sslconfig.akka.util.AkkaLoggerFactory;
import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.AlgorithmConstraintsParser$;
import com.typesafe.sslconfig.ssl.Ciphers$;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DisabledComplainingHostnameVerifier;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ev!B\u0001\u0003\u0011\u0003Y\u0011!D!lW\u0006\u001c6\u000bT\"p]\u001aLwM\u0003\u0002\u0004\t\u0005!\u0011m[6b\u0015\t)a!A\u0005tg2\u001cwN\u001c4jO*\u0011q\u0001C\u0001\tif\u0004Xm]1gK*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\u0007BW.\f7k\u0015'D_:4\u0017nZ\n\u0006\u001bA1\u0012q\u000f\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]YR$D\u0001\u0019\u0015\tI\"$A\u0003bGR|'OC\u0001\u0004\u0013\ta\u0002DA\u0006FqR,gn]5p]&#\u0007C\u0001\u0007\u001f\r\u0011q!AA\u0010\u0014\u0007y\u0001\u0002\u0005\u0005\u0002\u0018C%\u0011!\u0005\u0007\u0002\n\u000bb$XM\\:j_:D\u0001\u0002\n\u0010\u0003\u0002\u0003\u0006I!J\u0001\u0007gf\u001cH/Z7\u0011\u0005]1\u0013BA\u0014\u0019\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011!IcD!b\u0001\n\u0003Q\u0013AB2p]\u001aLw-F\u0001,!\tas&D\u0001.\u0015\tqC!A\u0002tg2L!\u0001M\u0017\u0003#M\u001bFjQ8oM&<7+\u001a;uS:<7\u000f\u0003\u00053=\t\u0005\t\u0015!\u0003,\u0003\u001d\u0019wN\u001c4jO\u0002BQ\u0001\u000e\u0010\u0005\u0002U\na\u0001P5oSRtDcA\u000f7o!)Ae\ra\u0001K!)\u0011f\ra\u0001W!9\u0011H\bb\u0001\n\u0013Q\u0014\u0001C7l\u0019><w-\u001a:\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!A\u0010\u0002\u0002\tU$\u0018\u000e\\\u0005\u0003\u0001v\u0012\u0011#Q6lC2{wmZ3s\r\u0006\u001cGo\u001c:z\u0011\u0019\u0011e\u0004)A\u0005w\u0005IQn\u001b'pO\u001e,'\u000f\t\u0005\b\tz\u0011\r\u0011\"\u0003F\u0003\rawnZ\u000b\u0002\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011JG\u0001\u0006KZ,g\u000e^\u0005\u0003\u0017\"\u0013a\u0002T8hO&tw-\u00113baR,'\u000f\u0003\u0004N=\u0001\u0006IAR\u0001\u0005Y><\u0007\u0005C\u0003P=\u0011\u0005\u0001+\u0001\u0007xSRD7+\u001a;uS:<7\u000f\u0006\u0002\u001e#\")!K\u0014a\u0001W\u0005\t1\rC\u0003U=\u0011\u0005Q+A\u0006nCB\u001cV\r\u001e;j]\u001e\u001cHCA\u000fW\u0011\u001596\u000b1\u0001Y\u0003\u00051\u0007\u0003B\tZW-J!A\u0017\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u0002/\u001f\t\u0003i\u0016aD2p]Z,'\u000f^*fiRLgnZ:\u0015\u0005uq\u0006\"B,\\\u0001\u0004y\u0006\u0003\u00021gW-j\u0011!\u0019\u0006\u0003E\u000e\f\u0001BZ;oGRLwN\u001c\u0006\u0003}\u0011T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hC\nAa)\u001e8di&|g\u000eC\u0004j=\t\u0007I\u0011\u00016\u0002!!|7\u000f\u001e8b[\u00164VM]5gS\u0016\u0014X#A6\u0011\u00051\u0014X\"A7\u000b\u00059r'BA8q\u0003\rqW\r\u001e\u0006\u0002c\u0006)!.\u0019<bq&\u00111/\u001c\u0002\u0011\u0011>\u001cHO\\1nKZ+'/\u001b4jKJDa!\u001e\u0010!\u0002\u0013Y\u0017!\u00055pgRt\u0017-\\3WKJLg-[3sA!9qO\bb\u0001\n\u0003A\u0018!F:tY\u0016sw-\u001b8f\u0007>tg-[4ve\u0006$xN]\u000b\u0002sB\u0011AB_\u0005\u0003w\n\u0011A\u0004R3gCVdGoU*M\u000b:<\u0017N\\3D_:4\u0017nZ;sCR|'\u000f\u0003\u0004~=\u0001\u0006I!_\u0001\u0017gNdWI\\4j]\u0016\u001cuN\u001c4jOV\u0014\u0018\r^8sA!1qP\bC\u0001\u0003\u0003\taCY;jY\u0012\\U-_'b]\u0006<WM\u001d$bGR|'/\u001f\u000b\u0005\u0003\u0007\tI\u0001E\u0002-\u0003\u000bI1!a\u0002.\u0005aYU-_'b]\u0006<WM\u001d$bGR|'/_,sCB\u0004XM\u001d\u0005\u0006]y\u0004\ra\u000b\u0005\b\u0003\u001bqB\u0011AA\b\u0003a\u0011W/\u001b7e)J,8\u000f^'b]\u0006<WM\u001d$bGR|'/\u001f\u000b\u0005\u0003#\t9\u0002E\u0002-\u0003'I1!!\u0006.\u0005i!&/^:u\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z/J\f\u0007\u000f]3s\u0011\u0019q\u00131\u0002a\u0001W!9\u00111\u0004\u0010\u0005\u0002\u0005u\u0011!\u00062vS2$\u0007j\\:u]\u0006lWMV3sS\u001aLWM\u001d\u000b\u0004W\u0006}\u0001bBA\u0011\u00033\u0001\raK\u0001\u0005G>tg\rC\u0004\u0002&y!\t!a\n\u00027Y\fG.\u001b3bi\u0016$UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3s)\u0011\tI#a\f\u0011\u0007E\tY#C\u0002\u0002.I\u0011A!\u00168ji\"9\u0011\u0011GA\u0012\u0001\u0004Y\u0013!C:tY\u000e{gNZ5h\u0011\u001d\t)D\bC\u0001\u0003o\t!cY8oM&<WO]3Qe>$xnY8mgR1\u0011\u0011HA+\u00033\u0002R!EA\u001e\u0003\u007fI1!!\u0010\u0013\u0005\u0015\t%O]1z!\u0011\t\t%a\u0014\u000f\t\u0005\r\u00131\n\t\u0004\u0003\u000b\u0012RBAA$\u0015\r\tIEC\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b\u0012\u0002\u0002CA,\u0003g\u0001\r!!\u000f\u0002#\u0015D\u0018n\u001d;j]\u001e\u0004&o\u001c;pG>d7\u000fC\u0004\u00022\u0005M\u0002\u0019A\u0016\t\u000f\u0005uc\u0004\"\u0001\u0002`\u0005)2m\u001c8gS\u001e,(/Z\"ja\",'oU;ji\u0016\u001cHCBA\u001d\u0003C\n)\u0007\u0003\u0005\u0002d\u0005m\u0003\u0019AA\u001d\u0003=)\u00070[:uS:<7)\u001b9iKJ\u001c\bbBA\u0019\u00037\u0002\ra\u000b\u0005\b\u0003SrB\u0011BA6\u0003=awn\\:f\t&\u001c\u0018M\u00197f':KE\u0003BA\u0015\u0003[B\u0001\"a\u001c\u0002h\u0001\u0007\u0011\u0011O\u0001\u000eI\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:\u0011\u00071\f\u0019(C\u0002\u0002v5\u0014QbU*M!\u0006\u0014\u0018-\\3uKJ\u001c\bcA\f\u0002z%\u0019\u00111\u0010\r\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\t\rQjA\u0011AA@)\u0005Y\u0001bBAB\u001b\u0011\u0005\u0013QQ\u0001\u0004O\u0016$HcA\u000f\u0002\b\"9A%!!A\u0002\u0005%\u0005cA\f\u0002\f&\u0019\u0011Q\u0012\r\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\b\u0003#kA\u0011AAJ\u0003\u0015\t\u0007\u000f\u001d7z)\t\t)\nF\u0002\u001e\u0003/Cq\u0001JAH\u0001\b\tI\tC\u0004\u0002\u001c6!\t%!(\u0002\r1|wn[;q)\t\tyJ\u0004\u0002\r\u0001!9\u00111U\u0007\u0005B\u0005\u0015\u0016aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007u\t9\u000b\u0003\u0004%\u0003C\u0003\r!\n\u0005\b\u0003WkA\u0011AAW\u0003a!WMZ1vYR\u001c6\u000bT\"p]\u001aLwmU3ui&twm\u001d\u000b\u0004W\u0005=\u0006b\u0002\u0013\u0002*\u0002\u0007\u0011\u0011\u0012")
public final class AkkaSSLConfig
implements Extension {
    private final ExtendedActorSystem system;
    private final SSLConfigSettings config;
    private final AkkaLoggerFactory mkLogger;
    private final LoggingAdapter log;
    private final HostnameVerifier hostnameVerifier;
    private final DefaultSSLEngineConfigurator sslEngineConfigurator;

    public static SSLConfigSettings defaultSSLConfigSettings(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.defaultSSLConfigSettings(actorSystem);
    }

    public static AkkaSSLConfig createExtension(ExtendedActorSystem extendedActorSystem) {
        return AkkaSSLConfig$.MODULE$.createExtension(extendedActorSystem);
    }

    public static AkkaSSLConfig$ lookup() {
        return AkkaSSLConfig$.MODULE$.lookup();
    }

    public static AkkaSSLConfig apply(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.apply(actorSystem);
    }

    public static AkkaSSLConfig get(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.apply(actorSystem);
    }

    public SSLConfigSettings config() {
        return this.config;
    }

    private AkkaLoggerFactory mkLogger() {
        return this.mkLogger;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public AkkaSSLConfig withSettings(SSLConfigSettings c) {
        return new AkkaSSLConfig(this.system, c);
    }

    public AkkaSSLConfig mapSettings(Function1<SSLConfigSettings, SSLConfigSettings> f) {
        return new AkkaSSLConfig(this.system, f.apply(this.config()));
    }

    public AkkaSSLConfig convertSettings(Function<SSLConfigSettings, SSLConfigSettings> f) {
        return new AkkaSSLConfig(this.system, f.apply(this.config()));
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public DefaultSSLEngineConfigurator sslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        String keyManagerAlgorithm = ssl.keyManagerConfig().algorithm();
        return new DefaultKeyManagerFactoryWrapper(keyManagerAlgorithm);
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        String trustManagerAlgorithm = ssl.trustManagerConfig().algorithm();
        return new DefaultTrustManagerFactoryWrapper(trustManagerAlgorithm);
    }

    /*
     * WARNING - void declaration
     */
    public HostnameVerifier buildHostnameVerifier(SSLConfigSettings conf) {
        void var3_3;
        Class<DisabledComplainingHostnameVerifier> clazz = this.config().loose().disableHostnameVerification() ? DisabledComplainingHostnameVerifier.class : this.config().hostnameVerifierClass();
        HostnameVerifier v = (HostnameVerifier)this.system.dynamicAccess().createInstanceFor(clazz, Nil$.MODULE$, ClassTag$.MODULE$.apply(HostnameVerifier.class)).orElse((Function0<Try> & Serializable & scala.Serializable)() -> $this.system.dynamicAccess().createInstanceFor(clazz, (Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(LoggerFactory.class), this.mkLogger())})), ClassTag$.MODULE$.apply(HostnameVerifier.class))).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new Exception("Unable to obtain hostname verifier for class: " + clazz);
        });
        this.log().debug("buildHostnameVerifier: created hostname verifier: {}", v);
        return var3_3;
    }

    public void validateDefaultTrustManager(SSLConfigSettings sslConfig) {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        String disabledKeyAlgorithms = sslConfig.disabledKeyAlgorithms().mkString(",");
        Set<AlgorithmConstraint> constraints = ((TraversableOnce)AlgorithmConstraintsParser$.MODULE$.parseAll(AlgorithmConstraintsParser$.MODULE$.line(), disabledKeyAlgorithms).get()).toSet();
        AkkaLoggerFactory x$3 = this.mkLogger();
        Set<AlgorithmConstraint> x$4 = constraints;
        Set x$5 = (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(x$3, x$5, x$4);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])trustManager.getAcceptedIssuers())).foreach((Function1<X509Certificate, Object> & Serializable & scala.Serializable)cert -> {
            AkkaSSLConfig.$anonfun$validateDefaultTrustManager$1(this, algorithmChecker, cert);
            return BoxedUnit.UNIT;
        });
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] definedProtocols;
        block4: {
            String[] stringArray;
            Option<Seq<String>> option = sslConfig.enabledProtocols();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq configuredProtocols = (Seq)some.value();
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])((TraversableOnce)configuredProtocols.filter((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(AkkaSSLConfig.$anonfun$configureProtocols$1(objectArray, elem)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols())).filter((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(AkkaSSLConfig.$anonfun$configureProtocols$2(objectArray, elem)));
            } else {
                throw new MatchError(option);
            }
            definedProtocols = stringArray;
            boolean allowWeakProtocols = sslConfig.loose().allowWeakProtocols();
            if (allowWeakProtocols) break block4;
            Set<String> deprecatedProtocols = Protocols$.MODULE$.deprecatedProtocols();
            deprecatedProtocols.foreach((Function1<String, Object> & Serializable & scala.Serializable)deprecatedProtocol -> {
                AkkaSSLConfig.$anonfun$configureProtocols$3(definedProtocols, deprecatedProtocol);
                return BoxedUnit.UNIT;
            });
        }
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] definedCiphers;
        block4: {
            String[] stringArray;
            Option<Seq<String>> option = sslConfig.enabledCipherSuites();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq configuredCiphers = (Seq)some.value();
                stringArray = (String[])((TraversableOnce)configuredCiphers.filter((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(AkkaSSLConfig.$anonfun$configureCipherSuites$1(existingCiphers, x$1)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                stringArray = (String[])((TraversableOnce)Ciphers$.MODULE$.recommendedCiphers().filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(AkkaSSLConfig.$anonfun$configureCipherSuites$2(existingCiphers, x$2)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                throw new MatchError(option);
            }
            definedCiphers = stringArray;
            boolean allowWeakCiphers = sslConfig.loose().allowWeakCiphers();
            if (allowWeakCiphers) break block4;
            Set<String> deprecatedCiphers = Ciphers$.MODULE$.deprecatedCiphers();
            deprecatedCiphers.foreach((Function1<String, Object> & Serializable & scala.Serializable)deprecatedCipher -> {
                AkkaSSLConfig.$anonfun$configureCipherSuites$3(definedCiphers, deprecatedCipher);
                return BoxedUnit.UNIT;
            });
        }
        return definedCiphers;
    }

    private void looseDisableSNI(SSLParameters defaultParams) {
        block0: {
            if (!this.config().loose().disableSNI()) break block0;
            this.log().warning("You are using ssl-config.loose.disableSNI=true! It is strongly discouraged to disable Server Name Indication, as it is crucial to preventing man-in-the-middle attacks.");
            defaultParams.setServerNames(Collections.emptyList());
            defaultParams.setSNIMatchers(Collections.emptyList());
        }
    }

    public static final /* synthetic */ void $anonfun$validateDefaultTrustManager$1(AkkaSSLConfig $this, AlgorithmChecker algorithmChecker$1, X509Certificate cert) {
        try {
            algorithmChecker$1.checkKeyAlgorithms(cert);
        }
        catch (CertPathValidatorException e) {
            $this.log().warning("You are using ssl-config.default=true and have a weak certificate in your default trust store! (You can modify akka.ssl-config.disabledKeyAlgorithms to remove this message.)", e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef<Object>(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$2(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef<Object>(eta$0$2$1).contains(elem);
    }

    public static final /* synthetic */ void $anonfun$configureProtocols$3(String[] definedProtocols$1, String deprecatedProtocol) {
        if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])definedProtocols$1)).contains(deprecatedProtocol)) {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weak protocol ", " found in ssl-config.protocols!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{deprecatedProtocol})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$1(String[] existingCiphers$1, String x$1) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$2(String[] existingCiphers$1, String x$2) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains(x$2);
    }

    public static final /* synthetic */ void $anonfun$configureCipherSuites$3(String[] definedCiphers$1, String deprecatedCipher) {
        if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])definedCiphers$1)).contains(deprecatedCipher)) {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weak cipher ", " found in ssl-config.ciphers!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{deprecatedCipher})));
        }
    }

    public AkkaSSLConfig(ExtendedActorSystem system, SSLConfigSettings config) {
        SSLContext sSLContext;
        this.system = system;
        this.config = config;
        this.mkLogger = new AkkaLoggerFactory(system);
        this.log = Logging$.MODULE$.apply(system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.log().debug("Initializing AkkaSSLConfig extension...");
        this.hostnameVerifier = this.buildHostnameVerifier(config);
        if (config.default()) {
            this.log().info("ssl-config.default is true, using the JDK's default SSLContext");
            this.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder(this.mkLogger(), config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, config);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, config);
        this.looseDisableSNI(defaultParams);
        this.sslEngineConfigurator = new DefaultSSLEngineConfigurator(config, protocols, cipherSuites);
    }
}

