/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.stream.impl.io.OutputStreamSourceStage;
import akka.stream.impl.io.OutputStreamSourceStage$Canceled$;
import akka.stream.impl.io.OutputStreamSourceStage$Close$;
import akka.stream.impl.io.OutputStreamSourceStage$Flush$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001!Q!aE(viB,Ho\u0015;sK\u0006l\u0017\tZ1qi\u0016\u0014(BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005!\u0011.\u001c9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002\u0013\u0005!\u0011m[6b'\t\u00011\u0002\u0005\u0002\r!5\tQB\u0003\u0002\u0004\u001d)\tq\"\u0001\u0003kCZ\f\u0017BA\t\u000e\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\u0019\u0002A!A!\u0002\u0013)\u0012!\u00033bi\u0006\fV/Z;f\u0007\u0001\u00012AF\u000e\u001e\u001b\u00059\"B\u0001\r\u001a\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u000359\tA!\u001e;jY&\u0011Ad\u0006\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005y\u0001S\"A\u0010\u000b\u0005iA\u0011BA\u0011 \u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\u0001Bm\\<ogR\u0014X-Y7Ti\u0006$Xo\u001d\t\u0004K!RS\"\u0001\u0014\u000b\u0005\u001d:\u0012AB1u_6L7-\u0003\u0002*M\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002,s9\u0011Af\u000e\b\u0003[Yr!AL\u001b\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0015\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u000f\u0002\u0002/=+H\u000f];u'R\u0014X-Y7T_V\u00148-Z*uC\u001e,\u0017B\u0001\u001e<\u0005A!un\u001e8tiJ,\u0017-\\*uCR,8O\u0003\u00029\u0005!AQ\b\u0001B\u0001B\u0003%a(A\u0006tK:$Gk\\*uC\u001e,\u0007\u0003B C\t\u001ek\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\n\rVt7\r^5p]F\u0002\"aK#\n\u0005\u0019[$!F!eCB$XM\u001d+p'R\fw-Z'fgN\fw-\u001a\t\u0004\u0011*cU\"A%\u000b\u0005a\u0001\u0015BA&J\u0005\u00191U\u000f^;sKB\u0011q(T\u0005\u0003\u001d\u0002\u0013A!\u00168ji\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u0007xe&$X\rV5nK>,H\u000f\u0005\u0002S+6\t1K\u0003\u0002U\u0013\u0006AA-\u001e:bi&|g.\u0003\u0002W'\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\"\u0002-\u0001\t\u0003I\u0016A\u0002\u001fj]&$h\bF\u0003[9vsv\f\u0005\u0002\\\u00015\t!\u0001C\u0003\u0014/\u0002\u0007Q\u0003C\u0003$/\u0002\u0007A\u0005C\u0003>/\u0002\u0007a\bC\u0003Q/\u0002\u0007\u0011\u000bC\u0004b\u0001\u0001\u0007I\u0011\u00012\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\u0012a\u0019\t\u0003\u007f\u0011L!!\u001a!\u0003\u000f\t{w\u000e\\3b]\"9q\r\u0001a\u0001\n\u0003A\u0017\u0001D5t\u0003\u000e$\u0018N^3`I\u0015\fHC\u0001'j\u0011\u001dQg-!AA\u0002\r\f1\u0001\u001f\u00132\u0011\u0019a\u0007\u0001)Q\u0005G\u0006I\u0011n]!di&4X\r\t\u0005\b]\u0002\u0001\r\u0011\"\u0001c\u0003AI7\u000fU;cY&\u001c\b.\u001a:BY&4X\rC\u0004q\u0001\u0001\u0007I\u0011A9\u0002)%\u001c\b+\u001e2mSNDWM]!mSZ,w\fJ3r)\ta%\u000fC\u0004k_\u0006\u0005\t\u0019A2\t\rQ\u0004\u0001\u0015)\u0003d\u0003EI7\u000fU;cY&\u001c\b.\u001a:BY&4X\r\t\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0003a\u0001XO\u00197jg\",'o\u00117pg\u0016$W\t_2faRLwN\\\u000b\u0002qB\u0011A\"_\u0005\u0003u6\u00111\"S(Fq\u000e,\u0007\u000f^5p]\"1A\u0010\u0001Q\u0001\na\f\u0011\u0004];cY&\u001c\b.\u001a:DY>\u001cX\rZ#yG\u0016\u0004H/[8oA!1a\u0010\u0001Q\u0005\n}\fAa]3oIR\u0019A*!\u0001\t\u000f\u0005\rQ\u00101\u0001\u0002\u0006\u0005Q1/\u001a8e\u0003\u000e$\u0018n\u001c8\u0011\t}\n9\u0001T\u0005\u0004\u0003\u0013\u0001%!\u0003$v]\u000e$\u0018n\u001c81Q\u0015i\u0018QBA\n!\u0011y\u0014q\u0002=\n\u0007\u0005E\u0001I\u0001\u0004uQJ|wo]\u0012\u0002q\"A\u0011q\u0003\u0001!\n\u0013\tI\"\u0001\u0005tK:$G)\u0019;b)\ra\u00151\u0004\u0005\b\u0003;\t)\u00021\u0001\u001e\u0003\u0011!\u0017\r^1)\r\u0005U\u0011QBA\n\u0011!\t\u0019\u0003\u0001Q\u0005\n\u0005\u0015\u0012aC:f]\u0012lUm]:bO\u0016$R\u0001TA\u0014\u0003WAq!!\u000b\u0002\"\u0001\u0007A)A\u0004nKN\u001c\u0018mZ3\t\u0013\u00055\u0012\u0011\u0005I\u0001\u0002\u0004\u0019\u0017a\u00045b]\u0012dWmQ1oG\u0016dG.\u001a3)\r\u0005\u0005\u0012QBA\n\u0011\u001d\t\u0019\u0004\u0001C!\u0003k\tQa\u001e:ji\u0016$2\u0001TA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012!\u00012\u0011\u0007}\ni$C\u0002\u0002@\u0001\u00131!\u00138uQ\u0019\t\t$!\u0004\u0002\u0014!9\u00111\u0007\u0001\u0005B\u0005\u0015Cc\u0002'\u0002H\u0005U\u0013\u0011\f\u0005\t\u0003s\t\u0019\u00051\u0001\u0002JA)q(a\u0013\u0002P%\u0019\u0011Q\n!\u0003\u000b\u0005\u0013(/Y=\u0011\u0007}\n\t&C\u0002\u0002T\u0001\u0013AAQ=uK\"A\u0011qKA\"\u0001\u0004\tY$A\u0002pM\u001aD\u0001\"a\u0017\u0002D\u0001\u0007\u00111H\u0001\u0004Y\u0016t\u0007FBA\"\u0003\u001b\t\u0019\u0002C\u0004\u0002b\u0001!\t%a\u0019\u0002\u000b\u0019dWo\u001d5\u0015\u00031Cc!a\u0018\u0002\u000e\u0005M\u0001bBA5\u0001\u0011\u0005\u00131M\u0001\u0006G2|7/\u001a\u0015\u0007\u0003O\ni!a\u0005\t\u0013\u0005=\u0004!%A\u0005\n\u0005E\u0014!F:f]\u0012lUm]:bO\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003gR3aYA;W\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0013Ut7\r[3dW\u0016$'bAAA\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class OutputStreamAdapter
extends OutputStream {
    private final BlockingQueue<ByteString> dataQueue;
    private final AtomicReference<OutputStreamSourceStage.DownstreamStatus> downstreamStatus;
    private final Function1<OutputStreamSourceStage.AdapterToStageMessage, Future<BoxedUnit>> sendToStage;
    private final FiniteDuration writeTimeout;
    private boolean isActive;
    private boolean isPublisherAlive;
    private final IOException publisherClosedException;

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public boolean isPublisherAlive() {
        return this.isPublisherAlive;
    }

    public void isPublisherAlive_$eq(boolean x$1) {
        this.isPublisherAlive = x$1;
    }

    public IOException publisherClosedException() {
        return this.publisherClosedException;
    }

    private void send(Function0<BoxedUnit> sendAction) throws IOException {
        if (this.isActive()) {
            if (!this.isPublisherAlive()) {
                throw this.publisherClosedException();
            }
        } else {
            throw new IOException("OutputStream is closed");
        }
        sendAction.apply$mcV$sp();
    }

    private void sendData(ByteString data) throws IOException {
        this.send((JFunction0$mcV$sp & Serializable)() -> {
            try {
                $this.dataQueue.put(data);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = option.get();
                    throw new IOException(ex);
                }
                throw throwable;
            }
            OutputStreamSourceStage.DownstreamStatus downstreamStatus = $this.downstreamStatus.get();
            OutputStreamSourceStage$Canceled$ outputStreamSourceStage$Canceled$ = OutputStreamSourceStage$Canceled$.MODULE$;
            if (!(downstreamStatus != null ? !downstreamStatus.equals(outputStreamSourceStage$Canceled$) : outputStreamSourceStage$Canceled$ != null)) {
                this.isPublisherAlive_$eq(false);
                throw this.publisherClosedException();
            }
        });
    }

    private void sendMessage(OutputStreamSourceStage.AdapterToStageMessage message, boolean handleCancelled) throws IOException {
        this.send((JFunction0$mcV$sp & Serializable)() -> {
            try {
                Await$.MODULE$.ready($this.sendToStage.apply(message), $this.writeTimeout);
                OutputStreamSourceStage.DownstreamStatus downstreamStatus = $this.downstreamStatus.get();
                OutputStreamSourceStage$Canceled$ outputStreamSourceStage$Canceled$ = OutputStreamSourceStage$Canceled$.MODULE$;
                if (!(downstreamStatus != null ? !downstreamStatus.equals(outputStreamSourceStage$Canceled$) : outputStreamSourceStage$Canceled$ != null) && handleCancelled) {
                    this.isPublisherAlive_$eq(false);
                    throw this.publisherClosedException();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    throw iOException;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    throw new IOException(e);
                }
                throw throwable;
            }
        });
    }

    private boolean sendMessage$default$2() {
        return true;
    }

    @Override
    public void write(int b) throws IOException {
        this.sendData(ByteString$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{b}), Numeric$IntIsIntegral$.MODULE$));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.sendData(ByteString$.MODULE$.fromArray(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.sendMessage(OutputStreamSourceStage$Flush$.MODULE$, this.sendMessage$default$2());
    }

    @Override
    public void close() throws IOException {
        this.sendMessage(OutputStreamSourceStage$Close$.MODULE$, false);
        this.isActive_$eq(false);
    }

    public OutputStreamAdapter(BlockingQueue<ByteString> dataQueue, AtomicReference<OutputStreamSourceStage.DownstreamStatus> downstreamStatus, Function1<OutputStreamSourceStage.AdapterToStageMessage, Future<BoxedUnit>> sendToStage, FiniteDuration writeTimeout) {
        this.dataQueue = dataQueue;
        this.downstreamStatus = downstreamStatus;
        this.sendToStage = sendToStage;
        this.writeTimeout = writeTimeout;
        this.isActive = true;
        this.isPublisherAlive = true;
        this.publisherClosedException = new IOException("Reactive stream is terminated, no writes are possible");
    }
}

