/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerHelper$;
import akka.stream.ActorMaterializerSettings;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.SourceModule;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.StreamLayout;
import akka.stream.impl.io.FilePublisher$;
import akka.util.ByteString;
import java.io.Serializable;
import java.nio.file.Path;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!B\u0001\u0003\u0005!Q!A\u0003$jY\u0016\u001cv.\u001e:dK*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000f!\taa\u001d;sK\u0006l'\"A\u0005\u0002\t\u0005\\7.Y\n\u0003\u0001-\u0001B\u0001D\u0007\u0010+5\tA!\u0003\u0002\u000f\t\ta1k\\;sG\u0016lu\u000eZ;mKB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003C\u0001\u0005kRLG.\u0003\u0002\u0015#\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0007YYR$D\u0001\u0018\u0015\tA\u0012$\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039]\u0011aAR;ukJ,\u0007C\u0001\u0010 \u001b\u00051\u0011B\u0001\u0011\u0007\u0005!IuJU3tk2$\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0003\u0019\u001c\u0001\u0001\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005!a-\u001b7f\u0015\tI#&A\u0002oS>T\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.M\t!\u0001+\u0019;i\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014!C2ik:\\7+\u001b>f!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014DA\u0002J]RD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000egR\f'\u000f\u001e)pg&$\u0018n\u001c8\u0011\u0005E:\u0014B\u0001\u001d\u001a\u0005\u0011auN\\4\t\u0011i\u0002!Q1A\u0005\u0002m\n!\"\u0019;ue&\u0014W\u000f^3t+\u0005a\u0004C\u0001\u0010>\u0013\tqdA\u0001\u0006BiR\u0014\u0018NY;uKND\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\fCR$(/\u001b2vi\u0016\u001c\b\u0005C\u0005C\u0001\t\u0005\t\u0015!\u0003D\r\u0006)1\u000f[1qKB\u0019a\u0004R\b\n\u0005\u00153!aC*pkJ\u001cWm\u00155ba\u0016L!AQ\u0007\t\u000b!\u0003A\u0011A%\u0002\rqJg.\u001b;?)\u0019QE*\u0014(P!B\u00111\nA\u0007\u0002\u0005!)!e\u0012a\u0001I!)qf\u0012a\u0001a!)Qg\u0012a\u0001m!)!h\u0012a\u0001y!)!i\u0012a\u0001\u0007\")!\u000b\u0001C!'\u000611M]3bi\u0016$\"\u0001V0\u0011\tE*v+F\u0005\u0003-f\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001-^\u001f5\t\u0011L\u0003\u0002[7\u0006y!/Z1di&4Xm\u001d;sK\u0006l7OC\u0001]\u0003\ry'oZ\u0005\u0003=f\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\t\u000b\u0001\f\u0006\u0019A1\u0002\u000f\r|g\u000e^3yiB\u0011aDY\u0005\u0003G\u001a\u0011a#T1uKJL\u0017\r\\5{CRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006K\u0002!\tFZ\u0001\f]\u0016<\u0018J\\:uC:\u001cW\r\u0006\u0002\fO\")!\t\u001aa\u0001\u0007\")\u0011\u000e\u0001C!U\u0006qq/\u001b;i\u0003R$(/\u001b2vi\u0016\u001cHCA6|!\ta\u0007P\u0004\u0002nm:\u0011a.\u001e\b\u0003_Rt!\u0001]:\u000e\u0003ET!A]\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002x\t\u0005a1\u000b\u001e:fC6d\u0015-_8vi&\u0011\u0011P\u001f\u0002\u0007\u001b>$W\u000f\\3\u000b\u0005]$\u0001\"\u0002?i\u0001\u0004a\u0014\u0001B1uiJDQA \u0001\u0005R}\fQ\u0001\\1cK2,\"!!\u0001\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002q3%\u0019\u0011\u0011B\r\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tI!\u0007")
public final class FileSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final Path f;
    private final int chunkSize;
    private final long startPosition;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        ActorMaterializer materializer = ActorMaterializerHelper$.MODULE$.downcast(context.materializer());
        ActorMaterializerSettings settings = materializer.effectiveSettings(context.effectiveAttributes());
        Promise<IOResult> ioResultPromise = Promise$.MODULE$.apply();
        Props props = FilePublisher$.MODULE$.props(this.f, ioResultPromise, this.chunkSize, this.startPosition, settings.initialInputBufferSize(), settings.maxInputBufferSize());
        String dispatcher = context.effectiveAttributes().get(Stages$DefaultAttributes$.MODULE$.IODispatcher(), ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class)).dispatcher();
        ActorRef ref = materializer.actorOf(context, props.withDispatcher(dispatcher));
        return new Tuple2<Publisher<ByteString>, Future<IOResult>>(ActorPublisher$.MODULE$.apply(ref), ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new FileSource(this.f, this.chunkSize, this.startPosition, this.attributes(), shape);
    }

    @Override
    public StreamLayout.Module withAttributes(Attributes attr) {
        return new FileSource(this.f, this.chunkSize, this.startPosition, attr, this.amendShape(attr));
    }

    @Override
    public String label() {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileSource(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.f, BoxesRunTime.boxToInteger(this.chunkSize)}));
    }

    public FileSource(Path f, int chunkSize, long startPosition, Attributes attributes, SourceShape<ByteString> shape) {
        this.f = f;
        this.chunkSize = chunkSize;
        this.startPosition = startPosition;
        this.attributes = attributes;
        super(shape);
        Predef$.MODULE$.require(chunkSize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "chunkSize must be greater than 0");
        Predef$.MODULE$.require(startPosition >= 0L, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "startPosition must be equal or greater than 0");
    }
}

