/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.SupervisorStrategy$;
import akka.pattern.BackoffOptions;
import akka.pattern.BackoffSupervisor;
import akka.pattern.BackoffSupervisor$GetCurrentChild$;
import akka.pattern.BackoffSupervisor$GetRestartCount$;
import akka.pattern.BackoffSupervisor$Reset$;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ClassTag$;

public final class BackoffSupervisor$ {
    public static BackoffSupervisor$ MODULE$;

    static {
        new BackoffSupervisor$();
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, SupervisorStrategy$.MODULE$.defaultStrategy());
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        Predef$.MODULE$.require(minBackoff.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "minBackoff must be > 0");
        Predef$.MODULE$.require(maxBackoff.$greater$eq(minBackoff), (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "maxBackoff must be >= minBackoff");
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "randomFactor must be between 0.0 and 1.0");
        return Props$.MODULE$.apply((Function0<BackoffSupervisor> & java.io.Serializable & Serializable)() -> new BackoffSupervisor(childProps, childName, minBackoff, maxBackoff, randomFactor, strategy), ClassTag$.MODULE$.apply(BackoffSupervisor.class));
    }

    public Props props(BackoffOptions options) {
        return options.props();
    }

    public BackoffSupervisor$GetCurrentChild$ getCurrentChild() {
        return BackoffSupervisor$GetCurrentChild$.MODULE$;
    }

    public BackoffSupervisor$Reset$ reset() {
        return BackoffSupervisor$Reset$.MODULE$;
    }

    public BackoffSupervisor$GetRestartCount$ getRestartCount() {
        return BackoffSupervisor$GetRestartCount$.MODULE$;
    }

    public FiniteDuration calculateDelay(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        FiniteDuration finiteDuration;
        double rnd = 1.0 + ThreadLocalRandom.current().nextDouble() * randomFactor;
        if (restartCount >= 30) {
            finiteDuration = maxBackoff;
        } else {
            FiniteDuration finiteDuration2;
            Duration duration = maxBackoff.min(minBackoff.$times(package$.MODULE$.pow(2.0, restartCount))).$times(rnd);
            FiniteDuration finiteDuration3 = duration instanceof FiniteDuration ? (finiteDuration2 = (FiniteDuration)duration) : maxBackoff;
            finiteDuration = finiteDuration3;
        }
        return finiteDuration;
    }

    private BackoffSupervisor$() {
        MODULE$ = this;
    }
}

