/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.annotation.InternalApi;
import akka.http.impl.model.JavaInitialization$;
import akka.http.impl.util.StreamUtils$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$Chunked$;
import akka.http.scaladsl.model.UniversalEntity;
import akka.http.scaladsl.util.FastFuture$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HttpEntity$ {
    public static HttpEntity$ MODULE$;
    private final HttpEntity.Strict Empty;
    private final Function1<ByteString, Object> sizeOfByteString;
    private final Function1<HttpEntity.ChunkStreamPart, Object> sizeOfChunkStreamPart;
    private final Attributes akka$http$scaladsl$model$HttpEntity$$limitableDefaults;

    static {
        new HttpEntity$();
    }

    public HttpEntity.Strict apply(String string) {
        return this.apply(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), string);
    }

    public HttpEntity.Strict apply(byte[] bytes) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), bytes);
    }

    public HttpEntity.Strict apply(ByteString data) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), data);
    }

    public HttpEntity.Strict apply(ContentType.NonBinary contentType, String string) {
        return string.isEmpty() ? this.empty(contentType) : this.apply((ContentType)contentType, ByteString$.MODULE$.apply(string.getBytes(contentType.charset().nioCharset())));
    }

    public HttpEntity.Strict apply(ContentType contentType, byte[] bytes) {
        return bytes.length == 0 ? this.empty(contentType) : this.apply(contentType, ByteString$.MODULE$.apply(bytes));
    }

    public HttpEntity.Strict apply(ContentType contentType, ByteString data) {
        return data.isEmpty() ? this.empty(contentType) : new HttpEntity.Strict(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
        return contentLength == 0L ? this.empty(contentType) : new HttpEntity.Default(contentType, contentLength, data);
    }

    public HttpEntity.Chunked apply(ContentType contentType, Source<ByteString, Object> data) {
        return HttpEntity$Chunked$.MODULE$.fromData(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, File file, int chunkSize) {
        return this.fromPath(contentType, file.toPath(), chunkSize);
    }

    public int apply$default$3() {
        return -1;
    }

    public UniversalEntity fromPath(ContentType contentType, Path file, int chunkSize) {
        long fileLength = Files.size(file);
        return fileLength > 0L ? new HttpEntity.Default(contentType, fileLength, chunkSize > 0 ? FileIO$.MODULE$.fromPath(file, chunkSize) : FileIO$.MODULE$.fromPath(file, FileIO$.MODULE$.fromPath$default$2())) : this.empty(contentType);
    }

    public int fromPath$default$3() {
        return -1;
    }

    public HttpEntity.Strict Empty() {
        return this.Empty;
    }

    public HttpEntity.Strict empty(ContentType contentType) {
        ContentType contentType2 = contentType;
        ContentType contentType3 = this.Empty().contentType();
        return !(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null) ? this.Empty() : new HttpEntity.Strict(contentType, ByteString$.MODULE$.empty());
    }

    public <Mat> Source<ByteString, Mat> limitableByteSource(Source<ByteString, Mat> source) {
        return source.via(new HttpEntity.Limitable<ByteString>(this.sizeOfByteString()));
    }

    public <Mat> Source<HttpEntity.ChunkStreamPart, Mat> limitableChunkSource(Source<HttpEntity.ChunkStreamPart, Mat> source) {
        return source.via(new HttpEntity.Limitable<HttpEntity.ChunkStreamPart>(this.sizeOfChunkStreamPart()));
    }

    private Function1<ByteString, Object> sizeOfByteString() {
        return this.sizeOfByteString;
    }

    private Function1<HttpEntity.ChunkStreamPart, Object> sizeOfChunkStreamPart() {
        return this.sizeOfChunkStreamPart;
    }

    public Attributes akka$http$scaladsl$model$HttpEntity$$limitableDefaults() {
        return this.akka$http$scaladsl$model$HttpEntity$$limitableDefaults;
    }

    @InternalApi
    public <T extends HttpEntity> Tuple2<T, Future<BoxedUnit>> captureTermination(T entity) {
        Tuple2<scala.Serializable, Future<Object>> tuple2;
        T t = entity;
        if (t instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = (HttpEntity.Strict)t;
            tuple2 = Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(strict), FastFuture$.MODULE$.successful().apply(BoxedUnit.UNIT));
        } else if (t instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)t;
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple22 = StreamUtils$.MODULE$.captureTermination(default_.data());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Source<ByteString, Object> newData = tuple22._1();
            Future<BoxedUnit> whenCompleted = tuple22._2();
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple23 = new Tuple2<Source<ByteString, Object>, Future<BoxedUnit>>(newData, whenCompleted);
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple24 = tuple23;
            Source<ByteString, Object> newData2 = tuple24._1();
            Future<BoxedUnit> whenCompleted2 = tuple24._2();
            Source<ByteString, Object> x$19 = newData2;
            ContentType x$20 = default_.copy$default$1();
            long x$21 = default_.copy$default$2();
            tuple2 = Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(default_.copy(x$20, x$21, x$19)), whenCompleted2);
        } else if (t instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)t;
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, Future<BoxedUnit>> tuple25 = StreamUtils$.MODULE$.captureTermination(chunked.chunks());
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            Source<HttpEntity.ChunkStreamPart, Object> newChunks = tuple25._1();
            Future<BoxedUnit> whenCompleted = tuple25._2();
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, Future<BoxedUnit>> tuple26 = new Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, Future<BoxedUnit>>(newChunks, whenCompleted);
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, Future<BoxedUnit>> tuple27 = tuple26;
            Source<HttpEntity.ChunkStreamPart, Object> newChunks2 = tuple27._1();
            Future<BoxedUnit> whenCompleted3 = tuple27._2();
            Source<HttpEntity.ChunkStreamPart, Object> x$22 = newChunks2;
            ContentType x$23 = chunked.copy$default$1();
            tuple2 = Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(chunked.copy(x$23, x$22)), whenCompleted3);
        } else if (t instanceof HttpEntity.CloseDelimited) {
            HttpEntity.CloseDelimited closeDelimited = (HttpEntity.CloseDelimited)t;
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple28 = StreamUtils$.MODULE$.captureTermination(closeDelimited.data());
            if (tuple28 == null) {
                throw new MatchError(tuple28);
            }
            Source<ByteString, Object> newData = tuple28._1();
            Future<BoxedUnit> whenCompleted = tuple28._2();
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple29 = new Tuple2<Source<ByteString, Object>, Future<BoxedUnit>>(newData, whenCompleted);
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple210 = tuple29;
            Source<ByteString, Object> newData3 = tuple210._1();
            Future<BoxedUnit> whenCompleted4 = tuple210._2();
            Source<ByteString, Object> x$24 = newData3;
            ContentType x$25 = closeDelimited.copy$default$1();
            tuple2 = Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(closeDelimited.copy(x$25, x$24)), whenCompleted4);
        } else if (t instanceof HttpEntity.IndefiniteLength) {
            HttpEntity.IndefiniteLength indefiniteLength = (HttpEntity.IndefiniteLength)t;
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple211 = StreamUtils$.MODULE$.captureTermination(indefiniteLength.data());
            if (tuple211 == null) {
                throw new MatchError(tuple211);
            }
            Source<ByteString, Object> newData = tuple211._1();
            Future<BoxedUnit> whenCompleted = tuple211._2();
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple212 = new Tuple2<Source<ByteString, Object>, Future<BoxedUnit>>(newData, whenCompleted);
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple213 = tuple212;
            Source<ByteString, Object> newData4 = tuple213._1();
            Future<BoxedUnit> whenCompleted5 = tuple213._2();
            Source<ByteString, Object> x$26 = newData4;
            ContentType x$27 = indefiniteLength.copy$default$1();
            tuple2 = Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(indefiniteLength.copy(x$27, x$26)), whenCompleted5);
        } else {
            throw new MatchError(t);
        }
        return tuple2;
    }

    public HttpEntity HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
        return httpEntity;
    }

    public static final /* synthetic */ int $anonfun$sizeOfChunkStreamPart$1(HttpEntity.ChunkStreamPart x$5) {
        return x$5.data().size();
    }

    private HttpEntity$() {
        MODULE$ = this;
        this.Empty = new HttpEntity.Strict(ContentTypes$.MODULE$.NoContentType(), ByteString$.MODULE$.empty());
        JavaInitialization$.MODULE$.initializeStaticFieldWith(this.Empty(), akka.http.javadsl.model.HttpEntity.class.getField("EMPTY"));
        this.sizeOfByteString = (Function1<ByteString, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.size());
        this.sizeOfChunkStreamPart = (Function1<HttpEntity.ChunkStreamPart, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(HttpEntity$.$anonfun$sizeOfChunkStreamPart$1(x$5));
        this.akka$http$scaladsl$model$HttpEntity$$limitableDefaults = Attributes$.MODULE$.name("limitable");
    }
}

