/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.engine.parsing.HttpMessageParser;
import akka.http.impl.engine.parsing.HttpResponseParser;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import akka.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import akka.http.impl.engine.rendering.HttpRequestRendererFactory$;
import akka.http.impl.engine.rendering.RequestRenderingContext;
import akka.http.impl.engine.rendering.RequestRenderingContext$;
import akka.http.impl.engine.ws.Handshake;
import akka.http.impl.engine.ws.Handshake$Client$;
import akka.http.impl.engine.ws.WebSocket$;
import akka.http.impl.engine.ws.WebSocketClientBlueprint;
import akka.http.impl.engine.ws.WebSocketClientBlueprint$UpgradeStage$1$;
import akka.http.impl.util.StreamUtils;
import akka.http.impl.util.StreamUtils$OneTimeValve$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.http.scaladsl.model.headers.Sec;
import akka.http.scaladsl.model.ws.InvalidUpgradeResponse;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.ValidUpgrade;
import akka.http.scaladsl.model.ws.WebSocketRequest;
import akka.http.scaladsl.model.ws.WebSocketUpgradeResponse;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.stream.Attributes;
import akka.stream.BidiShape;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.SourceShape;
import akka.stream.TLSProtocol;
import akka.stream.TLSProtocol$SendBytes$;
import akka.stream.UniformFanInShape;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Concat$;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.GraphDSL$Implicits$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Source$;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WebSocketClientBlueprint$ {
    public static WebSocketClientBlueprint$ MODULE$;

    static {
        new WebSocketClientBlueprint$();
    }

    public BidiFlow<Message, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, Message, Future<WebSocketUpgradeResponse>> apply(WebSocketRequest request, ClientConnectionSettings settings, LoggingAdapter log) {
        boolean x$3 = false;
        Function0<Random> x$4 = settings.websocketRandomFactory();
        LoggingAdapter x$5 = log;
        FiniteDuration x$6 = WebSocket$.MODULE$.stack$default$3();
        return this.simpleTls().atopMat(this.handshake(request, settings, log), Keep$.MODULE$.right()).atop(WebSocket$.MODULE$.framing()).atop(WebSocket$.MODULE$.stack(x$3, x$4, x$6, x$5)).reversed();
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, Future<WebSocketUpgradeResponse>> handshake(WebSocketRequest request, ClientConnectionSettings settings, LoggingAdapter log) {
        Promise result = Promise$.MODULE$.apply();
        StreamUtils.OneTimeValve valve = StreamUtils$OneTimeValve$.MODULE$.apply();
        Tuple2<HttpRequest, Sec.minusWebSocket.minusKey> tuple2 = Handshake$Client$.MODULE$.buildRequest(request.uri(), request.extraHeaders(), request.subprotocol().toList(), settings.websocketRandomFactory().apply());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpRequest initialRequest = tuple2._1();
        Sec.minusWebSocket.minusKey key = tuple2._2();
        Tuple2<HttpRequest, Sec.minusWebSocket.minusKey> tuple22 = new Tuple2<HttpRequest, Sec.minusWebSocket.minusKey>(initialRequest, key);
        Tuple2<HttpRequest, Sec.minusWebSocket.minusKey> tuple23 = tuple22;
        HttpRequest initialRequest2 = tuple23._1();
        Sec.minusWebSocket.minusKey key2 = tuple23._2();
        Host hostHeader = Host$.MODULE$.apply(request.uri().authority().normalizedFor(request.uri().scheme()));
        ByteString renderedInitialRequest = HttpRequestRendererFactory$.MODULE$.renderStrict(new RequestRenderingContext(initialRequest2, hostHeader, RequestRenderingContext$.MODULE$.apply$default$3()), settings, log);
        return BidiFlow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1<GraphDSL.Builder, BidiShape> & Serializable & scala.Serializable)b -> {
            public class Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1
            extends GraphStages.SimpleLinearGraphStage<ByteString> {
                public final WebSocketRequest request$1;
                public final ClientConnectionSettings settings$1;
                public final LoggingAdapter log$1;
                public final Promise result$1;
                public final StreamUtils.OneTimeValve valve$1;
                public final Sec.minusWebSocket.minusKey key$1;

                public GraphStageLogic createLogic(Attributes attributes) {
                    return new InHandler(this){
                        private final HttpResponseParser parser;
                        private final /* synthetic */ Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1 $outer;

                        public void onDownstreamFinish() throws Exception {
                            OutHandler.onDownstreamFinish$(this);
                        }

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$(this);
                        }

                        private HttpResponseParser parser() {
                            return this.parser;
                        }

                        public void onPush() {
                            ParserOutput.ResponseOutput responseOutput = (ParserOutput.ResponseOutput)this.parser().parseBytes((ByteString)this.grab(this.$outer.in()));
                            if (ParserOutput$NeedMoreData$.MODULE$.equals(responseOutput)) {
                                this.pull(this.$outer.in());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else if (responseOutput instanceof ParserOutput.ResponseStart) {
                                Right right;
                                Handshake.Client.NegotiatedWebSocketSettings negotiatedWebSocketSettings;
                                ParserOutput.ResponseStart responseStart = (ParserOutput.ResponseStart)responseOutput;
                                StatusCode status = responseStart.statusCode();
                                HttpProtocol protocol = responseStart.protocol();
                                List<HttpHeader> headers = responseStart.headers();
                                StatusCode x$7 = status;
                                List<HttpHeader> x$8 = headers;
                                HttpProtocol x$9 = protocol;
                                ResponseEntity x$10 = HttpResponse$.MODULE$.apply$default$3();
                                HttpResponse response = HttpResponse$.MODULE$.apply(x$7, x$8, x$10, x$9);
                                Either<String, Handshake.Client.NegotiatedWebSocketSettings> either = Handshake$Client$.MODULE$.validateResponse(response, this.$outer.request$1.subprotocol().toList(), this.$outer.key$1);
                                if (either instanceof Right && (negotiatedWebSocketSettings = (Handshake.Client.NegotiatedWebSocketSettings)(right = (Right)either).value()) != null) {
                                    ParserOutput.ResponseOutput parseResult;
                                    Option<String> protocol2 = negotiatedWebSocketSettings.subprotocol();
                                    this.$outer.result$1.success(new ValidUpgrade(response, protocol2));
                                    this.setHandler(this.$outer.in(), new InHandler(this){
                                        private final /* synthetic */ WebSocketClientBlueprint$UpgradeStage$1$.anon.1 $outer;

                                        public void onUpstreamFinish() throws Exception {
                                            InHandler.onUpstreamFinish$(this);
                                        }

                                        public void onUpstreamFailure(Throwable ex) throws Exception {
                                            InHandler.onUpstreamFailure$(this, ex);
                                        }

                                        public void onPush() {
                                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().out(), this.$outer.grab(this.$outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().in()));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            InHandler.$init$(this);
                                        }
                                    });
                                    this.$outer.valve$1.open();
                                    ParserOutput.ResponseOutput responseOutput2 = parseResult = this.parser().onPull();
                                    ParserOutput$MessageEnd$ parserOutput$MessageEnd$ = ParserOutput$MessageEnd$.MODULE$;
                                    Predef$.MODULE$.require(!(responseOutput2 != null ? !responseOutput2.equals(parserOutput$MessageEnd$) : parserOutput$MessageEnd$ != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parseResult should be MessageEnd but was ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{parseResult})));
                                    ParserOutput.ResponseOutput responseOutput3 = this.parser().onPull();
                                    if (ParserOutput$NeedMoreData$.MODULE$.equals(responseOutput3)) {
                                        this.pull(this.$outer.in());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else if (responseOutput3 instanceof ParserOutput.RemainingBytes) {
                                        ParserOutput.RemainingBytes remainingBytes = (ParserOutput.RemainingBytes)responseOutput3;
                                        ByteString bytes = remainingBytes.bytes();
                                        this.push(this.$outer.out(), bytes);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected element of type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{responseOutput3.getClass()})));
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else if (either instanceof Left) {
                                    Left left = (Left)either;
                                    String problem = (String)left.value();
                                    this.$outer.result$1.success(new InvalidUpgradeResponse(response, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WebSocket server at ", " returned ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.request$1.uri(), problem}))));
                                    this.failStage(new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WebSocket upgrade did not finish because of '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{problem}))));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError(either);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                if (responseOutput instanceof ParserOutput.MessageStartError) {
                                    ParserOutput.MessageStartError messageStartError = (ParserOutput.MessageStartError)responseOutput;
                                    StatusCode statusCode = messageStartError.status();
                                    ErrorInfo errorInfo = messageStartError.info();
                                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message failed with status code ", "; Error info: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{statusCode, errorInfo})));
                                }
                                throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected element of type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{responseOutput.getClass()})));
                            }
                        }

                        public void onPull() {
                            this.pull(this.$outer.in());
                        }

                        public void onUpstreamFailure(Throwable ex) {
                            this.$outer.result$1.tryFailure(new RuntimeException("Connection failed.", ex));
                            InHandler.onUpstreamFailure$(this, ex);
                        }

                        public /* synthetic */ Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1 akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            super($outer.shape());
                            InHandler.$init$(this);
                            OutHandler.$init$(this);
                            this.parser = new HttpResponseParser(this){
                                private boolean first;

                                public boolean first() {
                                    return this.first;
                                }

                                public void first_$eq(boolean x$1) {
                                    this.first = x$1;
                                }

                                public boolean handleInformationalResponses() {
                                    return false;
                                }

                                public HttpMessageParser.StateResult parseMessage(ByteString input, int offset) {
                                    HttpMessageParser.StateResult stateResult;
                                    if (this.first()) {
                                        this.first_$eq(false);
                                        stateResult = super.parseMessage(input, offset);
                                    } else {
                                        this.emit(new ParserOutput.RemainingBytes(input.drop(offset)));
                                        stateResult = this.terminate();
                                    }
                                    return stateResult;
                                }
                                {
                                    super($outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().settings$1.parserSettings(), HttpHeaderParser$.MODULE$.apply($outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().settings$1.parserSettings(), $outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().log$1));
                                    this.first = true;
                                }
                            };
                            this.parser().setContextForNextResponse(new HttpResponseParser.ResponseContext(HttpMethods$.MODULE$.GET(), None$.MODULE$));
                            this.setHandlers($outer.in(), $outer.out(), this);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1(akka.http.impl.engine.parsing.ParserOutput$ResponseOutput )}, serializedLambda);
                        }
                    };
                }

                public String toString() {
                    return "UpgradeStage";
                }

                public Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1(WebSocketRequest request$1, ClientConnectionSettings settings$1, LoggingAdapter log$1, Promise result$1, StreamUtils.OneTimeValve valve$1, Sec.minusWebSocket.minusKey key$1) {
                    this.request$1 = request$1;
                    this.settings$1 = settings$1;
                    this.log$1 = log$1;
                    this.result$1 = result$1;
                    this.valve$1 = valve$1;
                    this.key$1 = key$1;
                }
            }
            FlowShape networkIn = (FlowShape)b.add(Flow$.MODULE$.apply().via((Graph)new Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1(request, settings, log, result, valve, key2)));
            FlowShape wsIn = (FlowShape)b.add(Flow$.MODULE$.apply());
            SourceShape handshakeRequestSource = (SourceShape)b.add((Graph)((Object)Source$.MODULE$.single(renderedInitialRequest).$plus$plus(valve.source())));
            UniformFanInShape httpRequestBytesAndThenWSBytes = b.add(Concat$.MODULE$.apply(Concat$.MODULE$.apply$default$1()));
            new GraphDSL.Implicits.SourceShapeArrow(GraphDSL$Implicits$.MODULE$.SourceShapeArrow(handshakeRequestSource)).$tilde$greater(httpRequestBytesAndThenWSBytes, (GraphDSL.Builder<?>)b);
            GraphDSL$Implicits$.MODULE$.port2flow(GraphDSL$Implicits$.MODULE$.flow2flow(wsIn, (GraphDSL.Builder<?>)b).outlet(), (GraphDSL.Builder<?>)b).$tilde$greater(httpRequestBytesAndThenWSBytes, (GraphDSL.Builder<?>)b);
            return new BidiShape(networkIn.in(), networkIn.out(), wsIn.in(), httpRequestBytesAndThenWSBytes.out());
        })).mapMaterializedValue((Function1<NotUsed, Future> & Serializable & scala.Serializable)x$2 -> result.future());
    }

    public BidiFlow<TLSProtocol.SslTlsInbound, ByteString, ByteString, TLSProtocol.SendBytes, NotUsed> simpleTls() {
        return BidiFlow$.MODULE$.fromFlowsMat((Graph)((Object)Flow$.MODULE$.apply().collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TLSProtocol.SessionBytes) {
                    TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                    ByteString bytes = sessionBytes.bytes();
                    object = bytes;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x1;
                boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
                return bl;
            }
        })), (Graph)((Object)Flow$.MODULE$.apply().map(TLSProtocol$SendBytes$.MODULE$)), Keep$.MODULE$.none());
    }

    private WebSocketClientBlueprint$() {
        MODULE$ = this;
    }
}

