/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameData;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventRenderer$;
import akka.http.impl.engine.ws.FrameHeader;
import akka.http.impl.engine.ws.FrameStart;
import akka.http.impl.engine.ws.Protocol$;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.ByteString$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001}3Q!\u0001\u0002\u0003\u00111\u0011!C\u0012:b[\u0016,e/\u001a8u%\u0016tG-\u001a:fe*\u00111\u0001B\u0001\u0003oNT!!\u0002\u0004\u0002\r\u0015tw-\u001b8f\u0015\t9\u0001\"\u0001\u0003j[Bd'BA\u0005\u000b\u0003\u0011AG\u000f\u001e9\u000b\u0003-\tA!Y6lCN\u0011\u0001!\u0004\t\u0004\u001dM)R\"A\b\u000b\u0005A\t\u0012!B:uC\u001e,'B\u0001\n\u000b\u0003\u0019\u0019HO]3b[&\u0011Ac\u0004\u0002\u000b\u000fJ\f\u0007\u000f[*uC\u001e,\u0007\u0003\u0002\f\u00183ui\u0011!E\u0005\u00031E\u0011\u0011B\u00127poNC\u0017\r]3\u0011\u0005iYR\"\u0001\u0002\n\u0005q\u0011!A\u0003$sC6,WI^3oiB\u0011a$I\u0007\u0002?)\u0011\u0001EC\u0001\u0005kRLG.\u0003\u0002#?\tQ!)\u001f;f'R\u0014\u0018N\\4\t\u000b\u0011\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\n\t\u00035\u0001Aq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0002j]V\t1\u0006E\u0002\u0017YeI!!L\t\u0003\u000b%sG.\u001a;\t\r=\u0002\u0001\u0015!\u0003,\u0003\rIg\u000e\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003\ryW\u000f^\u000b\u0002gA\u0019a\u0003N\u000f\n\u0005U\n\"AB(vi2,G\u000f\u0003\u00048\u0001\u0001\u0006IaM\u0001\u0005_V$\b\u0005C\u0004:\u0001\t\u0007I\u0011\t\u001e\u0002\u000bMD\u0017\r]3\u0016\u0003UAa\u0001\u0010\u0001!\u0002\u0013)\u0012AB:iCB,\u0007\u0005C\u0003?\u0001\u0011\u0005s(A\u0006de\u0016\fG/\u001a'pO&\u001cGC\u0001!D!\tq\u0011)\u0003\u0002C\u001f\tyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0003E{\u0001\u0007Q)A\nj]\",'/\u001b;fI\u0006#HO]5ckR,7\u000f\u0005\u0002\u0017\r&\u0011q)\u0005\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\b\"B%\u0001\t\u0013Q\u0015a\u0003:f]\u0012,'o\u0015;beR$\"!H&\t\u000b1C\u0005\u0019A'\u0002\u000bM$\u0018M\u001d;\u0011\u0005iq\u0015BA(\u0003\u0005)1%/Y7f'R\f'\u000f\u001e\u0005\u0006#\u0002!IAU\u0001\re\u0016tG-\u001a:IK\u0006$WM\u001d\u000b\u0003;MCQ\u0001\u0016)A\u0002U\u000ba\u0001[3bI\u0016\u0014\bC\u0001\u000eW\u0013\t9&AA\u0006Ge\u0006lW\rS3bI\u0016\u0014\bF\u0001\u0001Z!\tQV,D\u0001\\\u0015\ta&\"\u0001\u0006b]:|G/\u0019;j_:L!AX.\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public final class FrameEventRenderer
extends GraphStage<FlowShape<FrameEvent, ByteString>> {
    private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply("FrameEventRenderer.in");
    private final Outlet<ByteString> out = Outlet$.MODULE$.apply("FrameEventRenderer.out");
    private final FlowShape<FrameEvent, ByteString> shape = new FlowShape<FrameEvent, ByteString>(this.in(), this.out());

    public Inlet<FrameEvent> in() {
        return this.in;
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    @Override
    public FlowShape<FrameEvent, ByteString> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new GraphStageLogic(this){
            private final InHandler Initial;
            private final /* synthetic */ FrameEventRenderer $outer;

            private InHandler Initial() {
                return this.Initial;
            }

            public InHandler akka$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(long initialRemaining, InHandler nextState) {
                return new InHandler(this, initialRemaining, nextState){
                    private long remaining;
                    private final /* synthetic */ $anon$1 $outer;
                    private final InHandler nextState$1;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$(this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$(this, ex);
                    }

                    private long remaining() {
                        return this.remaining;
                    }

                    private void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        FrameEvent frameEvent = this.$outer.grab(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameData) {
                            BoxedUnit boxedUnit;
                            FrameData frameData = (FrameData)frameEvent;
                            ByteString data = frameData.data();
                            boolean lastPart = frameData.lastPart();
                            if ((long)data.size() > this.remaining()) {
                                throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " frame bytes but got ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.remaining()), BoxesRunTime.boxToInteger(data.size())})));
                            }
                            if ((long)data.size() == this.remaining()) {
                                if (!lastPart) {
                                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame data complete but `lastPart` flag not set"})).s(Nil$.MODULE$));
                                }
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.nextState$1);
                                this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.remaining_$eq(this.remaining() - (long)data.size());
                                this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else if (frameEvent instanceof FrameStart) {
                            this.$outer.fail(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameStart (need more FrameData first)"));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(frameEvent);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextState$1 = nextState$1;
                        InHandler.$init$(this);
                        this.remaining = initialRemaining$1;
                    }
                };
            }

            public /* synthetic */ FrameEventRenderer akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.Initial = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$(this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$(this, ex);
                    }

                    public void onPush() {
                        FrameEvent frameEvent = this.$outer.grab(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameStart) {
                            FrameStart frameStart = (FrameStart)frameEvent;
                            FrameHeader header = frameStart.header();
                            ByteString data = frameStart.data();
                            Predef$.MODULE$.require(header.length() >= (long)data.size());
                            if (!frameStart.lastPart() && header.length() > 0L) {
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(header.length() - (long)data.length(), this));
                            }
                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().akka$http$impl$engine$ws$FrameEventRenderer$$renderStart(frameStart));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (frameEvent instanceof FrameData) {
                            this.$outer.fail(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(frameEvent);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        InHandler.$init$(this);
                    }
                };
                this.setHandler($outer.in(), this.Initial());
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$(this);
                    }

                    public void onPull() {
                        this.$outer.pull(this.$outer.akka$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$(this);
                    }
                });
            }
        };
    }

    public ByteString akka$http$impl$engine$ws$FrameEventRenderer$$renderStart(FrameStart start) {
        return this.renderHeader(start.header()).$plus$plus(start.data());
    }

    private ByteString renderHeader(FrameHeader header) {
        long length = header.length();
        long l = length;
        Tuple2$mcII$sp tuple2$mcII$sp = l < 126L ? new Tuple2$mcII$sp((int)l, 0) : (l <= 65535L ? new Tuple2$mcII$sp(126, 2) : new Tuple2$mcII$sp(127, 8));
        Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
        if (tuple2$mcII$sp2 == null) {
            throw new MatchError(tuple2$mcII$sp2);
        }
        int lengthBits = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
        int extraLengthBytes = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp3 = new Tuple2$mcII$sp(lengthBits, extraLengthBytes);
        Tuple2$mcII$sp tuple2$mcII$sp4 = tuple2$mcII$sp3;
        int lengthBits2 = ((Tuple2)tuple2$mcII$sp4)._1$mcI$sp();
        int extraLengthBytes2 = ((Tuple2)tuple2$mcII$sp4)._2$mcI$sp();
        int maskBytes = header.mask().isDefined() ? 4 : 0;
        int totalSize = 2 + extraLengthBytes2 + maskBytes;
        byte[] data = new byte[totalSize];
        int flags = FrameEventRenderer.bool$1(header.fin(), Protocol$.MODULE$.FIN_MASK()) | FrameEventRenderer.bool$1(header.rsv1(), Protocol$.MODULE$.RSV1_MASK()) | FrameEventRenderer.bool$1(header.rsv2(), Protocol$.MODULE$.RSV2_MASK()) | FrameEventRenderer.bool$1(header.rsv3(), Protocol$.MODULE$.RSV3_MASK());
        data[0] = (byte)(flags | header.opcode().code());
        data[1] = (byte)(FrameEventRenderer.bool$1(header.mask().isDefined(), Protocol$.MODULE$.MASK_MASK()) | lengthBits2);
        int n = extraLengthBytes2;
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                data[2] = (byte)((length & 0xFF00L) >> 8);
                data[3] = (byte)((length & 0xFFL) >> 0);
                break;
            }
            case 8: {
                this.addLongBytes$1(Long.rotateLeft(length, 8), 0, data);
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        int maskOffset = 2 + extraLengthBytes2;
        header.mask().foreach((JFunction1$mcVI$sp & Serializable)mask -> {
            data$1[maskOffset$1 + 0] = (byte)((mask & 0xFF000000) >> 24);
            data$1[maskOffset$1 + 1] = (byte)((mask & 0xFF0000) >> 16);
            data$1[maskOffset$1 + 2] = (byte)((mask & 0xFF00) >> 8);
            data$1[maskOffset$1 + 3] = (byte)((mask & 0xFF) >> 0);
        });
        return ByteString$.MODULE$.apply(data);
    }

    private static final int bool$1(boolean b, int mask) {
        return b ? mask : 0;
    }

    private final void addLongBytes$1(long l, int writtenBytes, byte[] data$1) {
        while (writtenBytes < 8) {
            data$1[2 + writtenBytes] = (byte)(l & 0xFFL);
            ++writtenBytes;
            l = Long.rotateLeft(l, 8);
        }
    }
}

