/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventParser$;
import akka.http.impl.engine.ws.FrameEventParser$$anon$1$ReadFrameHeader$;
import akka.http.impl.engine.ws.Protocol$CloseCodes$;
import akka.http.impl.engine.ws.Utf8Decoder$;
import akka.stream.Attributes;
import akka.stream.impl.io.ByteStringParser;
import akka.util.ByteString;
import akka.util.ByteString$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@InternalApi
public final class FrameEventParser$
extends ByteStringParser<FrameEvent> {
    public static FrameEventParser$ MODULE$;

    static {
        new FrameEventParser$();
    }

    @Override
    public ByteStringParser.ParsingLogic createLogic(Attributes attr) {
        return new ByteStringParser.ParsingLogic(){
            private volatile FrameEventParser$$anon$1$ReadFrameHeader$ ReadFrameHeader$module;

            public FrameEventParser$$anon$1$ReadFrameHeader$ akka$http$impl$engine$ws$FrameEventParser$$anon$$ReadFrameHeader() {
                if (this.ReadFrameHeader$module == null) {
                    this.ReadFrameHeader$lzycompute$1();
                }
                return this.ReadFrameHeader$module;
            }

            private final void ReadFrameHeader$lzycompute$1() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.ReadFrameHeader$module == null) {
                        this.ReadFrameHeader$module = new FrameEventParser$$anon$1$ReadFrameHeader$(this);
                    }
                }
            }
            {
                this.startWith(this.akka$http$impl$engine$ws$FrameEventParser$$anon$$ReadFrameHeader());
            }
        };
    }

    public ByteString mask(ByteString bytes, Option<Object> _mask) {
        ByteString byteString;
        Option<Object> option = _mask;
        if (option instanceof Some) {
            Some some = (Some)option;
            int m = BoxesRunTime.unboxToInt(some.value());
            byteString = this.mask(bytes, m)._1();
        } else if (None$.MODULE$.equals(option)) {
            byteString = bytes;
        } else {
            throw new MatchError(option);
        }
        return byteString;
    }

    public Tuple2<ByteString, Object> mask(ByteString bytes, int mask) {
        byte[] buffer = (byte[])bytes.toArray(ClassTag$.MODULE$.Byte());
        int newMask = this.rec$1(buffer, 0, mask);
        return new Tuple2<ByteString, Object>(ByteString$.MODULE$.apply(buffer), BoxesRunTime.boxToInteger(newMask));
    }

    public Option<Tuple2<Object, String>> parseCloseCode(ByteString data) {
        Option option;
        if (data.length() >= 2) {
            int code = (data.apply(0) & 0xFF) << 8 | data.apply(1) & 0xFF;
            Try<String> message = Utf8Decoder$.MODULE$.decode(data.drop(2));
            option = !Protocol$CloseCodes$.MODULE$.isValid(code) ? FrameEventParser$.invalid$1(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid close code '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(code)}))) : (message.isFailure() ? FrameEventParser$.invalid$1("close reason message is invalid UTF8") : new Some<Tuple2<Integer, String>>(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(code), message.get())));
        } else {
            option = data.length() == 1 ? FrameEventParser$.invalid$1("close code must be length 2 but was 1") : None$.MODULE$;
        }
        return option;
    }

    public String toString() {
        return "FrameEventParser";
    }

    private final int rec$1(byte[] bytes, int offset, int mask) {
        while (offset < bytes.length) {
            int newMask = Integer.rotateLeft(mask, 8);
            bytes[offset] = (byte)(bytes[offset] ^ newMask & 0xFF);
            mask = newMask;
            ++offset;
        }
        return mask;
    }

    private static final Some invalid$1(String reason) {
        return new Some<Tuple2<Integer, String>>(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(Protocol$CloseCodes$.MODULE$.ProtocolError()), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Peer sent illegal close frame (", ")."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{reason}))));
    }

    private FrameEventParser$() {
        MODULE$ = this;
    }
}

