/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$ContentLengthParser$;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.model.parser.HeaderParser$;
import akka.http.impl.util.EnhancedString$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.EmptyHeader$;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InternalApi
public final class HttpHeaderParser$ {
    public static HttpHeaderParser$ MODULE$;

    static {
        new HttpHeaderParser$();
    }

    private Seq<String> predefinedHeaders() {
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accept: *", "Accept: */*", "Connection: Keep-Alive", "Connection: close", "Connection: keep-alive", "Content-Length: 0", "Cache-Control: max-age=0", "Cache-Control: no-cache", "Expect: 100-continue"}));
    }

    public HttpHeaderParser apply(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return this.prime(this.unprimed(settings, log, this.defaultIllegalHeaderHandler(settings, log)));
    }

    public Function1<ErrorInfo, BoxedUnit> defaultIllegalHeaderHandler(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return settings.illegalHeaderWarnings() ? (Function1<ErrorInfo, Object> & Serializable & scala.Serializable)info -> {
            package$.MODULE$.logParsingError(info.withSummaryPrepended("Illegal header"), log, settings.errorLoggingVerbosity());
            return BoxedUnit.UNIT;
        } : (Function1<ErrorInfo, Object> & Serializable & scala.Serializable)x$16 -> {
            cfr_ignored_0 = (Function1<ErrorInfo, ErrorInfo> & Serializable & scala.Serializable)x$15 -> x$16;
            return BoxedUnit.UNIT;
        };
    }

    public HttpHeaderParser unprimed(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpHeaderParser(settings, log, warnOnIllegalHeader, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10());
    }

    public HttpHeaderParser prime(HttpHeaderParser parser) {
        Seq valueParsers = HeaderParser$.MODULE$.ruleNames().map((Function1<String, HttpHeaderParser.ModeledHeaderValueParser> & Serializable & scala.Serializable)name -> new HttpHeaderParser.ModeledHeaderValueParser((String)name, parser.settings().maxHeaderValueLength(), parser.settings().headerValueCacheLimit((String)name), parser.log(), parser.settings()), scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()));
        Seq x$326 = (Seq)valueParsers.sortBy((Function1<HttpHeaderParser.HeaderValueParser, String> & Serializable & scala.Serializable)x$17 -> x$17.headerName(), Ordering$String$.MODULE$);
        int x$327 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$326);
        int x$328 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$326);
        this.insertInGoodOrder$1(x$326, x$327, x$328, parser);
        Seq<SpecializedHeaderValueParsers$ContentLengthParser$> x$329 = SpecializedHeaderValueParsers$.MODULE$.specializedHeaderValueParsers();
        int x$330 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$329);
        int x$331 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$329);
        this.insertInGoodOrder$1(x$329, x$330, x$331, parser);
        Seq x$332 = (Seq)this.predefinedHeaders().sorted(Ordering$String$.MODULE$);
        int x$333 = HttpHeaderParser$.insertInGoodOrder$default$2$1(x$332);
        int x$334 = HttpHeaderParser$.insertInGoodOrder$default$3$1(x$332);
        this.insertInGoodOrder$1(x$332, x$333, x$334, parser);
        ByteString x$335 = ByteString$.MODULE$.apply("\r\n");
        EmptyHeader$ x$336 = EmptyHeader$.MODULE$;
        int x$337 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$335, x$336);
        int x$338 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$335, x$336);
        int x$339 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$335, x$336);
        int x$340 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$335, x$336);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$335, x$336, x$337, x$338, x$339, x$340);
        ByteString x$341 = ByteString$.MODULE$.apply("\n");
        EmptyHeader$ x$342 = EmptyHeader$.MODULE$;
        int x$343 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$341, x$342);
        int x$344 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$341, x$342);
        int x$345 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$341, x$342);
        int x$346 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$341, x$342);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$341, x$342, x$343, x$344, x$345, x$346);
        return parser;
    }

    public void insert(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$347 = input;
        Object x$348 = value;
        int x$349 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$347, x$348);
        int x$350 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$347, x$348);
        int x$351 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$347, x$348);
        int x$352 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$347, x$348);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$347, x$348, x$349, x$350, x$351, x$352);
    }

    public void insertRemainingCharsAsNewNodes(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$353 = input;
        Object x$354 = value;
        int x$355 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$353, x$354);
        int x$356 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$353, x$354);
        int x$357 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$353, x$354);
        int x$358 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$353, x$354);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$353, x$354, x$355, x$356, x$357, x$358);
    }

    public int akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderNameAndReturnIndexOfColon(ByteString input, int start, int limit, int ix) {
        block5: {
            block3: while (ix < limit) {
                char c = package$.MODULE$.byteChar(input, ix);
                switch (c) {
                    case ':': {
                        break;
                    }
                    default: {
                        if (BoxesRunTime.unboxToBoolean(CharacterClasses$.MODULE$.tchar().apply(BoxesRunTime.boxToCharacter(c)))) {
                            ++ix;
                            continue block3;
                        }
                        throw this.fail(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header name"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.escape(c)})));
                    }
                }
                break block5;
            }
            throw this.fail(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP header name exceeds the configured limit of ", " characters"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(limit - start - 1)})));
        }
        return ix;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tuple2<String, Object> akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode, StringBuilder sb, int ix) {
        block14: while (true) {
            StringBuilder stringBuilder;
            if (ix >= limit) {
                throw this.fail(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP header value exceeds the configured limit of ", " characters"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(limit - start - 2)})));
            }
            char c = package$.MODULE$.byteChar(input, ix);
            switch (c) {
                case '\t': {
                    StringBuilder stringBuilder2 = HttpHeaderParser$.appended$1(' ', input, start, sb, ix);
                    ++ix;
                    sb = stringBuilder2;
                    continue block14;
                }
                case '\r': {
                    if (package$.MODULE$.byteChar(input, ix + 1) != '\n') break;
                    if (BoxesRunTime.unboxToBoolean(CharacterClasses$.MODULE$.WSP().apply(BoxesRunTime.boxToCharacter(package$.MODULE$.byteChar(input, ix + 2))))) {
                        StringBuilder stringBuilder3 = HttpHeaderParser$.appended$1(' ', input, start, sb, ix);
                        ix += 3;
                        sb = stringBuilder3;
                        continue block14;
                    }
                    Tuple2<String, Object> tuple2 = new Tuple2<String, Integer>(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix), BoxesRunTime.boxToInteger(ix + 2));
                    return tuple2;
                }
                case '\n': {
                    if (BoxesRunTime.unboxToBoolean(CharacterClasses$.MODULE$.WSP().apply(BoxesRunTime.boxToCharacter(package$.MODULE$.byteChar(input, ix + 1))))) {
                        StringBuilder stringBuilder4 = HttpHeaderParser$.appended$1(' ', input, start, sb, ix);
                        ix += 2;
                        sb = stringBuilder4;
                        continue block14;
                    }
                    Tuple2<String, Object> tuple2 = new Tuple2<String, Object>(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix), BoxesRunTime.boxToInteger(ix + 1));
                    return tuple2;
                }
            }
            int nix = ix + 1;
            if (' ' <= c && c <= '\u007f') {
                stringBuilder = sb != null ? sb.append(c) : null;
            } else if ((c & 0xE0) == 192) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                nix = ix + 2;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, input, start, sb, ix);
                        break;
                    }
                }
            } else if ((c & 0xF0) == 224) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                nix = ix + 3;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, input, start, sb, ix);
                        break;
                    }
                }
            } else if ((c & 0xF8) == 240) {
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 3));
                nix = ix + 4;
                int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2)).append(package$.MODULE$.byteChar(input, ix + 3));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, input, start, sb, ix);
                        break;
                    }
                }
            } else {
                StringBuilder stringBuilder5;
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = mode;
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    throw this.fail(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header value"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.escape(c)})));
                }
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    log.warning(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header value"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.escape(c)})));
                    stringBuilder5 = sb;
                } else {
                    if (!ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) throw new MatchError(illegalResponseHeaderValueProcessingMode);
                    stringBuilder5 = sb;
                }
                stringBuilder = stringBuilder5;
            }
            StringBuilder nsb = stringBuilder;
            ix = nix;
            sb = nsb;
        }
    }

    public StringBuilder akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$7(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return null;
    }

    public int akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$8(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return start;
    }

    public Nothing$ fail(String summary) {
        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(summary, ErrorInfo$.MODULE$.apply$default$2()));
    }

    private char[] $lessinit$greater$default$4() {
        return new char[512];
    }

    private int $lessinit$greater$default$5() {
        return 0;
    }

    private short[] $lessinit$greater$default$6() {
        return new short[762];
    }

    private int $lessinit$greater$default$7() {
        return 0;
    }

    private Object[] $lessinit$greater$default$8() {
        return new Object[255];
    }

    private int $lessinit$greater$default$9() {
        return 0;
    }

    public boolean akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10() {
        return false;
    }

    private final void insertInGoodOrder$1(Seq items, int startIx, int endIx, HttpHeaderParser parser$1) {
        while (endIx - startIx > 0) {
            Serializable serializable;
            int pivot = (startIx + endIx) / 2;
            Object r = items.apply(pivot);
            if (r instanceof HttpHeaderParser.HeaderValueParser) {
                BoxedUnit boxedUnit;
                HttpHeaderParser.HeaderValueParser headerValueParser = (HttpHeaderParser.HeaderValueParser)r;
                String insertName = EnhancedString$.MODULE$.toRootLowerCase$extension(akka.http.impl.util.package$.MODULE$.enhanceString_(headerValueParser.headerName())) + ':';
                if (parser$1.isEmpty()) {
                    ByteString x$310 = ByteString$.MODULE$.apply(insertName);
                    HttpHeaderParser.HeaderValueParser x$311 = headerValueParser;
                    int x$312 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$310, x$311);
                    int x$313 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$310, x$311);
                    int x$314 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$310, x$311);
                    int x$315 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$310, x$311);
                    parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$310, x$311, x$312, x$313, x$314, x$315);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    ByteString x$316 = ByteString$.MODULE$.apply(insertName);
                    HttpHeaderParser.HeaderValueParser x$317 = headerValueParser;
                    int x$318 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$316, x$317);
                    int x$319 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$316, x$317);
                    int x$320 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$316, x$317);
                    int x$321 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$316, x$317);
                    parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$316, x$317, x$318, x$319, x$320, x$321);
                    boxedUnit = BoxedUnit.UNIT;
                }
                serializable = boxedUnit;
            } else if (r instanceof String) {
                String string = (String)r;
                ByteString x$322 = ByteString$.MODULE$.apply(string + "\r\nx");
                int x$323 = parser$1.parseHeaderLine$default$2();
                int x$324 = parser$1.parseHeaderLine$default$3(x$322, x$323);
                int x$325 = parser$1.parseHeaderLine$default$4(x$322, x$323);
                serializable = BoxesRunTime.boxToInteger(parser$1.parseHeaderLine(x$322, x$323, x$324, x$325));
            } else {
                throw new MatchError(r);
            }
            this.insertInGoodOrder$1(items, startIx, pivot, parser$1);
            startIx = pivot + 1;
        }
    }

    private static final int insertInGoodOrder$default$2$1(Seq items) {
        return 0;
    }

    private static final int insertInGoodOrder$default$3$1(Seq items) {
        return items.size();
    }

    private static final StringBuilder appended$1(char c, ByteString input$3, int start$1, StringBuilder sb$1, int ix$1) {
        return (sb$1 != null ? sb$1 : new StringBuilder(package$.MODULE$.asciiString(input$3, start$1, ix$1))).append(c);
    }

    private static final StringBuilder appended2$1(int c, ByteString input$3, int start$1, StringBuilder sb$1, int ix$1) {
        return c >> 16 != 0 ? HttpHeaderParser$.appended$1((char)c, input$3, start$1, sb$1, ix$1).append((char)(c >> 16)) : HttpHeaderParser$.appended$1((char)c, input$3, start$1, sb$1, ix$1);
    }

    private HttpHeaderParser$() {
        MODULE$ = this;
    }
}

