/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.UntypedActor;
import akka.event.BusLogging;
import akka.event.DiagnosticLoggingAdapter;
import akka.event.DiagnosticMarkerBusLoggingAdapter;
import akka.event.LogSource;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$Error$NoCause$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import akka.event.MarkerLoggingAdapter;
import akka.util.Helpers$;
import java.io.PrintWriter;
import java.io.StringWriter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.control.NoStackTrace;

public final class Logging$ {
    public static Logging$ MODULE$;
    private final int ErrorLevel;
    private final int WarningLevel;
    private final int InfoLevel;
    private final int DebugLevel;
    private final int OffLevel;
    private final Seq<Logging.LogLevel> AllLogLevels;
    private final Logging.SerializedStandardOutLogger akka$event$Logging$$serializedStandardOutLogger;
    private final Logging.StandardOutLogger StandardOutLogger;
    private final Map<String, Object> emptyMDC;

    static {
        new Logging$();
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public String messageClassName(Object message) {
        String string;
        Object object = message;
        if (object == null) {
            string = "null";
        } else if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
            Object m = actorSelectionMessage.msg();
            string = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSelectionMessage(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{m.getClass().getName()}));
        } else {
            string = object.getClass().getName();
        }
        return string;
    }

    public final int ErrorLevel() {
        return this.ErrorLevel;
    }

    public final int WarningLevel() {
        return this.WarningLevel;
    }

    public final int InfoLevel() {
        return this.InfoLevel;
    }

    public final int DebugLevel() {
        return this.DebugLevel;
    }

    private final int OffLevel() {
        return this.OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s2) {
        String string = Helpers$.MODULE$.toRootLowerCase(s2);
        Option option = "off".equals(string) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.OffLevel())) : ("error".equals(string) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.ErrorLevel())) : ("warning".equals(string) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.WarningLevel())) : ("info".equals(string) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.InfoLevel())) : ("debug".equals(string) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.DebugLevel())) : None$.MODULE$))));
        return option;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        return Logging.Error.class.isAssignableFrom(eventClass) ? this.ErrorLevel() : (Logging.Warning.class.isAssignableFrom(eventClass) ? this.WarningLevel() : (Logging.Info.class.isAssignableFrom(eventClass) ? this.InfoLevel() : (Logging.Debug.class.isAssignableFrom(eventClass) ? this.DebugLevel() : this.DebugLevel())));
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        Class clazz;
        int n = level;
        if (this.ErrorLevel() == n) {
            clazz = Logging.Error.class;
        } else if (this.WarningLevel() == n) {
            clazz = Logging.Warning.class;
        } else if (this.InfoLevel() == n) {
            clazz = Logging.Info.class;
        } else if (this.DebugLevel() == n) {
            clazz = Logging.Debug.class;
        } else {
            throw new MatchError(new Logging.LogLevel(n));
        }
        return clazz;
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return this.AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$3) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$3);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> MarkerLoggingAdapter withMarker(ActorSystem system, T logSource, LogSource<T> evidence$4) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$4);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new MarkerLoggingAdapter(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$5) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$5);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public <T> MarkerLoggingAdapter withMarker(LoggingBus bus, T logSource, LogSource<T> evidence$6) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$6);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new MarkerLoggingAdapter(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter apply(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticLoggingAdapter(str2, clazz2, system){
            private Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc;

            public Map<String, Object> mdc() {
                return DiagnosticLoggingAdapter.mdc$(this);
            }

            public void mdc(Map<String, Object> mdc) {
                DiagnosticLoggingAdapter.mdc$(this, mdc);
            }

            public java.util.Map<String, Object> getMDC() {
                return DiagnosticLoggingAdapter.getMDC$(this);
            }

            public void setMDC(java.util.Map<String, Object> jMdc) {
                DiagnosticLoggingAdapter.setMDC$(this, jMdc);
            }

            public void clearMDC() {
                DiagnosticLoggingAdapter.clearMDC$(this);
            }

            public Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map<String, Object> x$1) {
                this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
            {
                DiagnosticLoggingAdapter.$init$(this);
            }
        };
    }

    public DiagnosticMarkerBusLoggingAdapter withMarker(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticMarkerBusLoggingAdapter(system.eventStream(), str2, clazz2, system.logFilter());
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter getLogger(Actor logSource) {
        return this.apply(logSource);
    }

    public DiagnosticLoggingAdapter getLogger(UntypedActor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2 tuple22 = new Tuple2(str, clazz);
        Tuple2 tuple23 = tuple22;
        String str2 = tuple23._1();
        Class<?> clazz2 = tuple23._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.getContext().system();
        return new DiagnosticLoggingAdapter(str2, clazz2, system){
            private Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc;

            public Map<String, Object> mdc() {
                return DiagnosticLoggingAdapter.mdc$(this);
            }

            public void mdc(Map<String, Object> mdc) {
                DiagnosticLoggingAdapter.mdc$(this, mdc);
            }

            public java.util.Map<String, Object> getMDC() {
                return DiagnosticLoggingAdapter.getMDC$(this);
            }

            public void setMDC(java.util.Map<String, Object> jMdc) {
                DiagnosticLoggingAdapter.setMDC$(this, jMdc);
            }

            public void clearMDC() {
                DiagnosticLoggingAdapter.clearMDC$(this);
            }

            public Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map<String, Object> x$1) {
                this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
            {
                DiagnosticLoggingAdapter.$init$(this);
            }
        };
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.SerializedStandardOutLogger akka$event$Logging$$serializedStandardOutLogger() {
        return this.akka$event$Logging$$serializedStandardOutLogger;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return this.StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        String string;
        Throwable throwable = e;
        boolean bl = throwable == null ? true : Logging$Error$NoCause$.MODULE$.equals(throwable);
        if (bl) {
            string = "";
        } else if (throwable instanceof NoStackTrace) {
            string = " (" + e.getClass().getName() + ")";
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('\n');
            throwable.printStackTrace(pw);
            string = sw.toString();
        }
        return string;
    }

    public Map<String, Object> emptyMDC() {
        return this.emptyMDC;
    }

    private Logging$() {
        MODULE$ = this;
        this.ErrorLevel = 1;
        this.WarningLevel = 2;
        this.InfoLevel = 3;
        this.DebugLevel = 4;
        this.OffLevel = Integer.MIN_VALUE;
        this.AllLogLevels = (Seq)package$.MODULE$.Vector().apply(Predef$.MODULE$.genericWrapArray(new Logging.LogLevel[]{new Logging.LogLevel(this.ErrorLevel()), new Logging.LogLevel(this.WarningLevel()), new Logging.LogLevel(this.InfoLevel()), new Logging.LogLevel(this.DebugLevel())}));
        this.akka$event$Logging$$serializedStandardOutLogger = new Logging.SerializedStandardOutLogger();
        this.StandardOutLogger = new Logging.StandardOutLogger();
        this.emptyMDC = (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
    }
}

