/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.Map;
import jep.ClassEnquirer;
import jep.ClassList;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.MainInterpreter;
import jep.python.MemoryManager;

public abstract class Jep
implements Interpreter {
    private static final String THREAD_WARN = "JEP THREAD WARNING: ";
    private boolean closed = false;
    private long tstate = 0L;
    private Thread thread = null;
    private ClassLoader classLoader = null;
    private StringBuilder evalLines = null;
    private boolean interactive = false;
    private final MemoryManager memoryManager;
    private final boolean isSubInterpreter;
    private static final String LINE_SEP = "\n";
    private static final ThreadLocal<Boolean> threadUsed = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Deprecated
    public Jep() throws JepException {
        this(new JepConfig());
    }

    @Deprecated
    public Jep(JepConfig jepConfig) throws JepException {
        this(jepConfig, true, new MemoryManager());
    }

    protected Jep(JepConfig jepConfig, boolean bl, MemoryManager memoryManager) throws JepException {
        MainInterpreter mainInterpreter = MainInterpreter.getMainInterpreter();
        if (threadUsed.get().booleanValue()) {
            Thread thread = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder(THREAD_WARN).append("Unsafe reuse of thread ").append(thread.getName()).append(" for another Python sub-interpreter.\n").append("Please close() the previous Jep instance to ensure stability.");
            throw new JepException(stringBuilder.toString());
        }
        this.isSubInterpreter = bl;
        this.memoryManager = memoryManager;
        this.classLoader = jepConfig.classLoader == null ? this.getClass().getClassLoader() : jepConfig.classLoader;
        boolean bl2 = jepConfig.sharedModules != null && !jepConfig.sharedModules.isEmpty();
        this.interactive = jepConfig.interactive;
        this.tstate = this.init(this.classLoader, bl2, bl);
        threadUsed.set(true);
        this.thread = Thread.currentThread();
        this.configureInterpreter(jepConfig);
        this.memoryManager.openInterpreter(this);
    }

    protected void configureInterpreter(JepConfig jepConfig) throws JepException {
        if (jepConfig.includePath != null) {
            String string = jepConfig.includePath.toString();
            if (string.contains("\\")) {
                string = string.replace("\\", "\\\\");
            }
            this.exec("import sys");
            this.exec("sys.path += '" + string + "'.split('" + File.pathSeparator + "')");
        }
        boolean bl = jepConfig.sharedModules != null && !jepConfig.sharedModules.isEmpty();
        this.eval("import jep");
        if (bl) {
            this.set("sharedModules", jepConfig.sharedModules);
            this.set("sharedImporter", MainInterpreter.getMainInterpreter());
            this.exec("jep.shared_modules_hook.setupImporter(sharedModules,sharedImporter)");
            this.exec("del sharedModules");
            this.exec("del sharedImporter");
        }
        this.setupJavaImportHook(jepConfig.classEnquirer);
        if (jepConfig.redirectStdout != null || jepConfig.redirectStderr != null) {
            this.exec("from jep import redirect_streams");
            if (jepConfig.redirectStdout != null) {
                this.invoke("redirect_streams.redirectStdout", jepConfig.redirectStdout);
            }
            if (jepConfig.redirectStderr != null) {
                this.invoke("redirect_streams.redirectStderr", jepConfig.redirectStderr);
            }
        }
    }

    protected void setupJavaImportHook(ClassEnquirer classEnquirer) throws JepException {
        if (classEnquirer == null) {
            classEnquirer = ClassList.getInstance();
        }
        this.set("classlist", classEnquirer);
        this.exec("from jep import java_import_hook");
        this.exec("java_import_hook.setupImporter(classlist)");
        this.exec("del classlist");
        this.exec("del java_import_hook");
    }

    private native long init(ClassLoader var1, boolean var2, boolean var3) throws JepException;

    @Deprecated
    public void isValidThread() throws JepException {
        if (this.thread != Thread.currentThread()) {
            throw new JepException("Invalid thread access.");
        }
        if (this.closed) {
            throw new JepException("Jep instance has been closed.");
        }
        if (this.tstate == 0L) {
            throw new JepException("Initialization failed.");
        }
    }

    @Override
    public void runScript(String string) throws JepException {
        this.isValidThread();
        if (string == null) {
            throw new JepException("Script filename cannot be null.");
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new JepException("Invalid file: " + file.getAbsolutePath());
        }
        this.run(this.tstate, string);
    }

    private native void run(long var1, String var3) throws JepException;

    @Override
    public Object invoke(String string, Object ... objectArray) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, objectArray, null);
    }

    @Override
    public Object invoke(String string, Map<String, Object> map) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, null, map);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, Map<String, Object> map) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, objectArray, map);
    }

    private native Object invoke(long var1, String var3, Object[] var4, Map<String, Object> var5);

    @Override
    public boolean eval(String string) throws JepException {
        this.isValidThread();
        try {
            if (string != null) {
                string = string.replaceAll("\r", "");
            }
            if (string == null || string.trim().equals("")) {
                if (!this.interactive) {
                    return false;
                }
                if (this.evalLines == null) {
                    return true;
                }
                this.eval(this.tstate, this.evalLines.toString());
                this.evalLines = null;
                return true;
            }
            if (!this.interactive || this.evalLines == null && this.compileString(this.tstate, string) == 1) {
                this.eval(this.tstate, string);
                return true;
            }
            if (this.evalLines == null) {
                this.evalLines = new StringBuilder();
            } else {
                this.evalLines.append(LINE_SEP);
            }
            this.evalLines.append(string);
            return false;
        }
        catch (JepException jepException) {
            this.evalLines = null;
            throw jepException;
        }
    }

    private native int compileString(long var1, String var3) throws JepException;

    private native void eval(long var1, String var3) throws JepException;

    @Override
    public void exec(String string) throws JepException {
        this.isValidThread();
        this.exec(this.tstate, string);
    }

    private native void exec(long var1, String var3) throws JepException;

    @Override
    public Object getValue(String string) throws JepException {
        this.isValidThread();
        return this.getValue(this.tstate, string, Object.class);
    }

    @Override
    public <T> T getValue(String string, Class<T> clazz) throws JepException {
        this.isValidThread();
        return clazz.cast(this.getValue(this.tstate, string, clazz));
    }

    private native Object getValue(long var1, String var3, Class<?> var4) throws JepException;

    @Override
    public void set(String string, Object object) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, object);
    }

    private native void set(long var1, String var3, Object var4) throws JepException;

    protected MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    protected long getThreadState() {
        return this.tstate;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public synchronized void close() throws JepException {
        if (this.closed) {
            return;
        }
        if (!Thread.currentThread().equals(this.thread)) {
            Thread thread = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder(THREAD_WARN).append("Unsafe close() of Python sub-interpreter by thread ").append(thread.getName()).append(".\nPlease close() from the creating thread to ensure stability.");
            throw new JepException(stringBuilder.toString());
        }
        if (this.isSubInterpreter) {
            Integer n;
            this.exec("import sys");
            Boolean bl = this.getValue("'threading' in sys.modules", Boolean.class);
            if (bl.booleanValue() && (n = this.getValue("sys.modules['threading'].active_count()", Integer.class)) > 1) {
                throw new JepException("All threads must be stopped before closing Jep.");
            }
        }
        this.getMemoryManager().closeInterpreter(this);
        this.closed = true;
        if (this.isSubInterpreter) {
            this.exec(this.tstate, "import jep");
            this.exec(this.tstate, "jep.shared_modules_hook.teardownImporter()");
        }
        this.close(this.tstate);
        this.tstate = 0L;
        threadUsed.set(false);
    }

    private native void close(long var1);
}

