import numpy as np
import os
import _pickle as pickle
from sklearn.preprocessing import MinMaxScaler
from pathlib import Path

def get_scaler_location(relative_path):
    dir = Path(os.path.dirname(os.path.realpath(__file__)))
    return dir / 'resources' / relative_path

def main():
    '''
    This function constructs manual minmax scalers for the RNN implementations of CropSAR and saves them into the
    local repository. If the scikit-learn version gets upgraded, this function should be rerun to avoid breaking code
    when reading the scalers as pickle file.
    '''

    scalers = dict()

    scalers['S1'] = dict()

    ranges = dict()
    ranges['VV'] = [-17.5, -4]  #
    ranges['VH'] = [-26, -11]  #
    ranges['incidenceAngle'] = [29.98, 46]
    ranges['RVI'] = [0.2, 1]

    ranges['VVsmooth60d'] = [-18, -2]
    ranges['VVsmooth30d'] = [-19, -1]
    ranges['VVsmooth12d'] = [-20, 0]

    ranges['VHsmooth60d'] = [-28, -7]
    ranges['VHsmooth30d'] = [-29, -6]
    ranges['VHsmooth12d'] = [-30, -5]

    scalers['S1']['VV'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array(ranges['VV']).astype(float).reshape(-1, 1))
    scalers['S1']['VH'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array(ranges['VH']).astype(float).reshape(-1, 1))
    scalers['S1']['RVI'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array(ranges['RVI']).astype(float).reshape(-1, 1))
    scalers['S1']['VVsmooth60d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VVsmooth60d']).astype(float).reshape(-1, 1))
    scalers['S1']['VHsmooth60d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VHsmooth60d']).astype(float).reshape(-1, 1))
    scalers['S1']['VVsmooth30d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VVsmooth30d']).astype(float).reshape(-1, 1))
    scalers['S1']['VHsmooth30d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VHsmooth30d']).astype(float).reshape(-1, 1))
    scalers['S1']['VVsmooth12d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VVsmooth12d']).astype(float).reshape(-1, 1))
    scalers['S1']['VHsmooth12d'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['VHsmooth12d']).astype(float).reshape(-1, 1))
    scalers['S1']['incidenceAngle'] = MinMaxScaler(feature_range=(-1, 1)).fit(
        np.array(ranges['incidenceAngle']).astype(float).reshape(-1, 1))

    scalers['S2'] = dict()
    scalers['S2']['FAPAR'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array([0, 1]).astype(float).reshape(-1, 1))
    scalers['S2']['FAPAR_8BAND'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array([0, 1]).astype(float).reshape(-1, 1))
    scalers['S2']['FCOVER'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array([0, 1]).astype(float).reshape(-1, 1))
    scalers['S2']['deltaObs'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array([0, 50]).astype(float).reshape(-1, 1))

    scalers['doy'] = MinMaxScaler(feature_range=(-1, 1)).fit(np.array([0, 360]).astype(float).reshape(-1, 1))

    # Save the scalers dictionary to a file
    outfile = str(get_scaler_location("S1_S2_minmaxManualscalers.p"))
    print('Saving scalers to: {}'.format(outfile))
    with open(outfile, 'wb') as f:
        pickle.dump(scalers, f)

if __name__ == '__main__':

    main()



