import re
from pathlib import Path



def run(parameter='LAI',base_path ='/data/cel_vol1/HRL_PHENO/S2/S2_TOC/', product_glob='31UFS/S2*.SAFE/GRANULE/L2A_*/IMG_DATA/R20m/*_B03_20m.jp2',output_dir='/tmp'):
    from pyspark import SparkContext
    sc = SparkContext()
    import rasterio
    print("rasterio version:" + rasterio.__version__)
    p = Path(base_path)
    all_paths = list(p.glob(product_glob))

    print(all_paths)

    try:
        if parameter == 'ALBEDO':
            from biopar.s2_10m_processor import S2Biopar10MProcessor
            class FrameAlbedo(S2Biopar10MProcessor):

                def get_output_path(self):
                    filename = Path(self.basepath).name.replace("B03", self.parameter)
                    tile_id = re.compile(r'_\d\d[A-Z]+_').match(filename).string
                    return str(Path(output_dir) / tile_id / "ALBEDO" / filename)

            sc.parallelize(all_paths, len(all_paths)).foreach(
                lambda path: FrameAlbedo(str(path), output_dir=output_dir,
                                               parameter=parameter).compute_biopar_S2())
        else:
            from biopar.run_11_band_with_angles import S2BioparProcessor
            sc.parallelize(all_paths, len(all_paths)).foreach(
                lambda path: S2BioparProcessor(str(path), output_dir=output_dir,
                                               parameter=parameter).compute_biopar_S2())
    finally:
        sc.stop()


if __name__ == '__main__':
    import fire

    fire.Fire(run)
