/*
 * Decompiled with CFR 0.152.
 */
package jep.python;

import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import jep.Jep;
import jep.JepAccess;
import jep.JepException;
import jep.python.PyObject;
import jep.python.PyPointer;

public final class MemoryManager
extends JepAccess {
    private final ThreadLocal<Jep> interpreters = new ThreadLocal();
    private final Set<Jep> interpreterSet = Collections.newSetFromMap(new WeakHashMap());
    private final ReferenceQueue<PyObject> refQueue = new ReferenceQueue();
    private final Set<PyPointer> pointers = Collections.newSetFromMap(new IdentityHashMap());

    public void openInterpreter(Jep jep) {
        this.interpreters.set(jep);
        this.interpreterSet.add(jep);
    }

    protected ReferenceQueue<PyObject> getReferenceQueue() throws JepException {
        this.cleanupWeakReferences();
        return this.refQueue;
    }

    protected void addReference(PyPointer pyPointer) {
        this.pointers.add(pyPointer);
    }

    protected void removeReference(PyPointer pyPointer) {
        this.pointers.remove(pyPointer);
    }

    public void closeInterpreter(Jep jep) throws JepException {
        if (this.interpreterSet.size() == 1) {
            Iterator<PyPointer> iterator = this.pointers.iterator();
            while (iterator.hasNext()) {
                PyPointer pyPointer = iterator.next();
                iterator.remove();
                pyPointer.dispose();
            }
        }
        this.interpreters.remove();
        this.interpreterSet.remove(jep);
    }

    public void cleanupWeakReferences() throws JepException {
        PyPointer pyPointer = (PyPointer)this.refQueue.poll();
        while (pyPointer != null) {
            pyPointer.dispose();
            pyPointer = (PyPointer)this.refQueue.poll();
        }
    }

    private Jep getThreadLocalJep() throws JepException {
        Jep jep = this.interpreters.get();
        if (jep == null) {
            throw new JepException("Invalid thread access.");
        }
        return jep;
    }

    protected long getThreadState() throws JepException {
        return this.getThreadState(this.getThreadLocalJep());
    }

    protected ClassLoader getClassLoader() {
        return this.getClassLoader(this.getThreadLocalJep());
    }
}

