__title__ = 'biopar'
__author__ = 'Jeroen Dries'

from biopar._version import __version__
from biopar.bioparnnw import BioParNNW
from biopar.bioparnp import BioParNp
import numpy as np
import time
from . import filereading



def run(basepath,tilesize):

    start = time.perf_counter()
    (bands,mask) = filereading.read_bands(basepath, tilesize)
    image = BioParNNW().run(bands)
    as_image = np.zeros((tilesize*tilesize),dtype=np.int16)
    as_image[~mask.flatten()] = image.flatten()
    as_image = as_image.reshape((tilesize,tilesize))

    elapsed = time.perf_counter() - start
    print('Elapsed %.3f seconds.' % elapsed)
    return as_image

def run_np(basepath,tilesize):
    start = time.perf_counter()
    (bands,mask) = filereading.read_bands(basepath, tilesize)
    image = BioParNp().run(bands)
    as_image = np.zeros((tilesize*tilesize),dtype=np.int16)
    as_image[~mask.flatten()] = image.flatten()
    as_image = as_image.reshape((tilesize,tilesize))

    elapsed = time.perf_counter() - start
    print('Elapsed %.3f seconds.' % elapsed)
    return as_image


def run_3_band(b03_path):
    """
    Apply BioPhysical parameter calculation based on 3 bands in 10m resolution.
    :param b03_path: A path of a band 3 of a CGS_S2_RADIOMETRY product.
    :return: A numpy ndarray
    """
    return run(b03_path,2000)