/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jep.PyConfig;

final class LibraryLocator {
    private final String libraryName;
    private final boolean ignoreEnv;
    private final boolean noSite;
    private final boolean noUserSite;
    private final String pythonHome;

    private LibraryLocator(PyConfig pyConfig) {
        if (pyConfig != null) {
            this.ignoreEnv = pyConfig.ignoreEnvironmentFlag != 0 && pyConfig.ignoreEnvironmentFlag != -1;
            this.noSite = pyConfig.noSiteFlag != 0 && pyConfig.noSiteFlag != -1;
            this.noUserSite = pyConfig.noUserSiteDirectory != 0 && pyConfig.noUserSiteDirectory != -1;
            this.pythonHome = pyConfig.pythonHome;
        } else {
            this.ignoreEnv = false;
            this.noSite = false;
            this.noUserSite = false;
            this.pythonHome = null;
        }
        String string = System.mapLibraryName("jep");
        if (string.endsWith(".dylib")) {
            string = string.replace(".dylib", ".jnilib");
        }
        this.libraryName = string;
    }

    private boolean searchPythonPath() {
        if (this.ignoreEnv) {
            return false;
        }
        String string = System.getenv("PYTHONPATH");
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                if (!this.searchPackageDir(new File(string2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchSitePackages() {
        if (this.noSite) {
            return false;
        }
        String string = this.pythonHome;
        if (string == null && !this.ignoreEnv) {
            string = System.getenv("PYTHONHOME");
        }
        if (string != null) {
            for (String string2 : new String[]{"lib", "lib64", "Lib"}) {
                File file = new File(string, string2);
                if (!file.isDirectory()) continue;
                File file2 = new File(file, "site-packages");
                if (this.searchPackageDir(file2)) {
                    return true;
                }
                file2 = new File(file, "site-python");
                if (this.searchPackageDir(file2)) {
                    return true;
                }
                for (File file3 : file.listFiles()) {
                    if (!file3.isDirectory() || !file3.getName().matches("python\\d\\.\\d") || !this.searchPackageDir(file2 = new File(file3, "site-packages"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean searchUserSitePackages() {
        File file;
        File[] fileArray;
        Object object;
        if (this.noSite || this.noUserSite) {
            return false;
        }
        String string = System.getenv("APPDATA");
        if (string != null && ((File)(object = new File(string, "Python"))).isDirectory()) {
            fileArray = ((File)object).listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2;
                File file3 = fileArray[i];
                if (!file3.isDirectory() || !file3.getName().matches("python\\d{2}") || !this.searchPackageDir(file2 = new File(file3, "site-packages"))) continue;
                return true;
            }
        }
        if ((object = System.getProperty("user.home")) != null && (file = new File((File)(fileArray = new File((String)object, ".local")), "lib")).isDirectory()) {
            for (File file4 : file.listFiles()) {
                File file5;
                if (!file4.isDirectory() || !file4.getName().matches("python\\d\\.\\d") || !this.searchPackageDir(file5 = new File(file4, "site-packages"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchPackageDir(File file) {
        File file2;
        File file3;
        if (file.isDirectory() && (file3 = new File(file, "jep")).isDirectory() && (file2 = new File(file3, this.libraryName)).exists()) {
            try {
                System.load(file2.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Matcher matcher = Pattern.compile("libpython[\\w\\.]*").matcher(unsatisfiedLinkError.getMessage());
                if (matcher.find() && this.findPythonLibrary(matcher.group(0))) {
                    System.load(file2.getAbsolutePath());
                }
                if (this.findPythonLibraryWindows()) {
                    System.load(file2.getAbsolutePath());
                }
                throw unsatisfiedLinkError;
            }
            return true;
        }
        return false;
    }

    private boolean findPythonLibrary(String string) {
        String string2 = this.pythonHome;
        if (string2 == null && !this.ignoreEnv) {
            string2 = System.getenv("PYTHONHOME");
        }
        if (string2 != null) {
            for (String string3 : new String[]{"lib", "lib64", "Lib"}) {
                File file;
                File file2 = new File(string2, string3);
                if (!file2.isDirectory() || !(file = new File(file2, string)).exists()) continue;
                System.load(file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    private boolean findPythonLibraryWindows() {
        String string = this.pythonHome;
        if (string == null && !this.ignoreEnv) {
            string = System.getenv("PYTHONHOME");
        }
        if (string != null) {
            Pattern pattern = Pattern.compile("^python\\d\\d+\\.dll$");
            for (File file : new File(string).listFiles()) {
                if (!file.isFile() || !pattern.matcher(file.getName()).matches() || !file.exists()) continue;
                System.load(file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    public static boolean findJepLibrary(PyConfig pyConfig) {
        LibraryLocator libraryLocator = new LibraryLocator(pyConfig);
        if (libraryLocator.searchPythonPath()) {
            return true;
        }
        if (libraryLocator.searchSitePackages()) {
            return true;
        }
        return libraryLocator.searchUserSitePackages();
    }
}

