from . import BioParNNW
import rasterio
import numpy as np
import time
start = time.perf_counter()

tilesize = 5000
read_window = rasterio.windows.union([((0, tilesize), (0, tilesize))])
with rasterio.open('/home/driesj/alldata/CGS_S2_RADIOMETRY/2017/10/06/S2A_20171006T105937Z_31UER_TOC_V100/S2A_20171006T105937Z_31UER_TOC-B03_10M_V100.tif') as dataset:
    band3 = dataset.read(1,window=read_window)#[np.ix_([0,3],[0,3])]
    profile = dataset.profile


with rasterio.open('/home/driesj/alldata/CGS_S2_RADIOMETRY/2017/10/06/S2A_20171006T105937Z_31UER_TOC_V100/S2A_20171006T105937Z_31UER_TOC-B04_10M_V100.tif') as dataset:
    band4 = dataset.read(1,window=read_window)#[np.ix_([0,3],[0,3])]


basepath = '/home/driesj/alldata/CGS_S2_RADIOMETRY/2017/10/06/S2A_20171006T105937Z_31UER_TOC_V100/S2A_20171006T105937Z_31UER_TOC-B02_10M_V100.tif'
read_window_20m = rasterio.windows.union([((0, tilesize/2), (0, tilesize/2))])

def read_band_10m(band_id):
    global band5, dataset
    band5 = np.empty(shape=(1, round(tilesize), round(tilesize)), dtype=np.int16)
    with rasterio.open(basepath) as dataset:
        return dataset.read(1, out=band5, window=read_window_20m)

def read_band_20m(band_id):
    global band5, dataset
    band5 = np.empty(shape=(1, round(tilesize), round(tilesize)), dtype=np.int16)
    with rasterio.open(basepath.replace("10M","20M").replace("B02",band_id)) as dataset:
        return dataset.read(1, out=band5, window=read_window_20m)


band5 = read_band_20m("B05")
band6 = read_band_20m("B06")
band7 = read_band_20m("B07")
band8a = read_band_20m("B8A")
band11 = read_band_20m("B11")
band12 = read_band_20m("B12")

bands = np.matrix(
    [band3.flatten(), band4.flatten(), band5.flatten(), band6.flatten(), band7.flatten(), band8a.flatten(),
     band11.flatten(), band12.flatten()])

image = BioParNNW().run(bands).reshape(tilesize, tilesize)

with rasterio.drivers():

    # Write the product as a raster band to a new 8-bit file. For
    # the new file's profile, we start with the meta attributes of
    # the source file, but then change the band count to 1, set the
    # dtype to uint8, and specify LZW compression.

    with rasterio.open('fapar.tif', 'w', **profile) as dst:
        dst.write(image, 1)

elapsed = time.perf_counter() - start
print('Elapsed %.3f seconds.' % elapsed)


