/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// AffineDataCopyGeneration
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineDataCopyGenerationBase : public ::mlir::FunctionPass {
public:
  AffineDataCopyGenerationBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineDataCopyGenerationBase(const AffineDataCopyGenerationBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-data-copy-generate"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineDataCopyGeneration"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<uint64_t> fastMemoryCapacity{*this, "fast-mem-capacity", llvm::cl::desc("Set fast memory space capacity in KiB (default: unlimited)"), llvm::cl::init(std::numeric_limits<uint64_t>::max())};
  Pass::Option<unsigned> fastMemorySpace{*this, "fast-mem-space", llvm::cl::desc("Fast memory space identifier for copy generation (default: 1)"), llvm::cl::init(1)};
  Pass::Option<bool> generateDma{*this, "generate-dma", llvm::cl::desc("Generate DMA instead of point-wise copy"), llvm::cl::init(true)};
  Pass::Option<int> minDmaTransferSize{*this, "min-dma-transfer", llvm::cl::desc("Minimum DMA transfer size supported by the target in bytes"), llvm::cl::init(1024)};
  Pass::Option<unsigned> slowMemorySpace{*this, "slow-mem-space", llvm::cl::desc("Slow memory space identifier for copy generation (default: 0)"), llvm::cl::init(0)};
  Pass::Option<bool> skipNonUnitStrideLoops{*this, "skip-non-unit-stride-loops", llvm::cl::desc("Testing purposes: avoid non-unit stride loop choice depths for copy placement"), llvm::cl::init(false)};
  Pass::Option<unsigned> tagMemorySpace{*this, "tag-mem-space", llvm::cl::desc("Tag memory space identifier for copy generation (default: 0)"), llvm::cl::init(0)};
};

//===----------------------------------------------------------------------===//
// AffineLoopInvariantCodeMotion
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineLoopInvariantCodeMotionBase : public ::mlir::FunctionPass {
public:
  AffineLoopInvariantCodeMotionBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineLoopInvariantCodeMotionBase(const AffineLoopInvariantCodeMotionBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-loop-invariant-code-motion"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineLoopInvariantCodeMotion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// AffineLoopTiling
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineLoopTilingBase : public ::mlir::FunctionPass {
public:
  AffineLoopTilingBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineLoopTilingBase(const AffineLoopTilingBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-loop-tile"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineLoopTiling"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<uint64_t> cacheSizeInKiB{*this, "cache-size", llvm::cl::desc("Set size of cache to tile for in KiB"), llvm::cl::init(512)};
  Pass::Option<bool> separate{*this, "separate", llvm::cl::desc("Separate full and partial tiles")};
  Pass::Option<unsigned> tileSize{*this, "tile-size", llvm::cl::desc("Use this tile size for all loops")};
  Pass::ListOption<unsigned> tileSizes{*this, "tile-sizes", llvm::cl::desc("List of tile sizes for each perfect nest (overridden by -tile-size)"), llvm::cl::ZeroOrMore};
};

//===----------------------------------------------------------------------===//
// AffineLoopUnroll
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineLoopUnrollBase : public ::mlir::FunctionPass {
public:
  AffineLoopUnrollBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineLoopUnrollBase(const AffineLoopUnrollBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-loop-unroll"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineLoopUnroll"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<unsigned> unrollFactor{*this, "unroll-factor", llvm::cl::desc("Use this unroll factor for all loops being unrolled"), llvm::cl::init(4)};
  Pass::Option<bool> unrollFull{*this, "unroll-full", llvm::cl::desc("Fully unroll loops"), llvm::cl::init(false)};
  Pass::Option<unsigned> numRepetitions{*this, "unroll-num-reps", llvm::cl::desc("Unroll innermost loops repeatedly this many times"), llvm::cl::init(1)};
  Pass::Option<unsigned> unrollFullThreshold{*this, "unroll-full-threshold", llvm::cl::desc("Unroll all loops with trip count less than or equal to this"), llvm::cl::init(1)};
};

//===----------------------------------------------------------------------===//
// AffineLoopUnrollAndJam
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineLoopUnrollAndJamBase : public ::mlir::FunctionPass {
public:
  AffineLoopUnrollAndJamBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineLoopUnrollAndJamBase(const AffineLoopUnrollAndJamBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-loop-unroll-jam"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineLoopUnrollAndJam"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<unsigned> unrollJamFactor{*this, "unroll-jam-factor", llvm::cl::desc("Use this unroll jam factor for all loops (default 4)"), llvm::cl::init(4)};
};

//===----------------------------------------------------------------------===//
// AffineVectorize
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineVectorizeBase : public ::mlir::FunctionPass {
public:
  AffineVectorizeBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineVectorizeBase(const AffineVectorizeBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "affine-super-vectorize"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "AffineVectorize"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::ListOption<int64_t> vectorSizes{*this, "virtual-vector-size", llvm::cl::desc("Specify an n-D virtual vector size for vectorization"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
  Pass::ListOption<int64_t> fastestVaryingPattern{*this, "test-fastest-varying", llvm::cl::desc("Specify a 1-D, 2-D or 3-D pattern of fastest varying memory dimensions to match. See defaultPatterns in Vectorize.cpp for a description and examples. This is used for testing purposes"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
};

//===----------------------------------------------------------------------===//
// SimplifyAffineStructures
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SimplifyAffineStructuresBase : public ::mlir::FunctionPass {
public:
  SimplifyAffineStructuresBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  SimplifyAffineStructuresBase(const SimplifyAffineStructuresBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "simplify-affine-structures"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "SimplifyAffineStructures"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION
#define GEN_PASS_REGISTRATION_AffineDataCopyGeneration
#define GEN_PASS_REGISTRATION_AffineLoopInvariantCodeMotion
#define GEN_PASS_REGISTRATION_AffineLoopTiling
#define GEN_PASS_REGISTRATION_AffineLoopUnroll
#define GEN_PASS_REGISTRATION_AffineLoopUnrollAndJam
#define GEN_PASS_REGISTRATION_AffineVectorize
#define GEN_PASS_REGISTRATION_SimplifyAffineStructures
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_REGISTRATION_AffineDataCopyGeneration
::mlir::registerPass("affine-data-copy-generate", "Generate explicit copying for affine memory operations", []() -> std::unique_ptr<Pass> { return mlir::createAffineDataCopyGenerationPass(); });
#endif // GEN_PASS_REGISTRATION_AffineDataCopyGeneration
#undef GEN_PASS_REGISTRATION_AffineDataCopyGeneration
#ifdef GEN_PASS_REGISTRATION_AffineLoopInvariantCodeMotion
::mlir::registerPass("affine-loop-invariant-code-motion", "Hoist loop invariant instructions outside of affine loops", []() -> std::unique_ptr<Pass> { return mlir::createAffineLoopInvariantCodeMotionPass(); });
#endif // GEN_PASS_REGISTRATION_AffineLoopInvariantCodeMotion
#undef GEN_PASS_REGISTRATION_AffineLoopInvariantCodeMotion
#ifdef GEN_PASS_REGISTRATION_AffineLoopTiling
::mlir::registerPass("affine-loop-tile", "Tile affine loop nests", []() -> std::unique_ptr<Pass> { return mlir::createLoopTilingPass(); });
#endif // GEN_PASS_REGISTRATION_AffineLoopTiling
#undef GEN_PASS_REGISTRATION_AffineLoopTiling
#ifdef GEN_PASS_REGISTRATION_AffineLoopUnroll
::mlir::registerPass("affine-loop-unroll", "Unroll affine loops", []() -> std::unique_ptr<Pass> { return mlir::createLoopUnrollPass(); });
#endif // GEN_PASS_REGISTRATION_AffineLoopUnroll
#undef GEN_PASS_REGISTRATION_AffineLoopUnroll
#ifdef GEN_PASS_REGISTRATION_AffineLoopUnrollAndJam
::mlir::registerPass("affine-loop-unroll-jam", "Unroll and jam affine loops", []() -> std::unique_ptr<Pass> { return mlir::createLoopUnrollAndJamPass(); });
#endif // GEN_PASS_REGISTRATION_AffineLoopUnrollAndJam
#undef GEN_PASS_REGISTRATION_AffineLoopUnrollAndJam
#ifdef GEN_PASS_REGISTRATION_AffineVectorize
::mlir::registerPass("affine-super-vectorize", "Vectorize to a target independent n-D vector abstraction", []() -> std::unique_ptr<Pass> { return mlir::createSuperVectorizePass(); });
#endif // GEN_PASS_REGISTRATION_AffineVectorize
#undef GEN_PASS_REGISTRATION_AffineVectorize
#ifdef GEN_PASS_REGISTRATION_SimplifyAffineStructures
::mlir::registerPass("simplify-affine-structures", "Simplify affine expressions in maps/sets and normalize memrefs", []() -> std::unique_ptr<Pass> { return mlir::createSimplifyAffineStructuresPass(); });
#endif // GEN_PASS_REGISTRATION_SimplifyAffineStructures
#undef GEN_PASS_REGISTRATION_SimplifyAffineStructures
#ifdef GEN_PASS_REGISTRATION
#undef GEN_PASS_REGISTRATION_AffineDataCopyGeneration
#undef GEN_PASS_REGISTRATION_AffineLoopInvariantCodeMotion
#undef GEN_PASS_REGISTRATION_AffineLoopTiling
#undef GEN_PASS_REGISTRATION_AffineLoopUnroll
#undef GEN_PASS_REGISTRATION_AffineLoopUnrollAndJam
#undef GEN_PASS_REGISTRATION_AffineVectorize
#undef GEN_PASS_REGISTRATION_SimplifyAffineStructures
#endif // GEN_PASS_REGISTRATION
#undef GEN_PASS_REGISTRATION
