######################################################################################################
# croptypeclassification.py
# ---------------------------
# Purpose
#       Build OpenEO croptypeclassification service
#
######################################################################################################

#imports
import json
import openeo
import geopandas as gpd
import os
from openeo.api.process import Parameter
from openeo.rest.conversions import timeseries_json_to_pandas
from openeo.rest.udp import build_process_dict
import utm
import datetime
import time
from nextland_services.constants import *


OUTPUT_DIR = Path(__file__).with_suffix('.output')
OUTPUT_DIR.mkdir(parents=True, exist_ok=True)
OUTPUT_DIR_GRAPH = RESOURCES

# Functions



def _get_epsg(lat, zone_nr):
    if lat >= 0:
        epsg_code = '326' + str(zone_nr)
    else:
        epsg_code = '327' + str(zone_nr)
    return int(epsg_code)

def load_udf(udf):
    with open(udf, 'r+', encoding= "utf8") as f:
        return f.read()

#Write content to named file
def fwrite(fname, fcontent):
    f = open(fname, 'w')
    f.write(str(fcontent))
    f.close()

#Function that will built the input timeseries for the model
def get_input_TS(eoconn, time_range, geo):
        S2_L2A = eoconn.load_collection('SENTINEL2_L2A_SENTINELHUB',
                                        bands=["B01","B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B11", "B12","B8A", "SCL"])
        S2_L2A_masked = S2_L2A.process("mask_scl_dilation", data=S2_L2A,
                                         scl_band_name="SCL")
        S1_GRD = eoconn.load_collection('SENTINEL1_GRD', bands=['VH', 'VV'])
        S1_GRD = S1_GRD.sar_backscatter(coefficient="gamma0-ellipsoid", local_incidence_angle=True)
        S1_GRD = S1_GRD.apply(lambda x: 10 * x.log(base=10))
        S2_L2A_masked = S2_L2A_masked.resample_cube_spatial(S1_GRD)
        merged_cube = S1_GRD.merge(S2_L2A_masked)
        return merged_cube.filter_temporal(time_range).polygonal_mean_timeseries(geo)

# Test the croptypeclassification with an UDF
def test_run_udf_crop_type_classification(time_range, shp):
    eoconn = openeo.connect("https://openeo.vito.be/openeo/1.0").authenticate_basic('bontek', 'bontek123')


    TS_cube = get_input_TS(eoconn, time_range, shp)
    TS = TS_cube.send_job(out_format='json')#TS_cube.execute()
    _download_openeo_job_result(TS,r'/data/users/Public/bontek/Nextland/Croptype_classification/tmp/TS_validation_2.json')

    # with open(r'/data/users/Public/bontek/Nextland/Croptype_classification/tmp/TS_validation_2.json', 'w') as file:
    #     json.dump(TS, file)
    #
    #
    #
    # croptype_classification_code = load_udf("croptypeclassification_udf.py")
    #
    # udf = TS_cube.process("run_udf", data = TS_cube, udf = croptype_classification_code, runtime = "Python")
    #
    # pred = udf.send_job().start_and_wait().get_result().load_json()
    # return pred

def test_debug_croptypeclassification_udf():
    from openeo_udf.api.udf_data import UdfData
    from openeo_udf.api.structured_data import StructuredData
    from croptypeclassification_udf import udf_croptypeclassification
    with open(r'/data/users/Public/bontek/Nextland/Croptype_classification/tmp/TS_validation_2.json',
              'r') as json_file:
        ts = json.load(json_file)
        udfdata = UdfData({"EPSG":4326}, structured_data_list=[StructuredData(description= "timeseries input", data = ts, type = "dict")])
        res = udf_croptypeclassification(udfdata)
        fwrite(os.path.join(OUTPUT_DIR, 'croptypeclassication_testudf_result.res'), res.to_dict())




# Build graph croptypeclassification and write it away as a JSON file
def croptypeclassification_build_graph_poly_and_store_udp(eoconn):

    #Define the service parameters
    time_range = date_parameter("Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    polygon = polygon_param(description=" A polygon object for which the croptype classification will be done.")
    timeseries_input = get_input_TS(eoconn, time_range, polygon)

    #load UDF
    croptype_classification_code = load_udf("croptypeclassification_udf.py")
    udf = timeseries_input.process("run_udf", data = timeseries_input, udf = croptype_classification_code, runtime = "Python")

    #Build service dict
    croptypeclassification_dict = build_process_dict(
        process_id= "CROPTYPECLASSIFICATION",
        process_graph= udf,
        parameters= [time_range, polygon]
    )

    #Write service graph to json file

    fwrite(os.path.join(OUTPUT_DIR_GRAPH, 'croptypclassification_graph_poly.json'), json.dumps(croptypeclassification_dict, indent = 4))


#Save the json graph as an UDP
#Getgeometries function was manually added to the json to allow dealing witn loaded and  not loaded geometries (filename)
def save_udp(eoconn):
    # Define the service parameters
    time_range = date_parameter("Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    polygon = polygon_param(description=" A polygon object for which the croptype classification will be done.")
    with open(os.path.join(OUTPUT_DIR_GRAPH,'croptypclassification_graph_poly.json'),'r') as file:
        graph = json.load(file)
    udp = eoconn.save_user_defined_process(
        'CROPTYPECLASSIFICATION',
        graph["process_graph"],
        description= "Predicts crop type for all the input geometries. The input geometries can be given by the input parameter 'file_polygons' or 'polygon'. The outcome is a dictionary with some keys indicating the croptype prediction per year for each requested field (e.g. 2017_CT) and their correspoding confidence(e.g.2017_CONF). The amount if predictions within each key is determined by the size of the input geometries. The order of the predictions is the same as the order of the input geometries.",
        parameters=[time_range, polygon], public=True)


def test_build_croptypeclassification_graph():
    eoconn = openeo.connect("https://openeo.vito.be").authenticate_basic('bontek', 'bontek123')
    croptypeclassification_build_graph_poly_and_store_udp(eoconn)

#### TEST THE CROPTYPECLASSIFICATION
shp_file = "/data/users/Public/bontek/Nextland/Croptype_classification/SHP_validation.shp"
time_range = ['2018-10-01','2019-08-15']
eoconn = openeo.connect("https://openeo.vito.be/openeo/1.0").authenticate_basic('bontek', 'bontek123')


#
# import shapely
# import utm
# shp = gpd.read_file(shp_file)
# inw_buffer_size = -10
# buffer_args = {'cap_style': 1, 'join_style': 3, 'resolution': 4}
# utm_zone_nr = utm.from_latlon(shp.iloc[0, :].geometry.bounds[1], shp.iloc[0, :].geometry.bounds[0])[2]
# epsg_UTM_field = _get_epsg(shp.iloc[0, :].geometry.bounds[1], utm_zone_nr)
# parcels_UTM = shp.to_crs({'init': 'epsg:{}'.format(str(epsg_UTM_field))})
# parcels_buffered = parcels_UTM.buffer(inw_buffer_size, **buffer_args)
# parcels_buffered = parcels_buffered.simplify(2)
# parcels_buffered_WGS = parcels_buffered.to_crs({'init': 'epsg:4326'})
# shp.geometry = parcels_buffered_WGS.geometry.to_list()
# shp.crs = parcels_buffered_WGS.crs
# crs = int(shp.crs.get('init').split('epsg:')[1])
# geo = shapely.geometry.GeometryCollection([shapely.geometry.shape(feature.geometry) for index, feature in shp.iterrows()])
#pred = test_run_udf_crop_type_classification(time_range, shp_file)
#test_debug_croptypeclassification_udf()
test_build_croptypeclassification_graph()
save_udp(eoconn)


gpd_shp = gpd.read_file(shp_file)
js_shp = json.loads(gpd_shp.to_json())
for poly in js_shp['features']:
    polyid = poly['id']
    polyg = poly['geometry']
croptype_pred = eoconn.datacube_from_process('CROPTYPECLASSIFICATION', date= time_range, polygon = polyg).send_job().start_and_wait().get_result().load_json()


















